/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.model.support;

import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.ExtendedElementFactory;
import org.jsweet.transpiler.model.MethodInvocationElement;
import org.jsweet.transpiler.model.support.ExtendedElementSupport;

public class MethodInvocationElementSupport
extends ExtendedElementSupport<JCTree.JCMethodInvocation>
implements MethodInvocationElement {
    public MethodInvocationElementSupport(JCTree.JCMethodInvocation tree) {
        super(tree);
    }

    @Override
    public List<ExtendedElement> getArguments() {
        return ((JCTree.JCMethodInvocation)this.tree).args.stream().map(a -> ExtendedElementFactory.INSTANCE.create((JCTree)a)).collect(Collectors.toList());
    }

    @Override
    public int getArgumentCount() {
        return ((JCTree.JCMethodInvocation)this.tree).args.size();
    }

    @Override
    public List<ExtendedElement> getArgumentTail() {
        return ((JCTree.JCMethodInvocation)this.tree).args.tail.stream().map(a -> ExtendedElementFactory.INSTANCE.create((JCTree)a)).collect(Collectors.toList());
    }

    @Override
    public ExtendedElement getArgument(int i) {
        return ExtendedElementFactory.INSTANCE.create(((JCTree.JCMethodInvocation)this.tree).args.get(i));
    }

    @Override
    public String getMethodName() {
        JCTree.JCExpression methTree = ((JCTree.JCMethodInvocation)this.tree).meth;
        if (methTree instanceof JCTree.JCIdent) {
            return methTree.toString();
        }
        if (methTree instanceof JCTree.JCFieldAccess) {
            return ((JCTree.JCFieldAccess)methTree).name.toString();
        }
        return null;
    }

    @Override
    public ExecutableElement getMethod() {
        JCTree.JCExpression methTree = ((JCTree.JCMethodInvocation)this.tree).meth;
        if (methTree instanceof JCTree.JCIdent && ((JCTree.JCIdent)methTree).sym instanceof ExecutableElement) {
            return (ExecutableElement)((Object)((JCTree.JCIdent)methTree).sym);
        }
        if (methTree instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)methTree).sym instanceof ExecutableElement) {
            return (ExecutableElement)((Object)((JCTree.JCFieldAccess)methTree).sym);
        }
        return null;
    }

    @Override
    public ExtendedElement getTargetExpression() {
        JCTree.JCExpression methTree = ((JCTree.JCMethodInvocation)this.tree).meth;
        if (methTree instanceof JCTree.JCFieldAccess) {
            return ExtendedElementFactory.INSTANCE.create(((JCTree.JCFieldAccess)methTree).selected);
        }
        return null;
    }
}

