/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.extension;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.extension.RemoveJavaDependenciesAdapter;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.MethodInvocationElement;
import org.jsweet.transpiler.model.NewClassElement;

public class RemoveJavaDependenciesES6Adapter
extends RemoveJavaDependenciesAdapter {
    private Set<String> setClassNames = Stream.of(Set.class, HashSet.class, LinkedHashSet.class, TreeSet.class, AbstractSet.class).map(Class::getName).collect(Collectors.toSet());

    public RemoveJavaDependenciesES6Adapter(PrinterAdapter parentAdapter) {
        super(parentAdapter);
    }

    @Override
    protected void initTypesMapping() {
        this.setClassNames = Stream.of(Set.class, HashSet.class, AbstractSet.class).map(Class::getName).collect(Collectors.toSet());
        super.initTypesMapping();
        this.setClassNames.forEach(name -> this.extTypesMapping.put(name, "any"));
    }

    @Override
    protected RemoveJavaDependenciesES6Adapter print(ExtendedElement expression, boolean delegate) {
        super.print(expression, delegate);
        return this;
    }

    @Override
    protected RemoveJavaDependenciesES6Adapter printTargetForParameter(ExtendedElement expression, boolean delegate) {
        super.printTargetForParameter(expression, delegate);
        return this.print(expression, delegate);
    }

    @Override
    public boolean substituteNewClass(NewClassElement newClass) {
        String className = newClass.getTypeAsElement().toString();
        if (this.setClassNames.contains(className)) {
            this.substituteNewSet(newClass);
            return true;
        }
        return super.substituteNewClass(newClass);
    }

    private void substituteNewSet(NewClassElement newClass) {
        boolean ignoreArguments;
        boolean bl = ignoreArguments = newClass.getArgumentCount() == 0 || Integer.class.getName().equals(newClass.getArgument(0).getType().toString()) || "int".equals(newClass.getArgument(0).getType().toString());
        if (ignoreArguments) {
            this.print(String.format("(() => { const col = %s; col.data = new Set(); col.iterator = %s; return col; })()", this.createNewCollection(newClass.getType().toString()), "() => { let i = 0; const a = Array.from(col.data.values()); return { next: () => i < a.length? a[i++] : null, hasNext: () => i < a.length }; }"));
        } else {
            this.print(String.format("((arg) => { const col = %s; col.data = new Set(); col.iterator = %s; %s return col; })(", this.createNewCollection(newClass.getType().toString()), "() => { let i = 0; const a = Array.from(col.data.values()); return { next: () => i < a.length? a[i++] : null, hasNext: () => i < a.length }; }", "const it = arg.iterator(); while(it.hasNext()) col.data.add(it.next());")).print(newClass.getArgument(0)).print(")");
        }
    }

    @Override
    public boolean substituteMethodInvocation(MethodInvocationElement invocation) {
        String targetClassName = invocation.getMethod().getEnclosingElement().toString();
        ExtendedElement targetExpression = invocation.getTargetExpression();
        if (targetExpression != null) {
            targetClassName = targetExpression.getTypeAsElement().toString();
        }
        if (this.setClassNames.contains(targetClassName)) {
            this.substituteMethodOnSet(invocation);
            return true;
        }
        return super.substituteMethodInvocation(invocation);
    }

    private void substituteMethodOnSet(MethodInvocationElement invocation) {
        String targetMethodName = invocation.getMethodName();
        ExtendedElement targetExpression = invocation.getTargetExpression();
        switch (targetMethodName) {
            case "add": {
                this.printMacroName(targetMethodName);
                this.print("((s, v) => { const n = s.data.size; s.data.add(v); return n !== s.data.size; })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "addAll": {
                this.printMacroName(targetMethodName);
                this.print("((s, c) => { const it = c.iterator(); const n = s.data.size; while(it.hasNext()) s.data.add(it.next()); return n !== s.data.size; })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "clear": {
                this.printMacroName(targetMethodName);
                this.print(targetExpression).print(".data.clear()");
                break;
            }
            case "contains": {
                this.printMacroName(targetMethodName);
                this.print(targetExpression).print(".data.has(").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "containsAll": {
                this.printMacroName(targetMethodName);
                this.print("((s, c) => { const it = c.iterator(); while(it.hasNext()) if (!s.has(it.next())) return false; return true; })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "equals": {
                this.printMacroName(targetMethodName);
                this.print("((s1, s2) => { if (!s1 || !s2) return s1 === s2; const it1 = s1.iterator(); const it2 = s2.iterator(); while(it1.hasNext()) if (it1.next() !== it2.next()) return false; return !it2.hasNext(); })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "hashCode": {
                this.printMacroName(targetMethodName);
                this.report((ExtendedElement)invocation, JSweetProblem.USER_ERROR, "hashCode() is not supported.");
                break;
            }
            case "isEmpty": {
                this.printMacroName(targetMethodName);
                this.print("(").print(targetExpression).print(".data.size === 0").print(")");
                break;
            }
            case "iterator": {
                this.printMacroName(targetMethodName);
                this.print(targetExpression).print(".iterator()");
                break;
            }
            case "remove": {
                this.printMacroName(targetMethodName);
                this.print("(").print(targetExpression).print(".data.delete(").print(invocation.getArgument(0)).print(")").print(")");
                break;
            }
            case "removeAll": {
                this.printMacroName(targetMethodName);
                this.print("((s, c) => { const it = c.iterator(); const n = s.data.size; while (it.hasNext()) s.data.delete(it.next()); return n !== s.data.size; })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "retainAll": {
                this.printMacroName(targetMethodName);
                this.print("((s, c) => { const n = s.data.size; const s2 = new Set(); const it = c.iterator(); while(it.hasNext()) s2.add(it.next()); s.data.forEach(v => { if(!s2.has(v)) s.data.delete(v); }); return n !== s.data.size; })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "size": {
                this.printMacroName(targetMethodName);
                this.print(targetExpression).print(".data.size");
                break;
            }
            case "toArray": {
                this.printMacroName(targetMethodName);
                this.print("(").print("Array.from(").print(targetExpression).print(".data)").print(")");
                break;
            }
            default: {
                this.report((ExtendedElement)invocation, JSweetProblem.USER_ERROR, targetMethodName + " is not supported.");
            }
        }
    }

    private String createNewCollection(String className) {
        return String.format("{ className: '%s', data: null, iterator: null }", className);
    }
}

