/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.apache.log4j.Logger;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.util.DirectedGraph;
import org.jsweet.transpiler.util.ReferenceGrabber;

public class StaticInitilializerAnalyzer
extends TreeScanner {
    private JSweetContext context;
    private JCTree.JCCompilationUnit currentTopLevel;
    private int pass = 1;
    private static final Logger logger = Logger.getLogger(StaticInitilializerAnalyzer.class);
    public Map<Symbol.PackageSymbol, DirectedGraph<JCTree.JCCompilationUnit>> staticInitializersDependencies = new HashMap<Symbol.PackageSymbol, DirectedGraph<JCTree.JCCompilationUnit>>();
    public DirectedGraph<JCTree.JCCompilationUnit> globalStaticInitializersDependencies = new DirectedGraph();
    public Map<Symbol.TypeSymbol, JCTree.JCCompilationUnit> typesToCompilationUnits = new HashMap<Symbol.TypeSymbol, JCTree.JCCompilationUnit>();
    Set<Type> currentTopLevelImportedTypes = new HashSet<Type>();

    public StaticInitilializerAnalyzer(JSweetContext context) {
        this.context = context;
        this.context.referenceAnalyzer = this;
    }

    private DirectedGraph<JCTree.JCCompilationUnit> getGraph() {
        return this.globalStaticInitializersDependencies;
    }

    public boolean isDependent(JCTree.JCCompilationUnit cuSource, Symbol.TypeSymbol target) {
        JCTree.JCCompilationUnit cuTarget = this.typesToCompilationUnits.get(target);
        if (cuSource != null && cuTarget != null) {
            return this.globalStaticInitializersDependencies.hasEdge(cuTarget, cuSource);
        }
        return false;
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit compilationUnit) {
        this.currentTopLevel = compilationUnit;
        if (this.pass == 1) {
            this.getGraph().add(compilationUnit);
        } else {
            if (compilationUnit.packge.getQualifiedName().toString().startsWith("def.")) {
                return;
            }
            this.currentTopLevelImportedTypes.clear();
            for (JCTree.JCImport i : compilationUnit.getImports()) {
                if (i.qualid.type == null) continue;
                this.currentTopLevelImportedTypes.add(i.qualid.type);
            }
        }
        super.visitTopLevel(compilationUnit);
        this.currentTopLevel = null;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl classdecl) {
        if (this.pass == 1) {
            this.typesToCompilationUnits.put(classdecl.sym, this.currentTopLevel);
        } else {
            JCTree.JCCompilationUnit target;
            if (classdecl.extending != null && (target = this.typesToCompilationUnits.get(classdecl.extending.type.tsym)) != null && this.getGraph().contains(target)) {
                logger.debug((Object)("adding inheritance dependency: " + this.currentTopLevel.getSourceFile() + " -> " + target.getSourceFile()));
                this.getGraph().addEdge(target, this.currentTopLevel);
            }
            for (JCTree member : classdecl.defs) {
                JCTree.JCBlock initializer;
                if (member instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)member;
                    if (!field.getModifiers().getFlags().contains((Object)Modifier.STATIC) || field.getInitializer() == null || this.context.hasAnnotationType(field.sym, "jsweet.lang.StringType", "jsweet.lang.Erased")) continue;
                    this.acceptReferences(field.getInitializer());
                    continue;
                }
                if (!(member instanceof JCTree.JCBlock) || !(initializer = (JCTree.JCBlock)member).isStatic()) continue;
                this.acceptReferences(initializer);
            }
        }
        super.visitClassDef(classdecl);
    }

    private void acceptReferences(JCTree tree) {
        ReferenceGrabber refGrabber = new ReferenceGrabber();
        refGrabber.scan(tree);
        for (Symbol.TypeSymbol type : refGrabber.referencedTypes) {
            JCTree.JCCompilationUnit target;
            if (this.context.useModules && !this.currentTopLevel.packge.equals(type.packge()) || (target = this.typesToCompilationUnits.get(type)) == null || this.currentTopLevel.equals(target) || !this.getGraph().contains(target)) continue;
            logger.debug((Object)("adding static initializer dependency: " + this.currentTopLevel.getSourceFile() + " -> " + target.getSourceFile()));
            this.getGraph().addEdge(target, this.currentTopLevel);
        }
    }

    boolean isImported(Type type) {
        for (JCTree.JCImport i : this.currentTopLevel.getImports()) {
            if (i.type == null || !i.type.tsym.equals(type.tsym)) continue;
            return true;
        }
        return false;
    }

    public void process(Collection<JCTree.JCCompilationUnit> compilationUnits) {
        for (JCTree.JCCompilationUnit cu : compilationUnits) {
            this.scan(cu);
        }
        ++this.pass;
        for (JCTree.JCCompilationUnit cu : compilationUnits) {
            this.scan(cu);
        }
    }
}

