/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import java.io.File;
import java.util.Locale;
import javax.tools.Diagnostic;
import org.apache.log4j.Logger;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.JSweetTranspiler;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.TranspilationHandler;

public class JSweetDiagnosticHandler
extends BasicDiagnosticFormatter {
    protected TranspilationHandler transpilationHandler;
    protected JSweetContext context;
    private static final Logger logger = Logger.getLogger(JSweetTranspiler.class);

    public JSweetDiagnosticHandler(TranspilationHandler transpilationHandler, JSweetContext context) {
        super(JavacMessages.instance(context));
        this.context = context;
        this.transpilationHandler = transpilationHandler;
    }

    protected void reportJavaError(JCDiagnostic diagnostic, Locale locale) {
        this.transpilationHandler.report(JSweetProblem.INTERNAL_JAVA_ERROR, new SourcePosition(new File(diagnostic.getSource().getName()), null, (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber()), diagnostic.getMessage(locale));
    }

    private boolean ignoreError(JCDiagnostic diagnostic) {
        if (this.context.options.isIgnoreJavaErrors()) {
            return true;
        }
        return this.context.options.isIgnoreJavaFileNameError() && "compiler.err.class.public.should.be.in.file".equals(diagnostic.getCode());
    }

    @Override
    public String format(JCDiagnostic diagnostic, Locale locale) {
        if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
            if (!this.ignoreError(diagnostic)) {
                this.reportJavaError(diagnostic, locale);
            } else {
                return "";
            }
        }
        switch (diagnostic.getKind()) {
            case ERROR: {
                logger.error((Object)diagnostic);
                break;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                logger.debug((Object)diagnostic);
                break;
            }
            default: {
                logger.trace((Object)diagnostic);
            }
        }
        if (diagnostic.getSource() != null) {
            return diagnostic.getMessage(locale) + " at " + diagnostic.getSource().getName() + "(" + diagnostic.getLineNumber() + ")";
        }
        return diagnostic.getMessage(locale);
    }
}

