/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.util.AbstractTreeScanner;
import org.jsweet.transpiler.util.Util;

public class GlobalBeforeTranslationScanner
extends AbstractTreeScanner {
    Set<JCTree.JCVariableDecl> lazyInitializedStaticCandidates = new HashSet<JCTree.JCVariableDecl>();

    public GlobalBeforeTranslationScanner(TranspilationHandler logHandler, JSweetContext context) {
        super(logHandler, context, null);
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit topLevel) {
        if (topLevel.packge.getQualifiedName().toString().startsWith("def.")) {
            return;
        }
        this.compilationUnit = topLevel;
        super.visitTopLevel(topLevel);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl classdecl) {
        TypeMirror superClassType;
        if (this.getCompilationUnit().docComments.hasComment(classdecl)) {
            this.context.docComments.put(classdecl.sym, this.getCompilationUnit().docComments.getCommentText(classdecl));
        }
        if ((superClassType = this.context.modelTypes.erasure(classdecl.sym.getSuperclass())).toString().startsWith("java.") && !superClassType.toString().equals(Object.class.getName()) && !this.context.types.isSubtype(classdecl.type, this.context.symtab.throwableType) && !Util.isSourceElement(this.context.modelTypes.asElement(superClassType))) {
            this.context.addJdkSubclass(classdecl.sym.toString(), superClassType);
        }
        if (classdecl.sym.getEnclosingElement() instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clashingInnerClass;
            Type superClass = ((Symbol.ClassSymbol)classdecl.sym.getEnclosingElement()).getSuperclass();
            if (superClass != null && superClass.tsym != null && (clashingInnerClass = Util.findInnerClassDeclaration((Symbol.ClassSymbol)superClass.tsym, classdecl.name.toString())) != null && !this.context.hasClassNameMapping(clashingInnerClass)) {
                this.context.addClassNameMapping(classdecl.sym, "__" + ((Symbol)classdecl.sym.getEnclosingElement()).getQualifiedName().toString().replace('.', '_') + "_" + clashingInnerClass.getSimpleName());
            }
        } else if (classdecl.sym.getKind() == ElementKind.ANNOTATION_TYPE && this.context.hasAnnotationType(classdecl.sym, "jsweet.lang.Decorator")) {
            this.context.registerDecoratorAnnotation(classdecl);
        }
        boolean globals = false;
        if ("Globals".equals(classdecl.name.toString())) {
            globals = true;
        }
        for (JCTree def : classdecl.defs) {
            Symbol.MethodSymbol clashingMethod;
            Symbol.VarSymbol clashingField;
            if (def instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)def;
                if (this.getCompilationUnit().docComments.hasComment(var)) {
                    this.context.docComments.put(var.sym, this.getCompilationUnit().docComments.getCommentText(var));
                }
                if (!this.context.hasFieldNameMapping(var.sym)) {
                    Symbol.MethodSymbol m;
                    clashingField = null;
                    clashingField = Util.findFieldDeclaration((Symbol.ClassSymbol)classdecl.sym.getSuperclass().tsym, var.name);
                    if (clashingField != null && clashingField.isPrivate() && !this.context.hasFieldNameMapping(clashingField)) {
                        this.context.addFieldNameMapping(var.sym, "__" + classdecl.sym.toString().replace(".", "_") + "_" + var.name.toString());
                    }
                    if ((m = Util.findMethodDeclarationInType(this.context.types, classdecl.sym, var.name.toString(), null)) != null) {
                        this.context.addFieldNameMapping(var.sym, "__" + var.name.toString());
                    }
                }
                if (!(!var.getModifiers().getFlags().contains((Object)Modifier.STATIC) || var.getModifiers().getFlags().contains((Object)Modifier.FINAL) && var.init != null && var.init instanceof JCTree.JCLiteral)) {
                    this.lazyInitializedStaticCandidates.add(var);
                }
            } else if (def instanceof JCTree.JCBlock && ((JCTree.JCBlock)def).isStatic()) {
                this.context.countStaticInitializer(classdecl.sym);
            }
            if (!(def instanceof JCTree.JCMethodDecl)) continue;
            if (globals && ((JCTree.JCMethodDecl)def).sym.isStatic()) {
                this.context.registerGlobalMethod(classdecl, (JCTree.JCMethodDecl)def);
                continue;
            }
            JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)def;
            if (method.sym.isPrivate() && method.sym.type instanceof Type.MethodType && !method.sym.isStaticOrInstanceInit() && !method.sym.isStatic() && !method.sym.isConstructor() && (clashingMethod = Util.findMethodDeclarationInType2(this.context.types, classdecl.sym.getSuperclass().tsym, method.name.toString(), (Type.MethodType)method.sym.type)) != null && clashingMethod.isPrivate()) {
                this.context.addMethodNameMapping(method.sym, "__" + classdecl.sym.toString().replace(".", "_") + "_" + method.name.toString());
            }
            clashingField = null;
            clashingField = Util.findFieldDeclaration((Symbol.ClassSymbol)classdecl.sym.getSuperclass().tsym, method.name);
            if (clashingField == null || !clashingField.isPrivate() || this.context.hasFieldNameMapping(clashingField)) continue;
            this.context.addFieldNameMapping(clashingField, "__" + classdecl.sym.toString().replace(".", "_") + "_" + ((JCTree.JCMethodDecl)def).name.toString());
        }
        super.visitClassDef(classdecl);
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl methodDecl) {
        if (this.getCompilationUnit().docComments.hasComment(methodDecl)) {
            this.context.docComments.put(methodDecl.sym, this.getCompilationUnit().docComments.getCommentText(methodDecl));
        }
        if (methodDecl.mods.getFlags().contains((Object)Modifier.DEFAULT)) {
            this.getContext().addDefaultMethod(this.compilationUnit, this.getParent(JCTree.JCClassDecl.class), methodDecl);
        }
        if (!this.getContext().ignoreWildcardBounds) {
            this.scan(methodDecl.params);
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard wildcard) {
        Symbol.MethodSymbol container = null;
        JCTree.JCMethodDecl method = this.getParent(JCTree.JCMethodDecl.class);
        if (method != null) {
            container = method.sym;
        }
        if (container != null) {
            this.getContext().registerWildcard(container, wildcard);
            this.scan(wildcard.getBound());
        }
    }

    public void process(List<JCTree.JCCompilationUnit> compilationUnits) {
        for (JCTree.JCCompilationUnit compilationUnit : compilationUnits) {
            this.scan(compilationUnit);
        }
        for (JCTree.JCVariableDecl var : this.lazyInitializedStaticCandidates) {
            if (this.context.getStaticInitializerCount(var.sym.enclClass()) == 0 && var.init == null || Util.isLiteralExpression(var.init)) continue;
            this.context.lazyInitializedStatics.add(var.sym);
        }
    }
}

