/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jsweet.TranspilationTask;

public class JSweetFileWatcher {
    private static final Logger logger = Logger.getLogger(JSweetFileWatcher.class);
    private TranspilationThread transpilationThread;
    private static final SensitivityWatchEventModifier SENSITIVITY_WATCH_EVENT_MODIFIER = SensitivityWatchEventModifier.HIGH;
    private static ReentrantLock __Lock = new ReentrantLock();
    private static LinkedList<String> __RandomKeysTrigger = new LinkedList();
    protected TranspilationTask transpilationTask;

    public JSweetFileWatcher(TranspilationTask transpilationTask) {
        this.transpilationTask = transpilationTask;
    }

    public void execute() {
        logger.info((Object)"starting file watcher... ");
        this.transpilationThread = new TranspilationThread();
        this.transpilationThread.start();
        this.initialize();
    }

    private void initialize() {
        List<File> sourcePaths = this.transpilationTask.getInputDirList();
        try {
            while (true) {
                WatchService watchService = FileSystems.getDefault().newWatchService();
                ArrayList<Path> watchedPaths = new ArrayList<Path>();
                logger.info((Object)"registering source paths");
                for (File sourceDirectory : sourcePaths) {
                    Path path = sourceDirectory.toPath();
                    watchedPaths.add(path);
                    this.walkDirectoryTree(path, watchedPaths, watchService);
                }
                logger.info((Object)"done registering source paths");
                logger.info((Object)"listening for file change... ");
                try {
                    this.watch(watchService);
                }
                catch (Exception exception) {
                    watchService.close();
                }
                Thread.yield();
            }
        }
        catch (IOException ioException) {
            logger.error((Object)ioException);
            return;
        }
    }

    private void walkDirectoryTree(Path startPath, List<Path> watchedPaths, WatchService watchService) throws IOException {
        RegisteringFileTreeScanner scanner = new RegisteringFileTreeScanner(watchedPaths, watchService);
        Files.walkFileTree(startPath, scanner);
    }

    private void watch(WatchService watchService) throws Exception {
        WatchKey key;
        boolean valid;
        do {
            try {
                key = watchService.take();
            }
            catch (InterruptedException x) {
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                if (kind != StandardWatchEventKinds.ENTRY_MODIFY && kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                logger.info((Object)("file change detected" + filename));
                __Lock.lock();
                __RandomKeysTrigger.add(UUID.randomUUID().toString());
                __Lock.unlock();
            }
        } while (valid = key.reset());
        try {
            watchService.close();
        }
        catch (IOException ioException) {
            logger.error((Object)ioException);
        }
    }

    private class TranspilationThread
    extends Thread {
        public TranspilationThread() {
            this.setPriority(10);
        }

        @Override
        public void run() {
            while (true) {
                if (__Lock.tryLock()) {
                    if (__RandomKeysTrigger.size() != 0) {
                        __RandomKeysTrigger.removeLast();
                        try {
                            JSweetFileWatcher.this.transpilationTask.run();
                        }
                        catch (Exception exception) {
                            logger.info((Object)exception.getMessage());
                        }
                    }
                    __Lock.unlock();
                }
                TranspilationThread.yield();
            }
        }
    }

    private static class RegisteringFileTreeScanner
    extends SimpleFileVisitor<Path> {
        private List<Path> directories;
        private WatchService watchService;

        public RegisteringFileTreeScanner(List<Path> directories, WatchService watchService) {
            this.directories = directories;
            this.watchService = watchService;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory, IOException exc) {
            this.directories.add(directory);
            try {
                directory.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW}, SENSITIVITY_WATCH_EVENT_MODIFIER);
                logger.info((Object)("added [" + directory.toString() + "]"));
            }
            catch (IOException ioException) {
                logger.error((Object)("cannot register [" + directory.toString() + "]"));
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

