/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.Set;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.util.AbstractTreePrinter;
import org.jsweet.transpiler.util.Util;

public class TypeChecker {
    public static boolean jdkAllowed = true;
    static final Set<String> AUTHORIZED_ACCESSED_TYPES = new HashSet<String>();
    static final Set<String> AUTHORIZED_DECLARED_TYPES = new HashSet<String>();
    public static final Set<String> NUMBER_TYPES = new HashSet<String>();
    public static final Set<String> NUMBER_TYPE_NAMES = new HashSet<String>();
    public static final Set<String> AUTHORIZED_OBJECT_METHODS = new HashSet<String>();
    public static final Set<String> AUTHORIZED_STRING_METHODS = new HashSet<String>();
    public static final Set<String> FORBIDDEN_JDK_FUNCTIONAL_METHODS = new HashSet<String>();
    private AbstractTreePrinter translator;

    public TypeChecker(AbstractTreePrinter translator) {
        this.translator = translator;
    }

    public boolean checkApply(JCTree.JCMethodInvocation invocation, Symbol.MethodSymbol methSym) {
        if (!JSweetConfig.isJDKReplacementMode() && !jdkAllowed && methSym.owner.toString().startsWith("java.")) {
            if (invocation.meth instanceof JCTree.JCFieldAccess && "super".equals(((JCTree.JCFieldAccess)invocation.meth).selected.toString())) {
                this.translator.report((JCTree)invocation, JSweetProblem.JDK_METHOD, methSym);
                return false;
            }
            if (this.translator.getContext().strictMode || AUTHORIZED_OBJECT_METHODS.contains(methSym.name.toString())) {
                return true;
            }
            if (methSym.owner.toString().equals(String.class.getName()) && AUTHORIZED_STRING_METHODS.contains(methSym.toString())) {
                return true;
            }
            this.translator.report((JCTree)invocation, JSweetProblem.JDK_METHOD, methSym);
            return false;
        }
        return true;
    }

    public boolean checkType(JCTree declaringElement, Name declaringElementName, JCTree.JCExpression typeExpression) {
        if (!JSweetConfig.isJDKReplacementMode()) {
            if (typeExpression instanceof JCTree.JCArrayTypeTree) {
                return this.checkType(declaringElement, declaringElementName, ((JCTree.JCArrayTypeTree)typeExpression).elemtype);
            }
            String type = typeExpression.type.tsym.toString();
            if (!(jdkAllowed || this.translator.getContext().strictMode || !type.startsWith("java.") || AUTHORIZED_DECLARED_TYPES.contains(type) || NUMBER_TYPES.contains(type) || type.startsWith("java.util.function"))) {
                this.translator.report(declaringElement, declaringElementName, JSweetProblem.JDK_TYPE, type);
                return false;
            }
        }
        return true;
    }

    public boolean checkSelect(JCTree.JCFieldAccess select) {
        String type;
        if (!JSweetConfig.isJDKReplacementMode() && select.selected.type instanceof Type.ClassType && (type = select.selected.type.tsym.toString()).startsWith("java.") && !jdkAllowed && !AUTHORIZED_ACCESSED_TYPES.contains(type) && !type.startsWith("java.util.function")) {
            this.translator.report((JCTree)select, JSweetProblem.JDK_TYPE, type);
            return false;
        }
        return true;
    }

    private boolean checkUnionTypeAssignment(Types types, JCTree parent, Type assigned, JCTree.JCMethodInvocation union) {
        if (((JCTree.JCExpression)union.args.head).type.tsym.getQualifiedName().toString().startsWith("jsweet.util.union.Union")) {
            if (!Util.containsAssignableType(types, ((JCTree.JCExpression)union.args.head).type.getTypeArguments(), assigned)) {
                this.translator.report(parent, JSweetProblem.UNION_TYPE_MISMATCH, new Object[0]);
                return false;
            }
        } else {
            String typeName = ((JCTree.JCExpression)union.args.head).type.toString();
            if ("def.js.Function".equals(typeName) || "jsweet.lang.Function".equals(typeName)) {
                return true;
            }
            if (!Util.containsAssignableType(types, assigned.getTypeArguments(), ((JCTree.JCExpression)union.args.head).type)) {
                this.translator.report(parent, JSweetProblem.UNION_TYPE_MISMATCH, new Object[0]);
                return false;
            }
        }
        return true;
    }

    public boolean checkUnionTypeAssignment(Types types, JCTree parent, JCTree.JCMethodInvocation union) {
        if (parent instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)parent;
            if (decl.init == union) {
                return this.checkUnionTypeAssignment(types, parent, decl.type, union);
            }
        } else if (parent instanceof JCTree.JCAssign) {
            JCTree.JCAssign assign = (JCTree.JCAssign)parent;
            if (assign.rhs == union) {
                return this.checkUnionTypeAssignment(types, parent, assign.lhs.type, union);
            }
        } else if (parent instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation invocation = (JCTree.JCMethodInvocation)parent;
            for (JCTree jCTree : invocation.args) {
                if (jCTree != union) continue;
                return this.checkUnionTypeAssignment(types, parent, jCTree.type, union);
            }
        }
        return true;
    }

    static {
        AUTHORIZED_DECLARED_TYPES.add(String.class.getName());
        AUTHORIZED_DECLARED_TYPES.add(Object.class.getName());
        AUTHORIZED_DECLARED_TYPES.add(Class.class.getName());
        AUTHORIZED_DECLARED_TYPES.add(Boolean.class.getName());
        AUTHORIZED_DECLARED_TYPES.add(Void.class.getName());
        NUMBER_TYPES.add(Integer.class.getName());
        NUMBER_TYPES.add(Double.class.getName());
        NUMBER_TYPES.add(Number.class.getName());
        NUMBER_TYPES.add(Float.class.getName());
        NUMBER_TYPES.add(Byte.class.getName());
        NUMBER_TYPES.add(Short.class.getName());
        NUMBER_TYPE_NAMES.add(Integer.class.getSimpleName());
        NUMBER_TYPE_NAMES.add(Double.class.getSimpleName());
        NUMBER_TYPE_NAMES.add(Number.class.getSimpleName());
        NUMBER_TYPE_NAMES.add(Float.class.getSimpleName());
        NUMBER_TYPE_NAMES.add(Byte.class.getSimpleName());
        NUMBER_TYPE_NAMES.add(Short.class.getSimpleName());
        AUTHORIZED_DECLARED_TYPES.add(Runnable.class.getName());
        AUTHORIZED_OBJECT_METHODS.add("toString");
        AUTHORIZED_STRING_METHODS.add("charAt(int)");
        AUTHORIZED_STRING_METHODS.add("concat(java.lang.String)");
        AUTHORIZED_STRING_METHODS.add("indexOf(java.lang.String)");
        AUTHORIZED_STRING_METHODS.add("lastIndexOf(java.lang.String)");
        AUTHORIZED_STRING_METHODS.add("lastIndexOf(java.lang.String,int)");
        AUTHORIZED_STRING_METHODS.add("substring(int)");
        AUTHORIZED_STRING_METHODS.add("substring(int,int)");
        AUTHORIZED_STRING_METHODS.add("replace(java.lang.CharSequence,java.lang.CharSequence)");
        AUTHORIZED_STRING_METHODS.add("split(java.lang.String)");
        AUTHORIZED_STRING_METHODS.add("trim()");
        AUTHORIZED_STRING_METHODS.add("toLowerCase()");
        AUTHORIZED_STRING_METHODS.add("toUpperCase()");
        AUTHORIZED_STRING_METHODS.add("length()");
        FORBIDDEN_JDK_FUNCTIONAL_METHODS.add("and");
        FORBIDDEN_JDK_FUNCTIONAL_METHODS.add("negate");
        FORBIDDEN_JDK_FUNCTIONAL_METHODS.add("or");
        FORBIDDEN_JDK_FUNCTIONAL_METHODS.add("andThen");
    }
}

