/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jsweet.transpiler.util.Position;

public class SourceMap {
    private SortedSet<Entry> entries = new TreeSet<Entry>();
    private List<Entry> insertionOrderEntries = new ArrayList<Entry>();
    private int minOutputLine = 0;
    private int maxOutputLine = 0;

    public final Entry addEntry(Position inputPosition, Position outputPosition) {
        Entry entry = new Entry(inputPosition, outputPosition);
        this.entries.add(entry);
        this.insertionOrderEntries.add(entry);
        this.maxOutputLine = Math.max(this.maxOutputLine, outputPosition.getLine());
        return entry;
    }

    public final Position findInputPosition(Position outputPosition) {
        return this.findInputPosition(outputPosition.getLine(), outputPosition.getColumn());
    }

    public final Position findInputPosition(int outputLine, int outputColumn) {
        if (this.entries.isEmpty()) {
            return null;
        }
        if (outputLine < this.minOutputLine) {
            return null;
        }
        if (outputLine > this.maxOutputLine) {
            return null;
        }
        if (this.entries != null) {
            Entry[] e = this.entries.toArray(new Entry[0]);
            int i = 0;
            while (i < this.entries.size()) {
                if (i == e.length - 1 || e[i].getOutputPosition().getLine() == outputLine || e[i + 1].getOutputPosition().getLine() > outputLine) {
                    while (i + 1 < e.length && e[i + 1].getOutputPosition().getLine() == outputLine && e[i].getOutputPosition().getColumn() < outputColumn) {
                        ++i;
                    }
                    return e[i].getInputPosition();
                }
                ++i;
            }
        }
        return null;
    }

    public final void shiftOutputPositions(int lineOffset) {
        for (Entry entry : this.entries) {
            entry.setOutputPosition(new Position(entry.getOutputPosition().getLine() + lineOffset, entry.getOutputPosition().getColumn()));
        }
        this.minOutputLine += lineOffset;
        this.maxOutputLine += lineOffset;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Entry entry : this.entries) {
            sb.append(entry.toString());
            sb.append(" ");
        }
        return sb.toString();
    }

    public List<Entry> getSortedEntries(Comparator<Entry> comparator) {
        ArrayList<Entry> list = new ArrayList<Entry>(this.entries);
        list.sort(comparator);
        return list;
    }

    public void removeLastInsertedEntry() {
        if (this.entries.isEmpty()) {
            return;
        }
        Entry e = this.insertionOrderEntries.remove(this.insertionOrderEntries.size() - 1);
        this.entries.remove(e);
        this.maxOutputLine = 0;
        for (Entry entry : this.entries) {
            this.maxOutputLine = Math.max(this.maxOutputLine, entry.getOutputPosition().getLine());
        }
    }

    public static final class Entry
    implements Comparable<Entry> {
        private final Position inputPosition;
        private Position outputPosition;

        private Entry(Position inputPosition, Position outputPosition) {
            this.inputPosition = inputPosition;
            this.outputPosition = outputPosition;
        }

        public final Position getInputPosition() {
            return this.inputPosition;
        }

        public final Position getOutputPosition() {
            return this.outputPosition;
        }

        public final void setOutputPosition(Position position) {
            this.outputPosition = position;
        }

        @Override
        public int compareTo(Entry entry) {
            return this.getInputPosition().compareTo(entry.getInputPosition());
        }

        public String toString() {
            return String.valueOf(this.getInputPosition().toString()) + "->" + this.getOutputPosition().toString();
        }
    }
}

