/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ProcessUtil {
    private static final Logger logger = Logger.getLogger(ProcessUtil.class);
    public static final String NODE_MINIMUM_VERSION = "4.4.0";
    private static boolean initialized = false;
    public static File USER_HOME_DIR = new File(System.getProperty("user.home"));
    public static File NPM_DIR = new File(USER_HOME_DIR, ".jsweet-node_modules");
    private static List<String> nodeCommandsBaseNames = Arrays.asList("tsc", "browserify", "phantomjs");
    public static String NODE_COMMAND = "node";
    public static String NPM_COMMAND = "npm";
    private static String EXTRA_PATH = "";
    private static final Map<String, String> globalExecutableCache = new HashMap<String, String>();

    public static void initNode() {
        if (!initialized) {
            if (!System.getenv("PATH").contains("/usr/local/bin") && new File("/usr/local/bin/node").exists()) {
                ProcessUtil.addExtraPath("/usr/local/bin");
                NODE_COMMAND = "/usr/local/bin/node";
                NPM_COMMAND = "/usr/local/bin/npm";
            }
            initialized = true;
        }
        logger.debug((Object)("extra path: " + EXTRA_PATH));
    }

    public static void addExtraPath(String extraPath) {
        EXTRA_PATH = String.valueOf(EXTRA_PATH) + extraPath + File.pathSeparator;
    }

    public static String getGlobalNpmPackageNodeMainFilePath(String nodeModule, String mainFileName) {
        if (ProcessUtil.isWindows()) {
            return String.valueOf(NPM_DIR.getPath()) + File.separator + "node_modules" + File.separator + "typescript" + File.separator + "bin" + File.separator + mainFileName;
        }
        return String.valueOf(NPM_DIR.getPath()) + File.separator + "bin" + File.separator + mainFileName;
    }

    public static String getGlobalNpmPackageExecutablePath(String command) {
        File commandFile = new File(command);
        if (commandFile.isFile() && commandFile.isAbsolute()) {
            return command;
        }
        if (ProcessUtil.isWindows()) {
            return String.valueOf(NPM_DIR.getPath()) + File.separator + command + ".cmd";
        }
        return String.valueOf(NPM_DIR.getPath()) + File.separator + "bin" + File.separator + command;
    }

    public static String getGlobalNpmPackagePath(String packageName) {
        return String.valueOf(NPM_DIR.getPath()) + File.separator + "node_modules" + File.separator + packageName;
    }

    public static boolean isInstalledWithNpm(String command) {
        return new File(ProcessUtil.getGlobalNpmPackageExecutablePath(command)).exists();
    }

    public static Process runCommand(String command, Consumer<String> stdoutConsumer, Runnable errorHandler, String ... args) {
        return ProcessUtil.runCommand(command, null, false, stdoutConsumer, null, errorHandler, args);
    }

    public static Process runAsyncCommand(String command, Consumer<String> stdoutConsumer, Consumer<Process> endConsumer, Runnable errorHandler, String ... args) {
        return ProcessUtil.runCommand(command, null, true, stdoutConsumer, endConsumer, errorHandler, args);
    }

    public static Process runCommand(final String command, File directory, boolean async, final Consumer<String> stdoutConsumer, final Consumer<Process> endConsumer, final Runnable errorHandler, String ... args) {
        Object[] cmd;
        if (ProcessUtil.isWindows()) {
            String commandExecutableName = FilenameUtils.getBaseName((String)command);
            cmd = nodeCommandsBaseNames.contains(commandExecutableName) ? new String[]{ProcessUtil.getGlobalNpmPackageExecutablePath(command)} : new String[]{"cmd", "/c", command};
            cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])args);
        } else if (nodeCommandsBaseNames.contains(command)) {
            cmd = new String[]{ProcessUtil.getGlobalNpmPackageExecutablePath(command)};
            cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])args);
        } else {
            String cmdAndArgs = StringUtils.join((Object[])ArrayUtils.insert((int)0, (Object[])args, (Object[])new String[]{command}), (String)" ");
            cmd = new String[]{"/bin/sh", "-c", cmdAndArgs};
        }
        logger.debug((Object)("run command: " + StringUtils.join((Object[])cmd, (String)" ")));
        Process[] processReference = new Process[1];
        try {
            Process process;
            ProcessBuilder processBuilder = new ProcessBuilder((String[])cmd);
            processBuilder.redirectErrorStream(true);
            if (directory != null) {
                processBuilder.directory(directory);
            }
            if (!StringUtils.isBlank((CharSequence)EXTRA_PATH)) {
                processBuilder.environment().put("PATH", String.valueOf(processBuilder.environment().get("PATH")) + File.pathSeparator + EXTRA_PATH);
            }
            processReference[0] = process = processBuilder.start();
            logger.debug((Object)("started " + processBuilder.command()));
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                Process process2 = process.destroyForcibly();
            }));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    block16: {
                        try {
                            Throwable throwable = null;
                            Object var2_4 = null;
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));){
                                String line;
                                while ((line = in.readLine()) != null) {
                                    if (stdoutConsumer != null) {
                                        stdoutConsumer.accept(line);
                                        continue;
                                    }
                                    logger.info((Object)(String.valueOf(command) + " - " + line));
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            process.waitFor();
                            if (endConsumer != null) {
                                endConsumer.accept(process);
                            }
                            if (process.exitValue() != 0 && errorHandler != null) {
                                errorHandler.run();
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            if (errorHandler == null) break block16;
                            errorHandler.run();
                        }
                    }
                }
            };
            if (async) {
                new Thread(runnable).start();
            } else {
                runnable.run();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (errorHandler != null) {
                errorHandler.run();
            }
            return null;
        }
        return processReference[0];
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static void installNodePackage(String nodePackageName, String version, boolean global) {
        logger.debug((Object)("installing " + nodePackageName + " with npm"));
        ProcessUtil.initNode();
        if (global) {
            ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, null, null, null, "install", "--prefix", NPM_DIR.getPath(), version == null ? nodePackageName : String.valueOf(nodePackageName) + "@" + version, "-g");
        } else {
            ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, null, null, null, "install", version == null ? nodePackageName : String.valueOf(nodePackageName) + "@" + version, "--save");
        }
    }

    public static boolean isNodePackageInstalled(String nodePackageName) {
        logger.debug((Object)("checking installation of " + nodePackageName + " with npm"));
        ProcessUtil.initNode();
        boolean[] installed = new boolean[1];
        ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, (String line) -> {
            if (!installed[0]) {
                blArray[0] = line.endsWith("/" + nodePackageName);
            }
        }, null, null, "ls", "--parseable", nodePackageName);
        return installed[0];
    }

    public static void uninstallNodePackage(String nodePackageName, boolean global) {
        logger.debug((Object)("uninstalling " + nodePackageName + " with npm"));
        ProcessUtil.initNode();
        if (global) {
            ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, null, null, null, "uninstall", "--prefix", NPM_DIR.getPath(), nodePackageName, "-g");
        } else {
            ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, null, null, null, "uninstall", nodePackageName);
        }
    }

    public static boolean isVersionHighEnough(String currentVersion, String minimumVersion) {
        currentVersion = currentVersion.replace("v", "");
        minimumVersion = minimumVersion.replace("v", "");
        String[] currentVersionParts = currentVersion.split("[.]");
        String[] minimumVersionParts = minimumVersion.split("[.]");
        int i = 0;
        while (i < currentVersionParts.length) {
            int minimumVersionPart;
            int currentVersionPart;
            block5: {
                if (minimumVersionParts.length <= i) break;
                currentVersionPart = Integer.parseInt(currentVersionParts[i]);
                minimumVersionPart = Integer.parseInt(minimumVersionParts[i]);
                if (currentVersionPart <= minimumVersionPart) break block5;
                return true;
            }
            try {
                if (currentVersionPart < minimumVersionPart) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                logger.error((Object)("unexpected version token " + currentVersion + " / " + minimumVersion), (Throwable)e);
            }
            ++i;
        }
        return true;
    }

    public static String findGlobalExecutable(String fileName, String packageName) {
        String path2 = globalExecutableCache.get(fileName);
        if (path2 == null) {
            try {
                File programFilesPath;
                String globalPackagesDir = NPM_DIR.getAbsolutePath();
                Stream<Path> searchPaths = Files.walk(Paths.get(globalPackagesDir, new String[0]), new FileVisitOption[0]);
                if (ProcessUtil.isWindows() && (programFilesPath = new File(String.valueOf(System.getenv("ProgramFiles")) + "/nodejs/node_modules/" + packageName)).isDirectory()) {
                    searchPaths = Stream.concat(searchPaths, Files.walk(Paths.get(programFilesPath.getAbsolutePath(), new String[0]), FileVisitOption.FOLLOW_LINKS));
                }
                path2 = searchPaths.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(f -> {
                    String file = f.toFile().getName();
                    return file.equals(fileName);
                }).map(f -> f.toFile().getAbsolutePath()).findFirst().orElse(null);
                globalExecutableCache.put(fileName, path2);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot find global executable", e);
            }
        }
        return path2;
    }
}

