/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetOptions;
import org.jsweet.transpiler.util.Util;

public class JavaCompilationEnvironment {
    public final JavaFileManager fileManager;
    public final JavaCompiler compiler;
    public final JSweetContext context;
    public final Log log;
    public final Types types;
    public final Symtab symtab;
    public final Names names;
    public final Options options;

    public static JavaCompilationEnvironment create(JSweetOptions jsweetOptions, String classPath) {
        JSweetContext context = new JSweetContext(jsweetOptions);
        Options options = Options.instance(context);
        options.put(Option.CLASSPATH, classPath);
        options.put(Option.XLINT, "path");
        context.put(Log.outKey, new PrintWriter(System.out));
        options.put(String.valueOf(Option.XLINT_CUSTOM.text) + "-" + Lint.LintCategory.OVERRIDES.option, "true");
        JavacFileManager.preRegister(context);
        JavaFileManager fileManager = context.get(JavaFileManager.class);
        Log log = Log.instance(context);
        log.emitWarnings = false;
        log.suppressNotes = true;
        Types javacTypes = Types.instance(context);
        JavaCompiler compiler = JavaCompiler.instance(context);
        compiler.attrParseOnly = true;
        compiler.verbose = false;
        compiler.genEndPos = true;
        compiler.keepComments = true;
        Names names = Names.instance(context);
        Symtab symtab = Symtab.instance(context);
        return new JavaCompilationEnvironment(fileManager, compiler, options, context, log, javacTypes, names, symtab);
    }

    private JavaCompilationEnvironment(JavaFileManager fileManager, JavaCompiler compiler, Options options, JSweetContext context, Log log, Types javacTypes, Names names, Symtab symtab) {
        this.fileManager = fileManager;
        this.compiler = compiler;
        this.options = options;
        this.context = context;
        this.log = log;
        this.types = javacTypes;
        this.names = names;
        this.symtab = symtab;
    }

    public java.util.List<JCTree.JCCompilationUnit> parseAndAttributeJavaFiles(java.util.List<File> javaFiles) throws IOException {
        List<JavaFileObject> sources = Util.toJavaFileObjects(this.fileManager, javaFiles);
        List<JCTree.JCCompilationUnit> compilationUnits = this.compiler.enterTrees(this.compiler.parseFiles(sources));
        this.compiler.attribute(this.compiler.todo);
        return compilationUnits;
    }
}

