/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.eval;

import java.util.regex.Matcher;
import org.jsweet.transpiler.JSweetTranspiler;
import org.jsweet.transpiler.util.EvaluationResult;

class TraceBasedEvaluationResult
implements EvaluationResult {
    private String trace;

    public TraceBasedEvaluationResult(String trace) {
        this.trace = trace;
    }

    @Override
    public <T> T get(String variableName) {
        String[] var = null;
        Matcher matcher = JSweetTranspiler.EXPORTED_VAR_REGEXP.matcher(this.trace);
        int index = 0;
        boolean match = true;
        while (match) {
            match = matcher.find(index);
            if (!match) continue;
            if (variableName.equals(matcher.group(1))) {
                var = new String[]{matcher.group(1), matcher.group(2)};
                match = false;
            }
            index = matcher.end() - 1;
        }
        if (var == null) {
            return null;
        }
        void stringValue = var[1];
        try {
            return (T)Integer.valueOf(Integer.parseInt((String)stringValue));
        }
        catch (Exception e1) {
            try {
                return (T)Double.valueOf(Double.parseDouble((String)stringValue));
            }
            catch (Exception e2) {
                if ("true".equals(stringValue)) {
                    return (T)Boolean.TRUE;
                }
                if ("false".equals(stringValue)) {
                    return (T)Boolean.FALSE;
                }
                if ("undefined".equals(stringValue)) {
                    return null;
                }
                return stringValue;
            }
        }
    }

    @Override
    public String getExecutionTrace() {
        return this.trace;
    }
}

