/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.eval;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.util.Arrays;
import java.util.Map;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetTranspiler;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.eval.EvalOptions;
import org.jsweet.transpiler.eval.RuntimeEval;
import org.jsweet.transpiler.util.EvaluationResult;
import org.jsweet.transpiler.util.MainMethodFinder;
import org.jsweet.transpiler.util.Util;

public class JavaEval
extends RuntimeEval {
    private JSweetTranspiler transpiler;

    public JavaEval(JSweetTranspiler transpiler, EvalOptions options) {
        this.transpiler = transpiler;
    }

    public EvaluationResult performEval(SourceFile[] sourceFiles) throws Exception {
        JSweetContext context = new JSweetContext(this.transpiler);
        Options options = Options.instance(context);
        if (this.transpiler.getClassPath() != null) {
            options.put(Option.CLASSPATH, this.transpiler.getClassPath());
        }
        options.put(Option.XLINT, "path");
        if (this.transpiler.getEncoding() != null) {
            options.put(Option.ENCODING, this.transpiler.getEncoding());
        }
        JavacFileManager.preRegister(context);
        JavaFileManager fileManager = context.get(JavaFileManager.class);
        List<JavaFileObject> fileObjects = Util.toJavaFileObjects(fileManager, Arrays.asList(SourceFile.toFiles(sourceFiles)));
        JavaCompiler compiler = JavaCompiler.instance(context);
        compiler.attrParseOnly = true;
        compiler.verbose = true;
        compiler.genEndPos = false;
        compiler.encoding = this.transpiler.getEncoding();
        Log log = Log.instance(context);
        log.dumpOnError = false;
        log.emitWarnings = false;
        this.logger.info((Object)("parsing: " + fileObjects));
        List<JCTree.JCCompilationUnit> compilationUnits = compiler.enterTrees(compiler.parseFiles(fileObjects));
        MainMethodFinder mainMethodFinder = new MainMethodFinder();
        try {
            for (JCTree.JCCompilationUnit cu : compilationUnits) {
                cu.accept(mainMethodFinder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mainMethodFinder.mainMethod != null) {
            try {
                this.initExportedVarMap();
                Class<?> c = Class.forName(((Symbol)mainMethodFinder.mainMethod.getEnclosingElement()).getQualifiedName().toString());
                c.getMethod("main", String[].class).invoke(null, new Object[]{null});
            }
            catch (Exception e) {
                throw new Exception("evalution error", e);
            }
        }
        final Map<String, Object> map = this.getExportedVarMap();
        return new EvaluationResult(){

            @Override
            public <T> T get(String variableName) {
                return (T)map.get("_exportedVar_" + variableName);
            }

            public String toString() {
                return map.toString();
            }

            @Override
            public String getExecutionTrace() {
                return "<not available>";
            }
        };
    }
}

