/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DirectedGraph<T>
implements Collection<T> {
    private Map<T, Node<T>> nodes = new LinkedHashMap<T, Node<T>>();

    @Override
    public boolean addAll(Collection<? extends T> elements) {
        for (T element : elements) {
            this.add(element);
        }
        return true;
    }

    @Override
    public boolean add(T element) {
        if (this.nodes.containsKey(element)) {
            return false;
        }
        Node<T> node = new Node<T>(this, element);
        this.nodes.put(element, node);
        return true;
    }

    @Override
    public void clear() {
        this.nodes.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.nodes.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DirectedGraph)) {
            return false;
        }
        return this.nodes.equals(((DirectedGraph)obj).nodes);
    }

    @Override
    public int hashCode() {
        return this.nodes.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.nodes.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.nodes.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.remove(o);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean b = false;
        for (T element : this.nodes.keySet()) {
            if (c.contains(element)) continue;
            this.remove(element);
            b = true;
        }
        return b;
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public Object[] toArray() {
        return this.nodes.keySet().toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.toArray(a);
    }

    public void add(T ... elements) {
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            this.add(element);
            ++n2;
        }
    }

    public void addEdge(T sourceElement, T destinationElement) {
        if (sourceElement.equals(destinationElement)) {
            return;
        }
        if (this.hasEdge(sourceElement, destinationElement)) {
            return;
        }
        this.nodes.get(sourceElement).addEdge(destinationElement);
    }

    public <U extends T> void buildEdges(Comparator<U> nodeComparator) {
        for (T e1 : this.nodes.keySet()) {
            for (T e2 : this.nodes.keySet()) {
                int i = nodeComparator.compare(e1, e2);
                if (i < 0) {
                    this.addEdge(e1, e2);
                }
                if (i <= 0) continue;
                this.addEdge(e2, e1);
            }
        }
    }

    public void addEdges(T sourceElement, T ... destinationElements) {
        this.nodes.get(sourceElement).addEdges(destinationElements);
    }

    public boolean hasEdge(T sourceElement, T destinationElement) {
        if (this.nodes.get(sourceElement) == null) {
            return false;
        }
        for (Edge edge : this.nodes.get(sourceElement).outEdges) {
            if (edge.to.element != destinationElement) continue;
            return true;
        }
        return false;
    }

    public List<T> getDestinationElements(T sourceElement) {
        ArrayList l = new ArrayList();
        if (this.nodes.get(sourceElement) == null) {
            return null;
        }
        for (Edge edge : this.nodes.get(sourceElement).outEdges) {
            l.add(edge.to.element);
        }
        return l;
    }

    public List<T> getSourceElements(T destinationElement) {
        if (this.nodes.get(destinationElement) == null) {
            return null;
        }
        ArrayList l = new ArrayList();
        for (Edge edge : this.nodes.get(destinationElement).inEdges) {
            l.add(edge.from.element);
        }
        return l;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[");
        for (T element : this.nodes.keySet()) {
            s.append(element.toString());
            s.append("->");
            s.append(this.getDestinationElements(element));
            s.append(",");
        }
        if (!this.nodes.isEmpty()) {
            s.deleteCharAt(s.length() - 1);
        }
        s.append("]");
        return s.toString();
    }

    private List<T> toElements(List<Node<T>> nodes) {
        ArrayList elements = new ArrayList();
        for (Node<T> node : nodes) {
            elements.add(node.element);
        }
        return elements;
    }

    public List<T> topologicalSort(Consumer<Node<T>> cycleHandler) {
        ArrayList<Node<T>> allNodes = new ArrayList<Node<T>>(this.nodes.values());
        ArrayList<Node<T>> L = new ArrayList<Node<T>>();
        LinkedHashSet S = new LinkedHashSet();
        for (Node node : allNodes) {
            if (node.inEdges.size() != 0) continue;
            S.add(node);
        }
        while (!S.isEmpty()) {
            Node node = (Node)S.iterator().next();
            S.remove(node);
            L.add(node);
            for (Edge e : new ArrayList(node.outEdges)) {
                Node m = e.to;
                node.useOutEdge(e);
                m.useInEdge(e);
                if (!m.inEdges.isEmpty()) continue;
                S.add(m);
            }
        }
        for (Node node : allNodes) {
            if (node.inEdges.isEmpty() || cycleHandler == null) continue;
            cycleHandler.accept(node);
        }
        for (Node node : allNodes) {
            node.resetEdges();
        }
        return this.toElements(L);
    }

    public static <T> void dumpCycles(List<Node<T>> nodes, Function<T, String> toString) {
        for (Node<T> node : nodes) {
            Stack<Node<T>> path = new Stack<Node<T>>();
            path.add(node);
            DirectedGraph.dumpCycles(nodes, path, toString);
        }
    }

    private static <T> void dumpCycles(List<Node<T>> nodes, Stack<Node<T>> path, Function<T, String> toString) {
        path.peek().outEdges.stream().map(e -> e.to).forEach(node -> {
            if (nodes.contains(node)) {
                if (path.contains(node)) {
                    System.out.println("cycle: " + path.stream().map(n -> (String)toString.apply(n.element)).collect(Collectors.toList()));
                } else {
                    path.push((Node)node);
                    DirectedGraph.dumpCycles(nodes, path, toString);
                    path.pop();
                }
            }
        });
    }

    public static void main(String[] args) {
        DirectedGraph<Integer> g = new DirectedGraph<Integer>();
        g.add((T[])new Integer[]{7, 5, 3, 11, 8, 2, 9, 10});
        System.out.println(g.nodes.values());
        System.out.println(g.nodes.keySet());
        g.buildEdges(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (o1 == 5 && o2 == 3) {
                    return 1;
                }
                return 0;
            }
        });
        System.out.println(g.topologicalSort(null));
    }

    public static class Edge<T> {
        public final Node<T> from;
        public final Node<T> to;

        public Edge(Node<T> from, Node<T> to) {
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return "Edge[" + this.from + "->" + this.to + "]";
        }

        public boolean equals(Object obj) {
            Edge e = (Edge)obj;
            return e.from == this.from && e.to == this.to;
        }
    }

    public static class Node<T> {
        private DirectedGraph<T> graph;
        public final T element;
        public final LinkedHashSet<Edge<T>> inEdges;
        public final LinkedHashSet<Edge<T>> usedInEdges;
        public final LinkedHashSet<Edge<T>> outEdges;
        public final LinkedHashSet<Edge<T>> usedOutEdges;

        public Node(DirectedGraph<T> graph, T element) {
            this.graph = graph;
            this.element = element;
            this.inEdges = new LinkedHashSet();
            this.usedInEdges = new LinkedHashSet();
            this.outEdges = new LinkedHashSet();
            this.usedOutEdges = new LinkedHashSet();
        }

        public void addEdge(T destinationElement) {
            Node node = (Node)((DirectedGraph)this.graph).nodes.get(destinationElement);
            if (node == null) {
                this.graph.add(destinationElement);
                node = (Node)((DirectedGraph)this.graph).nodes.get(destinationElement);
            }
            Edge e = new Edge(this, node);
            this.outEdges.add(e);
            node.inEdges.add(e);
        }

        public void addEdges(T ... destinationElements) {
            T[] TArray = destinationElements;
            int n = destinationElements.length;
            int n2 = 0;
            while (n2 < n) {
                T destinationElement = TArray[n2];
                this.addEdge(destinationElement);
                ++n2;
            }
        }

        public void useInEdge(Edge<T> edge) {
            if (this.inEdges.remove(edge)) {
                this.usedInEdges.add(edge);
            }
        }

        public void useOutEdge(Edge<T> edge) {
            if (this.outEdges.remove(edge)) {
                this.usedOutEdges.add(edge);
            }
        }

        public void resetEdges() {
            this.inEdges.addAll(this.usedInEdges);
            this.usedInEdges.clear();
            this.outEdges.addAll(this.usedOutEdges);
            this.usedOutEdges.clear();
        }

        public String toString() {
            return "Node[" + this.element + "]";
        }
    }
}

