/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.File;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import javax.lang.model.element.Element;
import org.apache.commons.io.FileUtils;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.ExtendedElementFactory;
import org.jsweet.transpiler.model.support.ExtendedElementSupport;
import org.jsweet.transpiler.util.RollbackException;

public abstract class AbstractTreeScanner
extends TreeScanner {
    private TranspilationHandler logHandler;
    protected Stack<JCTree> stack = new Stack();
    protected Map<String, JCTree.JCImport> staticImports = new HashMap<String, JCTree.JCImport>();
    protected JCTree.JCCompilationUnit compilationUnit;
    protected JSweetContext context;
    protected DiagnosticSource diagnosticSource;
    private Map.Entry<String, String[]> sourceCache;

    public void report(JCTree tree, JSweetProblem problem, Object ... params) {
        this.report(tree, null, problem, params);
    }

    public void report(JCTree tree, Name name, JSweetProblem problem, Object ... params) {
        if (this.logHandler == null) {
            System.err.println(problem.getMessage(params));
        } else if (this.diagnosticSource == null) {
            this.logHandler.report(problem, null, problem.getMessage(params));
        } else {
            int s = tree.getStartPosition();
            int e = tree.getEndPosition(this.diagnosticSource.getEndPosTable());
            if (e == -1) {
                e = s;
            }
            if (name != null) {
                e += name.length();
            }
            this.logHandler.report(problem, new SourcePosition(new File(this.compilationUnit.sourcefile.getName()), tree, this.diagnosticSource.getLineNumber(s), this.diagnosticSource.getColumnNumber(s, false), this.diagnosticSource.getLineNumber(e), this.diagnosticSource.getColumnNumber(e, false)), problem.getMessage(params));
        }
    }

    public Map<String, JCTree.JCImport> getStaticImports() {
        return this.staticImports;
    }

    public JCTree.JCCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public JSweetContext getContext() {
        return this.context;
    }

    protected String[] getGetSource(JCTree.JCCompilationUnit compilationUnit) {
        if (this.sourceCache != null && this.sourceCache.getKey().equals(compilationUnit.getSourceFile().getName())) {
            return this.sourceCache.getValue();
        }
        try {
            this.sourceCache = new AbstractMap.SimpleEntry<String, String[]>(compilationUnit.getSourceFile().getName(), FileUtils.readFileToString((File)new File(compilationUnit.getSourceFile().getName())).split("\\n"));
        }
        catch (Exception e) {
            return null;
        }
        return this.sourceCache.getValue();
    }

    public AbstractTreeScanner(TranspilationHandler logHandler, JSweetContext context, JCTree.JCCompilationUnit compilationUnit) {
        this.logHandler = logHandler;
        this.context = context;
        this.context.symtab = Symtab.instance(context);
        this.context.names = Names.instance(context);
        this.context.types = Types.instance(context);
        this.context.modelTypes = JavacTypes.instance(context);
        this.setCompilationUnit(compilationUnit);
    }

    protected final void setCompilationUnit(JCTree.JCCompilationUnit compilationUnit) {
        if (compilationUnit != null) {
            this.compilationUnit = compilationUnit;
            for (JCTree.JCImport i : this.compilationUnit.getImports()) {
                if (!i.staticImport) continue;
                this.staticImports.put(i.qualid.toString().substring(i.qualid.toString().lastIndexOf(".") + 1), i);
            }
            this.diagnosticSource = new DiagnosticSource(compilationUnit.sourcefile, Log.instance(this.context));
        } else {
            this.compilationUnit = null;
            this.diagnosticSource = null;
        }
    }

    public void scan(ExtendedElement element) {
        this.scan((JCTree)((ExtendedElementSupport)element).getTree());
    }

    @Override
    public void scan(JCTree tree) {
        if (tree == null) {
            return;
        }
        this.enter(tree);
        try {
            try {
                tree.accept(this);
            }
            catch (RollbackException rollback) {
                if (rollback.getTarget() == tree) {
                    this.onRollbacked(tree);
                    if (rollback.getOnRollbacked() != null) {
                        rollback.getOnRollbacked().accept(tree);
                    }
                } else {
                    throw rollback;
                }
                this.exit();
            }
            catch (Exception e) {
                this.report(tree, JSweetProblem.INTERNAL_TRANSPILER_ERROR, new Object[0]);
                this.dumpStackTrace();
                e.printStackTrace();
                this.exit();
            }
        }
        finally {
            this.exit();
        }
    }

    protected void dumpStackTrace() {
        System.err.println("dumping transpiler's strack trace:");
        int i = this.stack.size() - 1;
        while (i >= 0) {
            JCTree tree = (JCTree)this.stack.get(i);
            if (tree != null) {
                String str = tree.toString().trim();
                int intialLength = str.length();
                int index = str.indexOf(10);
                if (index > 0) {
                    str = str.substring(0, index + 1);
                }
                str = str.replace('\n', ' ');
                str = str.substring(0, Math.min(str.length() - 1, 30));
                System.err.print("   [" + ((JCTree)this.stack.get(i)).getClass().getSimpleName() + "] " + str + (str.length() < intialLength ? "..." : "") + " (" + this.compilationUnit.getSourceFile().getName() + ":");
                if (this.diagnosticSource == null) {
                    System.err.println(String.valueOf(tree.pos) + ")");
                } else {
                    System.err.println(String.valueOf(this.diagnosticSource.getLineNumber(tree.pos)) + ")");
                }
            }
            --i;
        }
    }

    protected void onRollbacked(JCTree target) {
    }

    protected void rollback(JCTree target, Consumer<JCTree> onRollbacked) {
        throw new RollbackException(target, onRollbacked);
    }

    protected void enter(JCTree tree) {
        this.stack.push(tree);
    }

    protected void exit() {
        this.stack.pop();
    }

    public Stack<JCTree> getStack() {
        return this.stack;
    }

    public JCTree getCurrent() {
        if (this.stack.size() >= 1) {
            return (JCTree)this.stack.get(this.stack.size() - 1);
        }
        return null;
    }

    public JCTree getParent() {
        if (this.stack.size() >= 2) {
            return (JCTree)this.stack.get(this.stack.size() - 2);
        }
        return null;
    }

    public JCTree getParentOfParent() {
        if (this.stack.size() >= 3) {
            return (JCTree)this.stack.get(this.stack.size() - 3);
        }
        return null;
    }

    public ExtendedElement getParentElement() {
        return ExtendedElementFactory.INSTANCE.create(this.getParent());
    }

    public <T extends JCTree> T getParent(Class<T> type) {
        int i = this.stack.size() - 2;
        while (i >= 0) {
            if (type.isAssignableFrom(((JCTree)this.stack.get(i)).getClass())) {
                return (T)((JCTree)this.stack.get(i));
            }
            --i;
        }
        return null;
    }

    public <T extends Element> T getParentElement(Class<T> type) {
        int i = this.stack.size() - 2;
        while (i >= 0) {
            JCTree t = (JCTree)this.stack.get(i);
            if (t instanceof JCTree.JCClassDecl && type.isAssignableFrom(((JCTree.JCClassDecl)t).sym.getClass())) {
                return (T)((JCTree.JCClassDecl)t).sym;
            }
            if (t instanceof JCTree.JCMethodDecl && type.isAssignableFrom(((JCTree.JCMethodDecl)t).sym.getClass())) {
                return (T)((JCTree.JCClassDecl)t).sym;
            }
            if (t instanceof JCTree.JCVariableDecl && type.isAssignableFrom(((JCTree.JCVariableDecl)t).sym.getClass())) {
                return (T)((JCTree.JCClassDecl)t).sym;
            }
            --i;
        }
        return null;
    }

    public JCTree getFirstParent(Class<?> ... types) {
        int i = this.stack.size() - 2;
        while (i >= 0) {
            Class<?>[] classArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type = classArray[n2];
                if (type.isAssignableFrom(((JCTree)this.stack.get(i)).getClass())) {
                    return (JCTree)this.stack.get(i);
                }
                ++n2;
            }
            --i;
        }
        return null;
    }

    public <T extends JCTree> T getParent(Class<T> type, JCTree from) {
        int i = this.stack.size() - 1;
        while (i >= 0) {
            if (this.stack.get(i) == from) {
                int j = i - 1;
                while (j >= 0) {
                    if (type.isAssignableFrom(((JCTree)this.stack.get(j)).getClass())) {
                        return (T)((JCTree)this.stack.get(j));
                    }
                    --j;
                }
                return null;
            }
            --i;
        }
        return null;
    }
}

