/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.extension;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.jsweet.transpiler.extension.AnnotationManager;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.model.CaseElement;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.MethodInvocationElement;
import org.jsweet.transpiler.model.VariableAccessElement;

public class StringEnumAdapter
extends PrinterAdapter {
    private boolean isStringEnum(Element element) {
        return element.getKind() == ElementKind.ENUM && this.hasAnnotationType(element, "jsweet.lang.StringType");
    }

    public StringEnumAdapter(PrinterAdapter parent) {
        super(parent);
        this.addTypeMapping((typeTree, name) -> this.isStringEnum(typeTree.getTypeAsElement()) ? "string" : null);
        this.addAnnotationManager(new AnnotationManager(){

            @Override
            public AnnotationManager.Action manageAnnotation(Element element, String annotationType) {
                return "jsweet.lang.Erased".equals(annotationType) && StringEnumAdapter.this.isStringEnum(element) ? AnnotationManager.Action.ADD : AnnotationManager.Action.VOID;
            }
        });
    }

    @Override
    public boolean substituteMethodInvocation(MethodInvocationElement invocation) {
        block13: {
            Element targetType;
            if (invocation.getTargetExpression() == null || !this.isStringEnum(targetType = invocation.getTargetExpression().getTypeAsElement())) break block13;
            switch (invocation.getMethodName()) {
                case "name": {
                    this.printMacroName(invocation.getMethodName());
                    this.print(invocation.getTargetExpression());
                    return true;
                }
                case "valueOf": {
                    this.printMacroName(invocation.getMethodName());
                    this.print(invocation.getArgument(0));
                    return true;
                }
                case "equals": {
                    this.printMacroName(invocation.getMethodName());
                    this.print("(").print(invocation.getTargetExpression()).print(" == ").print(invocation.getArguments().get(0)).print(")");
                    return true;
                }
            }
        }
        return super.substituteMethodInvocation(invocation);
    }

    @Override
    public boolean substituteVariableAccess(VariableAccessElement variableAccess) {
        if (this.isStringEnum(variableAccess.getTargetElement())) {
            this.print("\"" + variableAccess.getVariableName() + "\"");
            return true;
        }
        return super.substituteVariableAccess(variableAccess);
    }

    @Override
    public boolean substituteCaseStatementPattern(CaseElement caseStatement, ExtendedElement pattern) {
        if (this.isStringEnum(pattern.getTypeAsElement())) {
            this.print("\"" + pattern + "\"");
            return true;
        }
        return super.substituteCaseStatementPattern(caseStatement, pattern);
    }
}

