/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.extension;

import com.sun.codemodel.internal.JJavaName;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.StringUtils;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.Java2TypeScriptTranslator;
import org.jsweet.transpiler.TypeChecker;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.ForeachLoopElement;
import org.jsweet.transpiler.model.IdentifierElement;
import org.jsweet.transpiler.model.ImportElement;
import org.jsweet.transpiler.model.InvocationElement;
import org.jsweet.transpiler.model.LiteralElement;
import org.jsweet.transpiler.model.MethodInvocationElement;
import org.jsweet.transpiler.model.NewClassElement;
import org.jsweet.transpiler.model.VariableAccessElement;
import org.jsweet.transpiler.model.support.ForeachLoopElementSupport;
import org.jsweet.transpiler.model.support.IdentifierElementSupport;
import org.jsweet.transpiler.model.support.ImportElementSupport;
import org.jsweet.transpiler.model.support.MethodInvocationElementSupport;
import org.jsweet.transpiler.model.support.NewClassElementSupport;
import org.jsweet.transpiler.model.support.VariableAccessElementSupport;
import org.jsweet.transpiler.util.Util;

public class Java2TypeScriptAdapter
extends PrinterAdapter {
    private static final String VAR_DECL_KEYWORD = "let";

    @Override
    public Java2TypeScriptTranslator getPrinter() {
        return (Java2TypeScriptTranslator)super.getPrinter();
    }

    public Java2TypeScriptAdapter(JSweetContext context) {
        super(context);
        this.init();
    }

    public Java2TypeScriptAdapter(PrinterAdapter parent) {
        super(parent);
        this.init();
    }

    private void init() {
        this.addTypeMapping(Object.class.getName(), "any");
        this.addTypeMapping(Runnable.class.getName(), "() => void");
        this.addTypeMapping(Callable.class.getName(), "() => any");
        this.addTypeMapping(DoubleConsumer.class.getName(), "(number) => void");
        this.addTypeMapping(DoublePredicate.class.getName(), "(number) => boolean");
        this.addTypeMapping(DoubleSupplier.class.getName(), "() => number");
        this.addTypeMapping(DoubleBinaryOperator.class.getName(), "(number, number) => number");
        this.addTypeMapping(DoubleUnaryOperator.class.getName(), "(number) => number");
        this.addTypeMapping(DoubleToIntFunction.class.getName(), "(number) => number");
        this.addTypeMapping(DoubleToLongFunction.class.getName(), "(number) => number");
        this.addTypeMapping(IntConsumer.class.getName(), "(number) => void");
        this.addTypeMapping(IntPredicate.class.getName(), "(number) => boolean");
        this.addTypeMapping(IntSupplier.class.getName(), "() => number");
        this.addTypeMapping(IntBinaryOperator.class.getName(), "(number, number) => number");
        this.addTypeMapping(IntUnaryOperator.class.getName(), "(number) => number");
        this.addTypeMapping(IntToDoubleFunction.class.getName(), "(number) => number");
        this.addTypeMapping(IntToLongFunction.class.getName(), "(number) => number");
        this.addTypeMapping(LongConsumer.class.getName(), "(number) => void");
        this.addTypeMapping(LongPredicate.class.getName(), "(number) => boolean");
        this.addTypeMapping(LongSupplier.class.getName(), "() => number");
        this.addTypeMapping(LongBinaryOperator.class.getName(), "(number, number) => number");
        this.addTypeMapping(LongUnaryOperator.class.getName(), "(number) => number");
        this.addTypeMapping(LongToDoubleFunction.class.getName(), "(number) => number");
        this.addTypeMapping(LongToIntFunction.class.getName(), "(number) => number");
        this.addTypeMapping(BooleanSupplier.class.getName(), "() => boolean");
        this.addTypeMapping(String.class.getName(), "string");
        this.addTypeMapping(Number.class.getName(), "number");
        this.addTypeMapping(Integer.class.getName(), "number");
        this.addTypeMapping(Short.class.getName(), "number");
        this.addTypeMapping(Float.class.getName(), "number");
        this.addTypeMapping(Long.class.getName(), "number");
        this.addTypeMapping(Byte.class.getName(), "number");
        this.addTypeMapping(Double.class.getName(), "number");
        this.addTypeMapping(Boolean.class.getName(), "boolean");
        this.addTypeMapping(Character.class.getName(), "string");
        this.addTypeMapping(CharSequence.class.getName(), "any");
        this.addTypeMapping(Void.class.getName(), "void");
        this.addTypeMapping(URL.class.getName(), "URL");
        this.addTypeMapping("double", "number");
        this.addTypeMapping("int", "number");
        this.addTypeMapping("float", "number");
        this.addTypeMapping("long", "number");
        this.addTypeMapping("byte", "number");
        this.addTypeMapping("short", "number");
        this.addTypeMapping("char", "string");
        this.addTypeMapping("Class", "any");
        this.addTypeMapping("jsweet.lang.Object", "Object");
        this.addTypeMapping("jsweet.lang.Boolean", "boolean");
        this.addTypeMapping("jsweet.lang.String", "string");
        this.addTypeMapping("jsweet.lang.Number", "number");
        this.addTypeMapping("def.js.Object", "Object");
        this.addTypeMapping("def.js.Boolean", "boolean");
        this.addTypeMapping("def.js.String", "string");
        this.addTypeMapping("def.js.Number", "number");
        this.context.getLangTypeMappings().put(Object.class.getName(), "Object");
        this.context.getLangTypeMappings().put(String.class.getName(), "String");
        this.context.getLangTypeMappings().put(Boolean.class.getName(), "Boolean");
        this.context.getLangTypeMappings().put(Number.class.getName(), "Number");
        this.context.getLangTypeMappings().put(Integer.class.getName(), "Number");
        this.context.getLangTypeMappings().put(Long.class.getName(), "Number");
        this.context.getLangTypeMappings().put(Short.class.getName(), "Number");
        this.context.getLangTypeMappings().put(Float.class.getName(), "Number");
        this.context.getLangTypeMappings().put(Double.class.getName(), "Number");
        this.context.getLangTypeMappings().put(Byte.class.getName(), "Number");
        this.context.getLangTypeMappings().put(Character.class.getName(), "String");
        this.context.getLangTypeMappings().put(Math.class.getName(), "Math");
        this.context.getLangTypeMappings().put(StrictMath.class.getName(), "Math");
        this.context.getLangTypeMappings().put(Exception.class.getName(), "Error");
        this.context.getLangTypeMappings().put(Throwable.class.getName(), "Error");
        this.context.getLangTypeMappings().put(Error.class.getName(), "Error");
        this.context.getLangTypeMappings().put(Date.class.getName(), "Date");
        for (String s : this.context.getLangTypeMappings().keySet()) {
            this.context.getLangTypesSimpleNames().add(s.substring(s.lastIndexOf(46) + 1));
        }
        this.context.getBaseThrowables().add(Throwable.class.getName());
        this.context.getBaseThrowables().add(Error.class.getName());
        this.context.getBaseThrowables().add(Exception.class.getName());
    }

    @Override
    public String needsImport(ImportElement importElement, String qualifiedName) {
        JCTree.JCImport importDecl;
        block20: {
            block21: {
                importDecl = (JCTree.JCImport)((ImportElementSupport)importElement).getTree();
                if (JSweetConfig.isJSweetPath(qualifiedName) || this.isMappedType(qualifiedName) || this.context.getLangTypeMappings().containsKey(qualifiedName) || qualifiedName.startsWith("java.util.function.") || qualifiedName.endsWith("globals.Globals")) {
                    return null;
                }
                if (importDecl.qualid.type != null) {
                    if (this.context.hasAnnotationType(importDecl.qualid.type.tsym, "jsweet.lang.Erased", "jsweet.lang.ObjectType")) {
                        return null;
                    }
                    if (importDecl.qualid.type.tsym.getKind() == ElementKind.ANNOTATION_TYPE && !this.context.hasAnnotationType(importDecl.qualid.type.tsym, "jsweet.lang.Decorator")) {
                        return null;
                    }
                }
                if (!importDecl.isStatic()) break block20;
                if (!(importDecl.getQualifiedIdentifier() instanceof JCTree.JCFieldAccess)) break block21;
                JCTree.JCFieldAccess fa = (JCTree.JCFieldAccess)importDecl.getQualifiedIdentifier();
                switch (fa.selected.toString()) {
                    case "java.lang.Math": {
                        return null;
                    }
                }
                String name = this.getPrinter().getRootRelativeName(fa.selected.type.tsym, false);
                String methodName = fa.name.toString();
                if ("Globals".equals(name)) {
                    return null;
                }
                if (!this.context.useModules && name.endsWith("globals.Globals")) {
                    return null;
                }
                if (JSweetConfig.TS_STRICT_MODE_KEYWORDS.contains(methodName.toLowerCase())) {
                    return null;
                }
                boolean globals = name.endsWith(".Globals");
                if (globals) {
                    name = name.substring(0, name.length() - "Globals".length() - 1);
                }
                String current = this.getPrinter().getRootRelativeName(this.getPrinter().getCompilationUnit().packge, this.context.useModules);
                if (this.context.useModules ? current.equals(name) : current.startsWith(name)) {
                    return null;
                }
                Symbol nameSymbol = fa.sym;
                if (nameSymbol == null) {
                    Symbol.TypeSymbol t = fa.selected.type.tsym;
                    nameSymbol = Util.findFirstDeclarationInType(t, methodName);
                }
                return StringUtils.isBlank((CharSequence)name) ? null : String.valueOf(name) + "." + (nameSymbol == null ? methodName : this.getPrinter().getIdentifier(nameSymbol));
            }
            return null;
        }
        if (this.context.useModules && importDecl.qualid instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess qualified = importDecl.qualid;
            if (qualified.sym instanceof Symbol.ClassSymbol && qualified.sym.getEnclosingElement() instanceof Symbol.ClassSymbol) {
                return null;
            }
        }
        if (importElement.isStatic()) {
            return null;
        }
        return super.needsImport(importElement, qualifiedName);
    }

    private boolean isWithinGlobals(String targetClassName) {
        if (targetClassName == null || targetClassName.equals("jsweet.util.Lang") || targetClassName.equals("jsweet.util.Globals")) {
            JCTree.JCClassDecl c = this.getPrinter().getParent(JCTree.JCClassDecl.class);
            return c != null && c.sym.getQualifiedName().toString().endsWith(".Globals");
        }
        return false;
    }

    @Override
    public boolean substituteMethodInvocation(MethodInvocationElement invocationElement) {
        String targetMethodName;
        block469: {
            String targetClassName;
            Element targetType;
            block467: {
                block465: {
                    block463: {
                        targetType = invocationElement.getMethod().getEnclosingElement();
                        if (this.hasAnnotationType(invocationElement.getMethod(), "jsweet.lang.Erased") && !this.isAmbientDeclaration(invocationElement.getMethod())) {
                            this.print("null");
                            return true;
                        }
                        if (invocationElement.getTargetExpression() != null) {
                            targetType = invocationElement.getTargetExpression().getTypeAsElement();
                        }
                        targetMethodName = invocationElement.getMethodName();
                        targetClassName = targetType.toString();
                        if (("println".equals(targetMethodName) || "printf".equals(targetMethodName) || "print".equals(targetMethodName)) && invocationElement.getTargetExpression() != null) {
                            if ("System.out".equals(invocationElement.getTargetExpression().toString())) {
                                PrinterAdapter print = this.print("console.info(");
                                if (invocationElement.getArgumentCount() > 0) {
                                    print.print(invocationElement.getArgument(0));
                                }
                                print.print(")");
                                return true;
                            }
                            if ("System.err".equals(invocationElement.getTargetExpression().toString())) {
                                PrinterAdapter print = this.print("console.error(");
                                if (invocationElement.getArgumentCount() > 0) {
                                    print.print(invocationElement.getArgument(0));
                                }
                                print.print(")");
                                return true;
                            }
                        }
                        if ("super".equals(invocationElement.getMethodName())) {
                            if (this.getPrinter().getParent(JCTree.JCClassDecl.class).extending == null || this.context.isInterface(this.getPrinter().getParent(JCTree.JCClassDecl.class).extending.type.tsym)) {
                                return true;
                            }
                            if (((JCTree.JCMethodInvocation)((MethodInvocationElementSupport)invocationElement).getTree()).meth instanceof JCTree.JCIdent) {
                                String superClassName = ((JCTree.JCIdent)((JCTree.JCMethodInvocation)((MethodInvocationElementSupport)invocationElement).getTree()).meth).sym.getEnclosingElement().getQualifiedName().toString();
                                if (this.context.getBaseThrowables().contains(superClassName)) {
                                    if (invocationElement.getArgumentCount() > 0) {
                                        this.print("super(").print(invocationElement.getArgument(0)).print(")");
                                        this.print("; this.message=").print(invocationElement.getArgument(0));
                                    } else {
                                        this.print("super()");
                                    }
                                    return true;
                                }
                            }
                        }
                        if (targetType == null || targetType.getKind() != ElementKind.ENUM || invocationElement.getTargetExpression() == null || "this".equals(invocationElement.getTargetExpression().toString())) break block463;
                        String relTarget = this.getRootRelativeName((Symbol)targetType);
                        switch (targetMethodName) {
                            case "name": {
                                this.printMacroName("Enum." + targetMethodName);
                                this.print(relTarget).print("[").print(invocationElement.getTargetExpression()).print("]");
                                return true;
                            }
                            case "ordinal": {
                                this.printMacroName("Enum." + targetMethodName);
                                this.print(relTarget).print("[").print(relTarget).print("[").print(invocationElement.getTargetExpression()).print("]").print("]");
                                return true;
                            }
                            case "valueOf": {
                                this.printMacroName("Enum." + targetMethodName);
                                if (invocationElement.getArgumentCount() != 1) break;
                                this.print("<any>").print(invocationElement.getTargetExpression()).print("[").print(invocationElement.getArgument(0)).print("]");
                                return true;
                            }
                            case "values": {
                                this.printMacroName("Enum." + targetMethodName);
                                this.print("function() { let result: number[] = []; for(let val in ").print(relTarget).print(") { if(!isNaN(<any>val)) { result.push(parseInt(val,10)); } } return result; }()");
                                return true;
                            }
                            case "equals": {
                                this.printMacroName("Enum." + targetMethodName);
                                this.print("(<any>(").print(invocationElement.getTargetExpression()).print(") === <any>(").print(invocationElement.getArgument(0)).print("))");
                                return true;
                            }
                        }
                        if (invocationElement.getTargetExpression() != null && invocationElement.getMethod().getModifiers().contains((Object)Modifier.STATIC)) {
                            this.print(invocationElement.getTargetExpression()).print("_$WRAPPER.").print(invocationElement.getMethodName()).print("(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        this.print(relTarget).print("[\"_$wrappers\"][").print(invocationElement.getTargetExpression()).print("].").print(invocationElement.getMethodName()).print("(").printArgList(invocationElement.getArguments()).print(")");
                        return true;
                    }
                    if (targetClassName == null || targetMethodName == null) break block465;
                    switch (targetClassName) {
                        case "jsweet.util.Lang": 
                        case "jsweet.util.Globals": {
                            switch (targetMethodName) {
                                case "$export": {
                                    if (!invocationElement.getArgument(0).isStringLiteral()) {
                                        this.report(invocationElement.getArgument(0), JSweetProblem.STRING_LITERAL_EXPECTED, new Object[0]);
                                    }
                                    String string = "_exportedVar_" + StringUtils.strip((String)invocationElement.getArgument(0).toString(), (String)"\"");
                                    this.getPrinter().footer.append("let " + string + ";\n");
                                    if (invocationElement.getArgumentCount() == 1) {
                                        this.print(string);
                                    } else {
                                        this.print("{ " + string + " = ").print(invocationElement.getArgument(1)).print("; ");
                                        this.print("console.log('EXPORT " + StringUtils.strip((String)invocationElement.getArgument(0).toString(), (String)"\"") + "='+").print(string).print("+';') }");
                                    }
                                    return true;
                                }
                                case "number": 
                                case "object": 
                                case "string": 
                                case "bool": 
                                case "array": 
                                case "function": 
                                case "integer": {
                                    this.printCastMethodInvocation(invocationElement);
                                    return true;
                                }
                                case "any": {
                                    this.print("(<any>");
                                    this.printCastMethodInvocation(invocationElement);
                                    this.print(")");
                                    return true;
                                }
                                case "async": {
                                    this.print("async ");
                                    this.print(invocationElement.getArgument(0));
                                    return true;
                                }
                                case "await": {
                                    this.print("await ");
                                    this.printCastMethodInvocation(invocationElement);
                                    return true;
                                }
                                case "asyncReturn": {
                                    this.printCastMethodInvocation(invocationElement);
                                    return true;
                                }
                                case "union": {
                                    this.getPrinter().typeChecker.checkUnionTypeAssignment(this.context.types, this.getPrinter().getParent(), (JCTree.JCMethodInvocation)((MethodInvocationElementSupport)invocationElement).getTree());
                                    this.print("(<any>");
                                    this.printCastMethodInvocation(invocationElement);
                                    this.print(")");
                                    return true;
                                }
                                case "typeof": {
                                    this.print("typeof ").print(invocationElement.getArgument(0));
                                    return true;
                                }
                                case "$noarrow": {
                                    this.print(invocationElement.getArgument(0));
                                    return true;
                                }
                                case "equalsStrict": {
                                    this.print("(").print(invocationElement.getArgument(0)).print(" === ").print(invocationElement.getArgument(1)).print(")");
                                    return true;
                                }
                                case "notEqualsStrict": {
                                    this.print("(").print(invocationElement.getArgument(0)).print(" !== ").print(invocationElement.getArgument(1)).print(")");
                                    return true;
                                }
                                case "equalsLoose": {
                                    this.print("(").print(invocationElement.getArgument(0)).print(" == ").print(invocationElement.getArgument(1)).print(")");
                                    return true;
                                }
                                case "notEqualsLoose": {
                                    this.print("(").print(invocationElement.getArgument(0)).print(" != ").print(invocationElement.getArgument(1)).print(")");
                                    return true;
                                }
                                case "$strict": {
                                    this.getPrinter().enterComparisonMode(Java2TypeScriptTranslator.ComparisonMode.STRICT);
                                    this.print(invocationElement.getArgument(0));
                                    this.getPrinter().exitComparisonMode();
                                    return true;
                                }
                                case "$loose": {
                                    this.getPrinter().enterComparisonMode(Java2TypeScriptTranslator.ComparisonMode.LOOSE);
                                    this.print(invocationElement.getArgument(0));
                                    this.getPrinter().exitComparisonMode();
                                    return true;
                                }
                                case "$insert": {
                                    if (invocationElement.getArgument(0) instanceof LiteralElement) {
                                        this.print(((LiteralElement)invocationElement.getArgument(0)).getValue().toString());
                                        return true;
                                    }
                                    this.report((ExtendedElement)invocationElement, JSweetProblem.MISUSED_INSERT_MACRO, invocationElement.getMethodName());
                                }
                                case "$template": {
                                    if (invocationElement.getArgumentCount() == 1) {
                                        if (invocationElement.getArgument(0) instanceof LiteralElement) {
                                            this.print("`" + ((LiteralElement)invocationElement.getArgument(0)).getValue().toString() + "`");
                                            return true;
                                        }
                                        if (invocationElement.getArgument(1) instanceof LiteralElement) {
                                            this.print(invocationElement.getArgument(0)).print("`" + ((LiteralElement)invocationElement.getArgument(1)).getValue().toString() + "`");
                                            return true;
                                        }
                                    }
                                    this.report((ExtendedElement)invocationElement, JSweetProblem.MISUSED_INSERT_MACRO, invocationElement.getMethodName());
                                }
                                case "$map": {
                                    if (invocationElement.getArgumentCount() % 2 != 0) {
                                        this.report((ExtendedElement)invocationElement, JSweetProblem.UNTYPED_OBJECT_ODD_PARAMETER_COUNT, new Object[0]);
                                    }
                                    this.print("{");
                                    List<JCTree.JCExpression> args = ((JCTree.JCMethodInvocation)((MethodInvocationElementSupport)invocationElement).getTree()).args;
                                    while (args != null && args.head != null) {
                                        String key = ((JCTree.JCExpression)args.head).toString();
                                        if (((JCTree.JCExpression)args.head).getTag() == JCTree.Tag.LITERAL && key.startsWith("\"")) {
                                            if (JJavaName.isJavaIdentifier((String)(key = key.substring(1, key.length() - 1)))) {
                                                this.print(key);
                                            } else {
                                                this.print("\"" + key + "\"");
                                            }
                                        } else {
                                            this.report(invocationElement.getArgument(0), JSweetProblem.UNTYPED_OBJECT_WRONG_KEY, ((JCTree.JCExpression)args.head).toString());
                                        }
                                        this.print(": ");
                                        this.getPrinter().print((JCTree)args.tail.head);
                                        args = args.tail.tail;
                                        if (args == null || args.head == null) continue;
                                        this.print(",");
                                    }
                                    this.print("}");
                                    return true;
                                }
                                case "$array": {
                                    this.print("[").printArgList(invocationElement.getArguments()).print("]");
                                    return true;
                                }
                                case "$apply": {
                                    this.print("(<any>").print(invocationElement.getArgument(0)).print(")(").printArgList(invocationElement.getArgumentTail()).print(")");
                                    return true;
                                }
                                case "$new": {
                                    this.print("new (<any>").print(invocationElement.getArgument(0)).print(")(").printArgList(invocationElement.getArgumentTail()).print(")");
                                    return true;
                                }
                            }
                        }
                    }
                }
                if (targetMethodName == null) break block467;
                switch (targetMethodName) {
                    case "$get": {
                        if (this.isWithinGlobals(targetClassName)) {
                            if (invocationElement.getArgumentCount() == 1) {
                                this.report((ExtendedElement)invocationElement, JSweetProblem.GLOBAL_INDEXER_GET, new Object[0]);
                                return true;
                            }
                            if (invocationElement.getArgument(0).toString().equals("Globals.class") || invocationElement.getArgument(0).toString().endsWith(".Globals.class")) {
                                this.report((ExtendedElement)invocationElement, JSweetProblem.GLOBAL_INDEXER_GET, new Object[0]);
                                return true;
                            }
                        }
                        if (invocationElement.getTargetExpression() != null && !"jsweet.util.Lang".equals(targetClassName) && !"jsweet.util.Globals".equals(targetClassName)) {
                            this.print(invocationElement.getTargetExpression()).print("[").print(invocationElement.getArgument(0)).print("]");
                        } else if (invocationElement.getArgumentCount() == 1) {
                            this.print("this[").print(invocationElement.getArguments().get(0)).print("]");
                        } else {
                            this.print(invocationElement.getArguments().get(0)).print("[").print(invocationElement.getArguments().get(1)).print("]");
                        }
                        return true;
                    }
                    case "$getStatic": {
                        if (invocationElement.getArgumentCount() == 1 && this.isWithinGlobals(targetClassName)) {
                            this.report((ExtendedElement)invocationElement, JSweetProblem.GLOBAL_INDEXER_GET, new Object[0]);
                            return true;
                        }
                        this.print(invocationElement.getTargetExpression()).print("[").print(invocationElement.getArgument(0)).print("]");
                        return true;
                    }
                    case "$set": {
                        if (this.isWithinGlobals(targetClassName)) {
                            if (invocationElement.getArgumentCount() == 2) {
                                this.report((ExtendedElement)invocationElement, JSweetProblem.GLOBAL_INDEXER_SET, new Object[0]);
                                return true;
                            }
                            if (invocationElement.getArgument(0).toString().equals("Globals.class") || invocationElement.getArgument(0).toString().endsWith("Globals.class")) {
                                this.report((ExtendedElement)invocationElement, JSweetProblem.GLOBAL_INDEXER_SET, new Object[0]);
                                return true;
                            }
                        }
                        if (invocationElement.getTargetExpression() != null && !"jsweet.util.Lang".equals(targetClassName) && !"jsweet.util.Globals".equals(targetClassName)) {
                            for (Element element : invocationElement.getTargetExpression().getTypeAsElement().getEnclosedElements()) {
                                if (!(element instanceof ExecutableElement) || !"$get".equals(element.getSimpleName().toString())) continue;
                                ExecutableElement getter = (ExecutableElement)element;
                                TypeMirror getterType = getter.getReturnType();
                                TypeMirror getterIndexType = getter.getParameters().get(0).asType();
                                TypeMirror invokedIndexType = invocationElement.getArgument(0).getType();
                                TypeMirror invokedValueType = invocationElement.getArgument(1).getType();
                                boolean sameIndexType = this.types().isSameType(getterIndexType, invokedIndexType);
                                if (!sameIndexType || this.types().isAssignable(invokedValueType, this.types().erasure(getterType))) continue;
                                this.report(invocationElement.getArgument(1), JSweetProblem.INDEXED_SET_TYPE_MISMATCH, getterType);
                            }
                            this.print(invocationElement.getTargetExpression()).print("[").print(invocationElement.getArgument(0)).print("] = ").print(invocationElement.getArgument(1));
                        } else if (invocationElement.getArgumentCount() == 2) {
                            this.print("this[").print(invocationElement.getArgument(0)).print("] = <any>").print(invocationElement.getArgument(1));
                        } else {
                            this.print(invocationElement.getArgument(0)).print("[").print(invocationElement.getArgument(1)).print("] = <any>").print(invocationElement.getArgument(2));
                        }
                        return true;
                    }
                    case "$setStatic": {
                        if (invocationElement.getArgumentCount() == 2 && this.isWithinGlobals(targetClassName)) {
                            this.report((ExtendedElement)invocationElement, JSweetProblem.GLOBAL_INDEXER_SET, new Object[0]);
                            return true;
                        }
                        this.print(invocationElement.getTargetExpression()).print("[").print(invocationElement.getArguments().get(0)).print("] = ").print(invocationElement.getArguments().get(1));
                        return true;
                    }
                    case "$delete": {
                        if (this.isWithinGlobals(targetClassName)) {
                            if (invocationElement.getArgumentCount() == 1) {
                                this.report((ExtendedElement)invocationElement, JSweetProblem.GLOBAL_DELETE, new Object[0]);
                                return true;
                            }
                            if (invocationElement.getArgument(0).toString().equals("Globals.class") || invocationElement.getArguments().get(0).toString().endsWith("Globals.class")) {
                                this.report((ExtendedElement)invocationElement, JSweetProblem.GLOBAL_DELETE, new Object[0]);
                                return true;
                            }
                        }
                        if (invocationElement.getTargetExpression() != null && !"jsweet.util.Lang".equals(targetClassName) && !"jsweet.util.Globals".equals(targetClassName)) {
                            this.print("delete ").print(invocationElement.getTargetExpression()).print("[").print(invocationElement.getArguments().get(0)).print("]");
                        } else if (invocationElement.getArgumentCount() == 1) {
                            this.print("delete this[").print(invocationElement.getArgument(0)).print("]");
                        } else {
                            this.print("delete ").print(invocationElement.getArgument(0)).print("[").print(invocationElement.getArgument(1)).print("]");
                        }
                        return true;
                    }
                    case "$deleteStatic": {
                        if (invocationElement.getArgumentCount() == 1 && this.isWithinGlobals(targetClassName)) {
                            this.report((ExtendedElement)invocationElement, JSweetProblem.GLOBAL_DELETE, new Object[0]);
                            return true;
                        }
                        if (invocationElement.getTargetExpression() != null && !"jsweet.util.Lang".equals(targetClassName) && !"jsweet.util.Globals".equals(targetClassName)) {
                            this.print("delete ").print(invocationElement.getTargetExpression()).print("[").print(invocationElement.getArgument(0)).print("]");
                        } else if (invocationElement.getArgumentCount() == 1) {
                            this.print("delete ").print("this[").print(invocationElement.getArgument(0)).print("]");
                        } else {
                            this.print("delete ").print(invocationElement.getArgument(0)).print("[").print(invocationElement.getArgument(1)).print("]");
                        }
                        return true;
                    }
                }
            }
            if (invocationElement.getTargetExpression() == null && "$super".equals(targetMethodName)) {
                this.print("super(").printArgList(invocationElement.getArguments()).print(")");
                return true;
            }
            if (invocationElement.getTargetExpression() != null && targetClassName != null && (targetClassName.startsWith("jsweet.util.function.") || targetClassName.equals(Callable.class.getName()) || targetClassName.startsWith(Function.class.getPackage().getName()))) {
                if (!TypeChecker.jdkAllowed && targetClassName.startsWith(Function.class.getPackage().getName()) && TypeChecker.FORBIDDEN_JDK_FUNCTIONAL_METHODS.contains(targetMethodName)) {
                    this.report((ExtendedElement)invocationElement, JSweetProblem.JDK_METHOD, targetMethodName);
                }
                this.printFunctionalInvocation(invocationElement.getTargetExpression(), targetMethodName, invocationElement.getArguments());
                return true;
            }
            if (invocationElement.getTargetExpression() != null && targetClassName != null && targetClassName.equals(Runnable.class.getName())) {
                this.printFunctionalInvocation(invocationElement.getTargetExpression(), targetMethodName, invocationElement.getArguments());
                return true;
            }
            if (targetClassName == null) break block469;
            switch (targetMethodName) {
                case "getMessage": {
                    if (!(targetType instanceof TypeElement) || !this.types().isAssignable(targetType.asType(), this.util().getType(Throwable.class))) break;
                    this.printTarget(invocationElement.getTargetExpression()).print(".message");
                    return true;
                }
                case "getCause": {
                    if (!(targetType instanceof TypeElement) || !this.types().isAssignable(targetType.asType(), this.util().getType(Throwable.class))) break;
                    this.print("(<Error>null)");
                    return true;
                }
                case "printStackTrace": {
                    if (!(targetType instanceof TypeElement) || !this.types().isAssignable(targetType.asType(), this.util().getType(Throwable.class))) break;
                    this.print("console.error(").print(invocationElement.getTargetExpression()).print(".message, ").print(invocationElement.getTargetExpression()).print(")");
                    return true;
                }
            }
            block115 : switch (targetClassName) {
                case "java.lang.CharSequence": 
                case "java.lang.String": {
                    switch (targetMethodName) {
                        case "valueOf": {
                            this.printMacroName(targetMethodName);
                            if (invocationElement.getArgumentCount() == 3) {
                                this.print("((str, index, len) => str.join('').substring(index, index + len))(").printArgList(invocationElement.getArguments()).print(")");
                            } else {
                                this.print("new String(").printArgList(invocationElement.getArguments()).print(").toString()");
                            }
                            return true;
                        }
                        case "subSequence": {
                            this.printMacroName(targetMethodName);
                            this.print(invocationElement.getTargetExpression()).print(".substring(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "contains": {
                            this.printMacroName(targetMethodName);
                            this.print("(").print(invocationElement.getTargetExpression()).print(".indexOf(").printArgList(invocationElement.getArguments()).print(") != -1)");
                            return true;
                        }
                        case "length": {
                            this.print(invocationElement.getTargetExpression()).print(".length");
                            return true;
                        }
                        case "startsWith": {
                            this.printMacroName(targetMethodName);
                            this.print("((str, searchString, position = 0) => str.substr(position, searchString.length) === searchString)(").print(invocationElement.getTargetExpression()).print(", ").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "endsWith": {
                            this.printMacroName(targetMethodName);
                            this.print("((str, searchString) => { let pos = str.length - searchString.length; let lastIndex = str.indexOf(searchString, pos); return lastIndex !== -1 && lastIndex === pos; })(").print(invocationElement.getTargetExpression()).print(", ").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "codePointAt": {
                            this.printMacroName(targetMethodName);
                            this.print(invocationElement.getTargetExpression()).print(".charCodeAt(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "isEmpty": {
                            this.printMacroName(targetMethodName);
                            this.print("(").print(invocationElement.getTargetExpression()).print(".length === 0)");
                            return true;
                        }
                        case "compareToIgnoreCase": {
                            this.printMacroName(targetMethodName);
                            this.print(invocationElement.getTargetExpression()).print(".toUpperCase().localeCompare(").printArgList(invocationElement.getArguments()).print(".toUpperCase())");
                            return true;
                        }
                        case "compareTo": {
                            this.printMacroName(targetMethodName);
                            this.print(invocationElement.getTargetExpression()).print(".localeCompare(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "equalsIgnoreCase": {
                            this.printMacroName(targetMethodName);
                            this.print("((o1, o2) => o1.toUpperCase() === (o2===null?o2:o2.toUpperCase()))(").print(invocationElement.getTargetExpression()).print(", ").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "toChars": {
                            this.printMacroName(targetMethodName);
                            this.print("String.fromCharCode(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "getBytes": {
                            this.printMacroName(targetMethodName);
                            this.print("(").print(invocationElement.getTargetExpression()).print(").split('').map(s => s.charCodeAt(0))");
                            return true;
                        }
                        case "toCharArray": {
                            this.printMacroName(targetMethodName);
                            this.print("(").print(invocationElement.getTargetExpression()).print(").split('')");
                            return true;
                        }
                        case "getChars": {
                            this.printMacroName(targetMethodName);
                            this.print("((a, s, e, d, l) => { d.splice.apply(d, [l, e-s].concat(<any>a.substring(s, e).split(''))); })(").print(invocationElement.getTargetExpression()).print(", ").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "replaceAll": {
                            this.printMacroName(targetMethodName);
                            this.print(invocationElement.getTargetExpression()).print(".replace(new RegExp(").print(invocationElement.getArguments().get(0)).print(", 'g'),").print(invocationElement.getArguments().get(1)).print(")");
                            return true;
                        }
                        case "replace": {
                            this.printMacroName(targetMethodName);
                            this.print(invocationElement.getTargetExpression()).print(".split(").print(invocationElement.getArguments().get(0)).print(").join(").print(invocationElement.getArguments().get(1)).print(")");
                            return true;
                        }
                        case "lastIndexOf": {
                            this.print(invocationElement.getTargetExpression()).print(".lastIndexOf(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "indexOf": {
                            if (invocationElement.getArgumentCount() == 1 && this.util().isNumber(invocationElement.getArgument(0).getType())) {
                                this.print(invocationElement.getTargetExpression()).print(".indexOf(String.fromCharCode(").print(invocationElement.getArgument(0)).print("))");
                            } else {
                                this.print(invocationElement.getTargetExpression()).print(".indexOf(").printArgList(invocationElement.getArguments()).print(")");
                            }
                            return true;
                        }
                        case "toLowerCase": {
                            if (invocationElement.getArgumentCount() <= 0) break block115;
                            this.printMacroName(targetMethodName);
                            this.print(invocationElement.getTargetExpression()).print(".toLowerCase()");
                            return true;
                        }
                        case "toUpperCase": {
                            if (invocationElement.getArgumentCount() <= 0) break block115;
                            this.printMacroName(targetMethodName);
                            this.print(invocationElement.getTargetExpression()).print(".toUpperCase()");
                            return true;
                        }
                    }
                    break;
                }
                case "java.lang.Character": {
                    switch (targetMethodName) {
                        case "toChars": {
                            this.printMacroName(targetMethodName);
                            this.print("String.fromCharCode(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                    }
                    break;
                }
                case "java.lang.Integer": 
                case "java.lang.Float": 
                case "java.lang.Short": 
                case "java.lang.Byte": 
                case "java.lang.Long": 
                case "java.lang.Double": 
                case "java.lang.Number": {
                    switch (targetMethodName) {
                        case "isNaN": {
                            this.printMacroName(targetMethodName);
                            if (invocationElement.getArgumentCount() > 0) {
                                this.print("isNaN(").printArgList(invocationElement.getArguments()).print(")");
                                return true;
                            }
                            this.print("isNaN(").print(invocationElement.getTargetExpression()).print(")");
                            return true;
                        }
                        case "isInfinite": {
                            this.printMacroName(targetMethodName);
                            if (invocationElement.getArgumentCount() > 0) {
                                this.print("((value) => Number.NEGATIVE_INFINITY === value || Number.POSITIVE_INFINITY === value)(").printArgList(invocationElement.getArguments()).print(")");
                                return true;
                            }
                            this.print("((value) => Number.NEGATIVE_INFINITY === value || Number.POSITIVE_INFINITY === value)(").print(invocationElement.getTargetExpression()).print(")");
                            return true;
                        }
                        case "intValue": {
                            this.printMacroName(targetMethodName);
                            this.print("(").print(invocationElement.getTargetExpression()).print("|0").print(")");
                            return true;
                        }
                        case "shortValue": {
                            this.printMacroName(targetMethodName);
                            this.print("(").print(invocationElement.getTargetExpression()).print("|0").print(")");
                            return true;
                        }
                        case "byteValue": {
                            this.printMacroName(targetMethodName);
                            this.print("(").print(invocationElement.getTargetExpression()).print("|0").print(")");
                            return true;
                        }
                        case "floatValue": {
                            this.printMacroName(targetMethodName);
                            this.print(invocationElement.getTargetExpression());
                            return true;
                        }
                        case "doubleValue": {
                            this.printMacroName(targetMethodName);
                            this.print(invocationElement.getTargetExpression());
                            return true;
                        }
                        case "longValue": {
                            this.printMacroName(targetMethodName);
                            this.print(invocationElement.getTargetExpression());
                            return true;
                        }
                        case "compare": {
                            if (invocationElement.getArgumentCount() != 2) break block115;
                            this.printMacroName(targetMethodName);
                            this.print("(").print(invocationElement.getArgument(0)).print(" - ").print(invocationElement.getArgument(1)).print(")");
                            return true;
                        }
                        case "toString": {
                            if (invocationElement.getArgumentCount() <= 0) break block115;
                            this.printMacroName(targetMethodName);
                            this.print("(''+(").print(invocationElement.getArgument(0)).print("))");
                            return true;
                        }
                    }
                    break;
                }
                case "java.lang.Boolean": {
                    switch (targetMethodName) {
                        case "booleanValue": {
                            this.printMacroName(targetMethodName);
                            this.print(invocationElement.getTargetExpression());
                            return true;
                        }
                    }
                    break;
                }
                case "java.lang.Math": 
                case "java.lang.StrictMath": {
                    switch (targetMethodName) {
                        case "cbrt": {
                            this.printMacroName(targetMethodName);
                            this.print("Math.pow(").printArgList(invocationElement.getArguments()).print(", 1/3)");
                            return true;
                        }
                        case "copySign": {
                            this.printMacroName(targetMethodName);
                            this.print("((magnitude, sign) => { if (sign < 0) { return (magnitude < 0) ? magnitude : -magnitude; } else { return (magnitude > 0) ? magnitude : -magnitude; } })(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "cosh": {
                            this.printMacroName(targetMethodName);
                            this.print("(x => (Math.exp(x) + Math.exp(-x)) / 2)(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "expm1": {
                            this.printMacroName(targetMethodName);
                            this.print("(d => { if (d == 0.0 || d === Number.NaN) { return d; } else if (!Number.POSITIVE_INFINITY === d && !Number.NEGATIVE_INFINITY === d) { if (d < 0) { return -1; } else { return Number.POSITIVE_INFINITY; } } })(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "hypot": {
                            this.printMacroName(targetMethodName);
                            this.print("(x => Math.sqrt(x * x + y * y))(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "log10": {
                            this.printMacroName(targetMethodName);
                            this.print("(x => Math.log(x) * Math.LOG10E)(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "log1p": {
                            this.printMacroName(targetMethodName);
                            this.print("(x => Math.log(x + 1))(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "rint": {
                            this.printMacroName(targetMethodName);
                            this.print("(d => { if (d === Number.NaN) { return d; } else if (Number.POSITIVE_INFINITY === d || Number.NEGATIVE_INFINITY === d) { return d; } else if(d == 0) { return d; } else { return Math.round(d); } })(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "scalb": {
                            this.printMacroName(targetMethodName);
                            this.print("((d, scaleFactor) => { if (scaleFactor >= 31 || scaleFactor <= -31) { return d * Math.pow(2, scaleFactor); } else if (scaleFactor > 0) { return d * (1 << scaleFactor); } else if (scaleFactor == 0) { return d; } else { return d * 1 / (1 << -scaleFactor); } })(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "signum": {
                            this.printMacroName(targetMethodName);
                            this.print("(f => { if (f > 0) { return 1; } else if (f < 0) { return -1; } else { return 0; } })(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "sinh": {
                            this.printMacroName(targetMethodName);
                            this.print("(x => (Math.exp(x) - Math.exp(-x)) / 2)(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "tanh": {
                            this.printMacroName(targetMethodName);
                            this.print("(x => { if (x == Number.POSITIVE_INFINITY) { return 1; } else if (x == Number.NEGATIVE_INFINITY) { return -1; } double e2x = Math.exp(2 * x); return (e2x - 1) / (e2x + 1); })(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "toDegrees": {
                            this.printMacroName(targetMethodName);
                            this.print("(x => x * 180 / Math.PI)(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "toRadians": {
                            this.printMacroName(targetMethodName);
                            this.print("(x => x * Math.PI / 180)(").printArgList(invocationElement.getArguments()).print(")");
                            return true;
                        }
                        case "nextUp": {
                            this.delegateToEmulLayer(targetClassName, targetMethodName, invocationElement);
                            return true;
                        }
                        case "nextDown": {
                            this.delegateToEmulLayer(targetClassName, targetMethodName, invocationElement);
                            return true;
                        }
                        case "ulp": {
                            this.delegateToEmulLayer(targetClassName, targetMethodName, invocationElement);
                            return true;
                        }
                        case "IEEEremainder": {
                            this.delegateToEmulLayer(targetClassName, targetMethodName, invocationElement);
                            return true;
                        }
                    }
                    this.print("Math." + targetMethodName + "(").printArgList(invocationElement.getArguments()).print(")");
                    return true;
                }
                case "java.lang.Class": {
                    switch (targetMethodName) {
                        case "getName": {
                            this.printMacroName(targetMethodName);
                            this.getPrinter().print("(c => c[\"__class\"]?c[\"__class\"]:c[\"name\"])(");
                            this.printTarget(invocationElement.getTargetExpression());
                            this.print(")");
                            return true;
                        }
                        case "getSimpleName": {
                            this.printMacroName(targetMethodName);
                            this.print("(c => c[\"__class\"]?c[\"__class\"].substring(c[\"__class\"].lastIndexOf('.')+1):c[\"name\"].substring(c[\"name\"].lastIndexOf('.')+1))(");
                            this.printTarget(invocationElement.getTargetExpression());
                            this.print(")");
                            return true;
                        }
                    }
                }
            }
            if (invocationElement.getTargetExpression() == null || !this.isMappedType(targetClassName) || !targetClassName.startsWith("java.lang.")) break block469;
            if (invocationElement.getMethod().getModifiers().contains((Object)Modifier.STATIC)) {
                this.delegateToEmulLayer(targetClassName, targetMethodName, invocationElement);
                return true;
            }
            switch (targetMethodName) {
                case "equals": {
                    this.printMacroName(targetMethodName);
                    this.print("(<any>((o1: any, o2: any) => { if(o1 && o1.equals) { return o1.equals(o2); } else { return o1 === o2; } })(");
                    this.printTarget(invocationElement.getTargetExpression()).print(",").print(invocationElement.getArgument(0));
                    this.print("))");
                    return true;
                }
                case "compareTo": {
                    if (invocationElement.getArgumentCount() == 1 && invocationElement.getTargetExpression() != null) {
                        this.printMacroName(targetMethodName);
                        this.print("(<any>((o1: any, o2: any) => { if(o1 && o1.compareTo) { return o1.compareTo(o2); } else { return o1 < o2 ? -1 : o2 < o1 ? 1 : 0; } })(");
                        this.printTarget(invocationElement.getTargetExpression()).print(",").print(invocationElement.getArgument(0));
                        this.print("))");
                    }
                    return true;
                }
            }
        }
        switch (targetMethodName) {
            case "getClass": {
                this.print("(<any>");
                this.printTarget(invocationElement.getTargetExpression());
                this.print(".constructor)");
                return true;
            }
            case "hashCode": {
                if (invocationElement.getArgumentCount() > 0) {
                    this.printTarget(invocationElement.getTargetExpression()).print(".hashCode(");
                    this.printArgList(invocationElement.getArguments());
                    this.print(")");
                } else {
                    this.printMacroName(targetMethodName);
                    this.print("(<any>((o: any) => { if(o.hashCode) { return o.hashCode(); } else { return o.toString().split('').reduce((prevHash, currVal) => (((prevHash << 5) - prevHash) + currVal.charCodeAt(0))|0, 0); }})(");
                    this.printTarget(invocationElement.getTargetExpression());
                    this.print("))");
                }
                return true;
            }
            case "equals": {
                Symbol.MethodSymbol methSym;
                if (invocationElement.getTargetExpression() == null || invocationElement.getArgumentCount() != 1 || ((methSym = Util.findMethodDeclarationInType(this.context.types, (Symbol.TypeSymbol)invocationElement.getTargetExpression().getTypeAsElement(), targetMethodName, (Type.MethodType)invocationElement.getMethod().asType())) == null || !Object.class.getName().equals(((Symbol)methSym.getEnclosingElement()).toString()) && !((Symbol)methSym.getEnclosingElement()).isInterface()) && invocationElement.getTargetExpression().getTypeAsElement().getKind() != ElementKind.INTERFACE && invocationElement.getTargetExpression().getType().getKind() != TypeKind.TYPEVAR) break;
                this.printMacroName(targetMethodName);
                this.print("(<any>((o1: any, o2: any) => { if(o1 && o1.equals) { return o1.equals(o2); } else { return o1 === o2; } })(");
                this.printTarget(invocationElement.getTargetExpression()).print(",").print(invocationElement.getArgument(0));
                this.print("))");
                return true;
            }
            case "clone": {
                if (invocationElement.getMethod().getModifiers().contains((Object)Modifier.STATIC) || invocationElement.getArgumentCount() != 0) break;
                this.printMacroName(targetMethodName);
                if (invocationElement.getTargetExpression() != null && "super".equals(invocationElement.getTargetExpression().toString())) {
                    JCTree.JCClassDecl parent = this.getPrinter().getParent(JCTree.JCClassDecl.class);
                    if (parent.sym.getSuperclass() != null && !this.context.symtab.objectType.equals(parent.sym.getSuperclass())) {
                        this.print("((o:any) => { if(super.clone!=undefined) { return super.clone(); } else { let clone = Object.create(o); for(let p in o) { if (o.hasOwnProperty(p)) clone[p] = o[p]; } return clone; } })(this)");
                    } else {
                        this.print("((o:any) => { let clone = Object.create(o); for(let p in o) { if (o.hasOwnProperty(p)) clone[p] = o[p]; } return clone; })(this)");
                    }
                } else {
                    this.print("((o:any) => { if(o.clone!=undefined) { return (<any>o).clone(); } else { let clone = Object.create(o); for(let p in o) { if (o.hasOwnProperty(p)) clone[p] = o[p]; } return clone; } })(");
                    this.printTarget(invocationElement.getTargetExpression());
                    this.print(")");
                }
                return true;
            }
        }
        this.getPrinter().printDefaultMethodInvocation((JCTree.JCMethodInvocation)((MethodInvocationElementSupport)invocationElement).getTree());
        return true;
    }

    protected void printFunctionalInvocation(ExtendedElement target, String functionName, java.util.List<ExtendedElement> arguments) {
        if (target instanceof IdentifierElement) {
            this.print("(typeof ").print(target).print(" === 'function'?target").print("(").printArgList(arguments).print("):(<any>target).").print(functionName).print("(").printArgList(arguments).print("))");
        } else {
            this.print("(target => (typeof target === 'function')?target").print("(").printArgList(arguments).print("):(<any>target).").print(functionName).print("(").printArgList(arguments).print("))(").print(target).print(")");
        }
    }

    protected final PrinterAdapter printTarget(ExtendedElement target) {
        if (target == null) {
            return this.print("this");
        }
        if ("super".equals(target.toString())) {
            return this.print("this");
        }
        return this.print(target);
    }

    protected final void delegateToEmulLayer(String targetClassName, String targetMethodName, InvocationElement invocation) {
        this.print("javaemul.internal." + targetClassName.substring(10) + "Helper.").print(targetMethodName).print("(").printArgList(invocation.getArguments()).print(")");
    }

    protected final void delegateToEmulLayerStatic(String targetClassName, String targetMethodName, ExtendedElement target) {
        this.print("javaemul.internal." + targetClassName.substring(10) + "Helper.").print(targetMethodName).print("(");
        this.printTarget(target).print(")");
    }

    protected final void printCastMethodInvocation(InvocationElement invocation) {
        boolean needsParens = this.getPrinter().getParent() instanceof JCTree.JCMethodInvocation;
        if (needsParens) {
            JCTree.JCMethodInvocation parentInvocation = (JCTree.JCMethodInvocation)this.getPrinter().getParent();
            if (parentInvocation.meth instanceof JCTree.JCIdent) {
                boolean bl = needsParens = !((JCTree.JCIdent)parentInvocation.meth).getName().toString().equals("async");
            }
        }
        if (needsParens) {
            this.print("(");
        }
        this.print(invocation.getArgument(0));
        if (needsParens) {
            this.print(")");
        }
    }

    public boolean substituteAndPrintType(ExtendedElement enclosingElement, TypeElement type) {
        String typeFullName = type.toString();
        boolean completeRawTypes = true;
        String mappedType = this.context.getTypeMappingTarget(typeFullName);
        if (mappedType != null) {
            if (mappedType.endsWith("<>")) {
                this.print(mappedType.substring(0, mappedType.length() - 2));
            } else {
                this.print(mappedType);
                if (completeRawTypes && !type.getTypeParameters().isEmpty() && !this.context.getTypeMappingTarget(typeFullName).equals("any")) {
                    this.getPrinter().printAnyTypeArguments(type.getTypeParameters().size());
                }
            }
            return true;
        }
        for (BiFunction<ExtendedElement, String, Object> mapping : this.context.getFunctionalTypeMappings()) {
            Object mapped = mapping.apply(enclosingElement, typeFullName);
            if (mapped instanceof String) {
                this.print((String)mapped);
                return true;
            }
            if (mapped instanceof JCTree) {
                this.getPrinter().substituteAndPrintType((JCTree)mapped);
                return true;
            }
            if (!(mapped instanceof TypeMirror)) continue;
            this.print(this.getMappedType((TypeMirror)mapped));
            return true;
        }
        return false;
    }

    @Override
    public boolean substituteVariableAccess(VariableAccessElement variableAccess) {
        if (variableAccess.getTypeAsElement().getKind() == ElementKind.ENUM && "this".equals(variableAccess.getVariableName()) && !(this.getParentElement() instanceof VariableAccessElement) && !(this.getParentElement() instanceof MethodInvocationElement)) {
            this.print("this.").print("_$ordinal");
            return true;
        }
        if (variableAccess.getTargetExpression() != null) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)((VariableAccessElementSupport)variableAccess).getTree();
            String targetFieldName = variableAccess.getVariableName();
            Element targetType = variableAccess.getTargetElement();
            if (!"class".equals(variableAccess.getVariableName()) && variableAccess.getVariable().getModifiers().contains((Object)Modifier.STATIC) && !this.context.getLangTypeMappings().containsKey(targetType.toString()) && this.substituteAndPrintType(variableAccess, (TypeElement)targetType)) {
                this.print(".");
                this.print(variableAccess.getVariableName());
                return true;
            }
            if (targetFieldName.startsWith("$") && targetFieldName.length() > 1 && Character.isDigit(targetFieldName.charAt(1))) {
                try {
                    int i = Integer.parseInt(targetFieldName.substring(1));
                    this.print(variableAccess.getTargetExpression());
                    this.print("[" + i + "]");
                    return true;
                }
                catch (NumberFormatException i) {
                    // empty catch block
                }
            }
            if (this.hasAnnotationType(variableAccess.getVariable(), "jsweet.lang.StringType")) {
                this.print("\"");
                this.print(this.getAnnotationValue(variableAccess.getVariable(), "jsweet.lang.StringType", String.class, variableAccess.getVariableName()));
                this.print("\"");
                return true;
            }
            if (fieldAccess.selected.toString().equals("this") && fieldAccess.sym.isStatic()) {
                this.report((ExtendedElement)variableAccess, JSweetProblem.CANNOT_ACCESS_STATIC_MEMBER_ON_THIS, fieldAccess.name);
            }
            if (!(targetType == null || targetType.getKind() != ElementKind.ENUM || fieldAccess.sym.isEnum() || "this".equals(fieldAccess.selected.toString()) || "class".equals(targetFieldName))) {
                String relTarget = this.getRootRelativeName((Symbol)targetType);
                this.getPrinter().print(relTarget).print("[\"_$wrappers\"][").print(fieldAccess.selected).print("].").print(fieldAccess.name.toString());
                return true;
            }
            String accessedType = ((Symbol)targetType).getQualifiedName().toString();
            if (fieldAccess.sym.isStatic() && this.isMappedType(accessedType) && accessedType.startsWith("java.lang.") && !"class".equals(fieldAccess.name.toString())) {
                this.delegateToEmulLayer(accessedType, variableAccess);
                return true;
            }
        } else {
            if ("jsweet.util.Lang".equals(variableAccess.getTargetElement().toString()) && "$this".equals(variableAccess.getVariableName())) {
                this.print("this");
                return true;
            }
            JCTree.JCIdent identifier = (JCTree.JCIdent)((VariableAccessElementSupport)variableAccess).getTree();
            if (this.context.hasAnnotationType(identifier.sym, "jsweet.lang.StringType")) {
                this.print("\"");
                this.getPrinter().print(this.context.getAnnotationValue(identifier.sym, "jsweet.lang.StringType", String.class, identifier.toString()));
                this.print("\"");
                return true;
            }
        }
        return super.substituteVariableAccess(variableAccess);
    }

    protected final void delegateToEmulLayer(String targetClassName, VariableAccessElement fieldAccess) {
        this.print("javaemul.internal." + targetClassName.substring(10) + "Helper.").print(fieldAccess.getVariableName());
    }

    @Override
    public boolean substituteNewClass(NewClassElement newClassElement) {
        JCTree.JCNewClass newClass = (JCTree.JCNewClass)((NewClassElementSupport)newClassElement).getTree();
        String className = newClassElement.getTypeAsElement().toString();
        if (className.startsWith("jsweet.util.tuple.")) {
            this.getPrinter().print("[").printArgList(null, newClass.args).print("]");
            return true;
        }
        if (this.isMappedType(className)) {
            List<JCTree.JCExpression> typeArgs;
            this.print("<").print(this.getTypeMappingTarget(className));
            if (newClass.clazz instanceof JCTree.JCTypeApply && (typeArgs = ((JCTree.JCTypeApply)newClass.clazz).arguments).size() > 0) {
                this.getPrinter().print("<").printTypeArgList(typeArgs).print(">");
            }
            this.print(">");
        }
        if (newClass.clazz.type.equals(this.context.symtab.stringType) && newClass.args.length() >= 3) {
            this.getPrinter().print("((str, index, len) => ").print("str.substring(index, index + len))((").print((JCTree)newClass.args.head).print(")");
            if ("byte[]".equals(newClass.args.get((int)0).type.toString())) {
                this.print(".map(s => String.fromCharCode(s))");
            }
            this.print(".join(''), ");
            this.getPrinter().print((JCTree)newClass.args.tail.head).print(", ").print((JCTree)newClass.args.tail.tail.head).print(")");
            return true;
        }
        this.getPrinter().printDefaultNewClass(newClass);
        return true;
    }

    @Override
    public boolean substituteIdentifier(IdentifierElement identifierElement) {
        JCTree.JCIdent identifier = (JCTree.JCIdent)((IdentifierElementSupport)identifierElement).getTree();
        if (identifier.type != null) {
            if (this.context.getLangTypesSimpleNames().contains(identifier.toString()) && this.context.getLangTypeMappings().containsKey(identifier.type.toString())) {
                this.print(this.context.getLangTypeMappings().get(identifier.type.toString()));
                return true;
            }
            if (identifier.type.toString().startsWith("java.lang.") && ("java.lang." + identifier.toString()).equals(identifier.type.toString())) {
                this.print(identifier.type.toString());
                return true;
            }
        }
        return super.substituteIdentifier(identifierElement);
    }

    @Override
    public Set<String> getErasedTypes() {
        return this.context.getLangTypeMappings().keySet();
    }

    protected void printForEachLoop(JCTree.JCEnhancedForLoop loop, String indexVarName) {
        this.getPrinter().print("for(let " + indexVarName + "=").print(loop.expr).print(".iterator();" + indexVarName + ".hasNext();) {").println().startIndent().printIndent();
        this.getPrinter().print("let " + loop.var.name.toString() + " = ").print(String.valueOf(indexVarName) + ".next();").println();
        this.getPrinter().printIndent().print(loop.body);
        this.endIndent().println().printIndent().print("}");
    }

    @Override
    public boolean substituteForEachLoop(ForeachLoopElement foreachLoop, boolean targetHasLength, String indexVarName) {
        if (!targetHasLength) {
            this.printForEachLoop((JCTree.JCEnhancedForLoop)((ForeachLoopElementSupport)foreachLoop).getTree(), indexVarName);
            return true;
        }
        return super.substituteForEachLoop(foreachLoop, targetHasLength, indexVarName);
    }
}

