/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.candy;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class CandyDescriptor {
    public static final String UNKNOWN = "unknown";
    private static final Pattern MODEL_VERSION_PATTERN = Pattern.compile("[\\<]groupId[\\>]org[.]jsweet[.]candies[.](.*)[\\<]/groupId[\\>]");
    private static final Gson GSON = new Gson();
    public final String name;
    public final String version;
    public final long lastUpdateTimestamp;
    public final String modelVersion;
    public final String transpilerVersion;
    public final String jsOutputDirPath;
    public final String jsDirPath;
    public final List<String> jsFilesPaths;

    public CandyDescriptor(String name, String version, long lastUpdateTimestamp, String modelVersion, String transpilerVersion, String jsOutputDirPath, String jsDirPath, List<String> jsFilesPaths) {
        this.name = name;
        this.version = version;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        this.modelVersion = modelVersion;
        this.transpilerVersion = transpilerVersion;
        this.jsOutputDirPath = jsOutputDirPath;
        this.jsDirPath = jsDirPath;
        this.jsFilesPaths = jsFilesPaths;
    }

    public boolean hasJsFiles() {
        return this.jsFilesPaths.size() > 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CandyDescriptor)) {
            return false;
        }
        CandyDescriptor other = (CandyDescriptor)obj;
        return this.name.equals(other.name) && this.version.equals(other.version) && this.lastUpdateTimestamp == other.lastUpdateTimestamp && StringUtils.equals((CharSequence)this.jsOutputDirPath, (CharSequence)other.jsOutputDirPath);
    }

    public static CandyDescriptor fromCandyJar(JarFile jarFile, String jsOutputDirPath) throws IOException {
        InputStream in;
        Object var13_17;
        Throwable throwable;
        Optional<JarEntry> pomXmlEntry = jarFile.stream().filter(t -> t.getName().endsWith("pom.xml")).findFirst();
        Optional<JarEntry> pomPropertiesEntry = jarFile.stream().filter(t -> t.getName().endsWith("pom.properties")).findFirst();
        ZipEntry metadataEntry = jarFile.getEntry("META-INF/candy-metadata.json");
        long lastUpdateTimestamp = jarFile.getEntry("META-INF/MANIFEST.MF").getTime();
        String modelVersion = UNKNOWN;
        String name = FilenameUtils.getBaseName((String)jarFile.getName());
        String version = UNKNOWN;
        String transpilerVersion = null;
        if (pomPropertiesEntry.isPresent()) {
            Properties props = new Properties();
            throwable = null;
            var13_17 = null;
            try {
                in = jarFile.getInputStream(pomPropertiesEntry.get());
                try {
                    props.load(in);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            name = props.getProperty("artifactId");
            version = props.getProperty("version");
        }
        if (pomXmlEntry.isPresent()) {
            String pomContent;
            throwable = null;
            var13_17 = null;
            try {
                in = jarFile.getInputStream(pomXmlEntry.get());
                try {
                    pomContent = IOUtils.toString((InputStream)in);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            int dependenciesIndex = pomContent.indexOf("<dependencies>");
            String pomGeneralPart = dependenciesIndex > 0 ? pomContent.substring(0, dependenciesIndex) : pomContent;
            Matcher matcher = MODEL_VERSION_PATTERN.matcher(pomGeneralPart);
            if (matcher.find()) {
                modelVersion = matcher.group(1);
            }
        }
        if (metadataEntry != null) {
            String metadataContent = IOUtils.toString((InputStream)jarFile.getInputStream(metadataEntry));
            Map metadata = (Map)GSON.fromJson(metadataContent, Map.class);
            transpilerVersion = (String)metadata.get("transpilerVersion");
        }
        String jsDirPath = "META-INF/resources/webjars/" + (UNKNOWN.equals(version) ? "" : String.valueOf(name) + "/" + version);
        ZipEntry jsDirEntry = jarFile.getEntry(jsDirPath);
        LinkedList<String> jsFilesPaths = new LinkedList<String>();
        if (jsDirEntry != null) {
            jarFile.stream().map(ZipEntry::getName).filter(t -> t.startsWith(jsDirPath) && t.endsWith(".js")).forEach(jsFilesPaths::add);
        }
        return new CandyDescriptor(name, version, lastUpdateTimestamp, modelVersion, transpilerVersion, jsOutputDirPath, jsDirPath, jsFilesPaths);
    }

    public String toString() {
        return "(" + this.name + "-" + this.version + ",t=" + this.lastUpdateTimestamp + ")";
    }
}

