/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.jsweet.transpiler.EcmaScriptComplianceLevel;
import org.jsweet.transpiler.JSweetOptions;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.TypeScript2JavaScriptTranspiler;
import org.jsweet.transpiler.util.ErrorCountTranspilationHandler;
import org.jsweet.transpiler.util.ProcessUtil;

public class TypeScript2JavaScriptWithTscTranspiler
extends TypeScript2JavaScriptTranspiler {
    private Process tsCompilationProcess;
    private Collection<SourceFile> watchedFiles;
    public static final String TSCROOTFILE = ".tsc-rootfile.ts";
    private static Pattern errorRE = Pattern.compile("(.*)\\((.*)\\): error TS[0-9]+: (.*)");

    @Override
    protected synchronized void doTranspile(ErrorCountTranspilationHandler transpilationHandler, Collection<File> tsFiles, Collection<SourceFile> tsSourceFiles, JSweetOptions options, boolean ignoreErrors, TypeScript2JavaScriptTranspiler.OnTsTranspilationCompletedCallback onTsTranspilationCompleted) throws Exception {
        File tscRootFile;
        if (this.tsCompilationProcess != null && options.isTscWatchMode()) {
            return;
        }
        this.logger.debug((Object)("ts2js with TSC: " + tsFiles));
        if (options.isTscWatchMode()) {
            this.watchedFiles = tsSourceFiles;
        }
        LinkedList<String> args = new LinkedList<String>();
        args.addAll(Arrays.asList("--target", options.getEcmaTargetVersion().name()));
        if (options.isUsingModules()) {
            args.add("--module");
            args.add(options.getModuleKind().toString());
        }
        args.add("--moduleResolution");
        args.add(options.getModuleResolution().toString());
        if (options.getEcmaTargetVersion().ordinal() >= EcmaScriptComplianceLevel.ES5.ordinal()) {
            args.add("--experimentalDecorators");
            args.add("--emitDecoratorMetadata");
        }
        if (options.isTscWatchMode()) {
            args.add("--watch");
        }
        if (options.isGenerateSourceMaps()) {
            args.add("--sourceMap");
        }
        if (options.isGenerateDeclarations()) {
            args.add("--declaration");
        }
        args.addAll(Arrays.asList("--rootDir", options.getTsOutputDir().getAbsolutePath()));
        if (options.getJsOutputDir() != null) {
            args.addAll(Arrays.asList("--outDir", options.getJsOutputDir().getAbsolutePath()));
        }
        if ((tscRootFile = this.getOrCreateTscRootFile(options.getTsOutputDir())).exists()) {
            args.add(this.relativizeTsFile(options.getTsOutputDir(), tscRootFile).toString());
        }
        for (File file : tsFiles) {
            String filePath = this.relativizeTsFile(options.getTsOutputDir(), file).toString();
            args.add(filePath);
        }
        this.logger.info((Object)"launching tsc...");
        boolean[] fullPass = new boolean[]{true};
        if (options.isSkipTypeScriptChecks()) {
            args.add("--skipDefaultLibCheck");
            args.add("--skipLibCheck");
        }
        this.tsCompilationProcess = ProcessUtil.runCommand("tsc", options.getTsOutputDir(), options.isTscWatchMode(), line -> {
            this.logger.info(line);
            TscOutput output = TypeScript2JavaScriptWithTscTranspiler.parseTscOutput(line);
            if (output.position != null) {
                if (ignoreErrors) {
                    return;
                }
                SourcePosition position = SourceFile.findOriginPosition(output.position, tsSourceFiles);
                if (position == null) {
                    transpilationHandler.report(JSweetProblem.INTERNAL_TSC_ERROR, output.position, output.message);
                } else {
                    transpilationHandler.report(JSweetProblem.MAPPED_TSC_ERROR, position, output.message);
                }
            } else if (output.message.startsWith("message TS6042:")) {
                onTsTranspilationCompleted.call(fullPass[0], transpilationHandler, tsSourceFiles);
                blArray[0] = false;
            }
        }, process -> {
            this.tsCompilationProcess = null;
            onTsTranspilationCompleted.call(fullPass[0], transpilationHandler, tsSourceFiles);
            blArray[0] = false;
        }, () -> {
            if (!ignoreErrors && transpilationHandler.getProblemCount() == 0) {
                transpilationHandler.report(JSweetProblem.INTERNAL_TSC_ERROR, null, "Unknown tsc error");
            }
        }, args.toArray(new String[0]));
    }

    private Path relativizeTsFile(File tsOutputDir, File file) {
        try {
            return tsOutputDir.getAbsoluteFile().getCanonicalFile().toPath().relativize(file.getAbsoluteFile().getCanonicalFile().toPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static TscOutput parseTscOutput(String outputString) {
        Matcher m = errorRE.matcher(outputString);
        TscOutput error = new TscOutput();
        if (m.matches()) {
            String[] pos = m.group(2).split(",");
            error.position = new SourcePosition(new File(m.group(1)), null, Integer.parseInt(pos[0]), Integer.parseInt(pos[1]));
            StringBuilder sb = new StringBuilder(m.group(3));
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            if (sb.charAt(sb.length() - 1) == '.') {
                sb.deleteCharAt(sb.length() - 1);
            }
            error.message = sb.toString();
        } else {
            error.message = outputString;
        }
        return error;
    }

    public Collection<SourceFile> getWatchedFiles() {
        return this.watchedFiles;
    }

    public SourceFile getWatchedFile(File javaFile) {
        if (this.watchedFiles != null) {
            for (SourceFile f : this.watchedFiles) {
                if (!f.getJavaFile().getAbsoluteFile().equals(javaFile.getAbsoluteFile())) continue;
                return f;
            }
        }
        return null;
    }

    public void stopWatch() {
        if (this.tsCompilationProcess != null) {
            this.tsCompilationProcess.destroyForcibly();
            while (this.tsCompilationProcess != null && this.tsCompilationProcess.isAlive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
                this.logger.error((Object)"tsc did not terminate");
            }
            try {
                if (this.tsCompilationProcess != null) {
                    this.tsCompilationProcess.waitFor();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.tsCompilationProcess = null;
            this.watchedFiles = null;
        }
    }

    private File getOrCreateTscRootFile(File tsOutputDir) throws IOException {
        File tscRootFile = new File(tsOutputDir, TSCROOTFILE);
        if (!tscRootFile.exists()) {
            FileUtils.write((File)tscRootFile, (CharSequence)"// Root empty file generated by JSweet to avoid tsc behavior, which\n// does not preserve the entire file hierarchy for empty directories.", (boolean)false);
        }
        return tscRootFile;
    }

    private static class TscOutput {
        public SourcePosition position;
        public String message;

        private TscOutput() {
        }

        public String toString() {
            return String.valueOf(this.message) + " - " + this.position;
        }
    }
}

