/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.util.Position;
import org.jsweet.transpiler.util.SourceMap;

public class SourceFile {
    private File javaFile;
    long javaFileLastTranspiled = 0L;
    File tsFile;
    File jsFile;
    File jsMapFile;
    File javaSourceDir;
    File javaSourceDirRelativeFile;
    long jsFileLastTranspiled = 0L;
    private SourceMap sourceMap;

    private static void addFiles(String extension, File file, LinkedList<File> files) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                SourceFile.addFiles(extension, f, files);
                ++n2;
            }
        } else if (file.getName().endsWith(extension)) {
            files.add(file);
        }
    }

    public static SourceFile[] getSourceFiles(File ... dirs) {
        return SourceFile.getSourceFiles(Arrays.asList(dirs));
    }

    public static SourceFile[] getSourceFiles(Iterable<File> dirs) {
        LinkedList<File> files = new LinkedList<File>();
        for (File dir : dirs) {
            SourceFile.addFiles(".java", dir, files);
        }
        return SourceFile.toSourceFiles(files);
    }

    public static SourceFile[] toSourceFiles(File[] javaFiles) {
        return SourceFile.toSourceFiles(Arrays.asList(javaFiles));
    }

    public static SourceFile[] toSourceFiles(Collection<File> javaFiles) {
        SourceFile[] dest = new SourceFile[javaFiles.size()];
        int i = 0;
        for (File javaFile : javaFiles) {
            dest[i++] = new SourceFile(javaFile);
        }
        return dest;
    }

    public static SourceFile[] toSourceFiles(String ... javaFilePaths) {
        SourceFile[] dest = new SourceFile[javaFilePaths.length];
        int i = 0;
        String[] stringArray = javaFilePaths;
        int n = javaFilePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String javaFilePath = stringArray[n2];
            dest[i++] = new SourceFile(new File(javaFilePath));
            ++n2;
        }
        return dest;
    }

    public static File[] toFiles(SourceFile ... sourceFiles) {
        File[] dest = new File[sourceFiles.length];
        int i = 0;
        while (i < sourceFiles.length) {
            dest[i] = sourceFiles[i].javaFile;
            ++i;
        }
        return dest;
    }

    public static void touch(SourceFile ... sourceFiles) {
        int i = 0;
        while (i < sourceFiles.length) {
            sourceFiles[i].touch();
            ++i;
        }
    }

    public static String[] toPaths(SourceFile[] sourceFiles) {
        String[] dest = new String[sourceFiles.length];
        int i = 0;
        while (i < sourceFiles.length) {
            dest[i] = sourceFiles[i].javaFile.getPath();
            ++i;
        }
        return dest;
    }

    public static SourcePosition findOriginPosition(SourcePosition position, SourceFile[] sourceFiles) {
        return SourceFile.findOriginPosition(position, Arrays.asList(sourceFiles));
    }

    public static SourcePosition findOriginPosition(SourcePosition position, Collection<SourceFile> sourceFiles) {
        for (SourceFile sourceFile : sourceFiles) {
            Position inputPosition;
            if (sourceFile.tsFile == null || !sourceFile.tsFile.getAbsolutePath().endsWith(position.getFile().getPath()) || sourceFile.getSourceMap() == null || (inputPosition = sourceFile.getSourceMap().findInputPosition(position.getStartLine(), position.getStartColumn())) == null) continue;
            return new SourcePosition(sourceFile.getJavaFile(), null, inputPosition);
        }
        return null;
    }

    public SourceFile(File javaFile) {
        this.javaFile = javaFile;
    }

    public String toString() {
        return this.javaFile.toString();
    }

    public File getJavaFile() {
        return this.javaFile;
    }

    public void setJavaFile(File javaFile) {
        this.javaFile = javaFile;
    }

    public File getTsFile() {
        return this.tsFile;
    }

    protected SourceFile setTsFile(File tsFile) {
        this.tsFile = tsFile;
        return this;
    }

    public File getJsFile() {
        return this.jsFile;
    }

    protected void setJsFile(File jsFile) {
        this.jsFile = jsFile;
    }

    public File getJsMapFile() {
        return this.jsMapFile;
    }

    public long getJavaFileLastTranspiled() {
        return this.javaFileLastTranspiled;
    }

    public long getJsFileLastTranspiled() {
        return this.jsFileLastTranspiled;
    }

    public int hashCode() {
        if (this.javaFile != null) {
            return this.javaFile.hashCode();
        }
        return super.hashCode();
    }

    public void touch() {
        this.tsFile = null;
        this.jsFile = null;
        this.jsMapFile = null;
        this.javaFileLastTranspiled = 0L;
        this.jsFileLastTranspiled = 0L;
    }

    public SourceMap getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(SourceMap sourceMap) {
        this.sourceMap = sourceMap;
    }
}

