/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.log4j.Logger;
import org.jsweet.transpiler.GlobalBeforeTranslationScanner;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetDiagnosticHandler;
import org.jsweet.transpiler.JSweetOptions;
import org.jsweet.transpiler.Java2TypeScriptTranslator;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.extension.Java2TypeScriptAdapter;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.extension.RemoveJavaDependenciesAdapter;

public class JSweetFactory {
    protected static final Logger logger = Logger.getLogger(JSweetFactory.class);

    public JSweetContext createContext(JSweetOptions options) {
        return new JSweetContext(options);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PrinterAdapter createAdapter(JSweetContext context) {
        if (context.options.getConfiguration() != null && context.options.getConfiguration().containsKey("adapters")) {
            logger.info((Object)("constructing adapters: " + context.options.getConfiguration().get("adapters")));
            try {
                PrinterAdapter adapter = null;
                List adapters = (List)context.options.getConfiguration().get("adapters");
                int i = adapters.size() - 1;
                while (i >= 0) {
                    if (adapters.get(i) instanceof String) {
                        Constructor<?> constructor;
                        Class<?> adapterClass = PrinterAdapter.class.getClassLoader().loadClass((String)adapters.get(i));
                        if (i == adapters.size() - 1) {
                            constructor = null;
                            try {
                                constructor = adapterClass.getConstructor(JSweetContext.class);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (constructor == null) {
                                logger.debug((Object)"constructing default adapter");
                                adapter = context.isUsingJavaRuntime() ? new Java2TypeScriptAdapter(context) : new RemoveJavaDependenciesAdapter(context);
                                try {
                                    constructor = adapterClass.getConstructor(PrinterAdapter.class);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (constructor == null) throw new RuntimeException("wrong adapter class " + adapterClass.getName() + ": the last adapter must be chainable or be the root adapter (see the PrinterAdapter API)");
                                adapter = (PrinterAdapter)constructor.newInstance(adapter);
                            } else {
                                adapter = (PrinterAdapter)constructor.newInstance(context);
                            }
                        } else {
                            constructor = adapterClass.getConstructor(PrinterAdapter.class);
                            if (constructor == null) {
                                throw new RuntimeException("wrong adapter class " + adapterClass.getName() + ": a chainable adapter must define a constructor accepting a parent adapter");
                            }
                            adapter = (PrinterAdapter)constructor.newInstance(adapter);
                        }
                    }
                    --i;
                }
                return adapter;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!context.isUsingJavaRuntime()) return new RemoveJavaDependenciesAdapter(context);
        return new Java2TypeScriptAdapter(context);
    }

    public Java2TypeScriptTranslator createTranslator(PrinterAdapter adapter, TranspilationHandler transpilationHandler, JSweetContext context, JCTree.JCCompilationUnit compilationUnit, boolean fillSourceMap) {
        return new Java2TypeScriptTranslator(adapter, transpilationHandler, context, compilationUnit, fillSourceMap);
    }

    public GlobalBeforeTranslationScanner createBeforeTranslationScanner(TranspilationHandler transpilationHandler, JSweetContext context) {
        return new GlobalBeforeTranslationScanner(transpilationHandler, context);
    }

    public JSweetDiagnosticHandler createDiagnosticHandler(TranspilationHandler transpilationHandler, JSweetContext context) {
        return new JSweetDiagnosticHandler(transpilationHandler, context);
    }
}

