/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ProcessUtil {
    private static final Logger logger = Logger.getLogger(ProcessUtil.class);
    public static final String NODE_MINIMUM_VERSION = "v4.4.0";
    private static boolean initialized = false;
    public static File USER_HOME_DIR = new File(System.getProperty("user.home"));
    public static File NPM_DIR = new File(USER_HOME_DIR, ".jsweet-node_modules");
    private static List<String> nodeCommands = Arrays.asList("tsc", "browserify");
    public static String NODE_COMMAND = "node";
    public static String NPM_COMMAND = "npm";
    private static String EXTRA_PATH = "";

    public static void initNode() {
        if (!initialized) {
            if (!System.getenv("PATH").contains("/usr/local/bin") && new File("/usr/local/bin/node").exists()) {
                ProcessUtil.addExtraPath("/usr/local/bin");
                NODE_COMMAND = "/usr/local/bin/node";
                NPM_COMMAND = "/usr/local/bin/npm";
            }
            initialized = true;
        }
        logger.debug((Object)("extra path: " + EXTRA_PATH));
    }

    public static void addExtraPath(String extraPath) {
        EXTRA_PATH = EXTRA_PATH + extraPath + File.pathSeparator;
    }

    private static String getNpmPath(String command) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return NPM_DIR.getPath() + File.separator + command + ".cmd";
        }
        return NPM_DIR.getPath() + File.separator + "bin" + File.separator + command;
    }

    public static boolean isInstalledWithNpm(String command) {
        return new File(ProcessUtil.getNpmPath(command)).exists();
    }

    public static Process runCommand(String command, Consumer<String> stdoutConsumer, Runnable errorHandler, String ... args) {
        return ProcessUtil.runCommand(command, null, false, stdoutConsumer, null, errorHandler, args);
    }

    public static Process runAsyncCommand(String command, Consumer<String> stdoutConsumer, Consumer<Process> endConsumer, Runnable errorHandler, String ... args) {
        return ProcessUtil.runCommand(command, null, true, stdoutConsumer, endConsumer, errorHandler, args);
    }

    public static Process runCommand(final String command, File directory, boolean async, final Consumer<String> stdoutConsumer, final Consumer<Process> endConsumer, final Runnable errorHandler, String ... args) {
        Object[] cmd = System.getProperty("os.name").startsWith("Windows") ? (nodeCommands.contains(command) ? new String[]{ProcessUtil.getNpmPath(command)} : new String[]{"cmd", "/c", command}) : (nodeCommands.contains(command) ? new String[]{ProcessUtil.getNpmPath(command)} : new String[]{command});
        cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])args);
        logger.debug((Object)("run command: " + StringUtils.join((Object[])cmd, (String)" ")));
        final Process[] process = new Process[]{null};
        try {
            ProcessBuilder processBuilder = new ProcessBuilder((String[])cmd);
            processBuilder.redirectErrorStream(true);
            if (directory != null) {
                processBuilder.directory(directory);
            }
            if (!StringUtils.isBlank((CharSequence)EXTRA_PATH)) {
                processBuilder.environment().put("PATH", processBuilder.environment().get("PATH") + File.pathSeparator + EXTRA_PATH);
            }
            process[0] = processBuilder.start();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    block19: {
                        try {
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(process[0].getInputStream(), "UTF-8"));){
                                String line;
                                while ((line = in.readLine()) != null) {
                                    if (stdoutConsumer != null) {
                                        stdoutConsumer.accept(line);
                                        continue;
                                    }
                                    logger.info((Object)(command + " - " + line));
                                }
                            }
                            process[0].waitFor();
                            if (endConsumer != null) {
                                endConsumer.accept(process[0]);
                            }
                            if (process[0].exitValue() != 0 && errorHandler != null) {
                                errorHandler.run();
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            if (errorHandler == null) break block19;
                            errorHandler.run();
                        }
                    }
                }
            };
            if (async) {
                new Thread(runnable).start();
            } else {
                runnable.run();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (errorHandler != null) {
                errorHandler.run();
            }
            return null;
        }
        return process[0];
    }

    public static void installNodePackage(String nodePackageName, String version, boolean global) {
        logger.debug((Object)("installing " + nodePackageName + " with npm"));
        ProcessUtil.initNode();
        if (global) {
            ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, null, null, null, "install", "--prefix", NPM_DIR.getPath(), version == null ? nodePackageName : nodePackageName + "@" + version, "-g");
        } else {
            ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, null, null, null, "install", version == null ? nodePackageName : nodePackageName + "@" + version, "--save");
        }
    }

    public static boolean isNodePackageInstalled(String nodePackageName) {
        logger.debug((Object)("checking installation of " + nodePackageName + " with npm"));
        ProcessUtil.initNode();
        boolean[] installed = new boolean[]{false};
        ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, (String line) -> {
            if (!installed[0]) {
                installed[0] = line.endsWith("/" + nodePackageName);
            }
        }, null, null, "ls", "--parseable", nodePackageName);
        return installed[0];
    }

    public static void uninstallNodePackage(String nodePackageName, boolean global) {
        logger.debug((Object)("uninstalling " + nodePackageName + " with npm"));
        ProcessUtil.initNode();
        if (global) {
            ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, null, null, null, "uninstall", "--prefix", NPM_DIR.getPath(), nodePackageName, "-g");
        } else {
            ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, null, null, null, "uninstall", nodePackageName);
        }
    }
}

