/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.JSweetTranspiler;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.TranspilationHandler;

public class ErrorCountTranspilationHandler
implements TranspilationHandler {
    private TranspilationHandler delegate;
    private int errorCount = 0;
    private int warningCount = 0;
    private int problemCount = 0;
    private boolean disabled = false;

    public ErrorCountTranspilationHandler(TranspilationHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public void report(JSweetProblem problem, SourcePosition sourcePosition, String message) {
        if (!this.disabled) {
            switch (problem.getSeverity()) {
                case ERROR: {
                    ++this.problemCount;
                    ++this.errorCount;
                    break;
                }
                case WARNING: {
                    ++this.problemCount;
                    ++this.warningCount;
                    break;
                }
                default: {
                    ++this.problemCount;
                }
            }
        }
        this.delegate.report(problem, sourcePosition, message);
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void onCompleted(JSweetTranspiler transpiler, boolean fullPass, SourceFile[] files) {
        this.delegate.onCompleted(transpiler, fullPass, files);
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getProblemCount() {
        return this.problemCount;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
}

