/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.candy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.candy.CandyDescriptor;
import org.jsweet.transpiler.candy.CandyStore;

public class CandyProcessor {
    private static final Logger logger = Logger.getLogger(CandyProcessor.class);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private String classPath;
    public static final String CANDIES_DIR_NAME = "candies";
    public static final String CANDIES_SOURCES_DIR_NAME = "candies" + File.separator + "src";
    public static final String CANDIES_STORE_FILE_NAME = "candies" + File.separator + CandyStore.class.getSimpleName() + ".json";
    public static final String CANDIES_TSDEFS_DIR_NAME = "candies" + File.separator + "typings";
    private static final String CANDIES_DEFAULT_JS_DIR_NAME = "candies" + File.separator + "js";
    private File candiesSourceDir;
    private File candyStoreFile;
    private File candiesTsdefsDir;
    private File candiesJavascriptOutDir;
    private File workingDir;
    private CandyStore candyStore;

    public CandyProcessor(File workingDir, String classPath, File extractedCandiesJavascriptDir) {
        this.workingDir = workingDir;
        this.classPath = classPath == null ? System.getProperty("java.class.path") : classPath;
        Object[] cp = this.classPath.split(File.pathSeparator);
        int[] indices = new int[]{};
        for (int i = 0; i < cp.length; ++i) {
            if (!cp[i].replace('\\', '/').matches(".*org/jsweet/lib/.*-testbundle/.*/.*-testbundle-.*\\.jar")) continue;
            logger.warn((Object)("candies processor ignores classpath entry: " + (String)cp[i]));
            indices = ArrayUtils.add((int[])indices, (int)i);
        }
        cp = (String[])ArrayUtils.removeAll((Object[])cp, (int[])indices);
        this.classPath = StringUtils.join((Object[])cp, (String)File.pathSeparator);
        logger.info((Object)("candies processor classpath: " + this.classPath));
        this.candiesSourceDir = new File(workingDir, CANDIES_SOURCES_DIR_NAME);
        this.candyStoreFile = new File(workingDir, CANDIES_STORE_FILE_NAME);
        this.candiesTsdefsDir = new File(workingDir, CANDIES_TSDEFS_DIR_NAME);
        this.setCandiesJavascriptOutDir(extractedCandiesJavascriptDir);
    }

    private List<CandyDescriptor> getCandies() {
        return this.getCandiesStore().getCandies();
    }

    private void setCandiesJavascriptOutDir(File extractedCandiesJavascriptDir) {
        this.candiesJavascriptOutDir = extractedCandiesJavascriptDir;
        if (this.candiesJavascriptOutDir == null) {
            logger.info((Object)"extracted candies directory is set to default");
            this.candiesJavascriptOutDir = new File(this.workingDir, CANDIES_DEFAULT_JS_DIR_NAME);
        }
        logger.info((Object)("extracted candies directory: " + extractedCandiesJavascriptDir));
        this.candiesJavascriptOutDir.mkdirs();
    }

    public File getCandiesTsdefsDir() {
        return this.candiesTsdefsDir;
    }

    public void processCandies(TranspilationHandler transpilationHandler) throws IOException {
        CandyStore candiesStore = this.getCandiesStore();
        LinkedHashMap<File, CandyDescriptor> newCandiesDescriptors = this.getCandiesDescriptorsFromClassPath(transpilationHandler);
        CandyStore newStore = new CandyStore(new ArrayList<CandyDescriptor>(newCandiesDescriptors.values()));
        if (newStore.equals(candiesStore)) {
            logger.info((Object)"candies are up to date");
            return;
        }
        this.candyStore = newStore;
        logger.info((Object)("candies changed, processing candies: " + this.candyStore));
        try {
            this.extractCandies(newCandiesDescriptors);
            this.writeCandyStore();
        }
        catch (Throwable t) {
            logger.error((Object)"cannot generate candies bundle", t);
        }
    }

    public boolean isUsingJavaRuntime() {
        if (this.candyStore == null) {
            return false;
        }
        for (CandyDescriptor c : this.candyStore.getCandies()) {
            if (c.name == null || !c.name.equals("j4ts")) continue;
            logger.info((Object)"found j4ts Java runtime in classpath");
            return true;
        }
        return false;
    }

    private LinkedHashMap<File, CandyDescriptor> getCandiesDescriptorsFromClassPath(TranspilationHandler transpilationHandler) throws IOException {
        LinkedHashMap<File, CandyDescriptor> jarFilesCollector = new LinkedHashMap<File, CandyDescriptor>();
        for (String classPathEntry : this.classPath.split("[" + System.getProperty("path.separator") + "]")) {
            if (!classPathEntry.endsWith(".jar")) continue;
            File jarFile = new File(classPathEntry);
            try (JarFile jarFileHandle = new JarFile(jarFile);){
                boolean isCandy;
                JarEntry candySpecificEntry = jarFileHandle.getJarEntry("META-INF/maven/" + JSweetConfig.MAVEN_CANDIES_GROUP);
                JarEntry candySpecificEntry2 = jarFileHandle.getJarEntry("META-INF/candy-metadata.json");
                boolean bl = isCandy = candySpecificEntry != null || candySpecificEntry2 != null;
                if (!isCandy) continue;
                CandyDescriptor descriptor = CandyDescriptor.fromCandyJar(jarFileHandle, this.candiesJavascriptOutDir.getAbsolutePath());
                this.checkCandyVersion(descriptor, transpilationHandler);
                jarFilesCollector.put(jarFile, descriptor);
            }
        }
        logger.info((Object)(jarFilesCollector.keySet().size() + " candies found in classpath"));
        return jarFilesCollector;
    }

    private String normalizeVersion(String version) {
        if (version == null) {
            return null;
        }
        String[] v = JSweetConfig.getVersionNumber().split("\\.");
        if (v.length == 2) {
            return version;
        }
        if (v.length == 1) {
            return v[0] + ".0";
        }
        return v[0] + "." + v[1];
    }

    private void checkCandyVersion(CandyDescriptor candy, TranspilationHandler transpilationHandler) {
        String actualTranspilerVersion = this.normalizeVersion(JSweetConfig.getVersionNumber().split("-")[0]);
        String candyTranspilerVersion = this.normalizeVersion(candy.transpilerVersion == null ? null : candy.transpilerVersion.split("-")[0]);
        if (candyTranspilerVersion == null || !candyTranspilerVersion.equals(actualTranspilerVersion)) {
            transpilationHandler.report(JSweetProblem.CANDY_VERSION_DISCREPANCY, null, JSweetProblem.CANDY_VERSION_DISCREPANCY.getMessage(candy.name, candy.version, actualTranspilerVersion, candyTranspilerVersion));
        }
    }

    private void extractCandies(Map<File, CandyDescriptor> candies) throws IOException {
        File extractedSourcesDir = this.candiesSourceDir;
        File extractedTsDefsDir = this.candiesTsdefsDir;
        FileUtils.deleteQuietly((File)extractedSourcesDir);
        FileUtils.deleteQuietly((File)extractedTsDefsDir);
        extractedSourcesDir.mkdirs();
        extractedTsDefsDir.mkdirs();
        for (Map.Entry<File, CandyDescriptor> candy : candies.entrySet()) {
            CandyDescriptor candyDescriptor = candy.getValue();
            File jarFile = candy.getKey();
            String candyName = candyDescriptor.name;
            boolean isCore = "jsweet-core".equals(candyName);
            JarFile jarFileHandle = new JarFile(jarFile);
            Throwable throwable = null;
            try {
                String candyJarName = FilenameUtils.getBaseName((String)jarFile.getName());
                File candyExtractedSourcesDir = new File(extractedSourcesDir, candyJarName);
                File candyExtractedJsDir = new File(this.candiesJavascriptOutDir, candyJarName);
                this.extractCandy(candyDescriptor, jarFileHandle, candyExtractedSourcesDir, extractedTsDefsDir, candyExtractedJsDir, isCore ? tsDefName -> false : null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jarFileHandle == null) continue;
                if (throwable != null) {
                    try {
                        jarFileHandle.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                jarFileHandle.close();
            }
        }
    }

    private void extractCandy(CandyDescriptor descriptor, JarFile jarFile, File javaOutputDirectory, File tsDefOutputDirectory, File jsOutputDirectory, Predicate<String> isTsDefToBeExtracted) {
        logger.info((Object)("extract candy: " + jarFile.getName() + " javaOutputDirectory=" + javaOutputDirectory + " tsDefOutputDirectory=" + tsDefOutputDirectory + " jsOutputDir=" + jsOutputDirectory));
        jarFile.stream().filter(entry -> entry.getName().endsWith(".d.ts") && (entry.getName().startsWith("src/") || entry.getName().startsWith("META-INF/resources/"))).forEach(entry -> {
            File out;
            if (entry.getName().endsWith(".java")) {
                out = new File(javaOutputDirectory + "/" + entry.getName().substring(4));
            } else if (entry.getName().endsWith(".d.ts")) {
                if (isTsDefToBeExtracted != null && !isTsDefToBeExtracted.test(entry.getName())) {
                    return;
                }
                out = new File(tsDefOutputDirectory + "/" + entry.getName());
            } else {
                out = null;
            }
            this.extractEntry(jarFile, (JarEntry)entry, out);
        });
        for (String jsFilePath : descriptor.jsFilesPaths) {
            JarEntry entry2 = jarFile.getJarEntry(jsFilePath);
            String relativeJsPath = jsFilePath.substring(descriptor.jsDirPath.length());
            File out = new File(jsOutputDirectory, relativeJsPath);
            this.extractEntry(jarFile, entry2, out);
        }
    }

    private void extractEntry(JarFile jarFile, JarEntry entry, File out) {
        if (out == null) {
            return;
        }
        out.getParentFile().mkdirs();
        try {
            FileUtils.copyInputStreamToFile((InputStream)jarFile.getInputStream(entry), (File)out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void touch() {
        this.candyStore = null;
    }

    private CandyStore getCandiesStore() {
        if (this.candyStore == null) {
            if (this.candyStoreFile.exists()) {
                try {
                    this.candyStore = (CandyStore)gson.fromJson(FileUtils.readFileToString((File)this.candyStoreFile), CandyStore.class);
                }
                catch (Exception e) {
                    logger.error((Object)"cannot read candies index", (Throwable)e);
                }
            }
            if (this.candyStore == null) {
                this.candyStore = new CandyStore();
            }
        }
        return this.candyStore;
    }

    private void writeCandyStore() {
        if (this.candyStore != null) {
            try {
                FileUtils.write((File)this.candyStoreFile, (CharSequence)gson.toJson((Object)this.candyStore));
            }
            catch (Exception e) {
                logger.error((Object)"cannot read candies index", (Throwable)e);
            }
        }
    }

    public boolean hasDeprecatedCandy() {
        for (CandyDescriptor candy : this.getCandies()) {
            if (!candy.transpilerVersion.startsWith("1")) continue;
            return true;
        }
        return false;
    }
}

