/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.util.AbstractTreeScanner;
import org.jsweet.transpiler.util.Util;

public class OverloadScanner
extends AbstractTreeScanner {
    private Types types;
    private int pass = 1;

    public OverloadScanner(TranspilationHandler logHandler, JSweetContext context) {
        super(logHandler, context, null);
        this.types = Types.instance(context);
    }

    private void inspectSuperTypes(Symbol.ClassSymbol clazz, Overload overload, JCTree.JCMethodDecl method) {
        if (clazz == null) {
            return;
        }
        Overload superOverload = this.context.getOverload(clazz, method.sym);
        if (superOverload != null && superOverload != overload) {
            superOverload.merge(this.types, overload);
        }
        this.inspectSuperTypes((Symbol.ClassSymbol)clazz.getSuperclass().tsym, overload, method);
        for (Type t : clazz.getInterfaces()) {
            this.inspectSuperTypes((Symbol.ClassSymbol)t.tsym, overload, method);
        }
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl classdecl) {
        Symbol.ClassSymbol clazz = classdecl.sym;
        if (clazz.getQualifiedName().toString().startsWith("def.") || this.context.hasAnnotationType(clazz, "jsweet.lang.Erased", "jsweet.lang.Ambient")) {
            return;
        }
        for (JCTree member : classdecl.defs) {
            if (!(member instanceof JCTree.JCMethodDecl) || this.context.hasAnnotationType(((JCTree.JCMethodDecl)member).sym, "jsweet.lang.Erased", "jsweet.lang.Ambient")) continue;
            JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)member;
            Overload overload = this.context.getOrCreateOverload(clazz, method.sym);
            if (this.pass == 1) {
                overload.methods.add(method);
                continue;
            }
            if (((JCTree.JCMethodDecl)member).sym.isConstructor()) continue;
            this.inspectSuperTypes(classdecl.sym, overload, method);
        }
        super.visitClassDef(classdecl);
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit cu) {
        this.setCompilationUnit(cu);
        super.visitTopLevel(cu);
        this.setCompilationUnit(null);
    }

    public void process(java.util.List<JCTree.JCCompilationUnit> cuList) {
        for (JCTree.JCCompilationUnit cu : cuList) {
            this.scan(cu);
        }
        ++this.pass;
        for (JCTree.JCCompilationUnit cu : cuList) {
            this.scan(cu);
        }
        for (Overload overload : this.context.getAllOverloads()) {
            overload.calculate(this.types, this.context.symtab);
            if (overload.methods.size() <= 1 || overload.isValid || !overload.coreMethod.sym.isConstructor()) continue;
            this.context.classesWithWrongConstructorOverload.add(overload.coreMethod.sym.enclClass());
        }
    }

    public static class Overload {
        public String methodName;
        public java.util.List<JCTree.JCMethodDecl> methods = new ArrayList<JCTree.JCMethodDecl>();
        public boolean isValid = true;
        public JCTree.JCMethodDecl coreMethod;
        public Map<Integer, JCTree> defaultValues;
        public boolean printed = false;
        private java.util.List<String> parameterNames = new ArrayList<String>();

        public String toString() {
            StringBuilder sb = new StringBuilder("overload(" + this.methodName + ")[" + this.methods.size() + "," + this.isValid + "]");
            if (this.methods.size() > 1) {
                for (JCTree.JCMethodDecl method : this.methods) {
                    sb.append("\n      # " + method.sym.getEnclosingElement() + "." + method.sym);
                }
            }
            return sb.toString();
        }

        public int getSmallerParameterCount() {
            return ((List)this.methods.get(this.methods.size() - 1).getParameters()).size();
        }

        public String getParameterName(int index) {
            return this.parameterNames.get(index);
        }

        private void initParameterNames() {
            if (this.isValid) {
                for (int index = 0; index < ((List)this.coreMethod.getParameters()).length(); ++index) {
                    this.parameterNames.add(((JCTree.JCVariableDecl)((List)this.coreMethod.getParameters()).get((int)index)).name.toString());
                }
            } else {
                for (int index = 0; index < ((List)this.coreMethod.getParameters()).length(); ++index) {
                    ArrayList<String> names = new ArrayList<String>();
                    for (JCTree.JCMethodDecl method : this.methods) {
                        if (((List)method.getParameters()).length() <= index || names.contains(((JCTree.JCVariableDecl)((List)method.getParameters()).get((int)index)).name.toString())) continue;
                        names.add(((JCTree.JCVariableDecl)((List)method.getParameters()).get((int)index)).name.toString());
                    }
                    String parameterName = (String)names.get(0);
                    for (int i = 1; i < names.size(); ++i) {
                        parameterName = parameterName + "Or" + StringUtils.capitalize((String)((String)names.get(i)));
                    }
                    int count = 2;
                    while (this.parameterNames.contains(parameterName)) {
                        parameterName = parameterName + count++;
                    }
                    this.parameterNames.add(parameterName);
                }
            }
        }

        public void calculate(Types types, Symtab symtab) {
            if (this.methods.size() < 2) {
                return;
            }
            this.methods.sort((m1, m2) -> {
                int i = ((List)m2.getParameters()).size() - ((List)m1.getParameters()).size();
                if (i == 0) {
                    this.isValid = false;
                    for (int j = 0; j < ((List)m1.getParameters()).size(); ++j) {
                        boolean abstract2;
                        if (types.isAssignable(types.erasure(((JCTree.JCVariableDecl)((List)m1.getParameters()).get((int)j)).type), types.erasure(((JCTree.JCVariableDecl)((List)m2.getParameters()).get((int)j)).type))) {
                            --i;
                        }
                        if (types.isAssignable(types.erasure(((JCTree.JCVariableDecl)((List)m2.getParameters()).get((int)j)).type), types.erasure(((JCTree.JCVariableDecl)((List)m1.getParameters()).get((int)j)).type))) {
                            ++i;
                        }
                        if (i == 0) {
                            boolean core1 = Util.isCoreType(((JCTree.JCVariableDecl)((List)m1.getParameters()).get((int)j)).type);
                            if (((JCTree.JCVariableDecl)((List)m1.getParameters()).get((int)j)).type == symtab.stringType) {
                                core1 = false;
                            }
                            boolean core2 = Util.isCoreType(((JCTree.JCVariableDecl)((List)m2.getParameters()).get((int)j)).type);
                            if (((JCTree.JCVariableDecl)((List)m2.getParameters()).get((int)j)).type == symtab.stringType) {
                                core2 = false;
                            }
                            if (!core1 && core2) {
                                --i;
                            }
                            if (core1 && !core2) {
                                ++i;
                            }
                        }
                        if (i != 0) continue;
                        boolean abstract1 = m1.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) || ((Symbol)m1.sym.getEnclosingElement()).isInterface() && !m1.getModifiers().getFlags().contains((Object)Modifier.DEFAULT);
                        boolean bl = abstract2 = m2.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) || ((Symbol)m2.sym.getEnclosingElement()).isInterface() && !m2.getModifiers().getFlags().contains((Object)Modifier.DEFAULT);
                        if (abstract1 && !abstract2) {
                            ++i;
                        }
                        if (abstract1 || !abstract2) continue;
                        --i;
                    }
                }
                if (m1.sym.getEnclosingElement() != m2.sym.getEnclosingElement()) {
                    this.isValid = false;
                }
                return i;
            });
            this.coreMethod = this.methods.get(0);
            Type coreMethodType = types.erasureRecursive(this.coreMethod.type);
            for (JCTree.JCMethodDecl m : new ArrayList<JCTree.JCMethodDecl>(this.methods)) {
                if (m == this.coreMethod || !coreMethodType.toString().equals(types.erasureRecursive(m.type).toString())) continue;
                this.methods.remove(m);
            }
            if (this.isValid) {
                this.defaultValues = new HashMap<Integer, JCTree>();
            }
            if (this.methods.size() > 1 && this.isValid) {
                block1: for (JCTree.JCMethodDecl methodDecl : this.methods) {
                    if (methodDecl.body != null && methodDecl.body.stats.size() == 1) {
                        if (methodDecl.equals(this.coreMethod)) continue;
                        JCTree.JCMethodInvocation invocation = null;
                        JCTree.JCStatement stat = methodDecl.body.stats.get(0);
                        if (stat instanceof JCTree.JCReturn) {
                            if (((JCTree.JCReturn)stat).expr instanceof JCTree.JCMethodInvocation) {
                                invocation = (JCTree.JCMethodInvocation)((JCTree.JCReturn)stat).expr;
                            }
                        } else if (stat instanceof JCTree.JCExpressionStatement && ((JCTree.JCExpressionStatement)stat).expr instanceof JCTree.JCMethodInvocation) {
                            invocation = (JCTree.JCMethodInvocation)((JCTree.JCExpressionStatement)stat).expr;
                        }
                        if (invocation == null) {
                            this.isValid = false;
                            continue;
                        }
                        Symbol.MethodSymbol method = Util.findMethodDeclarationInType(types, (Symbol.TypeSymbol)methodDecl.sym.getEnclosingElement(), invocation);
                        if (method != null && ((Name)method.getSimpleName()).toString().equals(this.methodName)) {
                            String inv = invocation.meth.toString();
                            if (!(inv.equals(this.methodName) || inv.equals("this." + this.methodName) || inv.equals("this"))) {
                                this.isValid = false;
                            }
                            if (!this.isValid || invocation.getArguments() == null) continue;
                            for (int i = 0; i < ((List)invocation.getArguments()).size(); ++i) {
                                JCTree.JCExpression expr = (JCTree.JCExpression)((List)invocation.getArguments()).get(i);
                                if (Util.isConstant(expr)) {
                                    this.defaultValues.put(i, expr);
                                    continue;
                                }
                                if (expr instanceof JCTree.JCIdent && i < methodDecl.params.length() && methodDecl.params.get((int)i).name.equals(((JCTree.JCIdent)expr).name)) continue;
                                this.isValid = false;
                                continue block1;
                            }
                            continue;
                        }
                        this.isValid = false;
                        continue;
                    }
                    this.isValid = false;
                }
            }
        }

        private static boolean hasMethodType(Types types, Overload overload, JCTree.JCMethodDecl method) {
            return overload.methods.stream().map(m -> types.erasureRecursive(m.type)).anyMatch(t -> {
                boolean match = t.toString().equals(types.erasureRecursive(method.type).toString());
                if (match && t.tsym.getEnclosingElement() != method.sym.getEnclosingElement()) {
                    overload.isValid = false;
                }
                return match;
            });
        }

        private static void safeAdd(Types types, Overload overload, JCTree.JCMethodDecl method) {
            if (!overload.methods.contains(method) && !Overload.hasMethodType(types, overload, method)) {
                overload.methods.add(method);
            }
        }

        public void merge(Types types, Overload subOverload) {
            for (JCTree.JCMethodDecl m : this.methods) {
                if (!m.getModifiers().getFlags().contains((Object)Modifier.DEFAULT)) continue;
                boolean overriden = false;
                for (JCTree.JCMethodDecl subm : new ArrayList<JCTree.JCMethodDecl>(subOverload.methods)) {
                    if (((List)subm.getParameters()).size() != ((List)m.getParameters()).size()) continue;
                    overriden = true;
                    for (int i = 0; i < ((List)subm.getParameters()).size(); ++i) {
                        if (types.isAssignable(((JCTree.JCVariableDecl)((List)m.getParameters()).get((int)i)).type, ((JCTree.JCVariableDecl)((List)subm.getParameters()).get((int)i)).type)) continue;
                        overriden = false;
                    }
                }
                if (overriden) continue;
                Overload.safeAdd(types, subOverload, m);
            }
            boolean merge = false;
            for (JCTree.JCMethodDecl subm : new ArrayList<JCTree.JCMethodDecl>(subOverload.methods)) {
                boolean overrides = false;
                for (JCTree.JCMethodDecl m : new ArrayList<JCTree.JCMethodDecl>(this.methods)) {
                    if (((List)subm.getParameters()).size() != ((List)m.getParameters()).size()) continue;
                    overrides = true;
                    for (int i = 0; i < ((List)subm.getParameters()).size(); ++i) {
                        if (types.isAssignable(((JCTree.JCVariableDecl)((List)m.getParameters()).get((int)i)).type, ((JCTree.JCVariableDecl)((List)subm.getParameters()).get((int)i)).type)) continue;
                        overrides = false;
                    }
                }
                if (overrides) continue;
                merge = true;
                Overload.safeAdd(types, this, subm);
            }
            boolean bl = merge = merge || this.methods.size() > 1;
            if (merge) {
                for (JCTree.JCMethodDecl m : this.methods) {
                    Overload.safeAdd(types, subOverload, m);
                }
            }
        }
    }
}

