/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapConsumerFactory;
import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import com.google.debugging.sourcemap.SourceMapping;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.gson.Gson;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.EcmaScriptComplianceLevel;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetFactory;
import org.jsweet.transpiler.JSweetOptions;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.Java2TypeScriptTranslator;
import org.jsweet.transpiler.ModuleKind;
import org.jsweet.transpiler.ModuleResolution;
import org.jsweet.transpiler.OverloadScanner;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.StaticInitilializerAnalyzer;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.candy.CandyProcessor;
import org.jsweet.transpiler.extension.ExtensionManager;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.util.DirectedGraph;
import org.jsweet.transpiler.util.ErrorCountTranspilationHandler;
import org.jsweet.transpiler.util.EvaluationResult;
import org.jsweet.transpiler.util.Position;
import org.jsweet.transpiler.util.ProcessUtil;
import org.jsweet.transpiler.util.SourceMap;
import org.jsweet.transpiler.util.Util;

public class JSweetTranspiler
implements JSweetOptions {
    public static final String TSC_VERSION = "2.1";
    public static final String TMP_WORKING_DIR_NAME = ".jsweet";
    public static final String EXPORTED_VAR_BEGIN = "EXPORT ";
    public static final String EXPORTED_VAR_END = ";";
    private static Pattern exportedVarRE;
    private static final Logger logger;
    public static final String TSCROOTFILE = ".tsc-rootfile.ts";
    private JSweetFactory factory;
    private PrinterAdapter adapter;
    private long transpilationStartTimestamp;
    private ArrayList<File> auxiliaryTsModuleFiles = new ArrayList();
    private JSweetContext context;
    private Options options;
    private JavaFileManager fileManager;
    private JavaCompiler compiler;
    private Log log;
    private CandyProcessor candiesProcessor;
    private boolean generateSourceMaps = false;
    private File workingDir;
    private File tsOutputDir;
    private File jsOutputDir;
    private String classPath;
    private boolean generateTsFiles = true;
    private boolean generateJsFiles = true;
    private boolean tscWatchMode = false;
    private File[] tsDefDirs = new File[0];
    private ModuleKind moduleKind = ModuleKind.none;
    private ModuleResolution moduleResolution = ModuleResolution.classic;
    private EcmaScriptComplianceLevel ecmaTargetVersion = EcmaScriptComplianceLevel.ES3;
    private boolean bundle = false;
    private String encoding = null;
    private boolean noRootDirectories = false;
    private boolean ignoreAssertions = true;
    private boolean ignoreJavaFileNameError = false;
    private boolean generateDeclarations = false;
    private File declarationsOutputDir;
    private boolean generateDefinitions = true;
    private ArrayList<File> jsLibFiles = new ArrayList();
    private File sourceRoot = null;
    private boolean ignoreTypeScriptErrors = false;
    private boolean ignoreJavaErrors = false;
    private boolean forceJavaRuntime = false;
    private boolean isUsingJavaRuntime = false;
    private File headerFile = null;
    private boolean debugMode = false;
    private boolean skipTypeScriptChecks = false;
    private boolean disableSingleFloatPrecision = false;
    private ArrayList<String> adapters = new ArrayList();
    private File configurationFile;
    private Map<String, Object> configuration;
    private File baseDirectory;
    private static Pattern errorRE;
    private Process tsCompilationProcess;
    private SourceFile[] watchedFiles;
    private File extractedCandyJavascriptDir;

    public static EcmaScriptComplianceLevel getEcmaTargetVersion(String targetVersion) {
        try {
            EcmaScriptComplianceLevel ecmaScriptComplianceLevel = EcmaScriptComplianceLevel.valueOf(targetVersion);
            return ecmaScriptComplianceLevel;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid EcmaScript target version: " + targetVersion);
        }
    }

    public void setUsingJavaRuntime(boolean usingJavaRuntime) {
        this.forceJavaRuntime = true;
        this.isUsingJavaRuntime = usingJavaRuntime;
    }

    public String toString() {
        return "workingDir=" + this.workingDir + "\ntsOutputDir=" + this.tsOutputDir + "\njsOutputDir=" + this.jsOutputDir + "\nclassPath=" + this.classPath + "\ngenerateJsFiles=" + this.generateJsFiles + "\ntscWatchMode=" + this.tscWatchMode + "\ntsDefDirs=" + (this.tsDefDirs == null ? null : Arrays.asList(this.tsDefDirs)) + "\nmoduleKind=" + (Object)((Object)this.moduleKind) + "\necmaTargertVersion=" + this.ecmaTargetVersion + "\nbundle=" + this.bundle + "\nencoding=" + this.encoding + "\nnoRootDirectories=" + this.noRootDirectories + "\nignoreAssertions=" + this.ignoreAssertions + "\nignoreJavaFileNameError=" + this.ignoreJavaFileNameError + "\ngenerateDeclarations=" + this.generateDeclarations + "\ndeclarationsOutputDir=" + this.declarationsOutputDir + "\ngenerateDefinitions=" + this.generateDefinitions + "\njsLibFiles=" + this.jsLibFiles;
    }

    public JSweetTranspiler(JSweetFactory factory) {
        this(factory, new File(System.getProperty("java.io.tmpdir")), null, null, System.getProperty("java.class.path"));
    }

    public JSweetTranspiler(JSweetFactory factory, File tsOutputDir, File jsOutputDir, File extractedCandiesJavascriptDir, String classPath) {
        this(factory, null, tsOutputDir, jsOutputDir, extractedCandiesJavascriptDir, classPath);
    }

    private <T> T getMapValue(Map<String, Object> map, String key) {
        return (T)map.get(key);
    }

    private void applyConfiguration() {
        if (this.configuration.containsKey("options")) {
            Map options = (Map)this.configuration.get("options");
            for (String key : options.keySet()) {
                if (ArrayUtils.contains((Object[])JSweetOptions.options, (Object)key)) continue;
                logger.error((Object)("unsupported option: " + key));
            }
            if (options.containsKey("bundle")) {
                this.setBundle((Boolean)this.getMapValue(options, "bundle"));
            }
            if (options.containsKey("noRootDirectories")) {
                this.setNoRootDirectories((Boolean)this.getMapValue(options, "noRootDirectories"));
            }
            if (options.containsKey("sourceMap")) {
                this.setGenerateSourceMaps((Boolean)this.getMapValue(options, "sourceMap"));
            }
            if (options.containsKey("module")) {
                this.setModuleKind(ModuleKind.valueOf((String)this.getMapValue(options, "module")));
            }
            if (options.containsKey("encoding")) {
                this.setEncoding((String)this.getMapValue(options, "encoding"));
            }
            if (options.containsKey("enableAssertions")) {
                this.setIgnoreAssertions((Boolean)this.getMapValue(options, "enableAssertions") == false);
            }
            if (options.containsKey("declaration")) {
                this.setGenerateDeclarations((Boolean)this.getMapValue(options, "declaration"));
            }
            if (options.containsKey("tsOnly")) {
                this.setGenerateJsFiles((Boolean)this.getMapValue(options, "tsOnly") == false);
            }
            if (options.containsKey("ignoreDefinitions")) {
                this.setGenerateDefinitions((Boolean)this.getMapValue(options, "ignoreDefinitions") == false);
            }
            if (options.containsKey("header")) {
                this.setHeaderFile(new File((String)this.getMapValue(options, "header")));
            }
            if (options.containsKey("disableSinglePrecisionFloats")) {
                this.setDisableSinglePrecisionFloats((Boolean)this.getMapValue(options, "disableSinglePrecisionFloats"));
            }
            if (options.containsKey("targetVersion")) {
                this.setEcmaTargetVersion(JSweetTranspiler.getEcmaTargetVersion((String)this.getMapValue(options, "targetVersion")));
            }
            if (options.containsKey("tsout")) {
                this.setTsOutputDir(new File((String)this.getMapValue(options, "tsout")));
            }
            if (options.containsKey("dtsout")) {
                this.setDeclarationsOutputDir(new File((String)this.getMapValue(options, "dtsout")));
            }
            if (options.containsKey("jsout")) {
                this.setJsOutputDir(new File((String)this.getMapValue(options, "jsout")));
            }
            if (options.containsKey("candiesJsOut")) {
                this.setJsOutputDir(new File((String)this.getMapValue(options, "candiesJsOut")));
            }
            if (options.containsKey("moduleResolution")) {
                this.setModuleResolution((ModuleResolution)((Object)this.getMapValue(options, "moduleResolution")));
            }
            if (options.containsKey("extraSystemPath")) {
                ProcessUtil.addExtraPath("extraSystemPath");
            }
        }
    }

    private void readConfiguration() {
        File confFile;
        File file = confFile = this.configurationFile == null ? new File(this.baseDirectory, "jsweetconfig.json") : this.configurationFile;
        if (confFile.exists()) {
            try {
                Map fromJson;
                logger.info((Object)("configuration file found: " + confFile));
                this.configuration = fromJson = (Map)new Gson().fromJson(FileUtils.readFileToString((File)confFile), Map.class);
                logger.debug((Object)("configuration: " + this.configuration));
                this.applyConfiguration();
            }
            catch (Exception e) {
                logger.warn((Object)"error reading configuration file", (Throwable)e);
            }
        } else {
            logger.info((Object)("no configuration file found at " + confFile.getAbsolutePath()));
        }
    }

    public JSweetTranspiler(JSweetFactory factory, File workingDir, File tsOutputDir, File jsOutputDir, File extractedCandiesJavascriptDir, String classPath) {
        this(null, factory, workingDir, tsOutputDir, tsOutputDir, extractedCandiesJavascriptDir, classPath);
    }

    public JSweetTranspiler(File configurationFile, JSweetFactory factory, File workingDir, File tsOutputDir, File jsOutputDir, File extractedCandiesJavascriptDir, String classPath) {
        this(null, configurationFile, factory, workingDir, tsOutputDir, jsOutputDir, extractedCandiesJavascriptDir, classPath);
    }

    public JSweetTranspiler(File baseDirectory, File configurationFile, JSweetFactory factory, File workingDir, File tsOutputDir, File jsOutputDir, File extractedCandiesJavascriptDir, String classPath) {
        if (baseDirectory == null) {
            baseDirectory = new File(".");
        }
        this.baseDirectory = baseDirectory;
        this.baseDirectory.mkdirs();
        this.configurationFile = configurationFile;
        this.factory = factory;
        this.readConfiguration();
        if (tsOutputDir == null) {
            tsOutputDir = new File(baseDirectory, "target/ts");
        }
        this.workingDir = workingDir == null ? new File(baseDirectory, TMP_WORKING_DIR_NAME).getAbsoluteFile() : workingDir.getAbsoluteFile();
        this.extractedCandyJavascriptDir = extractedCandiesJavascriptDir;
        try {
            tsOutputDir.mkdirs();
            this.tsOutputDir = tsOutputDir.getCanonicalFile();
            if (jsOutputDir != null && this.generateJsFiles) {
                jsOutputDir.mkdirs();
                this.jsOutputDir = jsOutputDir.getCanonicalFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("cannot locate output dirs", e);
        }
        File extensionDirectory = new File(baseDirectory, "jsweet_extension");
        classPath = classPath == null ? System.getProperty("java.class.path") : classPath;
        this.classPath = classPath = extensionDirectory.getAbsolutePath() + File.pathSeparator + classPath;
        logger.info((Object)("creating transpiler version " + JSweetConfig.getVersionNumber() + " (build date: " + JSweetConfig.getBuildDate() + ")"));
        logger.info((Object)("current dir: " + new File(".").getAbsolutePath()));
        logger.info((Object)("base directory: " + this.baseDirectory.getAbsolutePath()));
        logger.info((Object)("tsOut: " + tsOutputDir + (tsOutputDir == null ? "" : " - " + tsOutputDir.getAbsolutePath())));
        logger.info((Object)("jsOut: " + jsOutputDir + (jsOutputDir == null ? "" : " - " + jsOutputDir.getAbsolutePath())));
        logger.info((Object)("candyJsOut: " + extractedCandiesJavascriptDir));
        logger.info((Object)("factory: " + factory));
        logger.debug((Object)("compile classpath POUET: " + classPath));
        logger.debug((Object)("runtime classpath: " + System.getProperty("java.class.path")));
        logger.debug((Object)("extension directory: " + extensionDirectory.getAbsolutePath()));
        this.candiesProcessor = new CandyProcessor(this.workingDir, classPath, this.extractedCandyJavascriptDir);
        new ExtensionManager(extensionDirectory.getAbsolutePath()).checkAndCompileExtension(this.workingDir, classPath);
    }

    public File getWorkingDirectory() {
        return this.workingDir;
    }

    public void initNode(TranspilationHandler transpilationHandler) throws Exception {
        ProcessUtil.initNode();
        File initFile = new File(this.workingDir, ".node-init");
        boolean initialized = initFile.exists();
        if (!initialized) {
            ProcessUtil.runCommand(ProcessUtil.NODE_COMMAND, line -> {
                logger.info((Object)("node version: " + line));
                if (line.compareTo("v4.4.0") < 0) {
                    transpilationHandler.report(JSweetProblem.NODE_OBSOLETE_VERSION, null, JSweetProblem.NODE_OBSOLETE_VERSION.getMessage(line, "v4.4.0"));
                }
            }, () -> {
                transpilationHandler.report(JSweetProblem.NODE_CANNOT_START, null, JSweetProblem.NODE_CANNOT_START.getMessage(new Object[0]));
                throw new RuntimeException("cannot find node.js");
            }, "--version");
            initFile.mkdirs();
            initFile.createNewFile();
        }
        String v = "";
        File tscVersionFile = new File(ProcessUtil.NPM_DIR, "tsc-version");
        if (tscVersionFile.exists()) {
            v = FileUtils.readFileToString((File)tscVersionFile);
        }
        if (!ProcessUtil.isInstalledWithNpm("tsc") || !v.trim().startsWith(TSC_VERSION)) {
            if (ProcessUtil.isInstalledWithNpm("tsc")) {
                ProcessUtil.uninstallNodePackage("typescript", true);
            }
            ProcessUtil.installNodePackage("typescript", TSC_VERSION, true);
            FileUtils.writeStringToFile((File)tscVersionFile, (String)TSC_VERSION);
        }
    }

    public void setTsDefDirs(File ... tsDefDirs) {
        this.tsDefDirs = tsDefDirs;
    }

    public void addTsDefDir(File tsDefDir) {
        if (!ArrayUtils.contains((Object[])this.tsDefDirs, (Object)tsDefDir)) {
            this.tsDefDirs = (File[])ArrayUtils.add((Object[])this.tsDefDirs, (Object)tsDefDir);
        }
    }

    public void clearTsDefDirs() {
        this.tsDefDirs = new File[0];
    }

    private void initJavac(TranspilationHandler transpilationHandler) {
        this.context = this.factory.createContext(this);
        this.context.setUsingJavaRuntime(this.forceJavaRuntime ? this.isUsingJavaRuntime : (this.candiesProcessor == null ? false : this.candiesProcessor.isUsingJavaRuntime()));
        this.adapter = this.factory.createAdapter(this.context);
        this.options = Options.instance(this.context);
        if (this.classPath != null) {
            this.options.put(Option.CLASSPATH, this.classPath);
            for (String s : this.classPath.split(File.pathSeparator)) {
                if (!s.contains(JSweetConfig.MAVEN_JAVA_OVERRIDE_ARTIFACT)) continue;
                this.context.strictMode = true;
                this.options.put(Option.BOOTCLASSPATH, s);
            }
        }
        if (this.encoding != null) {
            this.options.put(Option.ENCODING, this.encoding);
        }
        logger.debug((Object)("encoding: " + this.options.get(Option.ENCODING)));
        logger.debug((Object)("strict mode: " + this.context.strictMode));
        this.options.put(Option.XLINT, "path");
        JavacFileManager.preRegister(this.context);
        this.fileManager = this.context.get(JavaFileManager.class);
        this.compiler = JavaCompiler.instance(this.context);
        this.compiler.attrParseOnly = true;
        this.compiler.verbose = false;
        this.compiler.genEndPos = true;
        this.compiler.keepComments = true;
        this.log = Log.instance(this.context);
        this.log.dumpOnError = false;
        this.log.emitWarnings = false;
        this.log.setWriters(new PrintWriter(new StringWriter(){

            @Override
            public void write(String str) {
            }
        }));
        this.log.setDiagnosticFormatter(this.factory.createDiagnosticHandler(transpilationHandler, this.context));
    }

    private boolean areAllTranspiled(SourceFile ... sourceFiles) {
        for (SourceFile file : sourceFiles) {
            if (file.getJsFile() != null) continue;
            return false;
        }
        return true;
    }

    public EvaluationResult eval(TranspilationHandler transpilationHandler, SourceFile ... sourceFiles) throws Exception {
        return this.eval("JavaScript", transpilationHandler, sourceFiles);
    }

    private void initExportedVarMap() throws Exception {
        Field f = null;
        try {
            f = Thread.currentThread().getContextClassLoader().loadClass("jsweet.util.Lang").getDeclaredField("EXPORTED_VARS");
        }
        catch (ClassNotFoundException ex) {
            f = Thread.currentThread().getContextClassLoader().loadClass("jsweet.util.Globals").getDeclaredField("EXPORTED_VARS");
        }
        f.setAccessible(true);
        ThreadLocal exportedVars = (ThreadLocal)f.get(null);
        exportedVars.set(new HashMap());
    }

    private Map<String, Object> getExportedVarMap() throws Exception {
        Field f = null;
        try {
            f = Thread.currentThread().getContextClassLoader().loadClass("jsweet.util.Lang").getDeclaredField("EXPORTED_VARS");
        }
        catch (ClassNotFoundException ex) {
            f = Thread.currentThread().getContextClassLoader().loadClass("jsweet.util.Globals").getDeclaredField("EXPORTED_VARS");
        }
        f.setAccessible(true);
        ThreadLocal exportedVars = (ThreadLocal)f.get(null);
        return new HashMap<String, Object>((Map)exportedVars.get());
    }

    public EvaluationResult eval(String engineName, TranspilationHandler transpilationHandler, SourceFile ... sourceFiles) throws Exception {
        Process runProcess;
        logger.info((Object)("[" + engineName + " engine] eval files: " + Arrays.asList(sourceFiles)));
        if ("Java".equals(engineName)) {
            JSweetContext context = new JSweetContext(this);
            Options options = Options.instance(context);
            if (this.classPath != null) {
                options.put(Option.CLASSPATH, this.classPath);
            }
            options.put(Option.XLINT, "path");
            if (this.encoding != null) {
                options.put(Option.ENCODING, this.encoding);
            }
            JavacFileManager.preRegister(context);
            JavaFileManager fileManager = context.get(JavaFileManager.class);
            List<JavaFileObject> fileObjects = Util.toJavaFileObjects(fileManager, Arrays.asList(SourceFile.toFiles(sourceFiles)));
            JavaCompiler compiler = JavaCompiler.instance(context);
            compiler.attrParseOnly = true;
            compiler.verbose = true;
            compiler.genEndPos = false;
            compiler.encoding = this.encoding;
            this.log = Log.instance(context);
            this.log.dumpOnError = false;
            this.log.emitWarnings = false;
            logger.info((Object)("parsing: " + fileObjects));
            List<JCTree.JCCompilationUnit> compilationUnits = compiler.enterTrees(compiler.parseFiles(fileObjects));
            MainMethodFinder mainMethodFinder = new MainMethodFinder();
            try {
                for (JCTree.JCCompilationUnit cu : compilationUnits) {
                    cu.accept(mainMethodFinder);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mainMethodFinder.mainMethod != null) {
                try {
                    this.initExportedVarMap();
                    Class<?> c = Class.forName(((Symbol)mainMethodFinder.mainMethod.getEnclosingElement()).getQualifiedName().toString());
                    c.getMethod("main", String[].class).invoke(null, new Object[]{null});
                }
                catch (Exception e) {
                    throw new Exception("evalution error", e);
                }
            }
            final Map<String, Object> map = this.getExportedVarMap();
            return new EvaluationResult(){

                @Override
                public <T> T get(String variableName) {
                    return (T)map.get("_exportedVar_" + variableName);
                }

                public String toString() {
                    return map.toString();
                }

                @Override
                public String getExecutionTrace() {
                    return "<not available>";
                }
            };
        }
        if (!this.areAllTranspiled(sourceFiles)) {
            ErrorCountTranspilationHandler errorHandler = new ErrorCountTranspilationHandler(transpilationHandler);
            this.transpile((TranspilationHandler)errorHandler, sourceFiles);
            if (errorHandler.getErrorCount() > 0) {
                throw new Exception("unable to evaluate: transpilation errors remain");
            }
        }
        StringWriter trace = new StringWriter();
        if (this.context.useModules) {
            File f = null;
            if (!this.context.entryFiles.isEmpty()) {
                f = this.context.entryFiles.get(0);
                for (SourceFile sf : sourceFiles) {
                    if (!sf.getJavaFile().equals(f)) continue;
                    f = sf.getJsFile();
                }
            }
            if (f == null) {
                f = sourceFiles[sourceFiles.length - 1].getJsFile();
            }
            logger.info((Object)("[modules] eval file: " + f));
            runProcess = ProcessUtil.runCommand(ProcessUtil.NODE_COMMAND, line -> trace.append(line + "\n"), null, f.getPath());
        } else {
            File tmpFile = new File(this.workingDir, "eval.tmp.js");
            FileUtils.deleteQuietly((File)tmpFile);
            if (this.jsLibFiles != null) {
                for (File jsLibFile : this.jsLibFiles) {
                    String script = FileUtils.readFileToString((File)jsLibFile);
                    FileUtils.write((File)tmpFile, (CharSequence)(script + "\n"), (boolean)true);
                }
            }
            for (SourceFile sourceFile : sourceFiles) {
                String script = FileUtils.readFileToString((File)sourceFile.getJsFile());
                FileUtils.write((File)tmpFile, (CharSequence)(script + "\n"), (boolean)true);
            }
            logger.info((Object)("[no modules] eval file: " + tmpFile));
            runProcess = ProcessUtil.runCommand(ProcessUtil.NODE_COMMAND, line -> trace.append(line + "\n"), null, tmpFile.getPath());
        }
        int returnCode = runProcess.exitValue();
        logger.info((Object)("return code=" + returnCode));
        if (returnCode != 0) {
            throw new Exception("evaluation error (code=" + returnCode + ") - trace=" + trace);
        }
        return new TraceBasedEvaluationResult(trace.getBuffer().toString());
    }

    public List<JCTree.JCCompilationUnit> setupCompiler(java.util.List<File> files, ErrorCountTranspilationHandler transpilationHandler) throws IOException {
        this.initJavac(transpilationHandler);
        List<JavaFileObject> fileObjects = Util.toJavaFileObjects(this.fileManager, files);
        logger.info((Object)("parsing: " + fileObjects));
        transpilationHandler.setDisabled(this.isIgnoreJavaErrors());
        List<JCTree.JCCompilationUnit> compilationUnits = this.compiler.enterTrees(this.compiler.parseFiles(fileObjects));
        this.context.compilationUnits = compilationUnits.toArray(new JCTree.JCCompilationUnit[compilationUnits.size()]);
        if (transpilationHandler.getErrorCount() > 0) {
            logger.warn((Object)"errors during parse tree");
            return null;
        }
        logger.info((Object)"attribution phase");
        this.compiler.attribute(this.compiler.todo);
        transpilationHandler.setDisabled(false);
        if (transpilationHandler.getErrorCount() > 0) {
            return null;
        }
        if (!this.generateTsFiles) {
            return null;
        }
        this.context.useModules = this.isUsingModules();
        boolean bl = this.context.useRequireForModules = this.moduleKind != ModuleKind.es2015;
        if (this.context.useModules && this.bundle) {
            transpilationHandler.report(JSweetProblem.BUNDLE_WITH_MODULE, null, JSweetProblem.BUNDLE_WITH_MODULE.getMessage(new Object[0]));
            return null;
        }
        return compilationUnits;
    }

    private String ts2js(ErrorCountTranspilationHandler handler, String tsCode, String targetFileName) throws IOException {
        SourceFile sf = new SourceFile(null);
        sf.setTsFile(File.createTempFile(targetFileName, ".ts", this.tsOutputDir));
        sf.setJsFile(File.createTempFile(targetFileName, ".js", this.jsOutputDir));
        try {
            sf.tsFile.getParentFile().mkdirs();
            sf.tsFile.createNewFile();
            Files.write(sf.tsFile.toPath(), Arrays.asList(tsCode), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.runTSC(handler, new SourceFile[]{sf}, "--target", this.ecmaTargetVersion.name(), "--outFile", sf.getJsFile().toString(), sf.getTsFile().toString());
        try {
            return new String(Files.readAllBytes(sf.jsFile.toPath()));
        }
        catch (IOException ex) {
            return null;
        }
    }

    public synchronized void transpile(TranspilationHandler transpilationHandler, SourceFile ... files) throws IOException {
        this.transpilationStartTimestamp = System.currentTimeMillis();
        try {
            this.initNode(transpilationHandler);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        this.candiesProcessor.processCandies(transpilationHandler);
        this.addTsDefDir(this.candiesProcessor.getCandiesTsdefsDir());
        ErrorCountTranspilationHandler errorHandler = new ErrorCountTranspilationHandler(transpilationHandler);
        Collection jsweetSources = Arrays.asList(files).stream().filter(source -> source.getJavaFile() != null).collect(Collectors.toList());
        this.java2ts(errorHandler, jsweetSources.toArray(new SourceFile[0]));
        if (errorHandler.getErrorCount() == 0 && this.generateTsFiles && this.generateJsFiles) {
            Collection tsSources = Arrays.asList(files).stream().filter(source -> source.getTsFile() != null).collect(Collectors.toList());
            this.ts2js(errorHandler, tsSources.toArray(new SourceFile[0]));
        }
        if (!this.generateJsFiles || !this.generateTsFiles) {
            transpilationHandler.onCompleted(this, !this.isTscWatchMode(), files);
        }
        logger.info((Object)("transpilation process finished in " + (System.currentTimeMillis() - this.transpilationStartTimestamp) + " ms"));
    }

    private void java2ts(ErrorCountTranspilationHandler transpilationHandler, SourceFile[] files) throws IOException {
        List<JCTree.JCCompilationUnit> compilationUnits = this.setupCompiler(Arrays.asList(SourceFile.toFiles(files)), transpilationHandler);
        if (compilationUnits == null) {
            return;
        }
        if (this.candiesProcessor.hasDeprecatedCandy()) {
            this.context.deprecatedApply = true;
            logger.warn((Object)"\n\n\n*********************************************************************\n*********************************************************************\n YOUR CLASSPATH CONTAINS JSweet v1.x CANDIES \n This can lead to unexpected behaviors, please contribute to https://github.com/jsweet-candies \n to add your library's typings \n*********************************************************************\n*********************************************************************\n\n");
        }
        this.context.sourceFiles = files;
        this.factory.createBeforeTranslationScanner(transpilationHandler, this.context).process(compilationUnits);
        if (this.context.useModules) {
            this.generateTsFiles(transpilationHandler, files, compilationUnits);
        } else if (this.bundle) {
            this.generateTsBundle(transpilationHandler, files, compilationUnits);
        } else {
            this.generateTsFiles(transpilationHandler, files, compilationUnits);
        }
        this.log.flush();
        this.getOrCreateTscRootFile();
    }

    private void generateModuleDefs(JCTree.JCCompilationUnit moduleDefs) throws IOException {
        StringBuilder out = new StringBuilder();
        for (String line : FileUtils.readLines((File)new File(moduleDefs.getSourceFile().getName()))) {
            if (!line.startsWith("///")) continue;
            out.append(line.substring(3));
        }
        FileUtils.write((File)new File(this.tsOutputDir, "module_defs.d.ts"), (CharSequence)out, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTsFiles(ErrorCountTranspilationHandler transpilationHandler, SourceFile[] files, List<JCTree.JCCompilationUnit> compilationUnits) throws IOException {
        new OverloadScanner(transpilationHandler, this.context).process(compilationUnits);
        String[] headerLines = this.getHeaderLines();
        for (int i = 0; i < compilationUnits.length(); ++i) {
            JCTree.JCCompilationUnit cu = compilationUnits.get(i);
            if (this.isModuleDefsFile(cu)) {
                if (!this.context.useModules) continue;
                this.generateModuleDefs(cu);
                continue;
            }
            logger.info((Object)("scanning " + cu.sourcefile.getName() + "..."));
            Java2TypeScriptTranslator printer = this.factory.createTranslator(this.adapter, transpilationHandler, this.context, cu, this.generateSourceMaps);
            printer.print(cu);
            if (StringUtils.isWhitespace((CharSequence)printer.getResult())) continue;
            String[] s = cu.getSourceFile().getName().split(File.separator.equals("\\") ? "\\\\" : File.separator);
            String cuName = s[s.length - 1];
            s = cuName.split("\\.");
            cuName = s[0];
            String javaSourceFileRelativeFullName = cu.packge.getQualifiedName().toString().replace(".", File.separator) + File.separator + cuName + ".java";
            files[i].javaSourceDirRelativeFile = new File(javaSourceFileRelativeFullName);
            files[i].javaSourceDir = new File(cu.getSourceFile().getName().substring(0, cu.getSourceFile().getName().length() - javaSourceFileRelativeFullName.length()));
            String packageName = this.isNoRootDirectories() ? this.context.getRootRelativeJavaName(cu.packge) : cu.packge.getQualifiedName().toString();
            String outputFileRelativePathNoExt = packageName.replace(".", File.separator) + File.separator + cuName;
            String outputFileRelativePath = outputFileRelativePathNoExt + (cu.packge.fullname.toString().startsWith("def.") ? ".d.ts" : ".ts");
            logger.info((Object)("output file: " + outputFileRelativePath));
            File outputFile = new File(this.tsOutputDir, outputFileRelativePath);
            outputFile.getParentFile().mkdirs();
            String outputFilePath = outputFile.getPath();
            PrintWriter out = new PrintWriter(outputFilePath);
            String headers = this.context.poolHeaders();
            int headersLineCount = StringUtils.countMatches((CharSequence)headers, (CharSequence)"\n");
            try {
                for (String line : headerLines) {
                    out.println(line);
                }
                out.print(headers);
                out.println(printer.getResult());
                out.print(this.context.getGlobalsMappingString());
                out.print(this.context.poolFooterStatements());
            }
            finally {
                out.close();
            }
            files[i].tsFile = outputFile;
            files[i].javaFileLastTranspiled = files[i].getJavaFile().lastModified();
            printer.sourceMap.shiftOutputPositions(headerLines.length + headersLineCount);
            files[i].setSourceMap(printer.sourceMap);
            if (this.generateSourceMaps && !this.generateJsFiles) {
                this.generateTypeScriptSourceMapFile(files[i]);
            }
            logger.info((Object)("created " + outputFilePath));
        }
    }

    private void generateTypeScriptSourceMapFile(SourceFile sourceFile) throws IOException {
        if (sourceFile.getSourceMap() == null) {
            return;
        }
        SourceMapGenerator generator = SourceMapGeneratorFactory.getInstance((SourceMapFormat)SourceMapFormat.V3);
        String javaSourceFilePath = sourceFile.getTsFile().getAbsoluteFile().getCanonicalFile().getParentFile().toPath().relativize(sourceFile.getJavaFile().getAbsoluteFile().getCanonicalFile().toPath()).toString();
        for (SourceMap.Entry entry : sourceFile.getSourceMap().getSortedEntries(new Comparator<SourceMap.Entry>(){

            @Override
            public int compare(SourceMap.Entry e1, SourceMap.Entry e2) {
                return e1.getOutputPosition().compareTo(e2.getOutputPosition());
            }
        })) {
            generator.addMapping(javaSourceFilePath, null, new FilePosition(entry.getInputPosition().getLine(), entry.getInputPosition().getColumn()), new FilePosition(entry.getOutputPosition().getLine(), entry.getOutputPosition().getColumn()), new FilePosition(entry.getOutputPosition().getLine(), entry.getOutputPosition().getColumn() + 1));
        }
        File outputFile = new File(sourceFile.getTsFile().getPath() + ".map");
        try (FileWriter writer = new FileWriter(outputFile, false);){
            generator.appendTo((Appendable)writer, sourceFile.getTsFile().getName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean isModuleDefsFile(JCTree.JCCompilationUnit cu) {
        return cu.getSourceFile().getName().equals("module_defs.java") || cu.getSourceFile().getName().endsWith("/module_defs.java");
    }

    private void generateTsBundle(ErrorCountTranspilationHandler transpilationHandler, SourceFile[] files, List<JCTree.JCCompilationUnit> compilationUnits) throws IOException {
        if (this.context.useModules) {
            return;
        }
        StaticInitilializerAnalyzer analizer = new StaticInitilializerAnalyzer(this.context);
        analizer.process(compilationUnits);
        ArrayList sourcesInCycle = new ArrayList();
        java.util.List<JCTree.JCCompilationUnit> orderedCompilationUnits = analizer.globalStaticInitializersDependencies.topologicalSort(n -> sourcesInCycle.add(n));
        if (!sourcesInCycle.isEmpty()) {
            transpilationHandler.report(JSweetProblem.CYCLE_IN_STATIC_INITIALIZER_DEPENDENCIES, null, JSweetProblem.CYCLE_IN_STATIC_INITIALIZER_DEPENDENCIES.getMessage(sourcesInCycle.stream().map(n -> ((JCTree.JCCompilationUnit)n.element).sourcefile.getName()).collect(Collectors.toList())));
            DirectedGraph.dumpCycles(sourcesInCycle, u -> u.sourcefile.getName());
            return;
        }
        new OverloadScanner(transpilationHandler, this.context).process(orderedCompilationUnits);
        logger.debug((Object)("ordered compilation units: " + orderedCompilationUnits.stream().map(cu -> cu.sourcefile.getName()).collect(Collectors.toList())));
        logger.debug((Object)("count: " + compilationUnits.size() + " (initial), " + orderedCompilationUnits.size() + " (ordered)"));
        int[] permutation = new int[orderedCompilationUnits.size()];
        StringBuilder permutationString = new StringBuilder();
        for (int i = 0; i < orderedCompilationUnits.size(); ++i) {
            permutation[i] = compilationUnits.indexOf(orderedCompilationUnits.get(i));
            permutationString.append("" + i + "=" + permutation[i] + EXPORTED_VAR_END);
        }
        logger.debug((Object)("permutation: " + permutationString.toString()));
        this.createBundle(transpilationHandler, files, permutation, orderedCompilationUnits, false);
        if (this.isGenerateDefinitions()) {
            this.createBundle(transpilationHandler, files, permutation, orderedCompilationUnits, true);
        }
    }

    private void initSourceFileJavaPaths(SourceFile file, JCTree.JCCompilationUnit cu) {
        String[] s = cu.getSourceFile().getName().split(File.separator.equals("\\") ? "\\\\" : File.separator);
        String cuName = s[s.length - 1];
        s = cuName.split("\\.");
        cuName = s[0];
        String javaSourceFileRelativeFullName = cu.packge.getQualifiedName().toString().replace(".", File.separator) + File.separator + cuName + ".java";
        file.javaSourceDirRelativeFile = new File(javaSourceFileRelativeFullName);
        file.javaSourceDir = new File(cu.getSourceFile().getName().substring(0, cu.getSourceFile().getName().length() - javaSourceFileRelativeFullName.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBundle(ErrorCountTranspilationHandler transpilationHandler, SourceFile[] files, int[] permutation, java.util.List<JCTree.JCCompilationUnit> orderedCompilationUnits, boolean definitionBundle) throws FileNotFoundException {
        this.context.bundleMode = true;
        StringBuilder sb = new StringBuilder();
        int lineCount = 0;
        for (String line : this.getHeaderLines()) {
            sb.append(line).append("\n");
            ++lineCount;
        }
        for (int i = 0; i < orderedCompilationUnits.size(); ++i) {
            JCTree.JCCompilationUnit cu = orderedCompilationUnits.get(i);
            if (this.isModuleDefsFile(cu) || (cu.packge.fullname.toString().startsWith("def.") ? !definitionBundle : definitionBundle)) continue;
            logger.info((Object)("scanning " + cu.sourcefile.getName() + "..."));
            Java2TypeScriptTranslator printer = this.factory.createTranslator(this.adapter, transpilationHandler, this.context, cu, this.generateSourceMaps);
            printer.print(cu);
            printer.sourceMap.shiftOutputPositions(lineCount);
            files[permutation[i]].setSourceMap(printer.sourceMap);
            sb.append(printer.getOutput());
            lineCount += printer.getCurrentLine() - 1;
            this.initSourceFileJavaPaths(files[permutation[i]], cu);
        }
        this.context.bundleMode = false;
        File bundleDirectory = this.tsOutputDir;
        if (!bundleDirectory.exists()) {
            bundleDirectory.mkdirs();
        }
        String bundleName = "bundle" + (definitionBundle ? ".d.ts" : ".ts");
        File outputFile = new File(bundleDirectory, bundleName);
        logger.info((Object)("creating bundle file: " + outputFile));
        outputFile.getParentFile().mkdirs();
        String outputFilePath = outputFile.getPath();
        try (PrintWriter out = new PrintWriter(outputFilePath);){
            out.println(sb.toString());
            if (!definitionBundle) {
                out.print(this.context.getGlobalsMappingString());
            }
            out.print(this.context.poolFooterStatements());
            if (definitionBundle && this.context.getExportedElements() != null) {
                for (Map.Entry<String, java.util.List<Symbol>> exportedElements : this.context.getExportedElements().entrySet()) {
                    out.println();
                    out.print("declare module \"" + exportedElements.getKey() + "\"");
                    boolean exported = false;
                    for (Symbol element : exportedElements.getValue()) {
                        if (!(element instanceof Symbol.PackageSymbol) || this.context.isRootPackage(element)) continue;
                        out.print(" {");
                        out.println();
                        out.print("    export = " + this.context.getExportedElementName(element) + EXPORTED_VAR_END);
                        out.println();
                        out.print("}");
                        exported = true;
                        break;
                    }
                    if (!exported) {
                        out.print(EXPORTED_VAR_END);
                    }
                    out.println();
                }
            }
        }
        for (int i = 0; i < orderedCompilationUnits.size(); ++i) {
            JCTree.JCCompilationUnit cu = orderedCompilationUnits.get(i);
            if (cu.packge.fullname.toString().startsWith("def.") ? !definitionBundle : definitionBundle) continue;
            files[permutation[i]].tsFile = outputFile;
            files[permutation[i]].javaFileLastTranspiled = files[permutation[i]].getJavaFile().lastModified();
        }
        logger.info((Object)("created " + outputFilePath));
    }

    private File getOrCreateTscRootFile() throws IOException {
        File tscRootFile = new File(this.tsOutputDir, TSCROOTFILE);
        if (!tscRootFile.exists()) {
            FileUtils.write((File)tscRootFile, (CharSequence)"// Root empty file generated by JSweet to avoid tsc behavior, which\n// does not preserve the entire file hierarchy for empty directories.", (boolean)false);
        }
        return tscRootFile;
    }

    private static TscOutput parseTscOutput(String outputString) {
        Matcher m = errorRE.matcher(outputString);
        TscOutput error = new TscOutput();
        if (m.matches()) {
            String[] pos = m.group(2).split(",");
            error.position = new SourcePosition(new File(m.group(1)), null, Integer.parseInt(pos[0]), Integer.parseInt(pos[1]));
            StringBuilder sb = new StringBuilder(m.group(3));
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            if (sb.charAt(sb.length() - 1) == '.') {
                sb.deleteCharAt(sb.length() - 1);
            }
            error.message = sb.toString();
        } else {
            error.message = outputString;
        }
        return error;
    }

    private Path relativizeTsFile(File file) {
        try {
            return this.getTsOutputDir().getAbsoluteFile().getCanonicalFile().toPath().relativize(file.getAbsoluteFile().getCanonicalFile().toPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized SourceFile[] getWatchedFiles() {
        return this.watchedFiles;
    }

    public synchronized SourceFile getWatchedFile(File javaFile) {
        if (this.watchedFiles != null) {
            for (SourceFile f : this.watchedFiles) {
                if (!f.getJavaFile().getAbsoluteFile().equals(javaFile.getAbsoluteFile())) continue;
                return f;
            }
        }
        return null;
    }

    private void ts2js(ErrorCountTranspilationHandler transpilationHandler, SourceFile[] files) throws IOException {
        File tscRootFile;
        if (this.tsCompilationProcess != null && this.isTscWatchMode()) {
            return;
        }
        if (this.isTscWatchMode()) {
            this.watchedFiles = files;
        }
        logger.debug((Object)("ts2js: " + Arrays.asList(files)));
        LinkedList<String> args = new LinkedList<String>();
        if (System.getProperty("os.name").startsWith("Windows")) {
            args.addAll(Arrays.asList("--target", this.ecmaTargetVersion.name()));
        } else {
            args.addAll(Arrays.asList("--target", this.ecmaTargetVersion.name()));
        }
        if (this.isUsingModules()) {
            if (this.ecmaTargetVersion.higherThan(EcmaScriptComplianceLevel.ES5) && this.moduleKind != ModuleKind.es2015) {
                logger.warn((Object)"cannot use old fashionned modules with ES>5 target");
            } else {
                args.add("--module");
                args.add(this.moduleKind.toString());
            }
        }
        args.add("--moduleResolution");
        args.add(this.getModuleResolution().toString());
        if (this.ecmaTargetVersion.ordinal() >= EcmaScriptComplianceLevel.ES5.ordinal()) {
            args.add("--experimentalDecorators");
            args.add("--emitDecoratorMetadata");
        }
        if (this.isTscWatchMode()) {
            args.add("--watch");
        }
        if (this.isGenerateSourceMaps()) {
            args.add("--sourceMap");
        }
        if (this.isGenerateDeclarations()) {
            args.add("--declaration");
        }
        args.addAll(Arrays.asList("--rootDir", this.tsOutputDir.getAbsolutePath()));
        if (this.jsOutputDir != null) {
            args.addAll(Arrays.asList("--outDir", this.jsOutputDir.getAbsolutePath()));
        }
        if ((tscRootFile = this.getOrCreateTscRootFile()).exists()) {
            args.add(this.relativizeTsFile(tscRootFile).toString());
        }
        for (SourceFile sourceFile : files) {
            String filePath = this.relativizeTsFile(sourceFile.getTsFile()).toString();
            if (args.contains(filePath)) continue;
            args.add(filePath);
        }
        for (File f : this.auxiliaryTsModuleFiles) {
            String filePath = this.relativizeTsFile(f).toString();
            if (args.contains(filePath)) continue;
            args.add(filePath);
        }
        System.out.println(args);
        for (File dir : this.tsDefDirs) {
            LinkedList<File> tsDefFiles = new LinkedList<File>();
            Util.addFiles(".d.ts", dir, tsDefFiles);
            for (File f : tsDefFiles) {
                args.add(this.relativizeTsFile(f).toString());
            }
        }
        try {
            logger.info((Object)"launching tsc...");
            this.runTSC(transpilationHandler, files, args.toArray(new String[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runTSC(ErrorCountTranspilationHandler transpilationHandler, SourceFile[] files, String ... args) {
        boolean[] fullPass = new boolean[]{true};
        if (this.skipTypeScriptChecks) {
            args = (String[])ArrayUtils.addAll((Object[])args, (Object[])new String[]{"--skipDefaultLibCheck", "--skipLibCheck"});
        }
        this.tsCompilationProcess = ProcessUtil.runCommand("tsc", this.getTsOutputDir(), this.isTscWatchMode(), line -> {
            logger.info(line);
            TscOutput output = JSweetTranspiler.parseTscOutput(line);
            if (output.position != null) {
                if (this.isIgnoreTypeScriptErrors()) {
                    return;
                }
                SourcePosition position = SourceFile.findOriginPosition(output.position, Arrays.asList(files));
                if (position == null) {
                    transpilationHandler.report(JSweetProblem.INTERNAL_TSC_ERROR, output.position, output.message);
                } else {
                    transpilationHandler.report(JSweetProblem.MAPPED_TSC_ERROR, position, output.message);
                }
            } else if (output.message.startsWith("message TS6042:")) {
                this.onTsTranspilationCompleted(fullPass[0], transpilationHandler, files);
                fullPass[0] = false;
            }
        }, process -> {
            this.tsCompilationProcess = null;
            this.onTsTranspilationCompleted(fullPass[0], transpilationHandler, files);
            fullPass[0] = false;
        }, () -> {
            if (!this.ignoreTypeScriptErrors && transpilationHandler.getProblemCount() == 0) {
                transpilationHandler.report(JSweetProblem.INTERNAL_TSC_ERROR, null, "Unknown tsc error");
            }
        }, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTsTranspilationCompleted(boolean fullPass, ErrorCountTranspilationHandler handler, SourceFile[] files) {
        block29: {
            try {
                if (this.isGenerateDeclarations() && this.getDeclarationsOutputDir() != null) {
                    logger.info((Object)("moving d.ts files to " + this.getDeclarationsOutputDir()));
                    LinkedList<File> dtsFiles = new LinkedList<File>();
                    File rootDir = this.jsOutputDir == null ? this.tsOutputDir : this.jsOutputDir;
                    Util.addFiles(".d.ts", rootDir, dtsFiles);
                    for (File dtsFile : dtsFiles) {
                        String relativePath = Util.getRelativePath(rootDir.getAbsolutePath(), dtsFile.getAbsolutePath());
                        File targetFile = new File(this.getDeclarationsOutputDir(), relativePath);
                        logger.info((Object)("moving " + dtsFile + " to " + targetFile));
                        if (targetFile.exists()) {
                            FileUtils.deleteQuietly((File)targetFile);
                        }
                        try {
                            FileUtils.moveFile((File)dtsFile, (File)targetFile);
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (handler.getErrorCount() != 0) break block29;
                HashSet<File> handledFiles = new HashSet<File>();
                for (SourceFile sourceFile : files) {
                    File outputFile;
                    if (!sourceFile.getTsFile().getAbsolutePath().startsWith(this.tsOutputDir.getAbsolutePath())) {
                        throw new RuntimeException("ts directory isn't configured properly, please use setTsDir: " + sourceFile.getTsFile().getAbsolutePath() + " != " + this.tsOutputDir.getAbsolutePath());
                    }
                    String outputFileRelativePath = sourceFile.getTsFile().getAbsolutePath().substring(this.tsOutputDir.getAbsolutePath().length());
                    sourceFile.jsFile = outputFile = new File(this.jsOutputDir == null ? this.tsOutputDir : this.jsOutputDir, Util.removeExtension(outputFileRelativePath) + ".js");
                    if (outputFile.lastModified() <= sourceFile.jsFileLastTranspiled || handledFiles.contains(outputFile)) continue;
                    handledFiles.add(outputFile);
                    logger.info((Object)("js output file: " + outputFile));
                    File mapFile = new File(outputFile.getAbsolutePath() + ".map");
                    if (!mapFile.exists() || !this.generateSourceMaps) continue;
                    SourceMapGeneratorV3 generator = (SourceMapGeneratorV3)SourceMapGeneratorFactory.getInstance((SourceMapFormat)SourceMapFormat.V3);
                    Path javaSourcePath = sourceFile.javaSourceDir.getCanonicalFile().toPath();
                    String sourceRoot = this.getSourceRoot() != null ? this.getSourceRoot().toString() : sourceFile.getJsFile().getParentFile().getCanonicalFile().toPath().relativize(javaSourcePath) + "/";
                    generator.setSourceRoot(sourceRoot);
                    sourceFile.jsMapFile = mapFile;
                    logger.info((Object)("redirecting map file: " + mapFile));
                    String contents = FileUtils.readFileToString((File)mapFile);
                    SourceMapping mapping = SourceMapConsumerFactory.parse((String)contents);
                    int line = 1;
                    int columnIndex = 0;
                    for (String lineContent : FileUtils.readLines((File)outputFile, (Charset)null)) {
                        SourcePosition originPosition;
                        for (columnIndex = 0; columnIndex < lineContent.length() && (lineContent.charAt(columnIndex) == ' ' || lineContent.charAt(columnIndex) == '\t'); ++columnIndex) {
                        }
                        Mapping.OriginalMapping originalMapping = mapping.getMappingForLine(line, columnIndex + 1);
                        if (originalMapping != null && (originPosition = SourceFile.findOriginPosition(new SourcePosition(sourceFile.tsFile, null, new Position(originalMapping.getLineNumber(), originalMapping.getColumnPosition())), files)) != null) {
                            generator.addMapping(javaSourcePath.relativize(originPosition.getFile().getCanonicalFile().toPath()).toString(), null, new FilePosition(originPosition.getStartLine() - 1, 0), new FilePosition(line - 1, 0), new FilePosition(line - 1, lineContent.length() - 1));
                        }
                        ++line;
                    }
                    try (FileWriter writer = new FileWriter(mapFile, false);){
                        generator.appendTo((Appendable)writer, outputFile.getName());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                handler.onCompleted(this, fullPass, files);
            }
        }
    }

    @Override
    @Deprecated
    public boolean isPreserveSourceLineNumbers() {
        return this.generateSourceMaps;
    }

    @Override
    public boolean isGenerateSourceMaps() {
        return this.generateSourceMaps;
    }

    @Deprecated
    public void setPreserveSourceLineNumbers(boolean preserveSourceLineNumbers) {
        this.generateSourceMaps = preserveSourceLineNumbers;
    }

    public void setGenerateSourceMaps(boolean generateSourceMaps) {
        this.generateSourceMaps = generateSourceMaps;
    }

    @Override
    public File getTsOutputDir() {
        return this.tsOutputDir;
    }

    public void setTsOutputDir(File tsOutputDir) {
        this.tsOutputDir = tsOutputDir;
    }

    @Override
    public File getJsOutputDir() {
        return this.jsOutputDir;
    }

    public void setJsOutputDir(File jsOutputDir) {
        this.jsOutputDir = jsOutputDir;
    }

    @Override
    public boolean isGenerateJsFiles() {
        return this.generateJsFiles;
    }

    public void setGenerateJsFiles(boolean generateJsFiles) {
        this.generateJsFiles = generateJsFiles;
    }

    public synchronized boolean isTscWatchMode() {
        return this.tscWatchMode;
    }

    public synchronized void setTscWatchMode(boolean tscWatchMode) {
        this.tscWatchMode = tscWatchMode;
        if (!tscWatchMode && this.tsCompilationProcess != null) {
            this.tsCompilationProcess.destroyForcibly();
            while (this.tsCompilationProcess != null && this.tsCompilationProcess.isAlive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                logger.error((Object)"tsc did not terminate");
            }
            try {
                if (this.tsCompilationProcess != null) {
                    this.tsCompilationProcess.waitFor();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.tsCompilationProcess = null;
            this.watchedFiles = null;
        }
    }

    public synchronized void resetTscWatchMode() {
        this.setTscWatchMode(false);
        this.setTscWatchMode(true);
    }

    public CandyProcessor getCandiesProcessor() {
        return this.candiesProcessor;
    }

    public void setEcmaTargetVersion(EcmaScriptComplianceLevel ecmaTargetVersion) {
        this.ecmaTargetVersion = ecmaTargetVersion;
    }

    @Override
    public EcmaScriptComplianceLevel getEcmaTargetVersion() {
        return this.ecmaTargetVersion;
    }

    @Override
    public ModuleKind getModuleKind() {
        return this.moduleKind;
    }

    public void setModuleKind(ModuleKind moduleKind) {
        this.moduleKind = moduleKind;
    }

    @Override
    public ModuleResolution getModuleResolution() {
        return this.moduleResolution;
    }

    public void setModuleResolution(ModuleResolution moduleResolution) {
        this.moduleResolution = moduleResolution;
    }

    public void setSkipTypeScriptChecks(boolean skipTypeScriptChecks) {
        this.skipTypeScriptChecks = skipTypeScriptChecks;
    }

    public boolean isUsingModules() {
        return this.moduleKind != null && this.moduleKind != ModuleKind.none;
    }

    @Override
    public boolean isBundle() {
        return this.bundle;
    }

    public void setBundle(boolean bundle) {
        this.bundle = bundle;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public boolean isNoRootDirectories() {
        return this.noRootDirectories;
    }

    public void setNoRootDirectories(boolean noRootDirectories) {
        this.noRootDirectories = noRootDirectories;
    }

    @Override
    public boolean isIgnoreAssertions() {
        return this.ignoreAssertions;
    }

    public void setIgnoreAssertions(boolean ignoreAssertions) {
        this.ignoreAssertions = ignoreAssertions;
    }

    @Override
    public boolean isIgnoreJavaFileNameError() {
        return this.ignoreJavaFileNameError;
    }

    public void setIgnoreJavaFileNameError(boolean ignoreJavaFileNameError) {
        this.ignoreJavaFileNameError = ignoreJavaFileNameError;
    }

    @Override
    public boolean isGenerateDeclarations() {
        return this.generateDeclarations;
    }

    public void setGenerateDeclarations(boolean generateDeclarations) {
        this.generateDeclarations = generateDeclarations;
    }

    @Override
    public File getDeclarationsOutputDir() {
        return this.declarationsOutputDir;
    }

    public void setDeclarationsOutputDir(File declarationsOutputDir) {
        this.declarationsOutputDir = declarationsOutputDir;
    }

    @Override
    public File getExtractedCandyJavascriptDir() {
        return this.extractedCandyJavascriptDir;
    }

    public void addJsLibFiles(File ... files) {
        this.jsLibFiles.addAll(Arrays.asList(files));
    }

    public void clearJsLibFiles() {
        this.jsLibFiles.clear();
    }

    public String transpile(ErrorCountTranspilationHandler handler, JCTree tree, String targetFileName) throws IOException {
        Java2TypeScriptTranslator translator = this.factory.createTranslator(this.adapter, handler, this.context, null, false);
        translator.enterScope();
        translator.scan(tree);
        translator.exitScope();
        String tsCode = translator.getResult();
        return this.ts2js(handler, tsCode, targetFileName);
    }

    @Override
    public boolean isGenerateDefinitions() {
        return this.generateDefinitions;
    }

    public void setGenerateDefinitions(boolean generateDefinitions) {
        this.generateDefinitions = generateDefinitions;
    }

    @Override
    public File getSourceRoot() {
        return this.sourceRoot;
    }

    public void setSourceRoot(File sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isIgnoreTypeScriptErrors() {
        return this.ignoreTypeScriptErrors;
    }

    public void setIgnoreTypeScriptErrors(boolean ignoreTypeScriptErrors) {
        this.ignoreTypeScriptErrors = ignoreTypeScriptErrors;
    }

    @Override
    public File getHeaderFile() {
        return this.headerFile;
    }

    public void setHeaderFile(File headerFile) {
        this.headerFile = headerFile;
    }

    private String[] getHeaderLines() {
        Object[] headerLines = null;
        if (this.getHeaderFile() != null) {
            try {
                headerLines = FileUtils.readLines((File)this.getHeaderFile(), (String)this.getEncoding()).toArray(new String[0]);
            }
            catch (Exception e) {
                logger.error((Object)("cannot read header file: " + this.getHeaderFile() + " - using default header"));
            }
        }
        if (headerLines == null) {
            headerLines = new String[]{"/* Generated from Java with JSweet " + JSweetConfig.getVersionNumber() + " - http://www.jsweet.org */"};
        }
        if (this.context.options.isDebugMode()) {
            headerLines = (String[])ArrayUtils.add(headerLines, (Object)"declare function __debug_exec(className, functionName, argNames, target, args, generator);");
            headerLines = (String[])ArrayUtils.add((Object[])headerLines, (Object)"declare function __debug_result(expression);");
        }
        return headerLines;
    }

    @Override
    public boolean isGenerateTsFiles() {
        return this.generateTsFiles;
    }

    public void setGenerateTsFiles(boolean generateTsFiles) {
        this.generateTsFiles = generateTsFiles;
    }

    @Override
    public boolean isIgnoreJavaErrors() {
        return this.ignoreJavaErrors;
    }

    public void setIgnoreJavaErrors(boolean ignoreJavaErrors) {
        this.ignoreJavaErrors = ignoreJavaErrors;
    }

    public JSweetContext getContext() {
        return this.context;
    }

    public Options getOptions() {
        return this.options;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    public boolean isVerbose() {
        return LogManager.getLogger((String)"org.jsweet").getLevel() == Level.ALL;
    }

    public void setVerbose(boolean verbose) {
        LogManager.getLogger((String)"org.jsweet").setLevel(Level.ALL);
    }

    @Override
    public boolean isDisableSinglePrecisionFloats() {
        return this.disableSingleFloatPrecision;
    }

    public void setDisableSinglePrecisionFloats(boolean disableSinglePrecisionFloats) {
        this.disableSingleFloatPrecision = disableSinglePrecisionFloats;
    }

    @Override
    public java.util.List<String> getAdapters() {
        return this.adapters;
    }

    public void setAdapters(java.util.List<String> adapters) {
        this.adapters = new ArrayList<String>(adapters);
    }

    @Override
    public File getConfigurationFile() {
        return this.configurationFile;
    }

    static {
        JSweetConfig.initClassPath(null);
        exportedVarRE = Pattern.compile("EXPORT (\\w*)=(.*);");
        logger = Logger.getLogger(JSweetTranspiler.class);
        errorRE = Pattern.compile("(.*)\\((.*)\\): error TS[0-9]+: (.*)");
    }

    private static class TscOutput {
        public SourcePosition position;
        public String message;

        private TscOutput() {
        }

        public String toString() {
            return this.message + " - " + this.position;
        }
    }

    private static class TraceBasedEvaluationResult
    implements EvaluationResult {
        private String trace;

        public TraceBasedEvaluationResult(String trace) {
            this.trace = trace;
        }

        @Override
        public <T> T get(String variableName) {
            String[] var = null;
            Matcher matcher = exportedVarRE.matcher(this.trace);
            int index = 0;
            boolean match = true;
            while (match) {
                match = matcher.find(index);
                if (!match) continue;
                if (variableName.equals(matcher.group(1))) {
                    var = new String[]{matcher.group(1), matcher.group(2)};
                    match = false;
                }
                index = matcher.end() - 1;
            }
            if (var == null) {
                return null;
            }
            void stringValue = var[1];
            try {
                return (T)Integer.valueOf(Integer.parseInt((String)stringValue));
            }
            catch (Exception e1) {
                try {
                    return (T)Double.valueOf(Double.parseDouble((String)stringValue));
                }
                catch (Exception e2) {
                    if ("true".equals(stringValue)) {
                        return (T)Boolean.TRUE;
                    }
                    if ("false".equals(stringValue)) {
                        return (T)Boolean.FALSE;
                    }
                    if ("undefined".equals(stringValue)) {
                        return null;
                    }
                    return stringValue;
                }
            }
        }

        @Override
        public String getExecutionTrace() {
            return this.trace;
        }
    }

    private static class MainMethodFinder
    extends TreeScanner {
        public Symbol.MethodSymbol mainMethod;

        private MainMethodFinder() {
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl methodDecl) {
            Symbol.MethodSymbol method = methodDecl.sym;
            if ("main(java.lang.String[])".equals(method.toString()) && method.isStatic()) {
                this.mainMethod = method;
                throw new RuntimeException();
            }
        }
    }
}

