/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import org.jsweet.transpiler.Severity;

public enum JSweetProblem {
    USER_ERROR(Severity.ERROR),
    USER_WARNING(Severity.WARNING),
    USER_MESSAGE(Severity.MESSAGE),
    JAVA_COMPILER_NOT_FOUND(Severity.ERROR),
    INTERNAL_JAVA_ERROR(Severity.ERROR),
    INTERNAL_TRANSPILER_ERROR(Severity.ERROR),
    INTERNAL_TSC_ERROR(Severity.ERROR),
    MAPPED_TSC_ERROR(Severity.ERROR),
    TSC_CANNOT_START(Severity.ERROR),
    NODE_CANNOT_START(Severity.ERROR),
    NODE_OBSOLETE_VERSION(Severity.WARNING),
    JDK_TYPE(Severity.ERROR),
    JDK_METHOD(Severity.ERROR),
    ERASED_METHOD(Severity.ERROR),
    SYNCHRONIZATION(Severity.WARNING),
    METHOD_CONFLICTS_FIELD(Severity.ERROR),
    FIELD_CONFLICTS_METHOD(Severity.ERROR),
    HIDDEN_INVOCATION(Severity.ERROR),
    INNER_CLASS(Severity.ERROR),
    INVALID_INITIALIZER_STATEMENT(Severity.ERROR),
    UNINITIALIZED_FIELD(Severity.ERROR),
    USELESS_OPTIONAL_ANNOTATION(Severity.WARNING),
    JS_KEYWORD_CONFLICT(Severity.WARNING),
    INVALID_PRIVATE_IN_INTERFACE(Severity.ERROR),
    INVALID_METHOD_BODY_IN_INTERFACE(Severity.ERROR),
    INVALID_FIELD_INITIALIZER_IN_INTERFACE(Severity.ERROR),
    INVALID_INITIALIZER_IN_INTERFACE(Severity.ERROR),
    INVALID_OVERLOAD(Severity.ERROR),
    INVALID_OVERLOAD_PARAMETER(Severity.ERROR),
    CONSTRUCTOR_MEMBER(Severity.ERROR),
    NATIVE_MODIFIER_IS_NOT_ALLOWED(Severity.ERROR),
    TRY_WITHOUT_CATCH_OR_FINALLY(Severity.ERROR),
    TRY_WITH_MULTIPLE_CATCHES(Severity.ERROR),
    UNSUPPORTED_TRY_WITH_RESOURCE(Severity.ERROR),
    GLOBAL_INDEXER_SET(Severity.ERROR),
    GLOBAL_INDEXER_GET(Severity.ERROR),
    GLOBAL_DELETE(Severity.ERROR),
    GLOBAL_CONSTRUCTOR_DEF(Severity.ERROR),
    GLOBAL_CANNOT_BE_INSTANTIATED(Severity.ERROR),
    STRING_LITERAL_EXPECTED(Severity.ERROR),
    INVALID_FIELD_IN_ENUM(Severity.ERROR),
    INVALID_CONSTRUCTOR_IN_ENUM(Severity.ERROR),
    INVALID_METHOD_IN_ENUM(Severity.ERROR),
    INVALID_METHOD_BODY_IN_AMBIENT(Severity.ERROR),
    INVALID_NON_EMPTY_CONSTRUCTOR_IN_AMBIENT(Severity.ERROR),
    INVALID_MODIFIER_IN_AMBIENT(Severity.ERROR),
    WRONG_USE_OF_AMBIENT(Severity.WARNING),
    INDEXED_SET_TYPE_MISMATCH(Severity.ERROR),
    UNION_TYPE_MISMATCH(Severity.ERROR),
    BUNDLE_WITH_MODULE(Severity.ERROR),
    PACKAGE_NAME_CONTAINS_KEYWORD(Severity.ERROR),
    WILDCARD_IMPORT(Severity.ERROR),
    ENCLOSED_ROOT_PACKAGES(Severity.ERROR),
    CLASS_OUT_OF_ROOT_PACKAGE_SCOPE(Severity.ERROR),
    MULTIPLE_ROOT_PACKAGES_NOT_ALLOWED_WITH_MODULES(Severity.ERROR),
    CANDY_VERSION_DISCREPANCY(Severity.WARNING),
    GLOBALS_CAN_ONLY_HAVE_STATIC_MEMBERS(Severity.ERROR),
    GLOBALS_CLASS_CANNOT_HAVE_SUPERCLASS(Severity.ERROR),
    GLOBALS_CLASS_CANNOT_BE_SUBCLASSED(Severity.ERROR),
    CANNOT_ACCESS_THIS(Severity.ERROR),
    CANNOT_ACCESS_STATIC_MEMBER_ON_THIS(Severity.ERROR),
    UNTYPED_OBJECT_ODD_PARAMETER_COUNT(Severity.ERROR),
    UNTYPED_OBJECT_WRONG_KEY(Severity.ERROR),
    CYCLE_IN_STATIC_INITIALIZER_DEPENDENCIES(Severity.ERROR),
    MISUSED_INSERT_MACRO(Severity.ERROR),
    MISUSED_TEMPLATE_MACRO(Severity.ERROR),
    WRONG_MIXIN_NAME(Severity.ERROR),
    SELF_MIXIN_TARGET(Severity.ERROR),
    CANNOT_FIND_GLOBAL_DECORATOR_FUNCTION(Severity.ERROR);

    private Severity severity;

    public Severity getSeverity() {
        return this.severity;
    }

    private JSweetProblem(Severity severity) {
        this.severity = severity;
    }

    public String getMessage(Object ... params) {
        switch (this) {
            case USER_ERROR: 
            case USER_WARNING: 
            case USER_MESSAGE: {
                return String.format("%s", params);
            }
            case JAVA_COMPILER_NOT_FOUND: {
                return String.format("Java compiler cannot be found: make sure that JAVA_HOME points to a JDK (version>=8) and not a JRE, or sets the transpiler jdkHome option", params);
            }
            case INTERNAL_JAVA_ERROR: {
                return String.format("%s", params);
            }
            case INTERNAL_TSC_ERROR: {
                return String.format("internal TypeScript error: %s", params);
            }
            case MAPPED_TSC_ERROR: {
                return String.format("%s", params);
            }
            case NODE_CANNOT_START: {
                return String.format("cannot find Node.js: install first and make sure that the 'node' command is in your execution path", params);
            }
            case NODE_OBSOLETE_VERSION: {
                return String.format("Node.js should be upgraded: %s < %s (recommended)", params);
            }
            case TSC_CANNOT_START: {
                return String.format("cannot find TypeScript compiler: install first and make sure that the 'tsc' command is in your execution path", params);
            }
            case JDK_TYPE: {
                return String.format("invalid access to JDK type '%s' from JSweet", params);
            }
            case JDK_METHOD: {
                return String.format("invalid access to JDK method '%s' from JSweet", params);
            }
            case ERASED_METHOD: {
                return String.format("invalid access to erased method '%s'", params);
            }
            case SYNCHRONIZATION: {
                return String.format("synchronization is ignored in JSweet", params);
            }
            case METHOD_CONFLICTS_FIELD: {
                return String.format("method '%s' has the same name as a field in '%s'", params);
            }
            case HIDDEN_INVOCATION: {
                return String.format("invocation of '%s' is hidden by a local variable", params);
            }
            case FIELD_CONFLICTS_METHOD: {
                return String.format("field '%s' has the same name as a method in '%s'", params);
            }
            case INNER_CLASS: {
                return String.format("inner classes are not allowed in JSweet: '%s'", params);
            }
            case INVALID_INITIALIZER_STATEMENT: {
                return String.format("invalid initializer statement; only field assignments are allowed", params);
            }
            case UNINITIALIZED_FIELD: {
                return String.format("field '%s' is not optional (see @Optional) but has not been initialized", params);
            }
            case USELESS_OPTIONAL_ANNOTATION: {
                return String.format("useless @Optional field %s (fields are optional by default in classes, use @Interface to define %s as an interface)", params);
            }
            case JS_KEYWORD_CONFLICT: {
                return String.format("local variable name '%s' is not allowed and is automatically generated to '__%s'", params);
            }
            case INVALID_METHOD_BODY_IN_INTERFACE: {
                return String.format("method '%s' cannot define a body in interface '%s' (try 'abstract' or 'native' modifiers)", params);
            }
            case INVALID_PRIVATE_IN_INTERFACE: {
                return String.format("member '%s' cannot be private in interface '%s'", params);
            }
            case INVALID_FIELD_INITIALIZER_IN_INTERFACE: {
                return String.format("field '%s' cannot be initialized in interface '%s'", params);
            }
            case INVALID_INITIALIZER_IN_INTERFACE: {
                return String.format("no initialization blocks are allowed in interface '%s'", params);
            }
            case INVALID_OVERLOAD: {
                return String.format("invalid overload of method '%s'", params);
            }
            case INVALID_OVERLOAD_PARAMETER: {
                return String.format("overloaded methods can only be invoked with literal parameters (constants)", params);
            }
            case CONSTRUCTOR_MEMBER: {
                return String.format("invalid member name 'constructor'", params);
            }
            case NATIVE_MODIFIER_IS_NOT_ALLOWED: {
                return String.format("method '%s' cannot be native", params);
            }
            case TRY_WITHOUT_CATCH_OR_FINALLY: {
                return String.format("try statement must define at least a catch or a finally clause", params);
            }
            case UNSUPPORTED_TRY_WITH_RESOURCE: {
                return String.format("try-with-resource statement is not supported", params);
            }
            case TRY_WITH_MULTIPLE_CATCHES: {
                return String.format("try statement cannot define more than one catch clause", params);
            }
            case GLOBAL_INDEXER_GET: {
                return String.format("indexer cannot be used in a global context", params);
            }
            case GLOBAL_INDEXER_SET: {
                return String.format("indexer cannot be used in a global context", params);
            }
            case GLOBAL_DELETE: {
                return String.format("static delete cannot be used in a global context", params);
            }
            case STRING_LITERAL_EXPECTED: {
                return String.format("string literal expected", params);
            }
            case GLOBAL_CONSTRUCTOR_DEF: {
                return String.format("global class cannot have constructor", params);
            }
            case GLOBAL_CANNOT_BE_INSTANTIATED: {
                return String.format("global classes cannot be instantiated", params);
            }
            case INVALID_CONSTRUCTOR_IN_ENUM: {
                return String.format("constructors are not allowed in enums", params);
            }
            case INVALID_FIELD_IN_ENUM: {
                return String.format("fields are not allowed in enums", params);
            }
            case INVALID_METHOD_IN_ENUM: {
                return String.format("methods are not allowed in enums", params);
            }
            case INVALID_METHOD_BODY_IN_AMBIENT: {
                return String.format("method '%s' is an ambiant declaration and cannot define an implementation", params);
            }
            case INVALID_NON_EMPTY_CONSTRUCTOR_IN_AMBIENT: {
                return String.format("constructor is an ambiant declaration and must have an empty body", params);
            }
            case INVALID_MODIFIER_IN_AMBIENT: {
                return String.format("modifier '%s' is not allowed in an ambiant declaration", params);
            }
            case INDEXED_SET_TYPE_MISMATCH: {
                return String.format("type mismatch, expecting '%s' (inferred from the indexed getter type)", params);
            }
            case UNION_TYPE_MISMATCH: {
                return String.format("type mismatch in union type", params);
            }
            case BUNDLE_WITH_MODULE: {
                return String.format("bundle and module options are exclusive: choose one or the other", params);
            }
            case PACKAGE_NAME_CONTAINS_KEYWORD: {
                return String.format("a package name cannot contain top-level keyword(s): '%s'", params);
            }
            case WILDCARD_IMPORT: {
                return String.format("imports cannot use * wildcards when using modules: please import a specific element", params);
            }
            case ENCLOSED_ROOT_PACKAGES: {
                return String.format("invalid package hierarchy: @Root package '%s' cannot be enclosed in @Root package '%s'", params);
            }
            case MULTIPLE_ROOT_PACKAGES_NOT_ALLOWED_WITH_MODULES: {
                return String.format("multipe @Root packages (including the default 'null' package) are not allowed when using modules, found packages: %s", params);
            }
            case CLASS_OUT_OF_ROOT_PACKAGE_SCOPE: {
                return String.format("invalid package hierarchy: type '%s' is declared in a parent of @Root package '%s'", params);
            }
            case WRONG_USE_OF_AMBIENT: {
                return String.format("wrong use of @Ambient on '%s': only types and globals can be declared as ambients", params);
            }
            case CANDY_VERSION_DISCREPANCY: {
                return String.format("candy %s:%s was generated for a different version of the transpiler (current:%s, candy:%s)", params);
            }
            case GLOBALS_CAN_ONLY_HAVE_STATIC_MEMBERS: {
                return String.format("globals classes can only define static members", params);
            }
            case GLOBALS_CLASS_CANNOT_HAVE_SUPERCLASS: {
                return String.format("globals classes cannot extend any class", params);
            }
            case GLOBALS_CLASS_CANNOT_BE_SUBCLASSED: {
                return String.format("globals classes cannot be subclassed", params);
            }
            case CANNOT_ACCESS_THIS: {
                return String.format("'this' isn't defined in scope of '%s'", params);
            }
            case CANNOT_ACCESS_STATIC_MEMBER_ON_THIS: {
                return String.format("member '%s' is static and cannot be accessed on 'this'", params);
            }
            case UNTYPED_OBJECT_ODD_PARAMETER_COUNT: {
                return String.format("wrong parameter count: method '$object' expects a list of key/value pairs as parameters", params);
            }
            case UNTYPED_OBJECT_WRONG_KEY: {
                return String.format("wrong key: method '$object' expects a list of key/value pairs as parameters, where keys are string literals", params);
            }
            case CYCLE_IN_STATIC_INITIALIZER_DEPENDENCIES: {
                return String.format("a cycle was detected in static intializers involving '%s'", params);
            }
            case INTERNAL_TRANSPILER_ERROR: {
                return String.format("internal transpiler error", new Object[0]);
            }
            case MISUSED_INSERT_MACRO: {
                return String.format("the '%s' macro argument must be a raw string literal", params);
            }
            case MISUSED_TEMPLATE_MACRO: {
                return String.format("the '%s' macro last argument must be a raw string literal", params);
            }
            case WRONG_MIXIN_NAME: {
                return String.format("the '%s' mixin must have the same root-relative name as its target ('%s')", params);
            }
            case SELF_MIXIN_TARGET: {
                return String.format("the '%s' mixin targets itself but should target another interface/declaration of the same name", params);
            }
            case CANNOT_FIND_GLOBAL_DECORATOR_FUNCTION: {
                return String.format("the '%s' decorator annotation should be implemented in a global function of the same name, but this function cannot be found", params);
            }
        }
        return null;
    }
}

