/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.File;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.JSweetOptions;
import org.jsweet.transpiler.Java2TypeScriptTranslator;
import org.jsweet.transpiler.OverloadScanner;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.extension.AnnotationManager;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.util.DirectedGraph;
import org.jsweet.transpiler.util.Util;

public class JSweetContext
extends Context {
    protected static Logger logger = Logger.getLogger(Java2TypeScriptTranslator.class);
    private Map<String, TypeMirror> jdkSubclasses = new HashMap<String, TypeMirror>();
    private java.util.List<AnnotationManager> annotationManagers = new ArrayList<AnnotationManager>();
    private Map<String, String> typesMapping = new HashMap<String, String>();
    private java.util.List<BiFunction<ExtendedElement, String, Object>> complexTypesMapping = new ArrayList<BiFunction<ExtendedElement, String, Object>>();
    protected Map<String, String> langTypesMapping = new HashMap<String, String>();
    protected Set<String> langTypesSimpleNames = new HashSet<String>();
    protected Set<String> baseThrowables = new HashSet<String>();
    private Map<String, JCTree[]> globalMethods = new HashMap<String, JCTree[]>();
    private Map<String, JCTree.JCClassDecl> decoratorAnnotations = new HashMap<String, JCTree.JCClassDecl>();
    private Pattern annotationWithParameterPattern = Pattern.compile("@([^(]*)\\((.*)\\)");
    private Map<String, Collection<AnnotationFilterDescriptor>> annotationFilters = new HashMap<String, Collection<AnnotationFilterDescriptor>>();
    private boolean usingJavaRuntime = false;
    public final JSweetOptions options;
    private Map<Symbol.ClassSymbol, Map<String, OverloadScanner.Overload>> overloads = new HashMap<Symbol.ClassSymbol, Map<String, OverloadScanner.Overload>>();
    private Map<Symbol.ClassSymbol, Map<String, OverloadScanner.Overload>> staticOverloads = new HashMap<Symbol.ClassSymbol, Map<String, OverloadScanner.Overload>>();
    public Set<Symbol.ClassSymbol> classesWithWrongConstructorOverload = new HashSet<Symbol.ClassSymbol>();
    public Symtab symtab;
    public Names names;
    public com.sun.tools.javac.code.Types types;
    public Types modelTypes;
    public boolean useModules = false;
    public boolean useRequireForModules = true;
    public SourceFile[] sourceFiles;
    public JCTree.JCCompilationUnit[] compilationUnits;
    private java.util.List<String> usedModules = new ArrayList<String>();
    public boolean bundleMode = false;
    public Set<Symbol.VarSymbol> lazyInitializedStatics = new HashSet<Symbol.VarSymbol>();
    private Map<Symbol.ClassSymbol, Integer> staticInitializerCounts = new HashMap<Symbol.ClassSymbol, Integer>();
    private Map<String, Set<String>> importedNamesInModules = new HashMap<String, Set<String>>();
    private Map<String, Map<Symbol, String>> importedElementsInModules = new HashMap<String, Map<Symbol, String>>();
    private Map<String, java.util.List<Symbol>> exportedElements = new HashMap<String, java.util.List<Symbol>>();
    private Map<Symbol, String> exportedNames = new HashMap<Symbol, String>();
    public java.util.List<File> entryFiles = new ArrayList<File>();
    public DirectedGraph<Symbol.PackageSymbol> packageDependencies = new DirectedGraph();
    public Set<String> topLevelPackageNames = new HashSet<String>();
    public HashSet<Symbol.PackageSymbol> rootPackages = new HashSet();
    public boolean reportedMultipleRootPackages = false;
    public Set<String> globalImports = new HashSet<String>();
    public Set<String> importedTopPackages = new HashSet<String>();
    public boolean strictMode = false;
    public boolean deprecatedApply = false;
    private java.util.List<String> footerStatements = new LinkedList<String>();
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private Map<String, String> globalsMapping = new HashMap<String, String>();
    private Map<Symbol.TypeSymbol, Set<Map.Entry<JCTree.JCClassDecl, JCTree.JCMethodDecl>>> defaultMethods = new HashMap<Symbol.TypeSymbol, Set<Map.Entry<JCTree.JCClassDecl, JCTree.JCMethodDecl>>>();
    private Map<JCTree.JCMethodDecl, JCTree.JCCompilationUnit> defaultMethodsCompilationUnits = new HashMap<JCTree.JCMethodDecl, JCTree.JCCompilationUnit>();
    private Map<Symbol.VarSymbol, String> fieldNameMapping = new HashMap<Symbol.VarSymbol, String>();
    private Map<Symbol.ClassSymbol, String> classNameMapping = new HashMap<Symbol.ClassSymbol, String>();
    public boolean ignoreWildcardBounds = true;
    private Map<JCTree.JCWildcard, String> wildcardNames = new HashMap<JCTree.JCWildcard, String>();
    private Map<Symbol, java.util.List<JCTree.JCWildcard>> wildcards = new HashMap<Symbol, java.util.List<JCTree.JCWildcard>>();
    private static Pattern libPackagePattern = Pattern.compile("def\\.[^.]*");
    public Map<Element, String> docComments = new HashMap<Element, String>();

    public void addJdkSubclass(String subclassName, TypeMirror extendedJdkClass) {
        this.jdkSubclasses.put(subclassName, extendedJdkClass);
    }

    public Map<String, TypeMirror> getJdkSubclasses() {
        return this.jdkSubclasses;
    }

    public TypeMirror getJdkSuperclass(String subclassName, Set<String> excludedJdkTypes) {
        TypeMirror jdkType = this.jdkSubclasses.get(subclassName);
        if (jdkType == null) {
            return null;
        }
        if (!excludedJdkTypes.contains(jdkType.toString())) {
            return jdkType;
        }
        return null;
    }

    public void registerGlobalMethod(JCTree.JCClassDecl owner, JCTree.JCMethodDecl method) {
        String name = ((Symbol)method.sym.getEnclosingElement()).getQualifiedName().toString();
        name = name + "." + method.name;
        name = name.replace("Globals.", "");
        this.globalMethods.put(name, new JCTree[]{owner, method});
    }

    public JCTree[] lookupGlobalMethod(String fullyQualifiedName) {
        return this.globalMethods.get(fullyQualifiedName);
    }

    public void registerDecoratorAnnotation(JCTree.JCClassDecl annotationDeclaration) {
        this.decoratorAnnotations.put(annotationDeclaration.sym.getQualifiedName().toString(), annotationDeclaration);
    }

    public JCTree.JCClassDecl lookupDecoratorAnnotation(String fullyQualifiedName) {
        return this.decoratorAnnotations.get(fullyQualifiedName);
    }

    public final void addTypeMapping(String sourceTypeName, String targetTypeName) {
        this.typesMapping.put(sourceTypeName, targetTypeName);
    }

    public final void addTypeMappings(Map<String, String> nameMappings) {
        this.typesMapping.putAll(nameMappings);
    }

    public final boolean isMappedType(String sourceTypeName) {
        return this.typesMapping.containsKey(sourceTypeName);
    }

    public final String getTypeMappingTarget(String sourceTypeName) {
        return this.typesMapping.get(sourceTypeName);
    }

    public final void addTypeMapping(BiFunction<ExtendedElement, String, Object> mappingFunction) {
        this.complexTypesMapping.add(mappingFunction);
    }

    public final java.util.List<BiFunction<ExtendedElement, String, Object>> getFunctionalTypeMappings() {
        return this.complexTypesMapping;
    }

    public final void addAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManagers.add(annotationManager);
    }

    public final void removeAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManagers.remove(annotationManager);
    }

    private static boolean testStringAt(StringBuilder sb, int i, String string) {
        if (i < 0) {
            return false;
        }
        if (i + string.length() > sb.length()) {
            return false;
        }
        return sb.subSequence(i, i + string.length()).equals(string);
    }

    private static String toRegexp(String pattern) {
        boolean argsEnv = false;
        StringBuilder sb = new StringBuilder(pattern);
        block6: for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            switch (c) {
                case '(': {
                    argsEnv = true;
                    sb.insert(i++, '\\');
                    continue block6;
                }
                case ')': {
                    argsEnv = false;
                    sb.insert(i++, '\\');
                    continue block6;
                }
                case '.': {
                    if (JSweetContext.testStringAt(sb, i + 1, ".")) {
                        sb.deleteCharAt(i);
                        sb.deleteCharAt(i);
                        sb.insert(i++, ".*");
                        continue block6;
                    }
                    sb.insert(i++, '\\');
                    continue block6;
                }
                case '*': {
                    if (JSweetContext.testStringAt(sb, i + 1, "*")) {
                        sb.deleteCharAt(i);
                        sb.deleteCharAt(i);
                        sb.insert(i++, ".*");
                        continue block6;
                    }
                    sb.deleteCharAt(i);
                    if (argsEnv) {
                        sb.insert(i, "[^,]*");
                        i += 4;
                        continue block6;
                    }
                    sb.insert(i, "[^.]*");
                    i += 4;
                }
            }
        }
        return sb.toString();
    }

    private Collection<AnnotationFilterDescriptor> getAnnotationFilterDescriptors(String annotationType) {
        Collection<AnnotationFilterDescriptor> descrs = this.annotationFilters.get(annotationType);
        if (descrs == null) {
            descrs = new ArrayList<AnnotationFilterDescriptor>();
            this.annotationFilters.put(annotationType, descrs);
        }
        return descrs;
    }

    private boolean hasAnnotationFilters() {
        return !this.annotationFilters.isEmpty();
    }

    public JSweetContext(JSweetOptions options) {
        this.options = options;
        if (options.getConfiguration() != null) {
            for (Map.Entry<String, Object> entry : options.getConfiguration().entrySet()) {
                this.addConfigurationEntry(entry);
            }
        }
        for (Map.Entry<String, Object> entry : this.annotationFilters.entrySet()) {
            logger.info((Object)("annotation filter descriptor: " + entry));
        }
    }

    public final void addAnnotation(Class<? extends Annotation> annotationType, String ... filters) {
        this.addAnnotation(annotationType.getName(), filters);
    }

    public final void addAnnotationWithValue(Class<? extends Annotation> annotationType, Object value, String ... filters) {
        this.addAnnotation(annotationType.getName() + "('" + value.toString() + "')", filters);
    }

    public final void addAnnotation(String annotationDescriptor, String ... filters) {
        if (!annotationDescriptor.startsWith("@")) {
            annotationDescriptor = "@" + annotationDescriptor;
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        AbstractMap.SimpleEntry<String, Object> entry = new AbstractMap.SimpleEntry<String, Object>(annotationDescriptor, map);
        for (String filter : filters) {
            String listKind = filter.startsWith("!") ? "exclude" : "include";
            ArrayList<String> list = (ArrayList<String>)map.get(listKind);
            if (list == null) {
                list = new ArrayList<String>();
                map.put(listKind, list);
            }
            list.add(listKind.equals("exclude") ? filter.substring(1).trim() : filter.trim());
        }
        this.addConfigurationEntry(entry);
    }

    private void addConfigurationEntry(Map.Entry<String, Object> untypedEntry) {
        if (untypedEntry.getKey().startsWith("@")) {
            Map.Entry<String, Object> entry = untypedEntry;
            String annotationType = null;
            Matcher m = this.annotationWithParameterPattern.matcher(entry.getKey());
            String parameter = null;
            if (m.matches()) {
                annotationType = m.group(1).contains(".") ? m.group(1) : "jsweet.lang." + m.group(1);
                parameter = m.group(2);
            } else {
                annotationType = entry.getKey().contains(".") ? entry.getKey().substring(1) : "jsweet.lang." + entry.getKey().substring(1);
            }
            Object include = ((Map)entry.getValue()).get("include");
            Collection<AnnotationFilterDescriptor> filterDescriptors = this.getAnnotationFilterDescriptors(annotationType);
            ArrayList<Pattern> inclusionPatterns = null;
            ArrayList<Pattern> exclusionPatterns = null;
            if (include != null) {
                inclusionPatterns = new ArrayList<Pattern>();
                if (include instanceof Collection) {
                    for (Object o : (Collection)include) {
                        try {
                            inclusionPatterns.add(Pattern.compile(JSweetContext.toRegexp(o.toString())));
                        }
                        catch (Exception e) {
                            logger.warn((Object)("invalid pattern '" + o + "' for " + entry.getKey() + ".include"));
                        }
                    }
                } else {
                    try {
                        inclusionPatterns.add(Pattern.compile(JSweetContext.toRegexp(include.toString())));
                    }
                    catch (Exception e) {
                        logger.warn((Object)("invalid pattern '" + include + "' for " + entry.getKey() + ".include"));
                    }
                }
            } else {
                logger.warn((Object)("annotation entry " + entry.getKey() + " does not have a mandatory 'include' entry"));
            }
            Object exclude = ((Map)entry.getValue()).get("exclude");
            if (exclude != null) {
                exclusionPatterns = new ArrayList<Pattern>();
                if (exclude instanceof Collection) {
                    for (Object o : (Collection)exclude) {
                        try {
                            exclusionPatterns.add(Pattern.compile(JSweetContext.toRegexp(o.toString())));
                        }
                        catch (Exception e) {
                            logger.warn((Object)("invalid pattern '" + o + "' for " + entry.getKey() + ".exclude"));
                        }
                    }
                } else {
                    try {
                        exclusionPatterns.add(Pattern.compile(JSweetContext.toRegexp(exclude.toString())));
                    }
                    catch (Exception e) {
                        logger.warn((Object)("invalid pattern '" + exclude + "' for " + entry.getKey() + ".exclude"));
                    }
                }
            }
            filterDescriptors.add(new AnnotationFilterDescriptor(inclusionPatterns, exclusionPatterns, parameter));
        } else {
            switch (untypedEntry.getKey()) {
                case "typeMapping": {
                    Map.Entry<String, Object> entry = untypedEntry;
                    for (Map.Entry e : ((Map)entry.getValue()).entrySet()) {
                        this.addTypeMapping((String)e.getKey(), (String)e.getValue());
                    }
                    break;
                }
            }
        }
    }

    public void dumpOverloads(PrintStream out) {
        for (Map.Entry<Symbol.ClassSymbol, Map<String, OverloadScanner.Overload>> e1 : this.overloads.entrySet()) {
            out.println("*** " + e1.getKey());
            for (Map.Entry<String, OverloadScanner.Overload> e2 : e1.getValue().entrySet()) {
                out.println("  - " + e2.getValue());
            }
        }
        for (Map.Entry<Symbol.ClassSymbol, Map<String, OverloadScanner.Overload>> e1 : this.staticOverloads.entrySet()) {
            out.println("*** " + e1.getKey() + " [STATIC]");
            for (Map.Entry<String, OverloadScanner.Overload> e2 : e1.getValue().entrySet()) {
                out.println("  - " + e2.getValue());
            }
        }
    }

    public Set<OverloadScanner.Overload> getAllOverloads() {
        HashSet<OverloadScanner.Overload> result = new HashSet<OverloadScanner.Overload>();
        this.overloads.values().forEach(m -> result.addAll(m.values()));
        this.staticOverloads.values().forEach(m -> result.addAll(m.values()));
        return result;
    }

    public OverloadScanner.Overload getOrCreateOverload(Symbol.ClassSymbol clazz, Symbol.MethodSymbol method) {
        String name;
        OverloadScanner.Overload overload;
        Map<Symbol.ClassSymbol, Map<String, OverloadScanner.Overload>> actualOverloads = method.isStatic() ? this.staticOverloads : this.overloads;
        Map<String, OverloadScanner.Overload> m = actualOverloads.get(clazz);
        if (m == null) {
            m = new HashMap<String, OverloadScanner.Overload>();
            actualOverloads.put(clazz, m);
        }
        if ((overload = m.get(name = method.name.toString())) == null) {
            overload = new OverloadScanner.Overload();
            overload.methodName = name;
            m.put(name, overload);
        }
        return overload;
    }

    public OverloadScanner.Overload getOverload(Symbol.ClassSymbol clazz, Symbol.MethodSymbol method) {
        Map<Symbol.ClassSymbol, Map<String, OverloadScanner.Overload>> actualOverloads = method.isStatic() ? this.staticOverloads : this.overloads;
        Map<String, OverloadScanner.Overload> m = actualOverloads.get(clazz);
        if (m == null) {
            return null;
        }
        OverloadScanner.Overload overload = m.get(method.name.toString());
        if (overload == null) {
            return null;
        }
        return overload;
    }

    public boolean isInvalidOverload(Symbol.MethodSymbol method) {
        OverloadScanner.Overload overload = this.getOverload((Symbol.ClassSymbol)method.getEnclosingElement(), method);
        return overload != null && overload.methods.size() > 1 && !overload.isValid;
    }

    public void countStaticInitializer(Symbol.ClassSymbol clazz) {
        this.staticInitializerCounts.put(clazz, (this.staticInitializerCounts.containsKey(clazz) ? this.staticInitializerCounts.get(clazz) : 0) + 1);
    }

    public int getStaticInitializerCount(Symbol.ClassSymbol clazz) {
        Integer count = null;
        count = this.staticInitializerCounts.get(clazz);
        return count == null ? 0 : count;
    }

    public void registerUsedModule(String moduleName) {
        if (!this.usedModules.contains(moduleName)) {
            this.usedModules.add(moduleName);
        }
    }

    public java.util.List<String> getUsedModules() {
        return this.usedModules;
    }

    public void registerImportedName(String moduleName, Symbol sourceElement, String targetName) {
        Set<String> importedNames = this.importedNamesInModules.get(moduleName);
        if (importedNames == null) {
            importedNames = new HashSet<String>();
            this.importedNamesInModules.put(moduleName, importedNames);
        }
        if (!importedNames.contains(targetName)) {
            importedNames.add(targetName);
        }
        if (sourceElement != null) {
            Map<Symbol, String> importedElements = this.importedElementsInModules.get(moduleName);
            if (importedElements == null) {
                importedElements = new HashMap<Symbol, String>();
                this.importedElementsInModules.put(moduleName, importedElements);
            }
            if (!importedElements.containsKey(sourceElement)) {
                importedElements.put(sourceElement, targetName);
            }
        }
    }

    public Set<String> getImportedNames(String moduleName) {
        Set<String> importedNames = this.importedNamesInModules.get(moduleName);
        if (importedNames == null) {
            importedNames = new HashSet<String>();
            this.importedNamesInModules.put(moduleName, importedNames);
        }
        return importedNames;
    }

    public Map<Symbol, String> getImportedElements(String moduleName) {
        Map<Symbol, String> importedElements = this.importedElementsInModules.get(moduleName);
        if (importedElements == null) {
            importedElements = new HashMap<Symbol, String>();
            this.importedElementsInModules.put(moduleName, importedElements);
        }
        return importedElements;
    }

    public void clearImportedNames(String moduleName) {
        HashSet importedNames = new HashSet();
        this.importedNamesInModules.put(moduleName, importedNames);
        HashMap importedModulesForNames = new HashMap();
        this.importedElementsInModules.put(moduleName, importedModulesForNames);
    }

    public Map<String, java.util.List<Symbol>> getExportedElements() {
        return this.exportedElements;
    }

    public String getExportedElementName(Symbol exportedElement) {
        String name = this.exportedNames.get(exportedElement);
        String forcedName = this.getAnnotationValue(exportedElement, "jsweet.lang.Module", "exportedElement", String.class, null);
        if (StringUtils.isNotBlank((CharSequence)forcedName)) {
            name = forcedName;
        }
        return name;
    }

    public void addExportedElement(String moduleName, Symbol exportedElement, JCTree.JCCompilationUnit compilationUnit) {
        java.util.List<Symbol> exportedNamesForModule = this.exportedElements.get(moduleName);
        if (exportedNamesForModule == null) {
            exportedNamesForModule = new ArrayList<Symbol>();
            this.exportedElements.put(moduleName, exportedNamesForModule);
        }
        this.exportedNames.put(exportedElement, this.getRootRelativeName(this.useModules ? this.getImportedElements(compilationUnit.getSourceFile().getName()) : null, exportedElement));
        exportedNamesForModule.add(exportedElement);
    }

    public String poolFooterStatements() {
        StringBuilder sb = new StringBuilder();
        for (String footerStatement : this.footerStatements) {
            sb.append("\n");
            sb.append(footerStatement);
            sb.append("\n");
        }
        this.footerStatements.clear();
        return sb.toString();
    }

    public void addFooterStatement(String footerStatement) {
        this.footerStatements.add(footerStatement);
    }

    public void addTopFooterStatement(String footerStatement) {
        this.footerStatements.add(0, footerStatement);
    }

    public String poolHeaders() {
        StringBuilder sb = new StringBuilder();
        if (!this.headers.isEmpty()) {
            for (String header : this.headers.values()) {
                sb.append(header);
            }
            sb.append("\n");
        }
        this.headers.clear();
        return sb.toString();
    }

    public void addHeader(String key, String header) {
        this.headers.put(key, header);
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public void addGlobalsMapping(String from, String to) {
        this.globalsMapping.put(from, to);
    }

    public String getGlobalsMappingString() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, String> e : this.globalsMapping.entrySet()) {
            b.append("var " + e.getValue() + " = " + e.getKey() + ";\n");
        }
        return b.toString();
    }

    public Set<Map.Entry<JCTree.JCClassDecl, JCTree.JCMethodDecl>> getDefaultMethods(Symbol.TypeSymbol type) {
        return this.defaultMethods.get(type);
    }

    public void addDefaultMethod(JCTree.JCCompilationUnit compilationUnit, JCTree.JCClassDecl type, JCTree.JCMethodDecl defaultMethod) {
        Set<Map.Entry<JCTree.JCClassDecl, JCTree.JCMethodDecl>> methods = this.defaultMethods.get(type.sym);
        if (methods == null) {
            methods = new HashSet<Map.Entry<JCTree.JCClassDecl, JCTree.JCMethodDecl>>();
            this.defaultMethods.put(type.sym, methods);
        }
        methods.add(new AbstractMap.SimpleEntry<JCTree.JCClassDecl, JCTree.JCMethodDecl>(type, defaultMethod));
        this.defaultMethodsCompilationUnits.put(defaultMethod, compilationUnit);
    }

    public JCTree.JCCompilationUnit getDefaultMethodCompilationUnit(JCTree.JCMethodDecl defaultMethod) {
        return this.defaultMethodsCompilationUnits.get(defaultMethod);
    }

    public void addFieldNameMapping(Symbol.VarSymbol field, String name) {
        this.fieldNameMapping.put(field, name);
    }

    public String getFieldNameMapping(Symbol field) {
        return this.fieldNameMapping.get(field);
    }

    public boolean hasFieldNameMapping(Symbol field) {
        return this.fieldNameMapping.containsKey(field);
    }

    public void addClassNameMapping(Symbol.ClassSymbol clazz, String name) {
        this.classNameMapping.put(clazz, name);
    }

    public String getClassNameMapping(Symbol clazz) {
        return this.classNameMapping.get(clazz);
    }

    public boolean hasClassNameMapping(Symbol clazz) {
        return this.classNameMapping.containsKey(clazz);
    }

    public void registerWildcard(Symbol holder, JCTree.JCWildcard wildcard) {
        if (wildcard.getBound() == null) {
            return;
        }
        java.util.List<JCTree.JCWildcard> l = this.wildcards.get(holder);
        if (l == null) {
            l = new ArrayList<JCTree.JCWildcard>();
            this.wildcards.put(holder, l);
        }
        l.add(wildcard);
        this.wildcardNames.put(wildcard, "__T" + l.size());
    }

    public String getWildcardName(JCTree.JCWildcard wildcard) {
        return this.wildcardNames.get(wildcard);
    }

    public java.util.List<JCTree.JCWildcard> getWildcards(Symbol holder) {
        return this.wildcards.get(holder);
    }

    public boolean isRootPackage(Element element) {
        Symbol symbol = (Symbol)element;
        return this.hasAnnotationType(symbol, "jsweet.lang.Root") || symbol instanceof Symbol.PackageSymbol && libPackagePattern.matcher(symbol.getQualifiedName().toString()).matches();
    }

    public boolean isInterface(Symbol.TypeSymbol typeSymbol) {
        return typeSymbol.type.isInterface() || this.hasAnnotationType(typeSymbol, "jsweet.lang.Interface");
    }

    public boolean hasAnnotationType(Symbol symbol, String ... annotationTypes) {
        String[] types = annotationTypes;
        for (AnnotationManager annotationIntrospector : this.annotationManagers) {
            String[] stringArray = types;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String annotationType = stringArray[i];
                AnnotationManager.Action state = annotationIntrospector.manageAnnotation(symbol, annotationType);
                if (state == AnnotationManager.Action.ADD) {
                    return true;
                }
                if (state != AnnotationManager.Action.REMOVE) continue;
                types = (String[])ArrayUtils.removeElement((Object[])annotationTypes, (Object)annotationType);
            }
        }
        if (this.hasAnnotationFilters()) {
            String signature = symbol.toString();
            if (!(symbol instanceof Symbol.TypeSymbol) && symbol.getEnclosingElement() != null) {
                signature = symbol.getEnclosingElement().getQualifiedName().toString() + "." + signature;
            }
            for (String annotationType : annotationTypes) {
                Collection<AnnotationFilterDescriptor> filterDescriptors = this.annotationFilters.get(annotationType);
                if (filterDescriptors == null) continue;
                for (AnnotationFilterDescriptor filterDescriptor : filterDescriptors) {
                    if (filterDescriptor.inclusionPatterns == null) {
                        logger.error((Object)("no inclusion patterns found for annotation filter: " + annotationType));
                    }
                    for (Pattern include : filterDescriptor.inclusionPatterns) {
                        if (!include.matcher(signature).matches()) continue;
                        boolean excluded = false;
                        Collection<Pattern> excludePatterns = filterDescriptor.exclusionPatterns;
                        if (excludePatterns != null) {
                            for (Pattern exclude : excludePatterns) {
                                if (!exclude.matcher(signature).matches()) continue;
                                excluded = true;
                                break;
                            }
                        }
                        if (excluded) continue;
                        return true;
                    }
                }
            }
        }
        return JSweetContext.hasActualAnnotationType(symbol, annotationTypes);
    }

    public String getActualName(Symbol symbol) {
        String originalName;
        String name = symbol.getSimpleName().toString();
        if (this.hasAnnotationType(symbol, "jsweet.lang.Name") && !StringUtils.isBlank((CharSequence)(originalName = (String)this.getAnnotationValue(symbol, "jsweet.lang.Name", String.class, null)))) {
            name = originalName;
        }
        return name;
    }

    private void getRootRelativeName(Map<Symbol, String> nameMapping, StringBuilder sb, Symbol symbol) {
        if (this.useModules && symbol instanceof Symbol.PackageSymbol && !symbol.toString().startsWith("def.")) {
            return;
        }
        if (!this.isRootPackage(symbol)) {
            String originalName;
            if (sb.length() > 0 && !"".equals(symbol.toString())) {
                sb.insert(0, ".");
            }
            String name = symbol.getSimpleName().toString();
            if (nameMapping != null && nameMapping.containsKey(symbol)) {
                name = nameMapping.get(symbol);
            } else if (this.hasAnnotationType(symbol, "jsweet.lang.Name") && !StringUtils.isBlank((CharSequence)(originalName = (String)this.getAnnotationValue(symbol, "jsweet.lang.Name", String.class, null)))) {
                name = originalName;
            }
            sb.insert(0, name);
            Symbol symbol2 = symbol = symbol instanceof Symbol.PackageSymbol ? ((Symbol.PackageSymbol)symbol).owner : symbol.getEnclosingElement();
            if (symbol != null) {
                this.getRootRelativeName(nameMapping, sb, symbol);
            }
        }
    }

    public Symbol.PackageSymbol getTopLevelPackage(Symbol symbol) {
        Symbol parent;
        if (symbol instanceof Symbol.PackageSymbol && this.isRootPackage(symbol)) {
            return null;
        }
        Symbol symbol2 = parent = symbol instanceof Symbol.PackageSymbol ? ((Symbol.PackageSymbol)symbol).owner : symbol.getEnclosingElement();
        if (parent != null && this.isRootPackage(parent)) {
            if (symbol instanceof Symbol.PackageSymbol) {
                return (Symbol.PackageSymbol)symbol;
            }
            return null;
        }
        if (parent == null || parent instanceof Symbol.PackageSymbol && StringUtils.isBlank((CharSequence)parent.getSimpleName())) {
            if (symbol instanceof Symbol.PackageSymbol) {
                return (Symbol.PackageSymbol)symbol;
            }
            return null;
        }
        return this.getTopLevelPackage(parent);
    }

    public Symbol.PackageSymbol getFirstEnclosingRootPackage(Symbol.PackageSymbol packageSymbol) {
        if (packageSymbol == null) {
            return null;
        }
        if (this.isRootPackage(packageSymbol)) {
            return packageSymbol;
        }
        return this.getFirstEnclosingRootPackage((Symbol.PackageSymbol)packageSymbol.owner);
    }

    private void getRootRelativeJavaName(StringBuilder sb, Symbol symbol) {
        if (!this.isRootPackage(symbol)) {
            if (sb.length() > 0 && !"".equals(symbol.toString())) {
                sb.insert(0, ".");
            }
            String name = symbol.getSimpleName().toString();
            sb.insert(0, name);
            Symbol symbol2 = symbol = symbol instanceof Symbol.PackageSymbol ? ((Symbol.PackageSymbol)symbol).owner : symbol.getEnclosingElement();
            if (symbol != null) {
                this.getRootRelativeJavaName(sb, symbol);
            }
        }
    }

    public String getRootRelativeName(Map<Symbol, String> nameMapping, Symbol symbol, boolean useJavaNames) {
        if (useJavaNames) {
            return this.getRootRelativeJavaName(symbol);
        }
        return this.getRootRelativeName(nameMapping, symbol);
    }

    public String getRootRelativeName(Map<Symbol, String> nameMapping, Symbol symbol) {
        StringBuilder sb = new StringBuilder();
        this.getRootRelativeName(nameMapping, sb, symbol);
        if (sb.length() > 0 && sb.charAt(0) == '.') {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public String getRootRelativeJavaName(Symbol symbol) {
        StringBuilder sb = new StringBuilder();
        this.getRootRelativeJavaName(sb, symbol);
        return sb.toString();
    }

    public final <T> T getAnnotationValue(Symbol symbol, String annotationType, Class<T> propertyClass, T defaultValue) {
        return this.getAnnotationValue(symbol, annotationType, null, propertyClass, defaultValue);
    }

    public <T> T getAnnotationValue(Symbol symbol, String annotationType, String propertyName, Class<T> propertyClass, T defaultValue) {
        Object firstVal;
        for (AnnotationManager annotationIntrospector : this.annotationManagers) {
            Object value = annotationIntrospector.getAnnotationValue(symbol, annotationType, propertyName, propertyClass, defaultValue);
            if (value == null) continue;
            return value;
        }
        if (this.hasAnnotationFilters()) {
            Collection<AnnotationFilterDescriptor> filterDescriptors;
            String signature = symbol.toString();
            if (symbol.getEnclosingElement() != null) {
                signature = symbol.getEnclosingElement().getQualifiedName().toString() + "." + signature;
            }
            if ((filterDescriptors = this.annotationFilters.get(annotationType)) != null) {
                for (AnnotationFilterDescriptor filterDescriptor : filterDescriptors) {
                    for (Pattern include : filterDescriptor.inclusionPatterns) {
                        if (!include.matcher(signature).matches()) continue;
                        boolean excluded = false;
                        Collection<Pattern> excludePatterns = filterDescriptor.exclusionPatterns;
                        if (excludePatterns != null) {
                            for (Pattern exclude : excludePatterns) {
                                if (!exclude.matcher(signature).matches()) continue;
                                excluded = true;
                                break;
                            }
                        }
                        if (excluded) continue;
                        if (filterDescriptor.parameter == null) {
                            return defaultValue;
                        }
                        if (filterDescriptor.parameter.startsWith("'")) {
                            return (T)filterDescriptor.parameter.substring(1, filterDescriptor.parameter.length() - 1);
                        }
                        if (filterDescriptor.parameter.endsWith(".class")) {
                            return (T)filterDescriptor.parameter.substring(0, filterDescriptor.parameter.length() - 6);
                        }
                        return (T)filterDescriptor.parameter;
                    }
                }
            }
        }
        AnnotationMirror anno = JSweetContext.getAnnotation(symbol, annotationType);
        T val = defaultValue;
        if (anno != null && (firstVal = JSweetContext.getFirstAnnotationValue(anno, propertyName, propertyClass, null)) != null) {
            val = firstVal;
        }
        return val;
    }

    private static <T> T getFirstAnnotationValue(AnnotationMirror annotation, String propertyName, Class<T> propertyClass, T defaultValue) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> valueEntry : annotation.getElementValues().entrySet()) {
            if (propertyName != null && !propertyName.equals(valueEntry.getKey().getSimpleName().toString())) continue;
            if (propertyClass.isArray()) {
                java.util.List l = (java.util.List)valueEntry.getValue().getValue();
                Object array = Array.newInstance(propertyClass.getComponentType(), l.size());
                for (int i = 0; i < l.size(); ++i) {
                    Array.set(array, i, ((Attribute)l.get(i)).getValue());
                }
                return (T)array;
            }
            return (T)valueEntry.getValue().getValue();
        }
        return defaultValue;
    }

    private static AnnotationMirror getAnnotation(Symbol symbol, String annotationType) {
        for (Attribute.Compound a : symbol.getAnnotationMirrors()) {
            if (!annotationType.equals(a.type.toString())) continue;
            return a;
        }
        return null;
    }

    public void grabSupportedInterfaceNames(Set<String> interfaces, Symbol.TypeSymbol type) {
        if (type == null) {
            return;
        }
        if (this.isInterface(type)) {
            interfaces.add(type.getQualifiedName().toString());
        }
        if (type instanceof Symbol.ClassSymbol) {
            for (Type t : ((Symbol.ClassSymbol)type).getInterfaces()) {
                this.grabSupportedInterfaceNames(interfaces, t.tsym);
            }
            this.grabSupportedInterfaceNames(interfaces, ((Symbol.ClassSymbol)type).getSuperclass().tsym);
        }
    }

    public void grabSuperClassNames(Set<String> superClasses, Element type) {
        if (type == null) {
            return;
        }
        if (type instanceof Symbol.ClassSymbol) {
            superClasses.add(((Symbol.ClassSymbol)type).getQualifiedName().toString());
            this.grabSuperClassNames(superClasses, ((Symbol.ClassSymbol)type).getSuperclass().tsym);
        }
    }

    public void grabMethodsToBeImplemented(java.util.List<Symbol.MethodSymbol> methods, Symbol.TypeSymbol type) {
        if (type == null) {
            return;
        }
        if (this.isInterface(type)) {
            for (Symbol s : type.getEnclosedElements()) {
                if (!(s instanceof Symbol.MethodSymbol) || s.isStatic() || Util.isOverridingBuiltInJavaObjectMethod((Symbol.MethodSymbol)s)) continue;
                methods.add((Symbol.MethodSymbol)s);
            }
        }
        if (type instanceof Symbol.ClassSymbol) {
            for (Type t : ((Symbol.ClassSymbol)type).getInterfaces()) {
                this.grabMethodsToBeImplemented(methods, t.tsym);
            }
            this.grabMethodsToBeImplemented(methods, ((Symbol.ClassSymbol)type).getSuperclass().tsym);
        }
    }

    private static boolean hasActualAnnotationType(Symbol symbol, String ... annotationTypes) {
        for (Attribute.Compound a : symbol.getAnnotationMirrors()) {
            for (String annotationType : annotationTypes) {
                if (!annotationType.equals(a.type.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAnonymousClass(JCTree.JCNewClass newClass) {
        if (newClass.clazz != null && newClass.def != null) {
            if (this.hasAnnotationType(newClass.clazz.type.tsym, "jsweet.lang.ObjectType") || this.hasAnnotationType(newClass.clazz.type.tsym, "jsweet.lang.Interface")) {
                return false;
            }
            if (newClass.def.defs.size() > 2) {
                return true;
            }
            if (newClass.clazz.type.tsym.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return true;
            }
            for (JCTree def : newClass.def.defs) {
                if (def instanceof JCTree.JCVariableDecl) {
                    return true;
                }
                if (!(!(def instanceof JCTree.JCMethodDecl) || ((JCTree.JCMethodDecl)def).sym.isConstructor() && ((List)((JCTree.JCMethodDecl)def).sym.getParameters()).isEmpty())) {
                    return true;
                }
                if (!(def instanceof JCTree.JCBlock)) continue;
                for (JCTree.JCStatement s : ((JCTree.JCBlock)def).stats) {
                    if (JSweetContext.isAllowedStatementInMap(s)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isAllowedStatementInMap(JCTree.JCStatement statement) {
        if (statement instanceof JCTree.JCExpressionStatement) {
            JCTree.JCExpressionStatement exprStat = (JCTree.JCExpressionStatement)statement;
            if (exprStat.getExpression() instanceof JCTree.JCAssign) {
                return true;
            }
            if (exprStat.getExpression() instanceof JCTree.JCMethodInvocation) {
                JCTree.JCMethodInvocation inv = (JCTree.JCMethodInvocation)exprStat.getExpression();
                String methodName = inv.meth instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)inv.meth).name.toString() : inv.meth.toString();
                if ("$get".equals(methodName) || "$set".equals(methodName)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int getFunctionalTypeParameterCount(Type type) {
        String name = ((Name)type.tsym.getSimpleName()).toString();
        String fullName = type.toString();
        if (Runnable.class.getName().equals(fullName)) {
            return 0;
        }
        if (type.toString().startsWith("jsweet.util.function.")) {
            if (name.equals("TriFunction")) {
                return 3;
            }
            if (name.equals("TriConsumer")) {
                return 3;
            }
            if (name.equals("Consumer")) {
                return 1;
            }
            if (name.startsWith("Function") || name.startsWith("Consumer")) {
                return Integer.parseInt(name.substring(8));
            }
            return -1;
        }
        if (type.toString().startsWith("java.util.function.")) {
            if (name.endsWith("Consumer")) {
                if (name.startsWith("Bi")) {
                    return 2;
                }
                return 1;
            }
            if (name.endsWith("Function")) {
                if (name.startsWith("Bi")) {
                    return 2;
                }
                return 1;
            }
            if (name.endsWith("UnaryOperator")) {
                return 1;
            }
            if (name.endsWith("BinaryOperator")) {
                return 2;
            }
            if (name.endsWith("Supplier")) {
                return 0;
            }
            if (name.endsWith("Predicate")) {
                if (name.startsWith("Bi")) {
                    return 2;
                }
                return 1;
            }
            return -1;
        }
        if (this.hasAnnotationType(type.tsym, JSweetConfig.ANNOTATION_FUNCTIONAL_INTERFACE)) {
            for (Element e : type.tsym.getEnclosedElements()) {
                if (!(e instanceof Symbol.MethodSymbol)) continue;
                return ((List)((Symbol.MethodSymbol)e).getParameters()).size();
            }
            return -1;
        }
        return -1;
    }

    public boolean isFunctionalType(Symbol.TypeSymbol type) {
        String name = type.getQualifiedName().toString();
        return name.startsWith("java.util.function.") || name.equals(Runnable.class.getName()) || name.startsWith("jsweet.util.function.") || type.isInterface() && (this.hasAnnotationType(type, FunctionalInterface.class.getName()) || this.hasAnonymousFunction(type));
    }

    public boolean isCoreFunctionalType(Symbol.TypeSymbol type) {
        String name = type.getQualifiedName().toString();
        return name.startsWith("java.util.function.") || name.equals(Runnable.class.getName()) || name.startsWith("jsweet.util.function.") || type.isInterface() && this.hasAnonymousFunction(type);
    }

    public boolean hasAnonymousFunction(Symbol.TypeSymbol type) {
        for (Symbol s : type.getEnclosedElements()) {
            String methodName;
            if (!(s instanceof Symbol.MethodSymbol) || !"$apply".equals(methodName = s.getSimpleName().toString()) && (!this.deprecatedApply || !"apply".equals(methodName))) continue;
            return true;
        }
        return false;
    }

    public boolean isIgnored(JCTree.JCClassDecl classdecl) {
        if (this.hasAnnotationType(classdecl.type.tsym, "jsweet.lang.ObjectType")) {
            return true;
        }
        if (this.hasAnnotationType(classdecl.type.tsym, "jsweet.lang.Erased")) {
            return true;
        }
        return classdecl.type.tsym.getKind() == ElementKind.ANNOTATION_TYPE && !this.hasAnnotationType(classdecl.sym, "jsweet.lang.Decorator");
    }

    public boolean isPackageErased(Symbol.PackageSymbol pkg) {
        if (pkg == null) {
            return false;
        }
        if (this.hasAnnotationType(pkg, "jsweet.lang.Erased")) {
            return true;
        }
        return this.isPackageErased((Symbol.PackageSymbol)pkg.getEnclosingElement());
    }

    public boolean isUsingJavaRuntime() {
        return this.usingJavaRuntime;
    }

    public void setUsingJavaRuntime(boolean usingJavaRuntime) {
        this.usingJavaRuntime = usingJavaRuntime;
    }

    public final Map<String, String> getLangTypeMappings() {
        return this.langTypesMapping;
    }

    public final Set<String> getLangTypesSimpleNames() {
        return this.langTypesSimpleNames;
    }

    public final Set<String> getBaseThrowables() {
        return this.baseThrowables;
    }

    private boolean isAmbientAnnotatedDeclaration(Symbol symbol) {
        if (symbol == null) {
            return false;
        }
        if (this.hasAnnotationType(symbol, "jsweet.lang.Ambient")) {
            return true;
        }
        return this.isAmbientAnnotatedDeclaration(symbol.getEnclosingElement());
    }

    public boolean isAmbientDeclaration(Symbol symbol) {
        if (symbol instanceof Symbol.TypeSymbol ? symbol.getQualifiedName().toString().startsWith("def.") : symbol.getEnclosingElement().getQualifiedName().toString().startsWith("def.")) {
            return true;
        }
        return this.isAmbientAnnotatedDeclaration(symbol);
    }

    private static class AnnotationFilterDescriptor {
        public final Collection<Pattern> inclusionPatterns;
        public final Collection<Pattern> exclusionPatterns;
        public final String parameter;

        public AnnotationFilterDescriptor(Collection<Pattern> inclusionPatterns, Collection<Pattern> exclusionPatterns, String parameter) {
            this.inclusionPatterns = inclusionPatterns;
            this.exclusionPatterns = exclusionPatterns;
            this.parameter = parameter;
        }

        public String toString() {
            return "FILTER" + (this.parameter == null ? "" : "('" + this.parameter + "')") + ": INCLUDES=" + this.inclusionPatterns + ", EXCLUDES=" + this.exclusionPatterns;
        }
    }
}

