/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class JSweetConfig {
    private static Logger logger = Logger.getLogger(JSweetConfig.class);
    public static Properties APPLICATION_PROPERTIES = new Properties();
    public static String MAVEN_CANDIES_GROUP;
    public static String MAVEN_JAVA_OVERRIDE_ARTIFACT;
    public static final String LIBS_PACKAGE = "def";
    private static final String JAVA_PACKAGE = "java";
    private static final String JAVAX_PACKAGE = "javax";
    private static final String ROOT_PACKAGE = "jsweet";
    public static final String LANG_PACKAGE = "jsweet.lang";
    public static final String LANG_PACKAGE_ALT = "def.js";
    public static final String UTIL_PACKAGE = "jsweet.util";
    public static final String DOM_PACKAGE = "def.dom";
    public static final String GLOBALS_PACKAGE_NAME = "globals";
    public static final String GLOBALS_CLASS_NAME = "Globals";
    public static final String DEPRECATED_UTIL_CLASSNAME = "jsweet.util.Globals";
    public static final String UTIL_CLASSNAME = "jsweet.util.Lang";
    public static final String STRING_TYPES_INTERFACE_NAME = "StringTypes";
    public static final String FUNCTION_CLASSES_PACKAGE = "jsweet.util.function";
    public static final String TUPLE_CLASSES_PACKAGE = "jsweet.util.tuple";
    public static final String TUPLE_CLASSES_PREFIX = "Tuple";
    public static final String UNION_PACKAGE = "jsweet.util.union";
    public static final String UNION_CLASS_NAME = "jsweet.util.union.Union";
    public static final String INDEXED_GET_FUCTION_NAME = "$get";
    public static final String INDEXED_SET_FUCTION_NAME = "$set";
    public static final String INDEXED_DELETE_FUCTION_NAME = "$delete";
    public static final String INDEXED_GET_STATIC_FUCTION_NAME = "$getStatic";
    public static final String INDEXED_SET_STATIC_FUCTION_NAME = "$setStatic";
    public static final String INDEXED_DELETE_STATIC_FUCTION_NAME = "$deleteStatic";
    public static final String NEW_FUNCTION_NAME = "$new";
    public static final String ANONYMOUS_DEPRECATED_FUNCTION_NAME = "apply";
    public static final String ANONYMOUS_FUNCTION_NAME = "$apply";
    public static final String ANONYMOUS_DEPRECATED_STATIC_FUNCTION_NAME = "applyStatic";
    public static final String ANONYMOUS_STATIC_FUNCTION_NAME = "$applyStatic";
    public static final String EXTENSION_DIR = "jsweet_extension";
    public static final String TS_LIBS_DIR_NAME = "typings";
    public static final String MAIN_FUNCTION_NAME = "main";
    public static final String MODULE_FILE_NAME = "module";
    public static final String OBJECT_CLASSNAME = "def.js.Object";
    public static final String ANNOTATION_DISABLED = "jsweet.lang.Disabled";
    public static final String ANNOTATION_ERASED = "jsweet.lang.Erased";
    public static final String ANNOTATION_SYNTACTIC_ITERABLE = "jsweet.lang.SyntacticIterable";
    public static final String ANNOTATION_AMBIENT = "jsweet.lang.Ambient";
    public static final String ANNOTATION_MIXIN = "jsweet.lang.Mixin";
    public static final String ANNOTATION_OBJECT_TYPE = "jsweet.lang.ObjectType";
    public static final String ANNOTATION_MODULE = "jsweet.lang.Module";
    public static final String ANNOTATION_INTERFACE = "jsweet.lang.Interface";
    public static final String ANNOTATION_OPTIONAL = "jsweet.lang.Optional";
    public static final String ANNOTATION_STRING_TYPE = "jsweet.lang.StringType";
    public static final String ANNOTATION_ROOT = "jsweet.lang.Root";
    public static final String ANNOTATION_NAME = "jsweet.lang.Name";
    public static final String ANNOTATION_DECORATOR = "jsweet.lang.Decorator";
    public static final String ANNOTATION_REPLACE = "jsweet.lang.Replace";
    public static final String ANNOTATION_GENERATOR = "jsweet.lang.Generator";
    public static final String ANNOTATION_NO_DEBUG = "jsweet.lang.NoDebug";
    public static final String ANNOTATION_FUNCTIONAL_INTERFACE;
    public static final Set<String> JAVA_KEYWORDS;
    public static final Set<String> JS_KEYWORDS;
    public static final Set<String> TS_STRICT_MODE_KEYWORDS;
    public static final Set<String> TS_TOP_LEVEL_KEYWORDS;
    public static final Set<Character> TS_IDENTIFIER_FORBIDDEN_CHARS;
    public static final String JS_KEYWORD_PREFIX = "__";
    public static final String FIELD_METHOD_CLASH_RESOLVER_PREFIX = "__";
    public static final String CONFIGURATION_FILE_NAME = "jsweetconfig.json";

    private JSweetConfig() {
    }

    public static String getVersionNumber() {
        return APPLICATION_PROPERTIES.getProperty("application.version");
    }

    public static String getBuildDate() {
        return APPLICATION_PROPERTIES.getProperty("application.buildDate");
    }

    public static void initClassPath(String jdkHome) {
        try {
            URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            boolean found = false;
            for (URL url : urlClassLoader.getURLs()) {
                if (!url.getPath().endsWith("/tools.jar") && !url.getPath().endsWith("/Classes/classes.jar")) continue;
                found = true;
                logger.debug((Object)"tools.jar already in classpath");
                break;
            }
            boolean foundExtension = false;
            for (URL url : urlClassLoader.getURLs()) {
                if (!url.getPath().endsWith("/jsweet_extension")) continue;
                foundExtension = true;
                logger.debug((Object)"extension dir already in classpath");
                break;
            }
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            if (!found) {
                logger.debug((Object)"adding tools.jar in classpath");
                File toolsLib = null;
                if (!StringUtils.isBlank((CharSequence)jdkHome)) {
                    logger.debug((Object)("lookup in " + jdkHome));
                    toolsLib = new File(jdkHome, "lib/tools.jar");
                    if (!toolsLib.exists()) {
                        toolsLib = new File(jdkHome, "../lib/tools.jar");
                    }
                    if (!toolsLib.exists()) {
                        toolsLib = new File(jdkHome, "/Classes/classes.jar");
                    }
                    if (!toolsLib.exists()) {
                        toolsLib = new File(jdkHome, "../Classes/classes.jar");
                    }
                }
                if (toolsLib == null || !toolsLib.exists()) {
                    logger.debug((Object)("lookup in JAVA_HOME=" + System.getenv("JAVA_HOME")));
                    toolsLib = new File(System.getenv("JAVA_HOME"), "lib/tools.jar");
                    if (!toolsLib.exists()) {
                        toolsLib = new File(System.getenv("JAVA_HOME"), "../lib/tools.jar");
                    }
                    if (!toolsLib.exists()) {
                        toolsLib = new File(System.getenv("JAVA_HOME"), "/Classes/classes.jar");
                    }
                    if (!toolsLib.exists()) {
                        toolsLib = new File(System.getenv("JAVA_HOME"), "../Classes/classes.jar");
                    }
                }
                if (toolsLib.exists()) {
                    method.invoke((Object)urlClassLoader, toolsLib.toURI().toURL());
                    logger.debug((Object)("updated classpath with: " + toolsLib));
                }
            }
            if (!foundExtension) {
                method.invoke((Object)urlClassLoader, new File(EXTENSION_DIR).toURI().toURL());
                logger.debug((Object)("updated classpath with: " + new File(EXTENSION_DIR).toURI().toURL()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isJDKReplacementMode() {
        return "java.lang".equals(LANG_PACKAGE);
    }

    public static boolean isJDKPath(String qualifiedName) {
        return qualifiedName.startsWith("java.") || qualifiedName.startsWith("javax.");
    }

    public static boolean isLibPath(String qualifiedName) {
        return qualifiedName.startsWith("def.");
    }

    public static boolean isJSweetPath(String qualifiedName) {
        return qualifiedName.startsWith("jsweet.") || qualifiedName.startsWith("def.js.") || qualifiedName.startsWith("def.dom.");
    }

    static {
        try (InputStream in = JSweetConfig.class.getResourceAsStream("/jsweet-transpiler-application.properties");){
            APPLICATION_PROPERTIES.load(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MAVEN_CANDIES_GROUP = "org.jsweet.candies";
        MAVEN_JAVA_OVERRIDE_ARTIFACT = "jsweet-core-strict";
        ANNOTATION_FUNCTIONAL_INTERFACE = FunctionalInterface.class.getName();
        JAVA_KEYWORDS = new HashSet<String>(){
            {
                this.add("abstract");
                this.add("assert");
                this.add("break");
                this.add("byte");
                this.add("case");
                this.add("catch");
                this.add("char");
                this.add("const");
                this.add("continue");
                this.add("default");
                this.add("do");
                this.add("double");
                this.add("else");
                this.add("extends");
                this.add("final");
                this.add("finally");
                this.add("float");
                this.add("for");
                this.add("goto");
                this.add("if");
                this.add("import");
                this.add("instanceof");
                this.add("int");
                this.add("long");
                this.add("native");
                this.add("new");
                this.add("package");
                this.add("private");
                this.add("protected");
                this.add("public");
                this.add("return");
                this.add("short");
                this.add("static");
                this.add("strictfp");
                this.add("super");
                this.add("switch");
                this.add("synchronized");
                this.add("this");
                this.add("throw");
                this.add("throws");
                this.add("transient");
                this.add("try");
                this.add("volatile");
                this.add("while");
            }
        };
        JS_KEYWORDS = new HashSet<String>(){
            {
                this.add("function");
                this.add("var");
                this.add("delete");
                this.add("typeof");
                this.add("in");
                this.add("arguments");
                this.add("eval");
            }
        };
        TS_STRICT_MODE_KEYWORDS = new HashSet<String>(){
            {
                this.add("as");
                this.add("implements");
                this.add("interface");
                this.add("let");
                this.add("package");
                this.add("private");
                this.add("protected");
                this.add("public");
                this.add("static");
                this.add("yield");
                this.add("symbol");
                this.add("type");
                this.add("from");
                this.add("of");
            }
        };
        TS_TOP_LEVEL_KEYWORDS = new HashSet<String>(){
            {
                this.add("require");
            }
        };
        TS_IDENTIFIER_FORBIDDEN_CHARS = new HashSet<Character>(){
            {
                this.add(Character.valueOf('-'));
                this.add(Character.valueOf('+'));
                this.add(Character.valueOf('~'));
                this.add(Character.valueOf('&'));
                this.add(Character.valueOf('#'));
                this.add(Character.valueOf('%'));
                this.add(Character.valueOf('|'));
                this.add(Character.valueOf('\u00b0'));
                this.add(Character.valueOf('@'));
            }
        };
    }
}

