/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jsweet.AbstractJSweetMojo;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.JSweetTranspiler;

@Mojo(name="watch", defaultPhase=LifecyclePhase.TEST)
public class JSweetWatchMojo
extends AbstractJSweetMojo {
    @Parameter(defaultValue="HIGH", required=false, readonly=true)
    public String watcherSensitivity;
    private TranspilatorThread transpilatorThread;
    private static final SensitivityWatchEventModifier SENSITIVITY_WATCH_EVENT_MODIFIER = SensitivityWatchEventModifier.HIGH;
    private static ReentrantLock __Lock = new ReentrantLock();
    private static LinkedList<String> __RandomKeysTrigger = new LinkedList();
    private JSweetTranspiler transpiler;

    @Override
    public void execute() throws MojoFailureException, MojoExecutionException {
        super.execute();
        MavenProject project = this.getMavenProject();
        this.transpiler = this.createJSweetTranspiler(project);
        this.getLog().info((CharSequence)"- Starting transpilator process  ... ");
        this.transpilatorThread = new TranspilatorThread(this, project);
        this.transpilatorThread.start();
        this.initialize(project);
    }

    private void initialize(MavenProject project) {
        List sourcePaths = project.getCompileSourceRoots();
        try {
            while (true) {
                WatchService watchService = FileSystems.getDefault().newWatchService();
                ArrayList<Path> watchedPaths = new ArrayList<Path>();
                this.getLog().info((CharSequence)"+ Registering source path");
                for (String sourceDirectory : sourcePaths) {
                    Path path = Paths.get(sourceDirectory, new String[0]);
                    watchedPaths.add(path);
                    this.walkDirectoryTree(path, watchedPaths, watchService);
                }
                this.getLog().info((CharSequence)"- Registering source path , DONE .");
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"- Listening for file change ... ");
                try {
                    this.watch(watchService);
                }
                catch (Exception exception) {
                    watchService.close();
                }
                Thread.yield();
            }
        }
        catch (IOException ioException) {
            this.getLog().error((Throwable)ioException);
            return;
        }
    }

    private void walkDirectoryTree(Path startPath, List<Path> watchedPaths, WatchService watchService) throws IOException {
        RegisteringFileTreeScanner scanner = new RegisteringFileTreeScanner(watchedPaths, watchService, this);
        Files.walkFileTree(startPath, scanner);
    }

    private void watch(WatchService watchService) throws Exception {
        WatchKey key;
        boolean valid;
        do {
            try {
                key = watchService.take();
            }
            catch (InterruptedException x) {
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                if (kind != StandardWatchEventKinds.ENTRY_MODIFY && kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                this.getLog().info((CharSequence)("* File change detected *" + filename));
                __Lock.lock();
                __RandomKeysTrigger.add(this.generateRandomEntry());
                __Lock.unlock();
            }
        } while (valid = key.reset());
        try {
            watchService.close();
        }
        catch (IOException ioException) {
            this.getLog().error((Throwable)ioException);
        }
    }

    private String generateRandomEntry() {
        return String.valueOf((int)(10000.0 * Math.random()));
    }

    private class TranspilatorThread
    extends Thread {
        private MavenProject project;
        private AbstractMojo mojo;

        public TranspilatorThread(AbstractMojo mojo, MavenProject project) {
            this.setPriority(10);
            this.project = project;
            this.mojo = mojo;
        }

        @Override
        public void run() {
            this.mojo.getLog().info((CharSequence)"- Transpilator process started ...");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("- JSweet transpiler version ");
            stringBuilder.append(JSweetConfig.getVersionNumber());
            stringBuilder.append(" (build date: ");
            stringBuilder.append(JSweetConfig.getBuildDate()).append(")");
            JSweetWatchMojo.this.getLog().info((CharSequence)stringBuilder.toString());
            while (true) {
                if (__Lock.tryLock()) {
                    if (__RandomKeysTrigger.size() != 0) {
                        __RandomKeysTrigger.removeLast();
                        try {
                            JSweetWatchMojo.this.transpile(this.project, JSweetWatchMojo.this.transpiler);
                        }
                        catch (Exception exception) {
                            JSweetWatchMojo.this.getLog().info((CharSequence)exception.getMessage());
                        }
                    }
                    __Lock.unlock();
                }
                TranspilatorThread.yield();
            }
        }
    }

    public static class RegisteringFileTreeScanner
    extends SimpleFileVisitor<Path> {
        private List<Path> directories;
        private WatchService watchService;
        private AbstractMojo mojo;

        public RegisteringFileTreeScanner(List<Path> directories, WatchService watchService, AbstractMojo mojo) {
            this.directories = directories;
            this.watchService = watchService;
            this.mojo = mojo;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory, IOException exc) {
            this.directories.add(directory);
            try {
                directory.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW}, SENSITIVITY_WATCH_EVENT_MODIFIER);
                this.mojo.getLog().info((CharSequence)("  - Added [" + directory.toString() + "]"));
            }
            catch (IOException ioException) {
                this.mojo.getLog().error((CharSequence)("  * Cannot register [" + directory.toString() + "]"));
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

