/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.jsweet.AbstractJSweetMojo;
import org.jsweet.Util;

@Mojo(name="clean", defaultPhase=LifecyclePhase.CLEAN)
public class JSweetCleanMojo
extends AbstractJSweetMojo {
    @Override
    public void execute() throws MojoFailureException, MojoExecutionException {
        super.execute();
        this.getLog().info((CharSequence)"cleaning jsweet working directory");
        try {
            MavenProject project = this.getMavenProject();
            File tsOutDir = this.getTsOutDir();
            FileUtils.deleteQuietly((File)tsOutDir);
            File jsOutDir = this.getJsOutDir();
            FileUtils.deleteQuietly((File)jsOutDir);
            File declarationsOutDir = this.getDeclarationsOutDir();
            if (declarationsOutDir != null) {
                FileUtils.deleteQuietly((File)declarationsOutDir);
            }
            if (this.candiesJsOut != null) {
                FileUtils.deleteQuietly((File)this.candiesJsOut);
            }
            FileUtils.deleteQuietly((File)(this.workingDir == null ? Util.getTranspilerWorkingDirectory(project) : this.workingDir));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"transpilation failed", (Throwable)e);
            throw new MojoExecutionException("transpilation failed", e);
        }
    }
}

