/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.EcmaScriptComplianceLevel;
import org.jsweet.transpiler.JSweetFactory;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.JSweetTranspiler;
import org.jsweet.transpiler.ModuleKind;
import org.jsweet.transpiler.ModuleResolution;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.util.ConsoleTranspilationHandler;
import org.jsweet.transpiler.util.ErrorCountTranspilationHandler;
import org.jsweet.transpiler.util.ProcessUtil;

public abstract class AbstractJSweetMojo
extends AbstractMojo {
    @Parameter(alias="target", required=false)
    protected EcmaScriptComplianceLevel targetVersion;
    @Parameter(required=false)
    protected ModuleKind module;
    @Parameter(required=false)
    protected String outDir;
    @Parameter(required=false)
    protected String tsOut;
    @Parameter(required=false)
    protected Boolean tsserver;
    @Parameter(required=false)
    protected Boolean bundle;
    @Parameter(required=false)
    protected Boolean declaration;
    @Parameter(required=false)
    protected Boolean tsOnly;
    @Parameter(required=false)
    protected String dtsOut;
    @Parameter(required=false)
    protected Boolean sourceMap;
    @Parameter(required=false)
    protected String sourceRoot;
    @Parameter(required=false)
    protected Boolean verbose;
    @Parameter(required=false)
    protected Boolean veryVerbose;
    @Parameter(required=false)
    protected Boolean ignoreDefinitions;
    @Parameter(required=false)
    protected File candiesJsOut;
    @Parameter
    protected String[] includes;
    @Parameter
    protected String[] excludes;
    @Parameter(required=false)
    protected String encoding;
    @Parameter(required=false)
    protected Boolean noRootDirectories;
    @Parameter(required=false)
    protected Boolean enableAssertions;
    @Parameter(required=false)
    protected Boolean disableSinglePrecisionFloats;
    @Parameter(defaultValue="${java.home}")
    protected File jdkHome;
    @Parameter(required=false)
    protected String extraSystemPath;
    @Parameter(required=false)
    protected ModuleResolution moduleResolution;
    @Parameter(defaultValue="${localRepository}", required=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(required=false)
    protected String factoryClassName;
    @Parameter(required=false)
    protected List<JSweetProblem> ignoredProblems;
    @Parameter(required=false)
    protected Boolean ignoreTypeScriptErrors;
    @Parameter(required=false)
    protected File header;
    @Parameter(required=false)
    protected File workingDir;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver resolver;
    @Component
    protected ArtifactMetadataSource metadataSource;
    @Component
    private PluginDescriptor descriptor;
    @Component
    private RuntimeInformation runtime;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logInfo("maven version: " + this.runtime.getMavenVersion());
    }

    private void logInfo(String content) {
        if (this.verbose != null && this.verbose.booleanValue() || this.veryVerbose != null && this.veryVerbose.booleanValue()) {
            this.getLog().info((CharSequence)content);
        }
    }

    protected SourceFile[] collectSourceFiles(MavenProject project) {
        this.logInfo("source includes: " + ArrayUtils.toString((Object)this.includes));
        this.logInfo("source excludes: " + ArrayUtils.toString((Object)this.excludes));
        List sourcePaths = project.getCompileSourceRoots();
        this.logInfo("sources paths: " + sourcePaths);
        LinkedList<SourceFile> sources = new LinkedList<SourceFile>();
        for (String sourcePath : sourcePaths) {
            this.scanForJavaFiles(sources, new File(sourcePath));
        }
        List resources = project.getResources();
        this.logInfo("sources paths from resources: " + sourcePaths);
        for (Resource resource : resources) {
            String directory = resource.getDirectory();
            this.scanForJavaFiles(sources, new File(directory));
        }
        this.logInfo("sourceFiles=" + sources);
        return sources.toArray(new SourceFile[0]);
    }

    private void scanForJavaFiles(List<SourceFile> sources, File sourceDirectory) {
        if (!sourceDirectory.exists()) {
            this.getLog().debug((CharSequence)(sourceDirectory.getAbsolutePath() + " is declared but doesn't exist"));
            return;
        }
        DirectoryScanner dirScanner = new DirectoryScanner();
        dirScanner.setBasedir(sourceDirectory);
        dirScanner.setIncludes(this.includes);
        dirScanner.setExcludes(this.excludes);
        dirScanner.scan();
        for (String includedPath : dirScanner.getIncludedFiles()) {
            if (!includedPath.endsWith(".java")) continue;
            sources.add(new SourceFile(new File(sourceDirectory, includedPath)));
        }
    }

    protected JSweetTranspiler createJSweetTranspiler(MavenProject project) throws MojoExecutionException {
        try {
            File sourceRoot;
            List<File> dependenciesFiles = this.getCandiesJars();
            String classPath = dependenciesFiles.stream().map(f -> f.getAbsolutePath()).collect(Collectors.joining(System.getProperty("path.separator")));
            this.logInfo("classpath from maven: " + classPath);
            File tsOutputDir = this.getTsOutDir();
            File jsOutDir = this.getJsOutDir();
            File declarationOutDir = this.getDeclarationsOutDir();
            this.logInfo("jsOut: " + jsOutDir);
            this.logInfo("bundle: " + this.bundle);
            this.logInfo("tsOut: " + tsOutputDir);
            this.logInfo("tsOnly: " + this.tsOnly);
            this.logInfo("tsserver: " + this.tsserver);
            this.logInfo("declarations: " + this.declaration);
            this.logInfo("ignoreDefinitions: " + this.ignoreDefinitions);
            this.logInfo("declarationOutDir: " + declarationOutDir);
            this.logInfo("candiesJsOutDir: " + this.candiesJsOut);
            this.logInfo("ecmaTargetVersion: " + this.targetVersion);
            this.logInfo("moduleKind: " + this.module);
            this.logInfo("sourceMap: " + this.sourceMap);
            this.logInfo("sourceRoot: " + this.sourceRoot);
            this.logInfo("verbose: " + this.verbose);
            this.logInfo("veryVerbose: " + this.veryVerbose);
            this.logInfo("jdkHome: " + this.jdkHome);
            this.logInfo("factoryClassName: " + this.factoryClassName);
            this.logInfo("ignoredProblems: " + this.ignoredProblems);
            JSweetConfig.initClassPath((String)this.jdkHome.getAbsolutePath());
            this.logInfo("extraSystemPath: " + this.extraSystemPath);
            if (StringUtils.isNotBlank((CharSequence)this.extraSystemPath)) {
                ProcessUtil.addExtraPath((String)this.extraSystemPath);
            }
            LogManager.getLogger((String)"org.jsweet").setLevel(Level.WARN);
            if (this.verbose != null && this.verbose.booleanValue()) {
                LogManager.getLogger((String)"org.jsweet").setLevel(Level.DEBUG);
            }
            if (this.veryVerbose != null && this.veryVerbose.booleanValue()) {
                LogManager.getLogger((String)"org.jsweet").setLevel(Level.ALL);
            }
            JSweetFactory factory = null;
            if (this.factoryClassName != null) {
                ClassRealm realm = this.descriptor.getClassRealm();
                List classpathElements = project.getRuntimeClasspathElements();
                classpathElements.addAll(project.getCompileClasspathElements());
                for (String element : classpathElements) {
                    File elementFile = new File(element);
                    realm.addURL(elementFile.toURI().toURL());
                }
                for (File dependencyFile : dependenciesFiles) {
                    realm.addURL(dependencyFile.toURI().toURL());
                }
                try {
                    Class c = realm.loadClass(this.factoryClassName);
                    factory = (JSweetFactory)c.newInstance();
                }
                catch (ClassNotFoundException e) {
                    this.logInfo("factory not found using ClassRealm.loadClass");
                    try {
                        URLClassLoader classLoader = new URLClassLoader(realm.getURLs(), Thread.currentThread().getContextClassLoader());
                        factory = (JSweetFactory)classLoader.loadClass(this.factoryClassName).newInstance();
                    }
                    catch (ClassNotFoundException e2) {
                        this.logInfo("factory not found using Thread.currentThread().getContextClassLoader().loadClass");
                        try {
                            factory = (JSweetFactory)Class.forName(this.factoryClassName).newInstance();
                        }
                        catch (ClassNotFoundException e3) {
                            this.logInfo("factory not found using Class.forName");
                            throw new MojoExecutionException("cannot find or instantiate factory class: " + this.factoryClassName + " (make sure the class is in the plugin's classpath and that it defines an empty public constructor)", (Exception)e3);
                        }
                    }
                }
            }
            if (factory == null) {
                factory = new JSweetFactory();
            }
            if (this.workingDir != null && !this.workingDir.isAbsolute()) {
                this.workingDir = new File(this.getBaseDirectory(), this.workingDir.getPath());
            }
            JSweetTranspiler transpiler = new JSweetTranspiler(this.getBaseDirectory(), null, factory, this.workingDir, tsOutputDir, jsOutDir, this.candiesJsOut, classPath);
            transpiler.setTscWatchMode(false);
            if (this.targetVersion != null) {
                transpiler.setEcmaTargetVersion(this.targetVersion);
            }
            if (this.module != null) {
                transpiler.setModuleKind(this.module);
            }
            if (this.bundle != null) {
                transpiler.setBundle(this.bundle.booleanValue());
            }
            if (this.tsserver != null) {
                transpiler.setUseTsserver(this.tsserver.booleanValue());
            }
            if (this.sourceMap != null) {
                transpiler.setGenerateSourceMaps(this.sourceMap.booleanValue());
            }
            if ((sourceRoot = this.getSourceRoot()) != null) {
                transpiler.setSourceRoot(sourceRoot);
            }
            if (this.encoding != null) {
                transpiler.setEncoding(this.encoding);
            }
            if (this.noRootDirectories != null) {
                transpiler.setNoRootDirectories(this.noRootDirectories.booleanValue());
            }
            if (this.enableAssertions != null) {
                transpiler.setIgnoreAssertions(this.enableAssertions == false);
            }
            if (this.declaration != null) {
                transpiler.setGenerateDeclarations(this.declaration.booleanValue());
            }
            if (declarationOutDir != null) {
                transpiler.setDeclarationsOutputDir(declarationOutDir);
            }
            if (this.ignoreDefinitions != null) {
                transpiler.setGenerateDefinitions(this.ignoreDefinitions == false);
            }
            if (this.tsOnly != null) {
                transpiler.setGenerateJsFiles(this.tsOnly == false);
            }
            if (this.ignoreTypeScriptErrors != null) {
                transpiler.setIgnoreTypeScriptErrors(this.ignoreTypeScriptErrors.booleanValue());
            }
            if (this.header != null) {
                transpiler.setHeaderFile(this.header);
            }
            if (this.disableSinglePrecisionFloats != null) {
                transpiler.setDisableSinglePrecisionFloats(this.disableSinglePrecisionFloats.booleanValue());
            }
            if (this.moduleResolution != null) {
                transpiler.setModuleResolution(this.moduleResolution);
            }
            if (tsOutputDir != null) {
                transpiler.setTsOutputDir(tsOutputDir);
            }
            if (jsOutDir != null) {
                transpiler.setJsOutputDir(jsOutDir);
            }
            return transpiler;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"failed to create transpiler", (Throwable)e);
            throw new MojoExecutionException("failed to create transpiler", e);
        }
    }

    protected File getDeclarationsOutDir() throws IOException {
        File declarationOutDir = null;
        if (StringUtils.isNotBlank((CharSequence)this.dtsOut)) {
            File dtsOutFile = new File(this.dtsOut);
            if (!dtsOutFile.isAbsolute()) {
                dtsOutFile = new File(this.getBaseDirectory(), this.dtsOut);
            }
            return dtsOutFile.getCanonicalFile();
        }
        return declarationOutDir;
    }

    protected File getSourceRoot() throws IOException {
        File sourceRoot = null;
        if (StringUtils.isNotBlank((CharSequence)this.sourceRoot)) {
            File sourceRootFile = new File(this.sourceRoot);
            if (!sourceRootFile.isAbsolute()) {
                sourceRootFile = new File(this.getBaseDirectory(), this.sourceRoot);
            }
            return sourceRootFile.getCanonicalFile();
        }
        return sourceRoot;
    }

    protected File getJsOutDir() throws IOException {
        if (StringUtils.isNotBlank((CharSequence)this.outDir)) {
            File jsOutFile = new File(this.outDir);
            if (!jsOutFile.isAbsolute()) {
                jsOutFile = new File(this.getBaseDirectory(), this.outDir);
            }
            return jsOutFile.getCanonicalFile();
        }
        return null;
    }

    protected File getBaseDirectory() throws IOException {
        return this.getMavenProject().getBasedir().getAbsoluteFile();
    }

    protected File getTsOutDir() throws IOException {
        if (StringUtils.isNotBlank((CharSequence)this.tsOut)) {
            File tsOutFile = new File(this.tsOut);
            if (!tsOutFile.isAbsolute()) {
                tsOutFile = new File(this.getBaseDirectory(), this.tsOut);
            }
            return tsOutFile.getCanonicalFile();
        }
        return null;
    }

    protected List<File> getCandiesJars() throws ArtifactResolutionException, ArtifactNotFoundException {
        MavenProject project = this.getMavenProject();
        List dependencies = project.getDependencies();
        this.logInfo("dependencies=" + dependencies);
        LinkedList<Artifact> directDependencies = new LinkedList<Artifact>();
        for (Dependency dependency : dependencies) {
            if (!dependency.getType().equals("jar")) {
                this.getLog().warn((CharSequence)("dependency type not-jar excluded from candies detection: " + dependency));
                continue;
            }
            Artifact mavenArtifact = this.artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "compile", "jar");
            this.logInfo("candies detection: add project dependency " + dependency + " => " + mavenArtifact);
            directDependencies.add(mavenArtifact);
        }
        ArtifactResolutionResult dependenciesResolutionResult = this.resolver.resolveTransitively(new HashSet(directDependencies), project.getArtifact(), this.remoteRepositories, this.localRepository, this.metadataSource);
        Set allDependenciesArtifacts = dependenciesResolutionResult.getArtifactResolutionNodes();
        this.logInfo("all candies artifacts: " + allDependenciesArtifacts);
        LinkedList<File> dependenciesFiles = new LinkedList<File>();
        for (ResolutionNode depResult : allDependenciesArtifacts) {
            dependenciesFiles.add(depResult.getArtifact().getFile());
        }
        this.logInfo("candies jars: " + dependenciesFiles);
        return dependenciesFiles;
    }

    protected MavenProject getMavenProject() {
        Map ctx = this.getPluginContext();
        MavenProject project = (MavenProject)ctx.get("project");
        return project;
    }

    protected void transpile(MavenProject project, JSweetTranspiler transpiler) throws MojoExecutionException {
        try {
            JSweetMavenPluginTranspilationHandler transpilationHandler = new JSweetMavenPluginTranspilationHandler();
            try {
                SourceFile[] sources = this.collectSourceFiles(project);
                transpiler.transpile((TranspilationHandler)transpilationHandler, null, sources);
            }
            catch (NoClassDefFoundError error) {
                error.printStackTrace();
                transpilationHandler.report(JSweetProblem.JAVA_COMPILER_NOT_FOUND, null, JSweetProblem.JAVA_COMPILER_NOT_FOUND.getMessage(new Object[0]));
            }
            int errorCount = transpilationHandler.getErrorCount();
            if (errorCount > 0) {
                throw new MojoFailureException("transpilation failed with " + errorCount + " error(s) and " + transpilationHandler.getWarningCount() + " warning(s)");
            }
            if (transpilationHandler.getWarningCount() > 0) {
                this.getLog().info((CharSequence)("transpilation completed with " + transpilationHandler.getWarningCount() + " warning(s)"));
            } else {
                this.getLog().info((CharSequence)"transpilation successfully completed with no errors and no warnings");
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"transpilation failed", (Throwable)e);
            throw new MojoExecutionException("transpilation failed", e);
        }
    }

    private class JSweetMavenPluginTranspilationHandler
    extends ErrorCountTranspilationHandler {
        public JSweetMavenPluginTranspilationHandler() {
            super((TranspilationHandler)new ConsoleTranspilationHandler());
        }

        public void report(JSweetProblem problem, SourcePosition sourcePosition, String message) {
            if (AbstractJSweetMojo.this.ignoredProblems != null && AbstractJSweetMojo.this.ignoredProblems.contains(problem)) {
                return;
            }
            super.report(problem, sourcePosition, message);
        }
    }
}

