var ktbyte;
(function (ktbyte) {
    var sprite;
    (function (sprite) {
        /**
         * Initializes the Sprite with the given image URL, coordinates and size.
         * @param {string} url  The URL of the image for the Sprite to use.
         * @param {number} x    The initial x coordinate of the Sprite
         * @param {number} y    The initial y coordinate of the Sprite
         * @param {number} w    The initial width of the Sprite
         * @param {number} h    The initial height of the Sprite
         * @class
         */
        var Sprite = (function () {
            function Sprite(url, x, y, w, h) {
                var _this = this;
                /*private*/ this._front = 0;
                /*private*/ this._hitboxCenter = new PVector();
                /*private*/ this._flipped = false;
                /*private*/ this.out = new PVector(-10000, -10000);
                if (((typeof url === 'string') || url === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                    var __args = arguments;
                    if (this._img === undefined)
                        this._img = null;
                    if (this._w === undefined)
                        this._w = 0;
                    if (this._h === undefined)
                        this._h = 0;
                    if (this._x === undefined)
                        this._x = 0;
                    if (this._y === undefined)
                        this._y = 0;
                    if (this._rotVector === undefined)
                        this._rotVector = null;
                    if (this._hitbox === undefined)
                        this._hitbox = null;
                    this._front = 0;
                    this._hitboxCenter = new PVector();
                    this._flipped = false;
                    this.out = new PVector(-10000, -10000);
                    if (this._img === undefined)
                        this._img = null;
                    if (this._w === undefined)
                        this._w = 0;
                    if (this._h === undefined)
                        this._h = 0;
                    if (this._x === undefined)
                        this._x = 0;
                    if (this._y === undefined)
                        this._y = 0;
                    if (this._rotVector === undefined)
                        this._rotVector = null;
                    if (this._hitbox === undefined)
                        this._hitbox = null;
                    (function () {
                        _this._img = _this.getPApplet().loadImage(url);
                        _this._x = x;
                        _this._y = y;
                        _this._w = w;
                        _this._h = h;
                        _this._rotVector = new PVector(1, 0, 0);
                        _this.resetRectHitbox();
                    })();
                }
                else if (((typeof url === 'number') || url === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                    var __args = arguments;
                    var x_1 = __args[0];
                    var y_1 = __args[1];
                    var w_1 = __args[2];
                    var h_1 = __args[3];
                    if (this._img === undefined)
                        this._img = null;
                    if (this._w === undefined)
                        this._w = 0;
                    if (this._h === undefined)
                        this._h = 0;
                    if (this._x === undefined)
                        this._x = 0;
                    if (this._y === undefined)
                        this._y = 0;
                    if (this._rotVector === undefined)
                        this._rotVector = null;
                    if (this._hitbox === undefined)
                        this._hitbox = null;
                    this._front = 0;
                    this._hitboxCenter = new PVector();
                    this._flipped = false;
                    this.out = new PVector(-10000, -10000);
                    if (this._img === undefined)
                        this._img = null;
                    if (this._w === undefined)
                        this._w = 0;
                    if (this._h === undefined)
                        this._h = 0;
                    if (this._x === undefined)
                        this._x = 0;
                    if (this._y === undefined)
                        this._y = 0;
                    if (this._rotVector === undefined)
                        this._rotVector = null;
                    if (this._hitbox === undefined)
                        this._hitbox = null;
                    (function () {
                        _this._img = _this.getPApplet().createImage(1, 1, PConstants.RGB);
                        _this._x = x_1;
                        _this._y = y_1;
                        _this._w = w_1;
                        _this._h = h_1;
                        _this._rotVector = new PVector(1, 0, 0);
                        _this.resetRectHitbox();
                    })();
                }
                else if (((url != null && url instanceof ktbyte.sprite.Sprite) || url === null) && x === undefined && y === undefined && w === undefined && h === undefined) {
                    var __args = arguments;
                    var s_1 = __args[0];
                    if (this._img === undefined)
                        this._img = null;
                    if (this._w === undefined)
                        this._w = 0;
                    if (this._h === undefined)
                        this._h = 0;
                    if (this._x === undefined)
                        this._x = 0;
                    if (this._y === undefined)
                        this._y = 0;
                    if (this._rotVector === undefined)
                        this._rotVector = null;
                    if (this._hitbox === undefined)
                        this._hitbox = null;
                    this._front = 0;
                    this._hitboxCenter = new PVector();
                    this._flipped = false;
                    this.out = new PVector(-10000, -10000);
                    if (this._img === undefined)
                        this._img = null;
                    if (this._w === undefined)
                        this._w = 0;
                    if (this._h === undefined)
                        this._h = 0;
                    if (this._x === undefined)
                        this._x = 0;
                    if (this._y === undefined)
                        this._y = 0;
                    if (this._rotVector === undefined)
                        this._rotVector = null;
                    if (this._hitbox === undefined)
                        this._hitbox = null;
                    (function () {
                        _this._img = s_1._img;
                        _this._x = s_1._x;
                        _this._y = s_1._y;
                        _this._w = s_1._w;
                        _this._h = s_1._h;
                        _this._rotVector = new PVector(s_1._rotVector.x, s_1._rotVector.y, 0);
                        _this._front = s_1._front;
                        _this._hitboxCenter = new PVector(s_1._hitboxCenter.x, s_1._hitboxCenter.y);
                        _this._hitbox = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(s_1._hitbox.length);
                        for (var i = 0; i < _this._hitbox.length; i++) {
                            {
                                _this._hitbox[i] = new PVector(s_1._hitbox[i].x, s_1._hitbox[i].y);
                            }
                            ;
                        }
                        _this._flipped = s_1._flipped;
                    })();
                }
                else
                    throw new Error('invalid overload');
            }
            Sprite.init = function (pa) {
                Sprite.forcedStaticPApplet = pa;
            };
            /*private*/ Sprite.prototype.getPApplet = function () {
                if (Sprite.forcedStaticPApplet != null) {
                    return Sprite.forcedStaticPApplet;
                }
                var currentApplet = (eval("MainPApplet.current"));
                if (currentApplet != null) {
                    return currentApplet;
                }
                throw new Error("Sprite is not bound to a PApplet. Please call Sprite.init(this) before");
            };
            /**
             * Adjust the direction of the PImage of the Sprite
             * without changing its orientation
             * @param {number} degrees      The degrees of turn to adjust the PImage
             */
            Sprite.prototype.frontAngle = function (degrees) {
                var newFront = PApplet.radians(degrees);
                this._rotVector.rotate(Math.fround(newFront - this._front));
                this._front = newFront;
            };
            /**
             * Adjusts the Sprite's hitbox, which is set to the Sprite's
             * width and height by default.
             * @param {number} w    The width of the hitbox
             * @param {number} h    The height of the hitbox
             */
            Sprite.prototype.setRectHitbox = function (w, h) {
                this._hitbox = [new PVector(Math.fround(-w / 2), Math.fround(h / 2)), new PVector(Math.fround(-w / 2), Math.fround(-h / 2)), new PVector(Math.fround(w / 2), Math.fround(-h / 2)), new PVector(Math.fround(w / 2), Math.fround(h / 2))];
            };
            /**
             * Resets the Sprite's hitbox to its own width and height
             */
            Sprite.prototype.resetRectHitbox = function () {
                this.setRectHitbox(this._w, this._h);
            };
            /**
             * Sets the Sprite's hitbox to a circle.
             * @param {number} r     The radius of the circle
             */
            Sprite.prototype.setRoundHitbox = function (r) {
                this._hitbox = [new PVector(r, Math.fround(r * 2))];
            };
            /**
             * Sets the Sprite's hitbox to a circle with radius
             * equals to (sum of its width and height) / 4.
             */
            Sprite.prototype.resetRoundHitbox = function () {
                this.setRoundHitbox(Math.fround((Math.fround(this._w + this._h)) / 4));
            };
            /**
             * Recenter the Sprite's hitbox relative to its center
             * @param {number} x     the offset in the x direction, in pixels
             * @param {number} y     the offset in the y direction, in pixels
             */
            Sprite.prototype.setHitboxCenter = function (x, y) {
                this._hitboxCenter = new PVector(x, y);
            };
            /**
             * Recenter the Sprite's hitbox to its center
             */
            Sprite.prototype.resetHitboxCenter = function () {
                this._hitboxCenter = new PVector(0, 0);
            };
            /**
             * Set the Sprite's hitbox to a polygon defined by
             * a list of PVectors (points) relative to its center
             * @param {Array} array         An array of points definig the hitbox polygon
             */
            Sprite.prototype.setHitboxPoints = function (array) {
                if (array.length > 0) {
                    var valid = true;
                    for (var index121 = 0; index121 < array.length; index121++) {
                        var pv = array[index121];
                        if (pv == null)
                            valid = false;
                    }
                    if (valid) {
                        this._hitbox = array;
                    }
                    else {
                        PApplet.print("invalid hitbox: ");
                        for (var index122 = 0; index122 < array.length; index122++) {
                            var pv = array[index122];
                            {
                                pv.toString();
                            }
                        }
                        PApplet.println();
                    }
                }
                else {
                    PApplet.print("hitbox must have 3+ points: ");
                    for (var index123 = 0; index123 < array.length; index123++) {
                        var pv = array[index123];
                        {
                            pv.toString();
                        }
                    }
                    PApplet.println();
                }
            };
            /**
             * Changes the color of a Sprite. This function is only supported
             * for Sprites created without an image.
             * @param {number} r     The first parameter defining the color.
             * In default RGB mode, this is the red value.
             * @param {number} g     The second parameter defining the color.
             * In default RGB mode, this is the green value.
             * @param {number} b     The third parameter defining the color.
             * In default RGB mode, this is the blue value.
             */
            Sprite.prototype.setColor = function (r, g, b) {
                var c = this.getPApplet().color(r, g, b);
                for (var x = 0; x < this._img.width; x++) {
                    {
                        for (var y = 0; y < this._img.height; y++) {
                            {
                                this._img.set(x, y, c);
                            }
                            ;
                        }
                    }
                    ;
                }
            };
            /**
             * Flips Sprite image across its X axis
             */
            Sprite.prototype.flip = function () {
                this._flipped = !this._flipped;
            };
            /**
             * Rotates the Sprite by a specified number of degrees
             * @param {number} degrees       The number of degrees to turn
             */
            Sprite.prototype.turn = function (degrees) {
                this._rotVector.rotate(PApplet.radians(degrees));
            };
            /**
             * Rotates the Sprite to face the specified (x, y) location
             * @param {number} x       The x coordinate of the point to face
             * @param {number} y       The y coordinate of the point to face
             */
            Sprite.prototype.turnToPoint = function (x, y) {
                this._rotVector.set(Math.fround(x - this._x), Math.fround(y - this._y), 0);
                this._rotVector.setMag(1);
            };
            /**
             * Rotates the Sprite to specified (absolute) angle.
             * @param {number} angle         The direction to turn to
             */
            Sprite.prototype.turnToDir = function (angle) {
                var radian = PApplet.radians(angle);
                this._rotVector.set(PApplet.cos(radian), PApplet.sin(radian));
                this._rotVector.setMag(1);
            };
            /**
             * Rotates the Sprite to the specified Sprite s
             * @param {ktbyte.sprite.Sprite} s     The Sprite to turn to
             */
            Sprite.prototype.turnToSprite = function (s) {
                this.turnToPoint(s._x, s._y);
            };
            /**
             * Moves the Sprite to the specified coordinate.
             * @param {number} x     The x coordinate of the point to move to
             * @param {number} y     The y coordinate of the point to move to
             */
            Sprite.prototype.moveToPoint = function (x, y) {
                this._x = x;
                this._y = y;
            };
            /**
             * Moves the Sprite to the specified Sprite s
             * @param {ktbyte.sprite.Sprite} s     The Sprite to move to
             */
            Sprite.prototype.moveToSprite = function (s) {
                this._x = s._x;
                this._y = s._y;
            };
            /**
             * Moves the Sprite in the x axis by the specified amount.
             * @param {number} x     The amount to move in pixels
             */
            Sprite.prototype.moveX = function (x) {
                this._x += x;
            };
            /**
             * Moves the Sprite in the y axis by the specified amount.
             * @param {number} y     The amount to move in pixels
             */
            Sprite.prototype.moveY = function (y) {
                this._y += y;
            };
            /**
             * Moves the Sprite in the x and y axes by the specified amounts.
             * @param x     The amount to move in pixels in the x axis
             * @param y     The amount to move in pixels in the y axis
             * @param {number} dx
             * @param {number} dy
             */
            Sprite.prototype.moveXY = function (dx, dy) {
                this._x += dx;
                this._y += dy;
            };
            /**
             * Moves the Sprite forward in the direction it is facing.
             * @param {number} steps The amount to move in pixels.
             */
            Sprite.prototype.forward = function (steps) {
                this._x += Math.fround(this._rotVector.x * steps);
                this._y += Math.fround(this._rotVector.y * steps);
            };
            /**
             * Moves the Sprite in the direction 90 degrees clockwise from its forward direction.
             * @param {number} steps The amount to move in pixels.
             */
            Sprite.prototype.sideStep = function (steps) {
                this._rotVector.rotate(Math.fround(PConstants.PI / 2));
                this._x += Math.fround(this._rotVector.x * steps);
                this._y += Math.fround(this._rotVector.y * steps);
                this._rotVector.rotate(Math.fround(-PConstants.PI / 2));
            };
            /**
             * Draws the Sprite. This function should be called in the <code>void draw()</code> function.
             */
            Sprite.prototype.display = function () {
                this.getPApplet().pushMatrix();
                this.getPApplet().pushStyle();
                this.getPApplet().translate(this._x, this._y);
                this.getPApplet().rotate(Math.fround(this._rotVector.heading() - this._front));
                if (this._flipped)
                    this.getPApplet().scale(-1, 1);
                this.getPApplet().imageMode(PConstants.CENTER);
                this.getPApplet().image(this._img, 0, 0, this._w, this._h);
                this.getPApplet().popStyle();
                this.getPApplet().popMatrix();
            };
            /**
             * Draws the Sprite's hitbox. This function should be called in the <code>void draw()</code> function.
             */
            Sprite.prototype.displayHitbox = function () {
                var cen = this._getCenter();
                this.getPApplet().pushStyle();
                this.getPApplet().stroke(255, 0, 0);
                this.getPApplet().strokeWeight(5);
                this.getPApplet().noFill();
                if (this._hitbox.length === 1) {
                    this.getPApplet().ellipseMode(PConstants.CENTER);
                    this.getPApplet().ellipse(cen.x, cen.y, this._hitbox[0].y, this._hitbox[0].y);
                }
                else {
                    var corners = this._getPoints();
                    for (var i = 0; i < corners.length; i++) {
                        {
                            var a = corners[i];
                            var b = corners[(i + 1) % corners.length];
                            this.getPApplet().line(a.x, a.y, b.x, b.y);
                        }
                        ;
                    }
                }
                this.getPApplet().line(cen.x, cen.y, Math.fround(cen.x + Math.fround(this._rotVector.x * 20)), Math.fround(cen.y + Math.fround(this._rotVector.y * 20)));
                this.getPApplet().fill(255, 0, 0);
                this.getPApplet().noStroke();
                this.getPApplet().ellipse(cen.x, cen.y, 15, 15);
                this.getPApplet().popStyle();
            };
            /**
             * Changes the direction of the Sprite by flipping
             * the x component of its direction
             */
            Sprite.prototype.flipX = function () {
                this._rotVector.x *= -1;
            };
            /**
             * Changes the direction of the Sprite by flipping
             * the y component of its direction
             */
            Sprite.prototype.flipY = function () {
                this._rotVector.y *= -1;
            };
            /**
             * Sets the size of the Sprite. The Sprite's hitbox is automatically
             * reset to be rectangular with the same size as the Sprite's new size.
             * @param {number} w     The width of the Sprite
             * @param {number} h     The height of the Sprite
             */
            Sprite.prototype.setSize = function (w, h) {
                this._w = w;
                this._h = h;
                this.resetRectHitbox();
            };
            /**
             * Moves the Sprite to the specified coordinate.
             * @param {number} x     The x coordinate of the point to move to
             * @param {number} y     The y coordinate of the point to move to
             */
            Sprite.prototype.setCoor = function (x, y) {
                this._x = x;
                this._y = y;
            };
            Sprite.prototype.setX = function (x) {
                this._x = x;
            };
            Sprite.prototype.setY = function (y) {
                this._y = y;
            };
            /**
             * Changes the image of the Sprite
             * @param {PImage} img   The image to set the Sprite to
             */
            Sprite.prototype.setImage = function (img) {
                this._img = img;
            };
            /**
             * Gets the x coordinate of the Sprite
             * @return {number} the x coordinate of the sprite
             */
            Sprite.prototype.getX = function () {
                return this._x;
            };
            /**
             * Gets the y coordinate of the Sprite
             * @return {number} the y coordinate of the sprite
             */
            Sprite.prototype.getY = function () {
                return this._y;
            };
            /**
             * Gets the width of the Sprite
             * @return {number} the width of the sprite
             */
            Sprite.prototype.getW = function () {
                return this._w;
            };
            /**
             * Gets the height of the Sprite
             * @return {number} the height of the sprite
             */
            Sprite.prototype.getH = function () {
                return this._h;
            };
            /**
             * Gets the image of the Sprite
             * @return {PImage} the image of the sprite
             */
            Sprite.prototype.getImage = function () {
                return this._img;
            };
            /**
             * Gets the direction of the Sprite
             * @return {number} the direction (in degrees) the Sprite in facing
             */
            Sprite.prototype.getDir = function () {
                return PApplet.degrees(this._rotVector.heading());
            };
            /**
             * Calculates the distance from this Sprite to Sprite s
             * @return {number} the distance from this Sprite to Sprite s
             * @param {ktbyte.sprite.Sprite} s     The Sprite to measure distance to
             */
            Sprite.prototype.distTo = function (s) {
                return PApplet.dist(this._x, this._y, s._x, s._y);
            };
            /**
             * Calculates the distance from this Sprite to the specified point
             * @return {number} the distance from this Sprite to the specified point
             * @param {number} x     The x coordinate of the point
             * @param {number} y     The y coordinate of the point
             */
            Sprite.prototype.distToPoint = function (x, y) {
                return PApplet.dist(this._x, this._y, x, y);
            };
            /**
             * Checks to see if this Sprite is touching Sprite s.
             * @return {boolean} true if this Sprite is touching Sprite s, false otherwise
             * @param {ktbyte.sprite.Sprite} s     The Sprite to detect whethet this Sprite is touching
             */
            Sprite.prototype.touchingSprite = function (s) {
                if (s._hitbox.length === 1) {
                    if (this._hitbox.length === 1) {
                        return PVector.dist(this._getCenter(), s._getCenter()) <= Math.fround(this._hitbox[0].x + s._hitbox[0].x);
                    }
                    return this._circPoly(s._getCenter(), s._hitbox[0].x, this._getPoints());
                }
                if (this._hitbox.length === 1) {
                    return this._circPoly(this._getCenter(), this._hitbox[0].x, s._getPoints());
                }
                var s1Points = s._getPoints();
                var s2Points = this._getPoints();
                for (var i = 0; i < s1Points.length; i++) {
                    {
                        var a = s1Points[i];
                        var b = s1Points[(i + 1) % s1Points.length];
                        for (var j = 0; j < s2Points.length; j++) {
                            {
                                var c = s2Points[j];
                                var d = s2Points[(j + 1) % s2Points.length];
                                if (this._clockwise(a, c, d) !== this._clockwise(b, c, d) && this._clockwise(a, b, c) !== this._clockwise(a, b, d)) {
                                    return true;
                                }
                            }
                            ;
                        }
                    }
                    ;
                }
                return this._insidePts(s1Points, s2Points) || this._insidePts(s2Points, s1Points);
            };
            /**
             * Checks to see if this Sprite is fully inside another sprite.
             * @return {boolean} true if this Sprite is touching Sprite s, false otherwise
             * @param {ktbyte.sprite.Sprite} s     The Sprite to detect whethet this Sprite is touching
             */
            Sprite.prototype.insideSprite = function (s) {
                if (s._hitbox.length === 1) {
                    if (this._hitbox.length === 1) {
                        return PVector.dist(s._getCenter(), this._getCenter()) < Math.fround(s._hitbox[0].x - this._hitbox[0].x);
                    }
                    return this._insideCirc(this._getPoints(), s._getCenter(), s._hitbox[0].x);
                }
                if (s._hitbox.length === 1) {
                    return false;
                }
                return this._insidePts(this._getPoints(), s._getPoints());
            };
            /**
             * Checks whether this Sprite is touching the specified point.
             * @return {boolean} true if this Sprite is touching the point, false otherwise
             * @param {number} x     The x coordinate of the point
             * @param {number} y     The y coordinate of the point
             */
            Sprite.prototype.touchingPoint = function (x, y) {
                if (this._hitbox.length === 1)
                    return PApplet.dist(x, y, this._hitboxCenter.x, this._hitboxCenter.y) < this._hitbox[0].x;
                return this._ptPoly(new PVector(x, y), this._getPoints());
            };
            /**
             * Checks whether this Sprite's hitbox is at least partially inside the canvas
             * @return {boolean} true if this Sprite is at least partially inside the canvas, false otherwise
             */
            Sprite.prototype.isInsideScreen = function () {
                if (this._hitbox.length === 1) {
                    var r = this._hitbox[0].x;
                    var c = this._getCenter();
                    return 0 <= Math.fround(c.x + r) && Math.fround(c.x - r) < this.getPApplet().width && 0 <= Math.fround(c.y + r) && Math.fround(c.y - r) < this.getPApplet().height;
                }
                var points = this._getPoints();
                for (var index124 = 0; index124 < points.length; index124++) {
                    var p = points[index124];
                    {
                        if (0 <= p.x && p.x < this.getPApplet().width && 0 <= p.y && p.y < this.getPApplet().height) {
                            return true;
                        }
                    }
                }
                return false;
            };
            /*private*/ Sprite.prototype._ptPoly = function (pt, poly) {
                var count = 0;
                for (var i = 0; i < poly.length; i++) {
                    {
                        var a = poly[i];
                        var b = poly[(i + 1) % poly.length];
                        if (this._clockwise(a, pt, this.out) !== this._clockwise(b, pt, this.out) && this._clockwise(a, b, pt) !== this._clockwise(a, b, this.out)) {
                            count++;
                        }
                    }
                    ;
                }
                return count % 2 === 1;
            };
            /*private*/ Sprite.prototype._circPoly = function (center, r, poly) {
                if (this._ptPoly(center, poly))
                    return true;
                if (this._insideCirc(poly, center, r))
                    return true;
                for (var index125 = 0; index125 < poly.length; index125++) {
                    var corner = poly[index125];
                    {
                        if (PApplet.dist(center.x, center.y, corner.x, corner.y) < r)
                            return true;
                    }
                }
                for (var i = 0; i < poly.length; i++) {
                    {
                        if (this._circSeg(center, r, poly[i], poly[(i + 1) % poly.length]))
                            return true;
                    }
                    ;
                }
                return false;
            };
            /*private*/ Sprite.prototype._circSeg = function (center, r, a, b) {
                var ab = PVector.sub(b, a);
                var abPerp = (new PVector(-ab.y, ab.x)).normalize().mult(r);
                var limits = [PVector.add(a, abPerp), PVector.sub(a, abPerp), PVector.sub(b, abPerp), PVector.add(b, abPerp)];
                return this._ptPoly(center, limits);
            };
            /*private*/ Sprite.prototype._insidePts = function (inPts, outPts) {
                for (var i = 0; i < inPts.length; i++) {
                    {
                        if (!this._ptPoly(inPts[i], outPts))
                            return false;
                    }
                    ;
                }
                return true;
            };
            /*private*/ Sprite.prototype._insideCirc = function (inPts, center, r) {
                for (var i = 0; i < inPts.length; i++) {
                    {
                        if (PVector.dist(inPts[i], center) > r)
                            return false;
                    }
                    ;
                }
                return true;
            };
            /*private*/ Sprite.prototype._getCenter = function () {
                var cen = new PVector(this._hitboxCenter.x, this._hitboxCenter.y);
                cen.rotate(Math.fround(this._rotVector.heading() - this._front));
                cen.x += this._x;
                cen.y += this._y;
                return cen;
            };
            /*private*/ Sprite.prototype._getPoints = function () {
                var cen = this._getCenter();
                var points = (function (s) { var a = []; while (s-- > 0)
                    a.push(null); return a; })(this._hitbox.length);
                var angle = this._rotVector.heading();
                for (var i = 0; i < this._hitbox.length; i++) {
                    {
                        points[i] = new PVector(this._hitbox[i].x, this._hitbox[i].y);
                        points[i].rotate(angle);
                        points[i].x += cen.x;
                        points[i].y += cen.y;
                    }
                    ;
                }
                return points;
            };
            /*private*/ Sprite.prototype._clockwise = function (A, B, C) {
                return Math.fround((Math.fround(C.y - A.y)) * (Math.fround(B.x - A.x))) > Math.fround((Math.fround(B.y - A.y)) * (Math.fround(C.x - A.x)));
            };
            return Sprite;
        }());
        Sprite.forcedStaticPApplet = null;
        sprite.Sprite = Sprite;
        Sprite["__class"] = "ktbyte.sprite.Sprite";
    })(sprite = ktbyte.sprite || (ktbyte.sprite = {}));
})(ktbyte || (ktbyte = {}));
