declare namespace ktbyte.sprite {
}
declare namespace ktbyte.sprite {
    /**
     * Initializes the Sprite with the given image URL, coordinates and size.
     * @param {string} url  The URL of the image for the Sprite to use.
     * @param {number} x    The initial x coordinate of the Sprite
     * @param {number} y    The initial y coordinate of the Sprite
     * @param {number} w    The initial width of the Sprite
     * @param {number} h    The initial height of the Sprite
     * @class
     */
    class Sprite {
        static forcedStaticPApplet: any;
        _img: PImage;
        _w: number;
        _h: number;
        _x: number;
        _y: number;
        _rotVector: PVector;
        _front: number;
        _hitboxCenter: PVector;
        _hitbox: PVector[];
        _flipped: boolean;
        out: PVector;
        static init(pa: any): void;
        getPApplet(): any;
        constructor(url?: any, x?: any, y?: any, w?: any, h?: any);
        /**
         * Adjust the direction of the PImage of the Sprite
         * without changing its orientation
         * @param {number} degrees      The degrees of turn to adjust the PImage
         */
        frontAngle(degrees: number): void;
        /**
         * Adjusts the Sprite's hitbox, which is set to the Sprite's
         * width and height by default.
         * @param {number} w    The width of the hitbox
         * @param {number} h    The height of the hitbox
         */
        setRectHitbox(w: number, h: number): void;
        /**
         * Resets the Sprite's hitbox to its own width and height
         */
        resetRectHitbox(): void;
        /**
         * Sets the Sprite's hitbox to a circle.
         * @param {number} r     The radius of the circle
         */
        setRoundHitbox(r: number): void;
        /**
         * Sets the Sprite's hitbox to a circle with radius
         * equals to (sum of its width and height) / 4.
         */
        resetRoundHitbox(): void;
        /**
         * Recenter the Sprite's hitbox relative to its center
         * @param {number} x     the offset in the x direction, in pixels
         * @param {number} y     the offset in the y direction, in pixels
         */
        setHitboxCenter(x: number, y: number): void;
        /**
         * Recenter the Sprite's hitbox to its center
         */
        resetHitboxCenter(): void;
        /**
         * Set the Sprite's hitbox to a polygon defined by
         * a list of PVectors (points) relative to its center
         * @param {Array} array         An array of points definig the hitbox polygon
         */
        setHitboxPoints(array: PVector[]): void;
        /**
         * Changes the color of a Sprite. This function is only supported
         * for Sprites created without an image.
         * @param {number} r     The first parameter defining the color.
         * In default RGB mode, this is the red value.
         * @param {number} g     The second parameter defining the color.
         * In default RGB mode, this is the green value.
         * @param {number} b     The third parameter defining the color.
         * In default RGB mode, this is the blue value.
         */
        setColor(r: number, g: number, b: number): void;
        /**
         * Flips Sprite image across its X axis
         */
        flip(): void;
        /**
         * Rotates the Sprite by a specified number of degrees
         * @param {number} degrees       The number of degrees to turn
         */
        turn(degrees: number): void;
        /**
         * Rotates the Sprite to face the specified (x, y) location
         * @param {number} x       The x coordinate of the point to face
         * @param {number} y       The y coordinate of the point to face
         */
        turnToPoint(x: number, y: number): void;
        /**
         * Rotates the Sprite to specified (absolute) angle.
         * @param {number} angle         The direction to turn to
         */
        turnToDir(angle: number): void;
        /**
         * Rotates the Sprite to the specified Sprite s
         * @param {ktbyte.sprite.Sprite} s     The Sprite to turn to
         */
        turnToSprite(s: Sprite): void;
        /**
         * Moves the Sprite to the specified coordinate.
         * @param {number} x     The x coordinate of the point to move to
         * @param {number} y     The y coordinate of the point to move to
         */
        moveToPoint(x: number, y: number): void;
        /**
         * Moves the Sprite to the specified Sprite s
         * @param {ktbyte.sprite.Sprite} s     The Sprite to move to
         */
        moveToSprite(s: Sprite): void;
        /**
         * Moves the Sprite in the x axis by the specified amount.
         * @param {number} x     The amount to move in pixels
         */
        moveX(x: number): void;
        /**
         * Moves the Sprite in the y axis by the specified amount.
         * @param {number} y     The amount to move in pixels
         */
        moveY(y: number): void;
        /**
         * Moves the Sprite in the x and y axes by the specified amounts.
         * @param x     The amount to move in pixels in the x axis
         * @param y     The amount to move in pixels in the y axis
         * @param {number} dx
         * @param {number} dy
         */
        moveXY(dx: number, dy: number): void;
        /**
         * Moves the Sprite forward in the direction it is facing.
         * @param {number} steps The amount to move in pixels.
         */
        forward(steps: number): void;
        /**
         * Moves the Sprite in the direction 90 degrees clockwise from its forward direction.
         * @param {number} steps The amount to move in pixels.
         */
        sideStep(steps: number): void;
        /**
         * Draws the Sprite. This function should be called in the <code>void draw()</code> function.
         */
        display(): void;
        /**
         * Draws the Sprite's hitbox. This function should be called in the <code>void draw()</code> function.
         */
        displayHitbox(): void;
        /**
         * Changes the direction of the Sprite by flipping
         * the x component of its direction
         */
        flipX(): void;
        /**
         * Changes the direction of the Sprite by flipping
         * the y component of its direction
         */
        flipY(): void;
        /**
         * Sets the size of the Sprite. The Sprite's hitbox is automatically
         * reset to be rectangular with the same size as the Sprite's new size.
         * @param {number} w     The width of the Sprite
         * @param {number} h     The height of the Sprite
         */
        setSize(w: number, h: number): void;
        /**
         * Moves the Sprite to the specified coordinate.
         * @param {number} x     The x coordinate of the point to move to
         * @param {number} y     The y coordinate of the point to move to
         */
        setCoor(x: number, y: number): void;
        setX(x: number): void;
        setY(y: number): void;
        /**
         * Changes the image of the Sprite
         * @param {PImage} img   The image to set the Sprite to
         */
        setImage(img: PImage): void;
        /**
         * Gets the x coordinate of the Sprite
         * @return {number} the x coordinate of the sprite
         */
        getX(): number;
        /**
         * Gets the y coordinate of the Sprite
         * @return {number} the y coordinate of the sprite
         */
        getY(): number;
        /**
         * Gets the width of the Sprite
         * @return {number} the width of the sprite
         */
        getW(): number;
        /**
         * Gets the height of the Sprite
         * @return {number} the height of the sprite
         */
        getH(): number;
        /**
         * Gets the image of the Sprite
         * @return {PImage} the image of the sprite
         */
        getImage(): PImage;
        /**
         * Gets the direction of the Sprite
         * @return {number} the direction (in degrees) the Sprite in facing
         */
        getDir(): number;
        /**
         * Calculates the distance from this Sprite to Sprite s
         * @return {number} the distance from this Sprite to Sprite s
         * @param {ktbyte.sprite.Sprite} s     The Sprite to measure distance to
         */
        distTo(s: Sprite): number;
        /**
         * Calculates the distance from this Sprite to the specified point
         * @return {number} the distance from this Sprite to the specified point
         * @param {number} x     The x coordinate of the point
         * @param {number} y     The y coordinate of the point
         */
        distToPoint(x: number, y: number): number;
        /**
         * Checks to see if this Sprite is touching Sprite s.
         * @return {boolean} true if this Sprite is touching Sprite s, false otherwise
         * @param {ktbyte.sprite.Sprite} s     The Sprite to detect whethet this Sprite is touching
         */
        touchingSprite(s: Sprite): boolean;
        /**
         * Checks to see if this Sprite is fully inside another sprite.
         * @return {boolean} true if this Sprite is touching Sprite s, false otherwise
         * @param {ktbyte.sprite.Sprite} s     The Sprite to detect whethet this Sprite is touching
         */
        insideSprite(s: Sprite): boolean;
        /**
         * Checks whether this Sprite is touching the specified point.
         * @return {boolean} true if this Sprite is touching the point, false otherwise
         * @param {number} x     The x coordinate of the point
         * @param {number} y     The y coordinate of the point
         */
        touchingPoint(x: number, y: number): boolean;
        /**
         * Checks whether this Sprite's hitbox is at least partially inside the canvas
         * @return {boolean} true if this Sprite is at least partially inside the canvas, false otherwise
         */
        isInsideScreen(): boolean;
        _ptPoly(pt: PVector, poly: PVector[]): boolean;
        _circPoly(center: PVector, r: number, poly: PVector[]): boolean;
        _circSeg(center: PVector, r: number, a: PVector, b: PVector): boolean;
        _insidePts(inPts: PVector[], outPts: PVector[]): boolean;
        _insideCirc(inPts: PVector[], center: PVector, r: number): boolean;
        _getCenter(): PVector;
        _getPoints(): PVector[];
        _clockwise(A: PVector, B: PVector, C: PVector): boolean;
    }
}
