/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.sprite;

import def.js.Error;
import def.js.Globals;
import def.processing.core.PApplet;
import def.processing.core.PImage;
import def.processing.core.PVector;

public class Sprite {
    private static PApplet forcedStaticPApplet;
    private PImage _img;
    private float _w;
    private float _h;
    private float _x;
    private float _y;
    private PVector _rotVector;
    private float _front = 0.0f;
    private PVector _hitboxCenter = new PVector();
    private PVector[] _hitbox;
    private boolean _flipped = false;
    private PVector out = new PVector(-10000.0f, -10000.0f);

    public static void init(PApplet pa) {
        forcedStaticPApplet = pa;
    }

    private PApplet getPApplet() {
        if (forcedStaticPApplet != null) {
            return forcedStaticPApplet;
        }
        PApplet currentApplet = (PApplet)Globals.eval((String)"MainPApplet.current");
        if (currentApplet != null) {
            return currentApplet;
        }
        throw new Error("Sprite is not bound to a PApplet. Please call Sprite.init(this) before");
    }

    public Sprite(String url, float x, float y, float w, float h) {
        this._img = this.getPApplet().loadImage(url);
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        this._rotVector = new PVector(1.0f, 0.0f, 0.0f);
        this.resetRectHitbox();
    }

    public Sprite(float x, float y, float w, float h) {
        this._img = this.getPApplet().createImage(1, 1, 1);
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        this._rotVector = new PVector(1.0f, 0.0f, 0.0f);
        this.resetRectHitbox();
    }

    public Sprite(Sprite s) {
        this._img = s._img;
        this._x = s._x;
        this._y = s._y;
        this._w = s._w;
        this._h = s._h;
        this._rotVector = new PVector(s._rotVector.x, s._rotVector.y, 0.0f);
        this._front = s._front;
        this._hitboxCenter = new PVector(s._hitboxCenter.x, s._hitboxCenter.y);
        this._hitbox = new PVector[s._hitbox.length];
        for (int i = 0; i < this._hitbox.length; ++i) {
            this._hitbox[i] = new PVector(s._hitbox[i].x, s._hitbox[i].y);
        }
        this._flipped = s._flipped;
    }

    public void frontAngle(float degrees) {
        float newFront = PApplet.radians((float)degrees);
        this._rotVector.rotate(newFront - this._front);
        this._front = newFront;
    }

    public void setRectHitbox(float w, float h) {
        this._hitbox = new PVector[]{new PVector(-w / 2.0f, h / 2.0f), new PVector(-w / 2.0f, -h / 2.0f), new PVector(w / 2.0f, -h / 2.0f), new PVector(w / 2.0f, h / 2.0f)};
    }

    public void resetRectHitbox() {
        this.setRectHitbox(this._w, this._h);
    }

    public void setRoundHitbox(float r) {
        this._hitbox = new PVector[]{new PVector(r, r * 2.0f)};
    }

    public void resetRoundHitbox() {
        this.setRoundHitbox((this._w + this._h) / 4.0f);
    }

    public void setHitboxCenter(float x, float y) {
        this._hitboxCenter = new PVector(x, y);
    }

    public void resetHitboxCenter() {
        this._hitboxCenter = new PVector(0.0f, 0.0f);
    }

    public void setHitboxPoints(PVector[] array) {
        if (array.length > 0) {
            boolean valid = true;
            for (PVector pv : array) {
                if (pv != null) continue;
                valid = false;
            }
            if (valid) {
                this._hitbox = array;
            } else {
                PApplet.print((String)"invalid hitbox: ");
                for (PVector pv : array) {
                    pv.toString();
                }
                PApplet.println();
            }
        } else {
            PApplet.print((String)"hitbox must have 3+ points: ");
            for (PVector pv : array) {
                pv.toString();
            }
            PApplet.println();
        }
    }

    public void setColor(float r, float g, float b) {
        int c = this.getPApplet().color(r, g, b);
        for (int x = 0; x < this._img.width; ++x) {
            for (int y = 0; y < this._img.height; ++y) {
                this._img.set(x, y, c);
            }
        }
    }

    public void flip() {
        this._flipped = !this._flipped;
    }

    public void turn(float degrees) {
        this._rotVector.rotate(PApplet.radians((float)degrees));
    }

    public void turnToPoint(float x, float y) {
        this._rotVector.set(x - this._x, y - this._y, 0.0f);
        this._rotVector.setMag(1.0f);
    }

    public void turnToDir(float angle) {
        float radian = PApplet.radians((float)angle);
        this._rotVector.set(PApplet.cos((float)radian), PApplet.sin((float)radian));
        this._rotVector.setMag(1.0f);
    }

    public void turnToSprite(Sprite s) {
        this.turnToPoint(s._x, s._y);
    }

    public void moveToPoint(float x, float y) {
        this._x = x;
        this._y = y;
    }

    public void moveToSprite(Sprite s) {
        this._x = s._x;
        this._y = s._y;
    }

    public void moveX(float x) {
        this._x += x;
    }

    public void moveY(float y) {
        this._y += y;
    }

    public void moveXY(float dx, float dy) {
        this._x += dx;
        this._y += dy;
    }

    public void forward(float steps) {
        this._x += this._rotVector.x * steps;
        this._y += this._rotVector.y * steps;
    }

    public void sideStep(float steps) {
        this._rotVector.rotate(1.5707964f);
        this._x += this._rotVector.x * steps;
        this._y += this._rotVector.y * steps;
        this._rotVector.rotate(-1.5707964f);
    }

    public void display() {
        this.getPApplet().pushMatrix();
        this.getPApplet().pushStyle();
        this.getPApplet().translate(this._x, this._y);
        this.getPApplet().rotate(this._rotVector.heading() - this._front);
        if (this._flipped) {
            this.getPApplet().scale(-1.0f, 1.0f);
        }
        this.getPApplet().imageMode(3);
        this.getPApplet().image(this._img, 0.0f, 0.0f, this._w, this._h);
        this.getPApplet().popStyle();
        this.getPApplet().popMatrix();
    }

    public void displayHitbox() {
        PVector cen = this._getCenter();
        this.getPApplet().pushStyle();
        this.getPApplet().stroke(255.0f, 0.0f, 0.0f);
        this.getPApplet().strokeWeight(5.0f);
        this.getPApplet().noFill();
        if (this._hitbox.length == 1) {
            this.getPApplet().ellipseMode(3);
            this.getPApplet().ellipse(cen.x, cen.y, this._hitbox[0].y, this._hitbox[0].y);
        } else {
            PVector[] corners = this._getPoints();
            for (int i = 0; i < corners.length; ++i) {
                PVector a = corners[i];
                PVector b = corners[(i + 1) % corners.length];
                this.getPApplet().line(a.x, a.y, b.x, b.y);
            }
        }
        this.getPApplet().line(cen.x, cen.y, cen.x + this._rotVector.x * 20.0f, cen.y + this._rotVector.y * 20.0f);
        this.getPApplet().fill(255.0f, 0.0f, 0.0f);
        this.getPApplet().noStroke();
        this.getPApplet().ellipse(cen.x, cen.y, 15.0f, 15.0f);
        this.getPApplet().popStyle();
    }

    public void flipX() {
        this._rotVector.x *= -1.0f;
    }

    public void flipY() {
        this._rotVector.y *= -1.0f;
    }

    public void setSize(float w, float h) {
        this._w = w;
        this._h = h;
        this.resetRectHitbox();
    }

    public void setCoor(float x, float y) {
        this._x = x;
        this._y = y;
    }

    public void setX(float x) {
        this._x = x;
    }

    public void setY(float y) {
        this._y = y;
    }

    public void setImage(PImage img) {
        this._img = img;
    }

    public float getX() {
        return this._x;
    }

    public float getY() {
        return this._y;
    }

    public float getW() {
        return this._w;
    }

    public float getH() {
        return this._h;
    }

    public PImage getImage() {
        return this._img;
    }

    public float getDir() {
        return PApplet.degrees((float)this._rotVector.heading());
    }

    public float distTo(Sprite s) {
        return PApplet.dist((float)this._x, (float)this._y, (float)s._x, (float)s._y);
    }

    public float distToPoint(float x, float y) {
        return PApplet.dist((float)this._x, (float)this._y, (float)x, (float)y);
    }

    public boolean touchingSprite(Sprite s) {
        if (s._hitbox.length == 1) {
            if (this._hitbox.length == 1) {
                return PVector.dist((PVector)this._getCenter(), (PVector)s._getCenter()) <= this._hitbox[0].x + s._hitbox[0].x;
            }
            return this._circPoly(s._getCenter(), s._hitbox[0].x, this._getPoints());
        }
        if (this._hitbox.length == 1) {
            return this._circPoly(this._getCenter(), this._hitbox[0].x, s._getPoints());
        }
        PVector[] s1Points = s._getPoints();
        PVector[] s2Points = this._getPoints();
        for (int i = 0; i < s1Points.length; ++i) {
            PVector a = s1Points[i];
            PVector b = s1Points[(i + 1) % s1Points.length];
            for (int j = 0; j < s2Points.length; ++j) {
                PVector c = s2Points[j];
                PVector d = s2Points[(j + 1) % s2Points.length];
                if (this._clockwise(a, c, d) == this._clockwise(b, c, d) || this._clockwise(a, b, c) == this._clockwise(a, b, d)) continue;
                return true;
            }
        }
        return this._insidePts(s1Points, s2Points) || this._insidePts(s2Points, s1Points);
    }

    public boolean insideSprite(Sprite s) {
        if (s._hitbox.length == 1) {
            if (this._hitbox.length == 1) {
                return PVector.dist((PVector)s._getCenter(), (PVector)this._getCenter()) < s._hitbox[0].x - this._hitbox[0].x;
            }
            return this._insideCirc(this._getPoints(), s._getCenter(), s._hitbox[0].x);
        }
        if (s._hitbox.length == 1) {
            return false;
        }
        return this._insidePts(this._getPoints(), s._getPoints());
    }

    public boolean touchingPoint(float x, float y) {
        if (this._hitbox.length == 1) {
            return PApplet.dist((float)x, (float)y, (float)this._hitboxCenter.x, (float)this._hitboxCenter.y) < this._hitbox[0].x;
        }
        return this._ptPoly(new PVector(x, y), this._getPoints());
    }

    public boolean isInsideScreen() {
        PVector[] points;
        if (this._hitbox.length == 1) {
            float r = this._hitbox[0].x;
            PVector c = this._getCenter();
            return 0.0f <= c.x + r && c.x - r < (float)this.getPApplet().width && 0.0f <= c.y + r && c.y - r < (float)this.getPApplet().height;
        }
        for (PVector p : points = this._getPoints()) {
            if (!(0.0f <= p.x) || !(p.x < (float)this.getPApplet().width) || !(0.0f <= p.y) || !(p.y < (float)this.getPApplet().height)) continue;
            return true;
        }
        return false;
    }

    private boolean _ptPoly(PVector pt, PVector[] poly) {
        int count = 0;
        for (int i = 0; i < poly.length; ++i) {
            PVector a = poly[i];
            PVector b = poly[(i + 1) % poly.length];
            if (this._clockwise(a, pt, this.out) == this._clockwise(b, pt, this.out) || this._clockwise(a, b, pt) == this._clockwise(a, b, this.out)) continue;
            ++count;
        }
        return count % 2 == 1;
    }

    private boolean _circPoly(PVector center, float r, PVector[] poly) {
        if (this._ptPoly(center, poly)) {
            return true;
        }
        if (this._insideCirc(poly, center, r)) {
            return true;
        }
        for (PVector corner : poly) {
            if (!(PApplet.dist((float)center.x, (float)center.y, (float)corner.x, (float)corner.y) < r)) continue;
            return true;
        }
        for (int i = 0; i < poly.length; ++i) {
            if (!this._circSeg(center, r, poly[i], poly[(i + 1) % poly.length])) continue;
            return true;
        }
        return false;
    }

    private boolean _circSeg(PVector center, float r, PVector a, PVector b) {
        PVector ab = PVector.sub((PVector)b, (PVector)a);
        PVector abPerp = new PVector(-ab.y, ab.x).normalize().mult(r);
        PVector[] limits = new PVector[]{PVector.add((PVector)a, (PVector)abPerp), PVector.sub((PVector)a, (PVector)abPerp), PVector.sub((PVector)b, (PVector)abPerp), PVector.add((PVector)b, (PVector)abPerp)};
        return this._ptPoly(center, limits);
    }

    private boolean _insidePts(PVector[] inPts, PVector[] outPts) {
        for (int i = 0; i < inPts.length; ++i) {
            if (this._ptPoly(inPts[i], outPts)) continue;
            return false;
        }
        return true;
    }

    private boolean _insideCirc(PVector[] inPts, PVector center, float r) {
        for (int i = 0; i < inPts.length; ++i) {
            if (!(PVector.dist((PVector)inPts[i], (PVector)center) > r)) continue;
            return false;
        }
        return true;
    }

    private PVector _getCenter() {
        PVector cen = new PVector(this._hitboxCenter.x, this._hitboxCenter.y);
        cen.rotate(this._rotVector.heading() - this._front);
        cen.x += this._x;
        cen.y += this._y;
        return cen;
    }

    private PVector[] _getPoints() {
        PVector cen = this._getCenter();
        PVector[] points = new PVector[this._hitbox.length];
        float angle = this._rotVector.heading();
        for (int i = 0; i < this._hitbox.length; ++i) {
            points[i] = new PVector(this._hitbox[i].x, this._hitbox[i].y);
            points[i].rotate(angle);
            points[i].x += cen.x;
            points[i].y += cen.y;
        }
        return points;
    }

    private boolean _clockwise(PVector A, PVector B, PVector C) {
        return (C.y - A.y) * (B.x - A.x) > (B.y - A.y) * (C.x - A.x);
    }
}

