/* Generated from Java with JSweet 2.2.0-SNAPSHOT - http://www.jsweet.org */
namespace ktbyte.sprite {}
namespace ktbyte.sprite {
    /**
     * Initializes the Sprite with the given image URL, coordinates and size.
     * @param {string} url  The URL of the image for the Sprite to use.
     * @param {number} x    The initial x coordinate of the Sprite
     * @param {number} y    The initial y coordinate of the Sprite
     * @param {number} w    The initial width of the Sprite
     * @param {number} h    The initial height of the Sprite
     * @class
     */
    export class Sprite {
        static forcedStaticPApplet : any = null;

        /*private*/ _img : PImage;

        /*private*/ _w : number;

        /*private*/ _h : number;

        /*private*/ _x : number;

        /*private*/ _y : number;

        /*private*/ _rotVector : PVector;

        /*private*/ _front : number = 0;

        /*private*/ _hitboxCenter : PVector = new PVector();

        /*private*/ _hitbox : PVector[];

        /*private*/ _flipped : boolean = false;

        /*private*/ out : PVector = new PVector(-10000, -10000);

        public static init(pa : any) {
            Sprite.forcedStaticPApplet = pa;
        }

        /*private*/ getPApplet() : any {
            if(Sprite.forcedStaticPApplet != null) {
                return Sprite.forcedStaticPApplet;
            }
            let currentApplet : any = <any>(eval("MainPApplet.current"));
            if(currentApplet != null) {
                return currentApplet;
            }
            throw new Error("Sprite is not bound to a PApplet. Please call Sprite.init(this) before");
        }

        public constructor(url? : any, x? : any, y? : any, w? : any, h? : any) {
            if(((typeof url === 'string') || url === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                let __args = arguments;
                if(this._img===undefined) this._img = null;
                if(this._w===undefined) this._w = 0;
                if(this._h===undefined) this._h = 0;
                if(this._x===undefined) this._x = 0;
                if(this._y===undefined) this._y = 0;
                if(this._rotVector===undefined) this._rotVector = null;
                if(this._hitbox===undefined) this._hitbox = null;
                this._front = 0;
                this._hitboxCenter = new PVector();
                this._flipped = false;
                this.out = new PVector(-10000, -10000);
                if(this._img===undefined) this._img = null;
                if(this._w===undefined) this._w = 0;
                if(this._h===undefined) this._h = 0;
                if(this._x===undefined) this._x = 0;
                if(this._y===undefined) this._y = 0;
                if(this._rotVector===undefined) this._rotVector = null;
                if(this._hitbox===undefined) this._hitbox = null;
                (() => {
                    this._img = this.getPApplet().loadImage(url);
                    this._x = x;
                    this._y = y;
                    this._w = w;
                    this._h = h;
                    this._rotVector = new PVector(1, 0, 0);
                    this.resetRectHitbox();
                })();
            } else if(((typeof url === 'number') || url === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                let __args = arguments;
                let x : any = __args[0];
                let y : any = __args[1];
                let w : any = __args[2];
                let h : any = __args[3];
                if(this._img===undefined) this._img = null;
                if(this._w===undefined) this._w = 0;
                if(this._h===undefined) this._h = 0;
                if(this._x===undefined) this._x = 0;
                if(this._y===undefined) this._y = 0;
                if(this._rotVector===undefined) this._rotVector = null;
                if(this._hitbox===undefined) this._hitbox = null;
                this._front = 0;
                this._hitboxCenter = new PVector();
                this._flipped = false;
                this.out = new PVector(-10000, -10000);
                if(this._img===undefined) this._img = null;
                if(this._w===undefined) this._w = 0;
                if(this._h===undefined) this._h = 0;
                if(this._x===undefined) this._x = 0;
                if(this._y===undefined) this._y = 0;
                if(this._rotVector===undefined) this._rotVector = null;
                if(this._hitbox===undefined) this._hitbox = null;
                (() => {
                    this._img = this.getPApplet().createImage(1, 1, PConstants.RGB);
                    this._x = x;
                    this._y = y;
                    this._w = w;
                    this._h = h;
                    this._rotVector = new PVector(1, 0, 0);
                    this.resetRectHitbox();
                })();
            } else if(((url != null && url instanceof <any>ktbyte.sprite.Sprite) || url === null) && x === undefined && y === undefined && w === undefined && h === undefined) {
                let __args = arguments;
                let s : any = __args[0];
                if(this._img===undefined) this._img = null;
                if(this._w===undefined) this._w = 0;
                if(this._h===undefined) this._h = 0;
                if(this._x===undefined) this._x = 0;
                if(this._y===undefined) this._y = 0;
                if(this._rotVector===undefined) this._rotVector = null;
                if(this._hitbox===undefined) this._hitbox = null;
                this._front = 0;
                this._hitboxCenter = new PVector();
                this._flipped = false;
                this.out = new PVector(-10000, -10000);
                if(this._img===undefined) this._img = null;
                if(this._w===undefined) this._w = 0;
                if(this._h===undefined) this._h = 0;
                if(this._x===undefined) this._x = 0;
                if(this._y===undefined) this._y = 0;
                if(this._rotVector===undefined) this._rotVector = null;
                if(this._hitbox===undefined) this._hitbox = null;
                (() => {
                    this._img = s._img;
                    this._x = s._x;
                    this._y = s._y;
                    this._w = s._w;
                    this._h = s._h;
                    this._rotVector = new PVector(s._rotVector.x, s._rotVector.y, 0);
                    this._front = s._front;
                    this._hitboxCenter = new PVector(s._hitboxCenter.x, s._hitboxCenter.y);
                    this._hitbox = (s => { let a=[]; while(s-->0) a.push(null); return a; })(s._hitbox.length);
                    for(let i : number = 0; i < this._hitbox.length; i++) {{
                        this._hitbox[i] = new PVector(s._hitbox[i].x, s._hitbox[i].y);
                    };}
                    this._flipped = s._flipped;
                })();
            } else throw new Error('invalid overload');
        }

        /**
         * Adjust the direction of the PImage of the Sprite
         * without changing its orientation
         * @param {number} degrees      The degrees of turn to adjust the PImage
         */
        public frontAngle(degrees : number) {
            let newFront : number = PApplet.radians(degrees);
            this._rotVector.rotate((<any>Math).fround(newFront - this._front));
            this._front = newFront;
        }

        /**
         * Adjusts the Sprite's hitbox, which is set to the Sprite's
         * width and height by default.
         * @param {number} w    The width of the hitbox
         * @param {number} h    The height of the hitbox
         */
        public setRectHitbox(w : number, h : number) {
            this._hitbox = [new PVector((<any>Math).fround(-w / 2), (<any>Math).fround(h / 2)), new PVector((<any>Math).fround(-w / 2), (<any>Math).fround(-h / 2)), new PVector((<any>Math).fround(w / 2), (<any>Math).fround(-h / 2)), new PVector((<any>Math).fround(w / 2), (<any>Math).fround(h / 2))];
        }

        /**
         * Resets the Sprite's hitbox to its own width and height
         */
        public resetRectHitbox() {
            this.setRectHitbox(this._w, this._h);
        }

        /**
         * Sets the Sprite's hitbox to a circle.
         * @param {number} r     The radius of the circle
         */
        public setRoundHitbox(r : number) {
            this._hitbox = [new PVector(r, (<any>Math).fround(r * 2))];
        }

        /**
         * Sets the Sprite's hitbox to a circle with radius
         * equals to (sum of its width and height) / 4.
         */
        public resetRoundHitbox() {
            this.setRoundHitbox((<any>Math).fround(((<any>Math).fround(this._w + this._h)) / 4));
        }

        /**
         * Recenter the Sprite's hitbox relative to its center
         * @param {number} x     the offset in the x direction, in pixels
         * @param {number} y     the offset in the y direction, in pixels
         */
        public setHitboxCenter(x : number, y : number) {
            this._hitboxCenter = new PVector(x, y);
        }

        /**
         * Recenter the Sprite's hitbox to its center
         */
        public resetHitboxCenter() {
            this._hitboxCenter = new PVector(0, 0);
        }

        /**
         * Set the Sprite's hitbox to a polygon defined by
         * a list of PVectors (points) relative to its center
         * @param {Array} array         An array of points definig the hitbox polygon
         */
        public setHitboxPoints(array : PVector[]) {
            if(array.length > 0) {
                let valid : boolean = true;
                for(let index126=0; index126 < array.length; index126++) {
                    let pv = array[index126];
                    if(pv == null) valid = false;
                }
                if(valid) {
                    this._hitbox = array;
                } else {
                    PApplet.print("invalid hitbox: ");
                    for(let index127=0; index127 < array.length; index127++) {
                        let pv = array[index127];
                        {
                            pv.toString();
                        }
                    }
                    PApplet.println();
                }
            } else {
                PApplet.print("hitbox must have 3+ points: ");
                for(let index128=0; index128 < array.length; index128++) {
                    let pv = array[index128];
                    {
                        pv.toString();
                    }
                }
                PApplet.println();
            }
        }

        /**
         * Changes the color of a Sprite. This function is only supported
         * for Sprites created without an image.
         * @param {number} r     The first parameter defining the color.
         * In default RGB mode, this is the red value.
         * @param {number} g     The second parameter defining the color.
         * In default RGB mode, this is the green value.
         * @param {number} b     The third parameter defining the color.
         * In default RGB mode, this is the blue value.
         */
        public setColor(r : number, g : number, b : number) {
            let c : number = this.getPApplet().color(r, g, b);
            for(let x : number = 0; x < this._img.width; x++) {{
                for(let y : number = 0; y < this._img.height; y++) {{
                    this._img.set(x, y, c);
                };}
            };}
        }

        /**
         * Flips Sprite image across its X axis
         */
        public flip() {
            this._flipped = !this._flipped;
        }

        /**
         * Rotates the Sprite by a specified number of degrees
         * @param {number} degrees       The number of degrees to turn
         */
        public turn(degrees : number) {
            this._rotVector.rotate(PApplet.radians(degrees));
        }

        /**
         * Rotates the Sprite to face the specified (x, y) location
         * @param {number} x       The x coordinate of the point to face
         * @param {number} y       The y coordinate of the point to face
         */
        public turnToPoint(x : number, y : number) {
            this._rotVector.set((<any>Math).fround(x - this._x), (<any>Math).fround(y - this._y), 0);
            this._rotVector.setMag(1);
        }

        /**
         * Rotates the Sprite to specified (absolute) angle.
         * @param {number} angle         The direction to turn to
         */
        public turnToDir(angle : number) {
            let radian : number = PApplet.radians(angle);
            this._rotVector.set(PApplet.cos(radian), PApplet.sin(radian));
            this._rotVector.setMag(1);
        }

        /**
         * Rotates the Sprite to the specified Sprite s
         * @param {ktbyte.sprite.Sprite} s     The Sprite to turn to
         */
        public turnToSprite(s : Sprite) {
            this.turnToPoint(s._x, s._y);
        }

        /**
         * Moves the Sprite to the specified coordinate.
         * @param {number} x     The x coordinate of the point to move to
         * @param {number} y     The y coordinate of the point to move to
         */
        public moveToPoint(x : number, y : number) {
            this._x = x;
            this._y = y;
        }

        /**
         * Moves the Sprite to the specified Sprite s
         * @param {ktbyte.sprite.Sprite} s     The Sprite to move to
         */
        public moveToSprite(s : Sprite) {
            this._x = s._x;
            this._y = s._y;
        }

        /**
         * Moves the Sprite in the x axis by the specified amount.
         * @param {number} x     The amount to move in pixels
         */
        public moveX(x : number) {
            this._x += x;
        }

        /**
         * Moves the Sprite in the y axis by the specified amount.
         * @param {number} y     The amount to move in pixels
         */
        public moveY(y : number) {
            this._y += y;
        }

        /**
         * Moves the Sprite in the x and y axes by the specified amounts.
         * @param x     The amount to move in pixels in the x axis
         * @param y     The amount to move in pixels in the y axis
         * @param {number} dx
         * @param {number} dy
         */
        public moveXY(dx : number, dy : number) {
            this._x += dx;
            this._y += dy;
        }

        /**
         * Moves the Sprite forward in the direction it is facing.
         * @param {number} steps The amount to move in pixels.
         */
        public forward(steps : number) {
            this._x += (<any>Math).fround(this._rotVector.x * steps);
            this._y += (<any>Math).fround(this._rotVector.y * steps);
        }

        /**
         * Moves the Sprite in the direction 90 degrees clockwise from its forward direction.
         * @param {number} steps The amount to move in pixels.
         */
        public sideStep(steps : number) {
            this._rotVector.rotate((<any>Math).fround(PConstants.PI / 2));
            this._x += (<any>Math).fround(this._rotVector.x * steps);
            this._y += (<any>Math).fround(this._rotVector.y * steps);
            this._rotVector.rotate((<any>Math).fround(-PConstants.PI / 2));
        }

        /**
         * Draws the Sprite. This function should be called in the <code>void draw()</code> function.
         */
        public display() {
            this.getPApplet().pushMatrix();
            this.getPApplet().pushStyle();
            this.getPApplet().translate(this._x, this._y);
            this.getPApplet().rotate((<any>Math).fround(this._rotVector.heading() - this._front));
            if(this._flipped) this.getPApplet().scale(-1, 1);
            this.getPApplet().imageMode(PConstants.CENTER);
            this.getPApplet().image(this._img, 0, 0, this._w, this._h);
            this.getPApplet().popStyle();
            this.getPApplet().popMatrix();
        }

        /**
         * Draws the Sprite's hitbox. This function should be called in the <code>void draw()</code> function.
         */
        public displayHitbox() {
            let cen : PVector = this._getCenter();
            this.getPApplet().pushStyle();
            this.getPApplet().stroke(255, 0, 0);
            this.getPApplet().strokeWeight(5);
            this.getPApplet().noFill();
            if(this._hitbox.length === 1) {
                this.getPApplet().ellipseMode(PConstants.CENTER);
                this.getPApplet().ellipse(cen.x, cen.y, this._hitbox[0].y, this._hitbox[0].y);
            } else {
                let corners : PVector[] = this._getPoints();
                for(let i : number = 0; i < corners.length; i++) {{
                    let a : PVector = corners[i];
                    let b : PVector = corners[(i + 1) % corners.length];
                    this.getPApplet().line(a.x, a.y, b.x, b.y);
                };}
            }
            this.getPApplet().line(cen.x, cen.y, (<any>Math).fround(cen.x + (<any>Math).fround(this._rotVector.x * 20)), (<any>Math).fround(cen.y + (<any>Math).fround(this._rotVector.y * 20)));
            this.getPApplet().fill(255, 0, 0);
            this.getPApplet().noStroke();
            this.getPApplet().ellipse(cen.x, cen.y, 15, 15);
            this.getPApplet().popStyle();
        }

        /**
         * Changes the direction of the Sprite by flipping
         * the x component of its direction
         */
        public flipX() {
            this._rotVector.x *= -1;
        }

        /**
         * Changes the direction of the Sprite by flipping
         * the y component of its direction
         */
        public flipY() {
            this._rotVector.y *= -1;
        }

        /**
         * Sets the size of the Sprite. The Sprite's hitbox is automatically
         * reset to be rectangular with the same size as the Sprite's new size.
         * @param {number} w     The width of the Sprite
         * @param {number} h     The height of the Sprite
         */
        public setSize(w : number, h : number) {
            this._w = w;
            this._h = h;
            this.resetRectHitbox();
        }

        /**
         * Moves the Sprite to the specified coordinate.
         * @param {number} x     The x coordinate of the point to move to
         * @param {number} y     The y coordinate of the point to move to
         */
        public setCoor(x : number, y : number) {
            this._x = x;
            this._y = y;
        }

        public setX(x : number) {
            this._x = x;
        }

        public setY(y : number) {
            this._y = y;
        }

        /**
         * Changes the image of the Sprite
         * @param {PImage} img   The image to set the Sprite to
         */
        public setImage(img : PImage) {
            this._img = img;
        }

        /**
         * Gets the x coordinate of the Sprite
         * @return {number} the x coordinate of the sprite
         */
        public getX() : number {
            return this._x;
        }

        /**
         * Gets the y coordinate of the Sprite
         * @return {number} the y coordinate of the sprite
         */
        public getY() : number {
            return this._y;
        }

        /**
         * Gets the width of the Sprite
         * @return {number} the width of the sprite
         */
        public getW() : number {
            return this._w;
        }

        /**
         * Gets the height of the Sprite
         * @return {number} the height of the sprite
         */
        public getH() : number {
            return this._h;
        }

        /**
         * Gets the image of the Sprite
         * @return {PImage} the image of the sprite
         */
        public getImage() : PImage {
            return this._img;
        }

        /**
         * Gets the direction of the Sprite
         * @return {number} the direction (in degrees) the Sprite in facing
         */
        public getDir() : number {
            return PApplet.degrees(this._rotVector.heading());
        }

        /**
         * Calculates the distance from this Sprite to Sprite s
         * @return {number} the distance from this Sprite to Sprite s
         * @param {ktbyte.sprite.Sprite} s     The Sprite to measure distance to
         */
        public distTo(s : Sprite) : number {
            return PApplet.dist(this._x, this._y, s._x, s._y);
        }

        /**
         * Calculates the distance from this Sprite to the specified point
         * @return {number} the distance from this Sprite to the specified point
         * @param {number} x     The x coordinate of the point
         * @param {number} y     The y coordinate of the point
         */
        public distToPoint(x : number, y : number) : number {
            return PApplet.dist(this._x, this._y, x, y);
        }

        /**
         * Checks to see if this Sprite is touching Sprite s.
         * @return {boolean} true if this Sprite is touching Sprite s, false otherwise
         * @param {ktbyte.sprite.Sprite} s     The Sprite to detect whethet this Sprite is touching
         */
        public touchingSprite(s : Sprite) : boolean {
            if(s._hitbox.length === 1) {
                if(this._hitbox.length === 1) {
                    return PVector.dist(this._getCenter(), s._getCenter()) <= (<any>Math).fround(this._hitbox[0].x + s._hitbox[0].x);
                }
                return this._circPoly(s._getCenter(), s._hitbox[0].x, this._getPoints());
            }
            if(this._hitbox.length === 1) {
                return this._circPoly(this._getCenter(), this._hitbox[0].x, s._getPoints());
            }
            let s1Points : PVector[] = s._getPoints();
            let s2Points : PVector[] = this._getPoints();
            for(let i : number = 0; i < s1Points.length; i++) {{
                let a : PVector = s1Points[i];
                let b : PVector = s1Points[(i + 1) % s1Points.length];
                for(let j : number = 0; j < s2Points.length; j++) {{
                    let c : PVector = s2Points[j];
                    let d : PVector = s2Points[(j + 1) % s2Points.length];
                    if(this._clockwise(a, c, d) !== this._clockwise(b, c, d) && this._clockwise(a, b, c) !== this._clockwise(a, b, d)) {
                        return true;
                    }
                };}
            };}
            return this._insidePts(s1Points, s2Points) || this._insidePts(s2Points, s1Points);
        }

        /**
         * Checks to see if this Sprite is fully inside another sprite.
         * @return {boolean} true if this Sprite is touching Sprite s, false otherwise
         * @param {ktbyte.sprite.Sprite} s     The Sprite to detect whethet this Sprite is touching
         */
        public insideSprite(s : Sprite) : boolean {
            if(s._hitbox.length === 1) {
                if(this._hitbox.length === 1) {
                    return PVector.dist(s._getCenter(), this._getCenter()) < (<any>Math).fround(s._hitbox[0].x - this._hitbox[0].x);
                }
                return this._insideCirc(this._getPoints(), s._getCenter(), s._hitbox[0].x);
            }
            if(s._hitbox.length === 1) {
                return false;
            }
            return this._insidePts(this._getPoints(), s._getPoints());
        }

        /**
         * Checks whether this Sprite is touching the specified point.
         * @return {boolean} true if this Sprite is touching the point, false otherwise
         * @param {number} x     The x coordinate of the point
         * @param {number} y     The y coordinate of the point
         */
        public touchingPoint(x : number, y : number) : boolean {
            if(this._hitbox.length === 1) return PApplet.dist(x, y, this._hitboxCenter.x, this._hitboxCenter.y) < this._hitbox[0].x;
            return this._ptPoly(new PVector(x, y), this._getPoints());
        }

        /**
         * Checks whether this Sprite's hitbox is at least partially inside the canvas
         * @return {boolean} true if this Sprite is at least partially inside the canvas, false otherwise
         */
        public isInsideScreen() : boolean {
            if(this._hitbox.length === 1) {
                let r : number = this._hitbox[0].x;
                let c : PVector = this._getCenter();
                return 0 <= (<any>Math).fround(c.x + r) && (<any>Math).fround(c.x - r) < this.getPApplet().width && 0 <= (<any>Math).fround(c.y + r) && (<any>Math).fround(c.y - r) < this.getPApplet().height;
            }
            let points : PVector[] = this._getPoints();
            for(let index129=0; index129 < points.length; index129++) {
                let p = points[index129];
                {
                    if(0 <= p.x && p.x < this.getPApplet().width && 0 <= p.y && p.y < this.getPApplet().height) {
                        return true;
                    }
                }
            }
            return false;
        }

        /*private*/ _ptPoly(pt : PVector, poly : PVector[]) : boolean {
            let count : number = 0;
            for(let i : number = 0; i < poly.length; i++) {{
                let a : PVector = poly[i];
                let b : PVector = poly[(i + 1) % poly.length];
                if(this._clockwise(a, pt, this.out) !== this._clockwise(b, pt, this.out) && this._clockwise(a, b, pt) !== this._clockwise(a, b, this.out)) {
                    count++;
                }
            };}
            return count % 2 === 1;
        }

        /*private*/ _circPoly(center : PVector, r : number, poly : PVector[]) : boolean {
            if(this._ptPoly(center, poly)) return true;
            if(this._insideCirc(poly, center, r)) return true;
            for(let index130=0; index130 < poly.length; index130++) {
                let corner = poly[index130];
                {
                    if(PApplet.dist(center.x, center.y, corner.x, corner.y) < r) return true;
                }
            }
            for(let i : number = 0; i < poly.length; i++) {{
                if(this._circSeg(center, r, poly[i], poly[(i + 1) % poly.length])) return true;
            };}
            return false;
        }

        /*private*/ _circSeg(center : PVector, r : number, a : PVector, b : PVector) : boolean {
            let ab : PVector = PVector.sub(b, a);
            let abPerp : PVector = (new PVector(-ab.y, ab.x)).normalize().mult(r);
            let limits : PVector[] = [PVector.add(a, abPerp), PVector.sub(a, abPerp), PVector.sub(b, abPerp), PVector.add(b, abPerp)];
            return this._ptPoly(center, limits);
        }

        /*private*/ _insidePts(inPts : PVector[], outPts : PVector[]) : boolean {
            for(let i : number = 0; i < inPts.length; i++) {{
                if(!this._ptPoly(inPts[i], outPts)) return false;
            };}
            return true;
        }

        /*private*/ _insideCirc(inPts : PVector[], center : PVector, r : number) : boolean {
            for(let i : number = 0; i < inPts.length; i++) {{
                if(PVector.dist(inPts[i], center) > r) return false;
            };}
            return true;
        }

        /*private*/ _getCenter() : PVector {
            let cen : PVector = new PVector(this._hitboxCenter.x, this._hitboxCenter.y);
            cen.rotate((<any>Math).fround(this._rotVector.heading() - this._front));
            cen.x += this._x;
            cen.y += this._y;
            return cen;
        }

        /*private*/ _getPoints() : PVector[] {
            let cen : PVector = this._getCenter();
            let points : PVector[] = (s => { let a=[]; while(s-->0) a.push(null); return a; })(this._hitbox.length);
            let angle : number = this._rotVector.heading();
            for(let i : number = 0; i < this._hitbox.length; i++) {{
                points[i] = new PVector(this._hitbox[i].x, this._hitbox[i].y);
                points[i].rotate(angle);
                points[i].x += cen.x;
                points[i].y += cen.y;
            };}
            return points;
        }

        /*private*/ _clockwise(A : PVector, B : PVector, C : PVector) : boolean {
            return (<any>Math).fround(((<any>Math).fround(C.y - A.y)) * ((<any>Math).fround(B.x - A.x))) > (<any>Math).fround(((<any>Math).fround(B.y - A.y)) * ((<any>Math).fround(C.x - A.x)));
        }
    }
    Sprite["__class"] = "ktbyte.sprite.Sprite";

}

