class Capture {
    constructor(applet, width, height) {
        if (((applet != null && applet instanceof PApplet) || applet === null) && ((typeof width === 'number') || width === null) && ((typeof height === 'number') || height === null)) {
            let __args = arguments;
            if (this.applet === undefined)
                this.applet = null;
            if (this.width === undefined)
                this.width = 0;
            if (this.height === undefined)
                this.height = 0;
            if (this.videoElement === undefined)
                this.videoElement = null;
            if (this.canvasElement === undefined)
                this.canvasElement = null;
            if (this.canvasContext === undefined)
                this.canvasContext = null;
            if (this.__available === undefined)
                this.__available = false;
            if (this.capturedImage === undefined)
                this.capturedImage = null;
            if (this.imageData === undefined)
                this.imageData = null;
            if (this.applet === undefined)
                this.applet = null;
            if (this.width === undefined)
                this.width = 0;
            if (this.height === undefined)
                this.height = 0;
            if (this.videoElement === undefined)
                this.videoElement = null;
            if (this.canvasElement === undefined)
                this.canvasElement = null;
            if (this.canvasContext === undefined)
                this.canvasContext = null;
            if (this.__available === undefined)
                this.__available = false;
            if (this.capturedImage === undefined)
                this.capturedImage = null;
            if (this.imageData === undefined)
                this.imageData = null;
            (() => {
                this.applet = applet;
                this.width = width;
                this.height = height;
                this.initDomElements();
            })();
        }
        else if (((applet != null && applet instanceof PApplet) || applet === null) && ((typeof width === 'string') || width === null) && height === undefined) {
            let __args = arguments;
            let dimension = __args[1];
            {
                let __args = arguments;
                let width = Capture.decodeDimension(dimension).width;
                let height = Capture.decodeDimension(dimension).height;
                if (this.applet === undefined)
                    this.applet = null;
                if (this.width === undefined)
                    this.width = 0;
                if (this.height === undefined)
                    this.height = 0;
                if (this.videoElement === undefined)
                    this.videoElement = null;
                if (this.canvasElement === undefined)
                    this.canvasElement = null;
                if (this.canvasContext === undefined)
                    this.canvasContext = null;
                if (this.__available === undefined)
                    this.__available = false;
                if (this.capturedImage === undefined)
                    this.capturedImage = null;
                if (this.imageData === undefined)
                    this.imageData = null;
                if (this.applet === undefined)
                    this.applet = null;
                if (this.width === undefined)
                    this.width = 0;
                if (this.height === undefined)
                    this.height = 0;
                if (this.videoElement === undefined)
                    this.videoElement = null;
                if (this.canvasElement === undefined)
                    this.canvasElement = null;
                if (this.canvasContext === undefined)
                    this.canvasContext = null;
                if (this.__available === undefined)
                    this.__available = false;
                if (this.capturedImage === undefined)
                    this.capturedImage = null;
                if (this.imageData === undefined)
                    this.imageData = null;
                (() => {
                    this.applet = applet;
                    this.width = width;
                    this.height = height;
                    this.initDomElements();
                })();
            }
        }
        else
            throw new Error('invalid overload');
    }
    toImageData() {
        return this.imageData;
    }
    /*private*/ initDomElements() {
        this.videoElement = document.getElementById(Capture.VIDEO_ELEMENT_ID);
        if (this.videoElement == null) {
            this.videoElement = document.createElement("video");
            this.videoElement.setAttribute("id", Capture.VIDEO_ELEMENT_ID);
            this.videoElement.setAttribute("style", "display:none;");
            this.videoElement.setAttribute("width", this.width + "px");
            this.videoElement.setAttribute("height", this.height + "px");
            this.videoElement.setAttribute("autoplay", "true");
            document.body.appendChild(this.videoElement);
        }
        this.canvasElement = document.getElementById(Capture.CAPTURE_CANVAS_ELEMENT_ID);
        if (this.canvasElement == null) {
            this.canvasElement = document.createElement("canvas");
            this.canvasElement.setAttribute("id", Capture.CAPTURE_CANVAS_ELEMENT_ID);
            this.canvasElement.setAttribute("style", "display:none;");
            this.canvasElement.setAttribute("width", this.width + "px");
            this.canvasElement.setAttribute("height", this.height + "px");
            document.body.appendChild(this.canvasElement);
        }
        this.canvasContext = this.canvasElement.getContext("2d");
        this.imageData = this.canvasContext.getImageData(0, 0, this.width, this.height);
    }
    /*private*/ static decodeDimension(dimensionString) {
        let dimension = Object.defineProperty({
            width: Capture.DEFAULT_WIDTH,
            height: Capture.DEFAULT_HEIGHT
        }, '__interfaces', { configurable: true, value: ["processing.webcam.Dimension"] });
        if (dimensionString != null) {
            let sizeRegExp = new RegExp("size=([0-9]+)x([0-9]+)", "g");
            let result = sizeRegExp.exec(dimensionString);
            if (result.length > 2) {
                let width = parseInt(result[1]);
                if (!isNaN(width)) {
                    dimension.width = width;
                }
                let height = parseInt(result[2]);
                if (!isNaN(height)) {
                    dimension.height = height;
                }
            }
        }
        return dimension;
    }
    drawOnApplet() {
        this.ensureAvailable();
        let appletCanvas = this.applet.externals.canvas;
        let appletRenderingContext = appletCanvas.getContext("2d");
        appletRenderingContext.drawImage(this.videoElement, 0, 0);
    }
    /**
     * Preload a PImage accessible after with this.get(int,int) using loadImage()
     *
     * @see #get(int, int)
     * @see #loadImage()
     */
    read() {
        this.capturedImage = this.loadImage();
        this.imageData = this.capturedImage.toImageData();
    }
    /**
     * Returns pixel at {x,y} of previously captured/read image, or 0 if no image
     * loaded.
     *
     * @see #read()
     * @see PImage#get(int, int)
     * @param {number} x
     * @param {number} y
     * @return {number}
     */
    get(x, y) {
        if (this.capturedImage == null) {
            return 0;
        }
        return this.capturedImage.get(x, y);
    }
    loadImage() {
        this.ensureAvailable();
        this.canvasContext.drawImage(this.videoElement, 0, 0);
        let image = this.applet.createImage(this.width, this.height, PConstants.ARGB);
        let imageData = this.canvasContext.getImageData(0, 0, this.width, this.height);
        image.fromImageData(imageData);
        return image;
    }
    start() {
        if (this.videoElement.dataset[Capture.INITIALIZED_DATA_ATTRIBUTE_NAME] !== "true") {
            let mediaDevices = ((navigator)["mediaDevices"]);
            if (mediaDevices == null || mediaDevices["getUserMedia"] == null) {
                this.noStream("navigator.mediaDevices.getUserMedia not found");
                return;
            }
            let gotStream = (stream) => this.gotStream(stream);
            let noStream = (error) => this.noStream(error);
            let getUserMediaPromise = (mediaDevices["getUserMedia"]({ video: true }));
            getUserMediaPromise.then((gotStream)).catch((noStream));
            this.videoElement.dataset[Capture.INITIALIZED_DATA_ATTRIBUTE_NAME] = "true";
        }
    }
    /*private*/ gotStream(stream) {
        console.info("requesting video play");
        this.videoElement["srcObject"] = stream;
        this.videoElement.onerror = (error) => {
            this.streamError(error);
            return null;
        };
        this.videoElement.onplay = (__) => {
            console.info("play started, video capture available");
            this.__available = true;
            return null;
        };
    }
    /*private*/ noStream(error) {
        console.error("an error occurred while accessing camera: " + error);
    }
    /*private*/ streamError(error) {
        console.error("an error occurred while streaming camera: " + error);
    }
    /*private*/ ensureAvailable() {
        if (!this.available()) {
            throw Object.defineProperty(new Error("camera not available"), '__classes', { configurable: true, value: ['java.lang.Throwable', 'java.lang.Error', 'java.lang.Object'] });
        }
    }
    available() {
        return this.__available;
    }
    /**
     * @return {Array} Only one value "name=Unknown,size=800x600,fps=30"
     */
    static list() {
        return ["name=Unknown,size=800x600,fps=30"];
    }
}
Capture.DEFAULT_WIDTH = 800;
Capture.DEFAULT_HEIGHT = 600;
Capture.CAPTURE_CANVAS_ELEMENT_ID = "ProcessingWebCam__captureCanvas";
Capture.VIDEO_ELEMENT_ID = "ProcessingWebCam__videoOutput";
Capture.INITIALIZED_DATA_ATTRIBUTE_NAME = "ProcessingWebCam__initialize";
Capture["__class"] = "processing.webcam.Capture";
Capture["__interfaces"] = ["def.processing.core.PApplet.PImageLike"];
