interface Dimension {
    width: number;
    height: number;
}
declare class Capture implements PApplet.PImageLike {
    static DEFAULT_WIDTH: number;
    static DEFAULT_HEIGHT: number;
    static CAPTURE_CANVAS_ELEMENT_ID: string;
    static VIDEO_ELEMENT_ID: string;
    static INITIALIZED_DATA_ATTRIBUTE_NAME: string;
    applet: PApplet;
    width: number;
    height: number;
    videoElement: HTMLVideoElement;
    canvasElement: HTMLCanvasElement;
    canvasContext: CanvasRenderingContext2D;
    __available: boolean;
    capturedImage: PImage;
    /**
     * Last captured image's data
     *
     * @see #read()
     */
    imageData: ImageData;
    toImageData(): ImageData;
    constructor(applet?: any, width?: any, height?: any);
    initDomElements(): void;
    static decodeDimension(dimensionString: string): Dimension;
    drawOnApplet(): void;
    /**
     * Preload a PImage accessible after with this.get(int,int) using loadImage()
     *
     * @see #get(int, int)
     * @see #loadImage()
     */
    read(): void;
    /**
     * Returns pixel at {x,y} of previously captured/read image, or 0 if no image
     * loaded.
     *
     * @see #read()
     * @see PImage#get(int, int)
     * @param {number} x
     * @param {number} y
     * @return {number}
     */
    get(x: number, y: number): number;
    loadImage(): PImage;
    start(): void;
    gotStream(stream: any): void;
    noStream(error: any): void;
    streamError(error: any): void;
    ensureAvailable(): void;
    available(): boolean;
    /**
     * @return {Array} Only one value "name=Unknown,size=800x600,fps=30"
     */
    static list(): string[];
}
