/* Generated from Java with JSweet 2.3.0-SNAPSHOT - http://www.jsweet.org */
interface Dimension {
    width : number;

    height : number;
}

class Capture implements PApplet.PImageLike {
    static DEFAULT_WIDTH : number = 800;

    static DEFAULT_HEIGHT : number = 600;

    static CAPTURE_CANVAS_ELEMENT_ID : string = "ProcessingWebCam__captureCanvas";

    static VIDEO_ELEMENT_ID : string = "ProcessingWebCam__videoOutput";

    static INITIALIZED_DATA_ATTRIBUTE_NAME : string = "ProcessingWebCam__initialize";

    /*private*/ applet : PApplet;

    public width : number;

    public height : number;

    /*private*/ videoElement : HTMLVideoElement;

    /*private*/ canvasElement : HTMLCanvasElement;

    /*private*/ canvasContext : CanvasRenderingContext2D;

    /*private*/ __available : boolean;

    /*private*/ capturedImage : PImage;

    /**
     * Last captured image's data
     * 
     * @see #read()
     */
    public imageData : ImageData;

    public toImageData() : ImageData {
        return this.imageData;
    }

    public constructor(applet? : any, width? : any, height? : any) {
        if(((applet != null && applet instanceof <any>PApplet) || applet === null) && ((typeof width === 'number') || width === null) && ((typeof height === 'number') || height === null)) {
            let __args = arguments;
            if(this.applet===undefined) this.applet = null;
            if(this.width===undefined) this.width = 0;
            if(this.height===undefined) this.height = 0;
            if(this.videoElement===undefined) this.videoElement = null;
            if(this.canvasElement===undefined) this.canvasElement = null;
            if(this.canvasContext===undefined) this.canvasContext = null;
            if(this.__available===undefined) this.__available = false;
            if(this.capturedImage===undefined) this.capturedImage = null;
            if(this.imageData===undefined) this.imageData = null;
            if(this.applet===undefined) this.applet = null;
            if(this.width===undefined) this.width = 0;
            if(this.height===undefined) this.height = 0;
            if(this.videoElement===undefined) this.videoElement = null;
            if(this.canvasElement===undefined) this.canvasElement = null;
            if(this.canvasContext===undefined) this.canvasContext = null;
            if(this.__available===undefined) this.__available = false;
            if(this.capturedImage===undefined) this.capturedImage = null;
            if(this.imageData===undefined) this.imageData = null;
            (() => {
                this.applet = applet;
                this.width = width;
                this.height = height;
                this.initDomElements();
            })();
        } else if(((applet != null && applet instanceof <any>PApplet) || applet === null) && ((typeof width === 'string') || width === null) && height === undefined) {
            let __args = arguments;
            let dimension : any = __args[1];
            {
                let __args = arguments;
                let width : any = Capture.decodeDimension(dimension).width;
                let height : any = Capture.decodeDimension(dimension).height;
                if(this.applet===undefined) this.applet = null;
                if(this.width===undefined) this.width = 0;
                if(this.height===undefined) this.height = 0;
                if(this.videoElement===undefined) this.videoElement = null;
                if(this.canvasElement===undefined) this.canvasElement = null;
                if(this.canvasContext===undefined) this.canvasContext = null;
                if(this.__available===undefined) this.__available = false;
                if(this.capturedImage===undefined) this.capturedImage = null;
                if(this.imageData===undefined) this.imageData = null;
                if(this.applet===undefined) this.applet = null;
                if(this.width===undefined) this.width = 0;
                if(this.height===undefined) this.height = 0;
                if(this.videoElement===undefined) this.videoElement = null;
                if(this.canvasElement===undefined) this.canvasElement = null;
                if(this.canvasContext===undefined) this.canvasContext = null;
                if(this.__available===undefined) this.__available = false;
                if(this.capturedImage===undefined) this.capturedImage = null;
                if(this.imageData===undefined) this.imageData = null;
                (() => {
                    this.applet = applet;
                    this.width = width;
                    this.height = height;
                    this.initDomElements();
                })();
            }
        } else throw new Error('invalid overload');
    }

    /*private*/ initDomElements() {
        this.videoElement = <HTMLVideoElement>document.getElementById(Capture.VIDEO_ELEMENT_ID);
        if(this.videoElement == null) {
            this.videoElement = document.createElement("video");
            this.videoElement.setAttribute("id", Capture.VIDEO_ELEMENT_ID);
            this.videoElement.setAttribute("style", "display:none;");
            this.videoElement.setAttribute("width", this.width + "px");
            this.videoElement.setAttribute("height", this.height + "px");
            this.videoElement.setAttribute("autoplay", "true");
            document.body.appendChild(this.videoElement);
        }
        this.canvasElement = <HTMLCanvasElement>document.getElementById(Capture.CAPTURE_CANVAS_ELEMENT_ID);
        if(this.canvasElement == null) {
            this.canvasElement = document.createElement("canvas");
            this.canvasElement.setAttribute("id", Capture.CAPTURE_CANVAS_ELEMENT_ID);
            this.canvasElement.setAttribute("style", "display:none;");
            this.canvasElement.setAttribute("width", this.width + "px");
            this.canvasElement.setAttribute("height", this.height + "px");
            document.body.appendChild(this.canvasElement);
        }
        this.canvasContext = this.canvasElement.getContext("2d");
        this.imageData = this.canvasContext.getImageData(0, 0, this.width, this.height);
    }

    /*private*/ static decodeDimension(dimensionString : string) : Dimension {
        let dimension : Dimension = <any>Object.defineProperty({
            width: Capture.DEFAULT_WIDTH,
            height: Capture.DEFAULT_HEIGHT
        }, '__interfaces', { configurable: true, value: ["processing.webcam.Dimension"] });
        if(dimensionString != null) {
            let sizeRegExp : RegExp = new RegExp("size=([0-9]+)x([0-9]+)", "g");
            let result : RegExpExecArray = sizeRegExp.exec(dimensionString);
            if(result.length > 2) {
                let width : number = parseInt(result[1]);
                if(!isNaN(width)) {
                    dimension.width = width;
                }
                let height : number = parseInt(result[2]);
                if(!isNaN(height)) {
                    dimension.height = height;
                }
            }
        }
        return dimension;
    }

    public drawOnApplet() {
        this.ensureAvailable();
        let appletCanvas : HTMLCanvasElement = this.applet.externals.canvas;
        let appletRenderingContext : CanvasRenderingContext2D = appletCanvas.getContext("2d");
        appletRenderingContext.drawImage(this.videoElement, 0, 0);
    }

    /**
     * Preload a PImage accessible after with this.get(int,int) using loadImage()
     * 
     * @see #get(int, int)
     * @see #loadImage()
     */
    public read() {
        this.capturedImage = this.loadImage();
        this.imageData = this.capturedImage.toImageData();
    }

    /**
     * Returns pixel at {x,y} of previously captured/read image, or 0 if no image
     * loaded.
     * 
     * @see #read()
     * @see PImage#get(int, int)
     * @param {number} x
     * @param {number} y
     * @return {number}
     */
    public get(x : number, y : number) : number {
        if(this.capturedImage == null) {
            return 0;
        }
        return this.capturedImage.get(x, y);
    }

    public loadImage() : PImage {
        this.ensureAvailable();
        this.canvasContext.drawImage(this.videoElement, 0, 0);
        let image : PImage = this.applet.createImage(this.width, this.height, PConstants.ARGB);
        let imageData : ImageData = this.canvasContext.getImageData(0, 0, this.width, this.height);
        image.fromImageData(imageData);
        return image;
    }

    public start() {
        if(this.videoElement.dataset[Capture.INITIALIZED_DATA_ATTRIBUTE_NAME] !== "true") {
            let mediaDevices : Object = <any>((navigator)["mediaDevices"]);
            if(mediaDevices == null || mediaDevices["getUserMedia"] == null) {
                this.noStream("navigator.mediaDevices.getUserMedia not found");
                return;
            }
            let gotStream : (p1: any) => void = (stream) => this.gotStream(stream);
            let noStream : (p1: any) => void = (error) => this.noStream(error);
            let getUserMediaPromise : Promise<any> = <any>(mediaDevices["getUserMedia"]({video: true}));
            getUserMediaPromise.then(<any>(gotStream)).catch(<any>(noStream));
            this.videoElement.dataset[Capture.INITIALIZED_DATA_ATTRIBUTE_NAME] = "true";
        }
    }

    /*private*/ gotStream(stream : any) {
        console.info("requesting video play");
        this.videoElement["srcObject"] = stream;
        this.videoElement.onerror = (error) => {
            this.streamError(error);
            return null;
        };
        this.videoElement.onplay = (__) => {
            console.info("play started, video capture available");
            this.__available = true;
            return null;
        };
    }

    /*private*/ noStream(error : any) {
        console.error("an error occurred while accessing camera: " + error);
    }

    /*private*/ streamError(error : any) {
        console.error("an error occurred while streaming camera: " + error);
    }

    /*private*/ ensureAvailable() {
        if(!this.available()) {
            throw Object.defineProperty(new Error("camera not available"), '__classes', { configurable: true, value: ['java.lang.Throwable','java.lang.Error','java.lang.Object'] });
        }
    }

    public available() : boolean {
        return this.__available;
    }

    /**
     * @return {Array} Only one value "name=Unknown,size=800x600,fps=30"
     */
    public static list() : string[] {
        return ["name=Unknown,size=800x600,fps=30"];
    }
}
Capture["__class"] = "processing.webcam.Capture";
Capture["__interfaces"] = ["def.processing.core.PApplet.PImageLike"];




