/*
 * Decompiled with CFR 0.152.
 */
package processing.webcam;

import def.dom.CanvasRenderingContext2D;
import def.dom.HTMLCanvasElement;
import def.dom.HTMLVideoElement;
import def.dom.ImageData;
import def.dom.Node;
import def.js.Globals;
import def.js.Object;
import def.js.Promise;
import def.js.RegExp;
import def.js.RegExpExecArray;
import def.processing.core.PApplet;
import def.processing.core.PImage;
import java.util.function.Consumer;
import jsweet.util.Lang;
import jsweet.util.StringTypes;
import processing.webcam.Dimension;

public class Capture
extends PApplet.PImageLike {
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 600;
    private static final String CAPTURE_CANVAS_ELEMENT_ID = "ProcessingWebCam__captureCanvas";
    private static final String VIDEO_ELEMENT_ID = "ProcessingWebCam__videoOutput";
    private static final String INITIALIZED_DATA_ATTRIBUTE_NAME = "ProcessingWebCam__initialize";
    private final PApplet applet;
    public final int width;
    public final int height;
    private HTMLVideoElement videoElement;
    private HTMLCanvasElement canvasElement;
    private CanvasRenderingContext2D canvasContext;
    private boolean available;
    private PImage capturedImage;
    public ImageData imageData;

    public ImageData toImageData() {
        return this.imageData;
    }

    public Capture(PApplet applet, String dimension) {
        this(applet, Capture.decodeDimension((String)dimension).width, Capture.decodeDimension((String)dimension).height);
    }

    public Capture(PApplet applet, int width, int height) {
        this.applet = applet;
        this.width = width;
        this.height = height;
        this.initDomElements();
    }

    private void initDomElements() {
        this.videoElement = (HTMLVideoElement)def.dom.Globals.document.getElementById(VIDEO_ELEMENT_ID);
        if (this.videoElement == null) {
            this.videoElement = def.dom.Globals.document.createElement(StringTypes.video);
            this.videoElement.setAttribute("id", VIDEO_ELEMENT_ID);
            this.videoElement.setAttribute("style", "display:none;");
            this.videoElement.setAttribute("width", String.valueOf(this.width) + "px");
            this.videoElement.setAttribute("height", String.valueOf(this.height) + "px");
            this.videoElement.setAttribute("autoplay", "true");
            def.dom.Globals.document.body.appendChild((Node)this.videoElement);
        }
        this.canvasElement = (HTMLCanvasElement)def.dom.Globals.document.getElementById(CAPTURE_CANVAS_ELEMENT_ID);
        if (this.canvasElement == null) {
            this.canvasElement = def.dom.Globals.document.createElement(StringTypes.canvas);
            this.canvasElement.setAttribute("id", CAPTURE_CANVAS_ELEMENT_ID);
            this.canvasElement.setAttribute("style", "display:none;");
            this.canvasElement.setAttribute("width", String.valueOf(this.width) + "px");
            this.canvasElement.setAttribute("height", String.valueOf(this.height) + "px");
            def.dom.Globals.document.body.appendChild((Node)this.canvasElement);
        }
        this.canvasContext = this.canvasElement.getContext(StringTypes._2d);
        this.imageData = this.canvasContext.getImageData(0.0, 0.0, (double)this.width, (double)this.height);
    }

    private static Dimension decodeDimension(String dimensionString) {
        Dimension dimension = new Dimension(){
            {
                this.width = 800;
                this.height = 600;
            }
        };
        if (dimensionString != null) {
            RegExp sizeRegExp = new RegExp("size=([0-9]+)x([0-9]+)", "g");
            RegExpExecArray result = sizeRegExp.exec(dimensionString);
            if (result.length > 2) {
                int height;
                int width = Globals.parseInt((String)((String)result.$get(1)));
                if (!Globals.isNaN((double)width).booleanValue()) {
                    dimension.width = width;
                }
                if (!Globals.isNaN((double)(height = Globals.parseInt((String)((String)result.$get(2))))).booleanValue()) {
                    dimension.height = height;
                }
            }
        }
        return dimension;
    }

    public void drawOnApplet() {
        this.ensureAvailable();
        HTMLCanvasElement appletCanvas = this.applet.externals.canvas;
        CanvasRenderingContext2D appletRenderingContext = appletCanvas.getContext(StringTypes._2d);
        appletRenderingContext.drawImage(this.videoElement, 0.0, 0.0);
    }

    public void read() {
        this.capturedImage = this.loadImage();
        this.imageData = this.capturedImage.toImageData();
    }

    public int get(int x, int y) {
        if (this.capturedImage == null) {
            return 0;
        }
        return this.capturedImage.get(x, y);
    }

    public PImage loadImage() {
        this.ensureAvailable();
        this.canvasContext.drawImage(this.videoElement, 0.0, 0.0);
        PImage image = this.applet.createImage(this.width, this.height, 2);
        ImageData imageData = this.canvasContext.getImageData(0.0, 0.0, (double)this.width, (double)this.height);
        image.fromImageData(imageData);
        return image;
    }

    public void start() {
        if (this.videoElement.dataset.$get(INITIALIZED_DATA_ATTRIBUTE_NAME) != "true") {
            Object mediaDevices = (Object)Lang.object((java.lang.Object)def.dom.Globals.navigator).$get("mediaDevices");
            if (mediaDevices == null || mediaDevices.$get("getUserMedia") == null) {
                this.noStream("navigator.mediaDevices.getUserMedia not found");
                return;
            }
            Consumer<java.lang.Object> gotStream = stream -> this.gotStream(stream);
            Consumer<java.lang.Object> noStream = error -> this.noStream(error);
            Promise getUserMediaPromise = (Promise)mediaDevices.$invoke("getUserMedia", new java.lang.Object[]{Lang.$map((java.lang.Object[])new java.lang.Object[]{"video", true})});
            getUserMediaPromise.then(gotStream).Catch(noStream);
            this.videoElement.dataset.$set(INITIALIZED_DATA_ATTRIBUTE_NAME, (java.lang.Object)"true");
        }
    }

    private void gotStream(java.lang.Object stream) {
        System.out.println("requesting video play");
        this.videoElement.$set("srcObject", stream);
        this.videoElement.onerror = error -> {
            this.streamError(error);
            return null;
        };
        this.videoElement.onplay = __ -> {
            System.out.println("play started, video capture available");
            this.available = true;
            return null;
        };
    }

    private void noStream(java.lang.Object error) {
        System.err.println("an error occurred while accessing camera: " + error);
    }

    private void streamError(java.lang.Object error) {
        System.err.println("an error occurred while streaming camera: " + error);
    }

    private void ensureAvailable() {
        if (!this.available()) {
            throw new Error("camera not available");
        }
    }

    public boolean available() {
        return this.available;
    }

    public static String[] list() {
        return new String[]{"name=Unknown,size=800x600,fps=30"};
    }
}

