/* Generated from Java with JSweet 2.3.0-SNAPSHOT - http://www.jsweet.org */
class Capture {
    static CAPTURE_CANVAS_ELEMENT_ID : string = "ProcessingWebCam__captureCanvas";

    static VIDEO_ELEMENT_ID : string = "ProcessingWebCam__videoOutput";

    static INITIALIZED_DATA_ATTRIBUTE_NAME : string = "ProcessingWebCam__initialize";

    /*private*/ applet : PApplet;

    public width : number;

    public height : number;

    /*private*/ videoElement : HTMLVideoElement;

    /*private*/ canvasElement : HTMLCanvasElement;

    /*private*/ canvasContext : CanvasRenderingContext2D;

    /*private*/ __available : boolean;

    /*private*/ capturedImage : PImage;

    public constructor(applet : PApplet, width : number, height : number) {
        if(this.applet===undefined) this.applet = null;
        if(this.width===undefined) this.width = 0;
        if(this.height===undefined) this.height = 0;
        if(this.videoElement===undefined) this.videoElement = null;
        if(this.canvasElement===undefined) this.canvasElement = null;
        if(this.canvasContext===undefined) this.canvasContext = null;
        if(this.__available===undefined) this.__available = false;
        if(this.capturedImage===undefined) this.capturedImage = null;
        this.applet = applet;
        this.width = width;
        this.height = height;
        this.videoElement = <HTMLVideoElement>document.getElementById(Capture.VIDEO_ELEMENT_ID);
        if(this.videoElement == null) {
            this.videoElement = document.createElement("video");
            this.videoElement.setAttribute("id", Capture.VIDEO_ELEMENT_ID);
            this.videoElement.setAttribute("style", "display:none;");
            this.videoElement.setAttribute("width", width + "px");
            this.videoElement.setAttribute("height", height + "px");
            this.videoElement.setAttribute("autoplay", "true");
            document.body.appendChild(this.videoElement);
        }
        this.canvasElement = <HTMLCanvasElement>document.getElementById(Capture.CAPTURE_CANVAS_ELEMENT_ID);
        if(this.canvasElement == null) {
            this.canvasElement = document.createElement("canvas");
            this.canvasElement.setAttribute("id", Capture.CAPTURE_CANVAS_ELEMENT_ID);
            this.canvasElement.setAttribute("style", "display:none;");
            this.canvasElement.setAttribute("width", width + "px");
            this.canvasElement.setAttribute("height", height + "px");
            document.body.appendChild(this.canvasElement);
        }
        this.canvasContext = this.canvasElement.getContext("2d");
    }

    public drawOnApplet() {
        this.ensureAvailable();
        let appletCanvas : HTMLCanvasElement = this.applet.externals.canvas;
        let appletRenderingContext : CanvasRenderingContext2D = appletCanvas.getContext("2d");
        appletRenderingContext.drawImage(this.videoElement, 0, 0);
    }

    /**
     * Preload a PImage accessible after with this.get(int,int) using loadImage()
     * 
     * @see #get(int, int)
     * @see #loadImage()
     */
    public read() {
        this.capturedImage = this.loadImage();
    }

    /**
     * Returns pixel at {x,y} of previously captured/read image, or 0 if no image
     * loaded.
     * 
     * @see #read()
     * @see PImage#get(int, int)
     * @param {number} x
     * @param {number} y
     * @return {number}
     */
    public get(x : number, y : number) : number {
        if(this.capturedImage == null) {
            return 0;
        }
        return this.capturedImage.get(x, y);
    }

    public loadImage() : PImage {
        this.ensureAvailable();
        this.canvasContext.drawImage(this.videoElement, 0, 0);
        let image : PImage = this.applet.createImage(this.width, this.height, PConstants.ARGB);
        let imageData : ImageData = this.canvasContext.getImageData(0, 0, this.width, this.height);
        image.fromImageData(imageData);
        return image;
    }

    public start() {
        if(this.videoElement.dataset[Capture.INITIALIZED_DATA_ATTRIBUTE_NAME] !== "true") {
            let mediaDevices : Object = <any>((navigator)["mediaDevices"]);
            if(mediaDevices == null || mediaDevices["getUserMedia"] == null) {
                this.noStream("navigator.mediaDevices.getUserMedia not found");
                return;
            }
            let gotStream : (p1: any) => void = (stream) => this.gotStream(stream);
            let noStream : (p1: any) => void = (error) => this.noStream(error);
            let getUserMediaPromise : Promise<any> = <any>(mediaDevices["getUserMedia"]({video: true}));
            getUserMediaPromise.then(<any>(gotStream)).catch(<any>(noStream));
            this.videoElement.dataset[Capture.INITIALIZED_DATA_ATTRIBUTE_NAME] = "true";
        }
    }

    /*private*/ gotStream(stream : any) {
        console.info("requesting video play");
        this.videoElement["srcObject"] = stream;
        this.videoElement.onerror = (error) => {
            this.streamError(error);
            return null;
        };
        this.videoElement.onplay = (__) => {
            console.info("play started, video capture available");
            this.__available = true;
            return null;
        };
    }

    /*private*/ noStream(error : any) {
        console.error("an error occurred while accessing camera: " + error);
    }

    /*private*/ streamError(error : any) {
        console.error("an error occurred while streaming camera: " + error);
    }

    /*private*/ ensureAvailable() {
        if(!this.available()) {
            throw Object.defineProperty(new Error("camera not available"), '__classes', { configurable: true, value: ['java.lang.Throwable','java.lang.Error','java.lang.Object'] });
        }
    }

    public available() : boolean {
        return this.__available;
    }
}
Capture["__class"] = "processing.webcam.Capture";



