/*
 * Decompiled with CFR 0.152.
 */
package processing.webcam;

import def.dom.CanvasRenderingContext2D;
import def.dom.Globals;
import def.dom.HTMLCanvasElement;
import def.dom.HTMLVideoElement;
import def.dom.ImageData;
import def.dom.Node;
import def.js.Object;
import def.js.Promise;
import def.processing.core.PApplet;
import def.processing.core.PImage;
import java.util.function.Consumer;
import jsweet.util.Lang;
import jsweet.util.StringTypes;

public class Capture {
    private static final String CAPTURE_CANVAS_ELEMENT_ID = "ProcessingWebCam__captureCanvas";
    private static final String VIDEO_ELEMENT_ID = "ProcessingWebCam__videoOutput";
    private static final String INITIALIZED_DATA_ATTRIBUTE_NAME = "ProcessingWebCam__initialize";
    private final PApplet applet;
    public final int width;
    public final int height;
    private HTMLVideoElement videoElement;
    private HTMLCanvasElement canvasElement;
    private CanvasRenderingContext2D canvasContext;
    private boolean available;
    private PImage capturedImage;

    public Capture(PApplet applet, int width, int height) {
        this.applet = applet;
        this.width = width;
        this.height = height;
        this.videoElement = (HTMLVideoElement)Globals.document.getElementById(VIDEO_ELEMENT_ID);
        if (this.videoElement == null) {
            this.videoElement = Globals.document.createElement(StringTypes.video);
            this.videoElement.setAttribute("id", VIDEO_ELEMENT_ID);
            this.videoElement.setAttribute("style", "display:none;");
            this.videoElement.setAttribute("width", String.valueOf(width) + "px");
            this.videoElement.setAttribute("height", String.valueOf(height) + "px");
            this.videoElement.setAttribute("autoplay", "true");
            Globals.document.body.appendChild((Node)this.videoElement);
        }
        this.canvasElement = (HTMLCanvasElement)Globals.document.getElementById(CAPTURE_CANVAS_ELEMENT_ID);
        if (this.canvasElement == null) {
            this.canvasElement = Globals.document.createElement(StringTypes.canvas);
            this.canvasElement.setAttribute("id", CAPTURE_CANVAS_ELEMENT_ID);
            this.canvasElement.setAttribute("style", "display:none;");
            this.canvasElement.setAttribute("width", String.valueOf(width) + "px");
            this.canvasElement.setAttribute("height", String.valueOf(height) + "px");
            Globals.document.body.appendChild((Node)this.canvasElement);
        }
        this.canvasContext = this.canvasElement.getContext(StringTypes._2d);
    }

    public void drawOnApplet() {
        this.ensureAvailable();
        HTMLCanvasElement appletCanvas = this.applet.externals.canvas;
        CanvasRenderingContext2D appletRenderingContext = appletCanvas.getContext(StringTypes._2d);
        appletRenderingContext.drawImage(this.videoElement, 0.0, 0.0);
    }

    public void read() {
        this.capturedImage = this.loadImage();
    }

    public int get(int x, int y) {
        if (this.capturedImage == null) {
            return 0;
        }
        return this.capturedImage.get(x, y);
    }

    public PImage loadImage() {
        this.ensureAvailable();
        this.canvasContext.drawImage(this.videoElement, 0.0, 0.0);
        PImage image = this.applet.createImage(this.width, this.height, 2);
        ImageData imageData = this.canvasContext.getImageData(0.0, 0.0, (double)this.width, (double)this.height);
        image.fromImageData(imageData);
        return image;
    }

    public void start() {
        if (this.videoElement.dataset.$get(INITIALIZED_DATA_ATTRIBUTE_NAME) != "true") {
            Object mediaDevices = (Object)Lang.object((java.lang.Object)Globals.navigator).$get("mediaDevices");
            if (mediaDevices == null || mediaDevices.$get("getUserMedia") == null) {
                this.noStream("navigator.mediaDevices.getUserMedia not found");
                return;
            }
            Consumer<java.lang.Object> gotStream = stream -> this.gotStream(stream);
            Consumer<java.lang.Object> noStream = error -> this.noStream(error);
            Promise getUserMediaPromise = (Promise)mediaDevices.$invoke("getUserMedia", new java.lang.Object[]{Lang.$map((java.lang.Object[])new java.lang.Object[]{"video", true})});
            getUserMediaPromise.then(gotStream).Catch(noStream);
            this.videoElement.dataset.$set(INITIALIZED_DATA_ATTRIBUTE_NAME, (java.lang.Object)"true");
        }
    }

    private void gotStream(java.lang.Object stream) {
        System.out.println("requesting video play");
        this.videoElement.$set("srcObject", stream);
        this.videoElement.onerror = error -> {
            this.streamError(error);
            return null;
        };
        this.videoElement.onplay = __ -> {
            System.out.println("play started, video capture available");
            this.available = true;
            return null;
        };
    }

    private void noStream(java.lang.Object error) {
        System.err.println("an error occurred while accessing camera: " + error);
    }

    private void streamError(java.lang.Object error) {
        System.err.println("an error occurred while streaming camera: " + error);
    }

    private void ensureAvailable() {
        if (!this.available()) {
            throw new Error("camera not available");
        }
    }

    public boolean available() {
        return this.available;
    }
}

