/* Generated from Java with JSweet 2.2.0-SNAPSHOT - http://www.jsweet.org */
namespace ktbyte.gui {}
namespace ktbyte.gui {
    /**
     * This abstract class should be extended by the KTGUI components (controllers)
     * @class
     */
    export abstract class EventAdapter {
        public onMousePressed() {
        }

        public onMouseReleased() {
        }

        public onMouseMoved() {
        }

        public onMouseDragged() {
        }

        public onMouseWheel(count : number) {
        }

        public onAnyKeyReleased() {
        }

        public onAnyKeyPressed() {
        }

        public onEnterKeyPressed() {
        }

        public onValueChanged() {
        }

        public onConsoleInput(textInput : string, lastVariableName : string) {
        }

        public println(string : string) {
            PApplet.println(string);
        }
    }
    EventAdapter["__class"] = "ktbyte.gui.EventAdapter";

}
namespace ktbyte.gui {
    /**
     * This is a constructor of the KTGUI class.
     * It automatically registers the 'draw', 'mouseEvent' and 'keyEvent' methods of this class in PApplet.
     * @param {*} pa
     * @class
     */
    export class KTGUI implements PConstants {
        static pa : any = null;

        /*private*/ garbageList : any;

        public drawCallStack : Array<string> = <any>([]);

        public static COLOR_FG_HOVERED : number = 0;

        public static COLOR_FG_PRESSED : number = 0;

        public static COLOR_FG_PASSIVE : number = 0;

        public static COLOR_BG_HOVERED : number = 0;

        public static COLOR_BG_PASSIVE : number = 0;

        public static COLOR_BG_PRESSED : number = 0;

        public static DEFAULT_COMPONENT_WIDTH : number = 0;

        public static DEFAULT_ALIGN_GAP : number = 0;

        public static DEFAULT_ROUNDING : number = 0;

        static debugControllers : boolean = false;

        /*private*/ debugDrawCallStack : boolean = false;

        public constructor(pa : any) {
            if(this.garbageList===undefined) this.garbageList = null;
            KTGUI.debug("\nCreating of the KTGUI instance started.");
            this.init(pa);
            KTGUI.debug("Creating of the KTGUI instance completed.\n");
        }

        /*private*/ init(pa : any) {
            KTGUI.debug("\tInitializing of the KTGUI started.");
            KTGUI.pa = pa;
            KTGUI.pa.registerMethod("draw", this);
            KTGUI.debug("\t\t\'draw()\' method has been registered in parent PApplet.");
            KTGUI.pa.registerMethod("mouseEvent", this);
            KTGUI.debug("\t\t\'mouseEvent()\' method has been registered in parent PApplet.");
            KTGUI.pa.registerMethod("keyEvent", this);
            KTGUI.debug("\t\t\'keyEvent()\' method has been registered in parent PApplet.");
            this.garbageList = <any>({});
            KTGUI.debug("\t\tGarbage list created.");
            KTGUI.COLOR_FG_PASSIVE = pa.color(150, 180, 150);
            KTGUI.COLOR_FG_HOVERED = pa.color(150, 220, 150);
            KTGUI.COLOR_FG_PRESSED = pa.color(110, 200, 110);
            KTGUI.COLOR_BG_PASSIVE = pa.color(190);
            KTGUI.COLOR_BG_HOVERED = pa.color(220);
            KTGUI.COLOR_BG_PRESSED = pa.color(210);
            KTGUI.DEFAULT_COMPONENT_WIDTH = 16;
            KTGUI.DEFAULT_ALIGN_GAP = 20;
            KTGUI.DEFAULT_ROUNDING = 8;
            KTGUI.debug("\t\tColor and size constants initialized.");
            ktbyte.gui.StageManager.getInstance();
            KTGUI.debug("\tInitializing of the KTGUI completed.");
        }

        public static getParentPApplet() : any {
            return KTGUI.pa;
        }

        /**
         * This method is intended to be called <b>automatically</b> at the end of each draw() cycle of the parent PApplet.
         * This way, the KTGUI class automatically updates all the controllers on the <i>default</i> and <i>active</i> stages.
         */
        public draw() {
            if(ktbyte.gui.StageManager.getInstance().userStagesExist()) {
                ktbyte.gui.StageManager.getInstance().getActiveStage().draw();
            }
            ktbyte.gui.StageManager.getInstance().getDefaultStage().draw();
            this.collectGarbage();
        }

        public setDrawCallStackFlag(debug : boolean) {
            this.debugDrawCallStack = debug;
        }

        drawDebugTextSplitLine(x : number, y : number) {
            KTGUI.pa.text("----------------------------------------------------------------------------------------------------------------------------", x, y);
        }

        public addDrawCallStackDebugMessage(msg : string) {
            if(this.debugDrawCallStack) {
                /* add */(this.drawCallStack.push(msg)>0);
            }
        }

        public addToGarbage(controller : ktbyte.gui.Controller, millis : number) {
            /* put */((m,k,v) => { if(m.entries==null) m.entries=[]; for(let i=0;i<m.entries.length;i++) if(m.entries[i].key.equals!=null && m.entries[i].key.equals(k) || m.entries[i].key===k) { m.entries[i].value=v; return; } m.entries.push({key:k,value:v,getKey: function() { return this.key }, getValue: function() { return this.value }}); })(<any>this.garbageList, controller, millis);
        }

        collectGarbage() {
            {
                let array122 = /* entrySet */((m) => { if(m.entries==null) m.entries=[]; return m.entries; })(<any>this.garbageList);
                for(let index121=0; index121 < array122.length; index121++) {
                    let me = array122[index121];
                    {
                        let controller : ktbyte.gui.Controller = <ktbyte.gui.Controller>me.getKey();
                        let time : number = <number>me.getValue();
                        if(KTGUI.pa.millis() - time > 100) {
                            if(controller.parentStage != null) {
                                controller.parentStage.unregisterController(controller);
                            } else {
                                if(controller.parentController != null) {
                                    controller.parentController.detachController(controller);
                                }
                            }
                        }
                    }
                }
            }
        }

        public createButton$java_lang_String$int$int$int$int(title : string, x : number, y : number, w : number, h : number) : ktbyte.gui.Button {
            return new ktbyte.gui.Button(this, title, x, y, w, h);
        }

        public createButton(title? : any, x? : any, y? : any, w? : any, h? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                return <any>this.createButton$java_lang_String$int$int$int$int(title, x, y, w, h);
            } else if(((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                return <any>this.createButton$int$int$int$int(title, x, y, w);
            } else throw new Error('invalid overload');
        }

        public createButton$int$int$int$int(x : number, y : number, w : number, h : number) : ktbyte.gui.Button {
            return new ktbyte.gui.Button(this, "A Button", x, y, w, h);
        }

        public createDirectionButton$java_lang_String$int$int$int$int$int(title : string, x : number, y : number, w : number, h : number, dir : number) : ktbyte.gui.ArrowButton {
            return new ktbyte.gui.ArrowButton(this, title, x, y, w, h, dir);
        }

        public createDirectionButton(title? : any, x? : any, y? : any, w? : any, h? : any, dir? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof dir === 'number') || dir === null)) {
                return <any>this.createDirectionButton$java_lang_String$int$int$int$int$int(title, x, y, w, h, dir);
            } else if(((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && dir === undefined) {
                return <any>this.createDirectionButton$int$int$int$int$int(title, x, y, w, h);
            } else throw new Error('invalid overload');
        }

        public createDirectionButton$int$int$int$int$int(x : number, y : number, w : number, h : number, dir : number) : ktbyte.gui.ArrowButton {
            return new ktbyte.gui.ArrowButton(this, "A DirButton", x, y, w, h, dir);
        }

        public createSlider$java_lang_String$int$int$int$int$int$int(title : string, posx : number, posy : number, w : number, h : number, sr : number, er : number) : ktbyte.gui.Slider {
            return new ktbyte.gui.Slider(this, title, posx, posy, w, h, sr, er);
        }

        public createSlider(title? : any, posx? : any, posy? : any, w? : any, h? : any, sr? : any, er? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof posx === 'number') || posx === null) && ((typeof posy === 'number') || posy === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof sr === 'number') || sr === null) && ((typeof er === 'number') || er === null)) {
                return <any>this.createSlider$java_lang_String$int$int$int$int$int$int(title, posx, posy, w, h, sr, er);
            } else if(((typeof title === 'number') || title === null) && ((typeof posx === 'number') || posx === null) && ((typeof posy === 'number') || posy === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof sr === 'number') || sr === null) && er === undefined) {
                return <any>this.createSlider$int$int$int$int$int$int(title, posx, posy, w, h, sr);
            } else throw new Error('invalid overload');
        }

        public createSlider$int$int$int$int$int$int(posx : number, posy : number, w : number, h : number, sr : number, er : number) : ktbyte.gui.Slider {
            return new ktbyte.gui.Slider(this, "A Slider", posx, posy, w, h, sr, er);
        }

        public createPanel$java_lang_String$int$int$int$int(title : string, x : number, y : number, w : number, h : number) : ktbyte.gui.Panel {
            let panel : ktbyte.gui.Panel = new ktbyte.gui.Panel(this, title, x, y, w, h);
            return panel;
        }

        public createPanel(title? : any, x? : any, y? : any, w? : any, h? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                return <any>this.createPanel$java_lang_String$int$int$int$int(title, x, y, w, h);
            } else if(((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                return <any>this.createPanel$int$int$int$int(title, x, y, w);
            } else throw new Error('invalid overload');
        }

        public createPanel$int$int$int$int(x : number, y : number, w : number, h : number) : ktbyte.gui.Panel {
            let panel : ktbyte.gui.Panel = new ktbyte.gui.Panel(this, "A Panel", x, y, w, h);
            return panel;
        }

        public createPane$java_lang_String$int$int$int$int(title : string, x : number, y : number, w : number, h : number) : ktbyte.gui.Pane {
            let pane : ktbyte.gui.Pane = new ktbyte.gui.Pane(this, title, x, y, w, h);
            return pane;
        }

        public createPane(title? : any, x? : any, y? : any, w? : any, h? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                return <any>this.createPane$java_lang_String$int$int$int$int(title, x, y, w, h);
            } else if(((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                return <any>this.createPane$int$int$int$int(title, x, y, w);
            } else throw new Error('invalid overload');
        }

        public createPane$int$int$int$int(x : number, y : number, w : number, h : number) : ktbyte.gui.Pane {
            let pane : ktbyte.gui.Pane = new ktbyte.gui.Pane(this, "A Pane", x, y, w, h);
            return pane;
        }

        public createScrollBar$int$int$int$int$int$int(x : number, y : number, w : number, h : number, sr : number, er : number) : ktbyte.gui.ScrollBar {
            let scrollBar : ktbyte.gui.ScrollBar = this.createScrollBar$java_lang_String$int$int$int$int$int$int("A ScrollBar", x, y, w, h, sr, er);
            return scrollBar;
        }

        public createScrollBar$java_lang_String$int$int$int$int$int$int(title : string, x : number, y : number, w : number, h : number, sr : number, er : number) : ktbyte.gui.ScrollBar {
            if(w > h) {
                if((w - 2 * h) < 2 * KTGUI.DEFAULT_COMPONENT_WIDTH) {
                    KTGUI.debug("ERROR: The width of the ScrollBar to be created is  too small. As a consequence, the internal slider would have  orthogonal direction. Cannot create ScrollBar. Returning null reference.");
                    return null;
                }
            } else {
                if((h - 2 * w) < 2 * KTGUI.DEFAULT_COMPONENT_WIDTH) {
                    KTGUI.debug("ERROR: The height of the ScrollBar to be created is  too small. As a consequence, the internal slider would have  orthogonal direction. Cannot create ScrollBar. Returning null reference.");
                    return null;
                }
            }
            let scrollBar : ktbyte.gui.ScrollBar = new ktbyte.gui.ScrollBar(this, title, x, y, w, h, sr, er);
            return scrollBar;
        }

        public createScrollBar(title? : any, x? : any, y? : any, w? : any, h? : any, sr? : any, er? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof sr === 'number') || sr === null) && ((typeof er === 'number') || er === null)) {
                return <any>this.createScrollBar$java_lang_String$int$int$int$int$int$int(title, x, y, w, h, sr, er);
            } else if(((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof sr === 'number') || sr === null) && er === undefined) {
                return <any>this.createScrollBar$int$int$int$int$int$int(title, x, y, w, h, sr);
            } else throw new Error('invalid overload');
        }

        public createInputTextBox$java_lang_String$int$int$int$int(title : string, x : number, y : number, w : number, h : number) : ktbyte.gui.InputTextBox {
            return new ktbyte.gui.InputTextBox(this, title, x, y, w, h);
        }

        public createInputTextBox(title? : any, x? : any, y? : any, w? : any, h? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                return <any>this.createInputTextBox$java_lang_String$int$int$int$int(title, x, y, w, h);
            } else if(((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                return <any>this.createInputTextBox$int$int$int$int(title, x, y, w);
            } else throw new Error('invalid overload');
        }

        public createInputTextBox$int$int$int$int(x : number, y : number, w : number, h : number) : ktbyte.gui.InputTextBox {
            return this.createInputTextBox$java_lang_String$int$int$int$int("An InputTextBox", x, y, w, h);
        }

        /**
         * This method 'redirects' the emitted mouse event from PApplet to KTGUI 'transfer' methods.
         * This method will be called <b>automatically</b> when the PApplet.mouseEvent is happening.
         * @param {ProcessingMouseEvent} e
         */
        public mouseEvent(e : ProcessingMouseEvent) {
            switch((e.getAction())) {
            case ProcessingMouseEvent.PRESS:
                this.mousePressed();
                break;
            case ProcessingMouseEvent.RELEASE:
                this.mouseReleased();
                break;
            case ProcessingMouseEvent.DRAG:
                this.mouseDragged();
                break;
            case ProcessingMouseEvent.MOVE:
                this.mouseMoved();
                break;
            case ProcessingMouseEvent.WHEEL:
                this.mouseWheel(e);
                break;
            }
        }

        /**
         * This method 'redirects' the emitted keyboard event from PApplet to KTGUI 'transfer' methods.
         * This method will be called <b>automatically</b> when the PApplet.keyEvent is happening.
         * @param {ProcessingKeyEvent} e
         */
        public keyEvent(e : ProcessingKeyEvent) {
            switch((e.getAction())) {
            case ProcessingKeyEvent.PRESS:
                this.keyPressed();
                break;
            case ProcessingKeyEvent.RELEASE:
                this.keyReleased();
                break;
            }
        }

        public static debug(string : string) {
            if(KTGUI.debugControllers) PApplet.println(string);
        }

        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.mouseDragged event to KTGUI components (controllers)
         * @private
         */
        /*private*/ mouseDragged() {
            for(let index123=0; index123 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index123++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index123];
                {
                    controller.processMouseDragged();
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index124=0; index124 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index124++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index124];
                    {
                        controller.processMouseDragged();
                    }
                }
            }
        }

        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.mousePressed event to KTGUI components (controllers)
         * @private
         */
        /*private*/ mousePressed() {
            for(let index125=0; index125 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index125++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index125];
                {
                    controller.processMousePressed();
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index126=0; index126 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index126++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index126];
                    {
                        controller.processMousePressed();
                    }
                }
            }
        }

        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.mouseReleased event to KTGUI components (controllers)
         * @private
         */
        /*private*/ mouseReleased() {
            for(let index127=0; index127 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index127++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index127];
                {
                    controller.processMouseReleased();
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index128=0; index128 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index128++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index128];
                    {
                        controller.processMouseReleased();
                    }
                }
            }
        }

        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.mouseMoved event to KTGUI components (controllers)
         * @private
         */
        /*private*/ mouseMoved() {
            for(let index129=0; index129 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index129++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index129];
                {
                    controller.processMouseMoved();
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index130=0; index130 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index130++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index130];
                    {
                        controller.processMouseMoved();
                    }
                }
            }
        }

        /*private*/ mouseWheel(me : ProcessingMouseEvent) {
            for(let index131=0; index131 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index131++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index131];
                {
                    controller.processMouseWheel(me);
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index132=0; index132 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index132++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index132];
                    {
                        controller.processMouseWheel(me);
                    }
                }
            }
        }

        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.keyPressed event to KTGUI components (controllers)
         * @private
         */
        /*private*/ keyPressed() {
            for(let index133=0; index133 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index133++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index133];
                {
                    controller.processKeyPressed();
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index134=0; index134 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index134++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index134];
                    {
                        controller.processKeyPressed();
                    }
                }
            }
        }

        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.keyReleased event to KTGUI components (controllers)
         * @private
         */
        /*private*/ keyReleased() {
            for(let index135=0; index135 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index135++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index135];
                {
                    controller.processKeyReleased();
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index136=0; index136 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index136++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index136];
                    {
                        controller.processKeyReleased();
                    }
                }
            }
        }
    }
    KTGUI["__class"] = "ktbyte.gui.KTGUI";
    KTGUI["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    /**
     * 
     * 
     * @class
     */
    export class StageManager {
        static __static_initialized : boolean = false;
        static __static_initialize() { if(!StageManager.__static_initialized) { StageManager.__static_initialized = true; StageManager.__static_initializer_0(); } }

        public static stages : Array<ktbyte.gui.Stage>; public static stages_$LI$() : Array<ktbyte.gui.Stage> { StageManager.__static_initialize(); return StageManager.stages; };

        static activeStage : ktbyte.gui.Stage; public static activeStage_$LI$() : ktbyte.gui.Stage { StageManager.__static_initialize(); return StageManager.activeStage; };

        static defaultStage : ktbyte.gui.Stage; public static defaultStage_$LI$() : ktbyte.gui.Stage { StageManager.__static_initialize(); return StageManager.defaultStage; };

        static instance : StageManager; public static instance_$LI$() : StageManager { StageManager.__static_initialize(); return StageManager.instance; };

        static __static_initializer_0() {
            StageManager.instance = new StageManager();
            StageManager.instance_$LI$().init();
        }

        public static getInstance() : StageManager {
            return StageManager.instance_$LI$();
        }

        /*private*/ init() {
            StageManager.stages = <any>([]);
            StageManager.defaultStage = this.createStage("Default");
            StageManager.activeStage = StageManager.defaultStage;
        }

        public createStage(name : string) : ktbyte.gui.Stage {
            let stage : ktbyte.gui.Stage = new ktbyte.gui.Stage(name);
            StageManager.activeStage = stage;
            return stage;
        }

        public getDefaultStage() : ktbyte.gui.Stage {
            return StageManager.defaultStage_$LI$();
        }

        public getActiveStage() : ktbyte.gui.Stage {
            return StageManager.activeStage_$LI$();
        }

        public goToStage$ktbyte_gui_Stage(stage : ktbyte.gui.Stage) {
            if(stage !== StageManager.defaultStage_$LI$()) {
                StageManager.activeStage = stage;
            }
        }

        public goToStage(stage? : any) : any {
            if(((stage != null && stage instanceof <any>ktbyte.gui.Stage) || stage === null)) {
                return <any>this.goToStage$ktbyte_gui_Stage(stage);
            } else if(((typeof stage === 'number') || stage === null)) {
                return <any>this.goToStage$int(stage);
            } else throw new Error('invalid overload');
        }

        public goToStage$int(numStage : number) {
            if(numStage > 0 && numStage < /* size */(<number>StageManager.stages_$LI$().length)) {
                StageManager.activeStage = /* get */StageManager.stages[numStage];
            }
        }

        public goToNextStage() {
            if(this.userStagesExist()) {
                let indexOfCurrentStage : number = StageManager.stages_$LI$().indexOf(StageManager.activeStage_$LI$());
                if(indexOfCurrentStage > 0 && indexOfCurrentStage < /* size */(<number>StageManager.stages_$LI$().length) - 1) {
                    StageManager.activeStage = /* get */StageManager.stages[indexOfCurrentStage + 1];
                } else {
                    StageManager.activeStage = /* get */StageManager.stages[1];
                }
            }
        }

        public unregisterControllerFromAllStages(controller : ktbyte.gui.Controller) {
            ktbyte.gui.KTGUI.debug("Unregistering [" + controller.title + "] from all stages ...");
            for(let index137=0; index137 < StageManager.stages_$LI$().length; index137++) {
                let stage = StageManager.stages_$LI$()[index137];
                {
                    ktbyte.gui.KTGUI.debug("\tStage {" + stage.getName() + "} contains:");
                    for(let index138=0; index138 < stage.controllers.length; index138++) {
                        let c = stage.controllers[index138];
                        {
                            ktbyte.gui.KTGUI.debug("\t\t[" + c.title + "] of type <" + /* getName */(c => c["__class"]?c["__class"]:c["name"])((<any>c.constructor)) + ">");
                        }
                    }
                    if(/* contains */(stage.controllers.indexOf(<any>(controller)) >= 0)) {
                        ktbyte.gui.KTGUI.debug("\t\t\t>>> Found [" + controller.title + "] of type <" + /* getName */(c => c["__class"]?c["__class"]:c["name"])((<any>controller.constructor)) + "> in stage {" + stage.getName() + "}, removing ...");
                        /* remove */stage.controllers.splice(stage.controllers.indexOf(controller), 1)[0];
                        ktbyte.gui.KTGUI.debug("\t\t\tNow, {" + stage.getName() + "}.controllers.contains(" + controller.title + ") = " + /* contains */(stage.controllers.indexOf(<any>(controller)) >= 0));
                    }
                }
            }
            controller.parentStage = null;
            ktbyte.gui.KTGUI.debug("Done.");
        }

        public userStagesExist() : boolean {
            return StageManager.getInstance().getDefaultStage() !== StageManager.getInstance().getActiveStage();
        }

        public getStages() : Array<ktbyte.gui.Stage> {
            return StageManager.stages_$LI$();
        }
    }
    StageManager["__class"] = "ktbyte.gui.StageManager";

}
namespace ktbyte.gui {
    export class EventProcessor {
        public isActive : boolean = true;

        public isPressed : boolean;

        public isHovered : boolean;

        public isDragged : boolean;

        public isVisible : boolean = true;

        public isDragable : boolean;

        public handleFocus : boolean;

        public adapters : Array<ktbyte.gui.EventAdapter> = <any>([]);

        public processMouseMoved() {
        }

        public processMousePressed() {
        }

        public processMouseReleased() {
        }

        public processMouseDragged() {
        }

        public processMouseWheel(me : ProcessingMouseEvent) {
        }

        public processKeyPressed() {
        }

        public processKeyReleased() {
        }

        public isPointInside(x : number, y : number) : boolean {
            return false;
        }

        public addEventAdapter(adapter : ktbyte.gui.EventAdapter) {
            /* add */(this.adapters.push(adapter)>0);
        }

        constructor() {
            if(this.isPressed===undefined) this.isPressed = false;
            if(this.isHovered===undefined) this.isHovered = false;
            if(this.isDragged===undefined) this.isDragged = false;
            if(this.isDragable===undefined) this.isDragable = false;
            if(this.handleFocus===undefined) this.handleFocus = false;
        }
    }
    EventProcessor["__class"] = "ktbyte.gui.EventProcessor";

}
namespace ktbyte.gui {
    /**
     * A Stage can have multple controllers.
     * The KTGUI class should handle the transition from one Stage to another.
     * Only one Stage can be active at a time.
     * Only the GUI elements from the active Stage will be displayed
     * This allows the sharing of variables between different Stages, by storing/retriving data from the 'context' object
     * @param {string} name
     * @class
     */
    export class Stage {
        controllers : Array<ktbyte.gui.Controller>;

        name : string;

        pa : any;

        public constructor(name : string) {
            if(this.controllers===undefined) this.controllers = null;
            if(this.name===undefined) this.name = null;
            if(this.pa===undefined) this.pa = null;
            ktbyte.gui.KTGUI.debug("Creation of stage {" + name + "} started.");
            this.pa = ktbyte.gui.KTGUI.getParentPApplet();
            this.name = name;
            this.controllers = <any>([]);
            /* add */(ktbyte.gui.StageManager.getInstance().getStages().push(this)>0);
            ktbyte.gui.KTGUI.debug("Creation of stage {" + name + "} completed.");
        }

        public getName() : string {
            return this.name;
        }

        public draw() {
            for(let index139=0; index139 < this.controllers.length; index139++) {
                let controller = this.controllers[index139];
                {
                    if(controller.isActive) {
                        controller.updateGraphics();
                        controller.draw();
                    }
                }
            }
        }

        public registerController(controller : ktbyte.gui.Controller) {
            ktbyte.gui.KTGUI.debug("Registering controller [" + controller.title + "] of type <" + /* getName */(c => c["__class"]?c["__class"]:c["name"])((<any>controller.constructor)) + "> in stage {" + this.name + "}:");
            if(/* contains */(this.controllers.indexOf(<any>(controller)) >= 0)) {
                ktbyte.gui.KTGUI.debug("\tController [" + controller.title + "] already exist in stage {" + this.name + "}. Interrupting.");
                return;
            }
            if(/* contains */(ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.indexOf(<any>(controller)) >= 0)) {
                ktbyte.gui.StageManager.getInstance().getDefaultStage().unregisterController(controller);
            }
            if(ktbyte.gui.StageManager.getInstance().getActiveStage() != null) {
                if(/* contains */(ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.indexOf(<any>(controller)) >= 0)) {
                    ktbyte.gui.StageManager.getInstance().getActiveStage().unregisterController(controller);
                }
            }
            /* add */(this.controllers.push(controller)>0);
            controller.parentStage = this;
            ktbyte.gui.KTGUI.debug("\tDone. Now, stage {" + this.name + "} contain " + /* size */(<number>this.controllers.length) + " controller(s).");
            for(let index140=0; index140 < this.controllers.length; index140++) {
                let c = this.controllers[index140];
                {
                    ktbyte.gui.KTGUI.debug("\t\t" + this.controllers.indexOf(c) + ": " + c.title + " (" + /* size */(<number>c.controllers.length) + " child controllers)");
                    for(let index141=0; index141 < c.controllers.length; index141++) {
                        let child = c.controllers[index141];
                        {
                            ktbyte.gui.KTGUI.debug("\t\t\t" + c.controllers.indexOf(child) + ": " + child.title);
                        }
                    }
                }
            }
        }

        public unregisterController(controller : ktbyte.gui.Controller) {
            if(/* contains */(this.controllers.indexOf(<any>(controller)) >= 0)) {
                /* remove */(a => { let index = a.indexOf(controller); if(index>=0) { a.splice(index, 1); return true; } else { return false; }})(this.controllers);
                controller.parentStage = null;
            }
        }

        public getControllers() : Array<ktbyte.gui.Controller> {
            return this.controllers;
        }
    }
    Stage["__class"] = "ktbyte.gui.Stage";

}
namespace ktbyte.gui {
    /**
     * This class automatically receives events from PApplet when they happen.
     * Every KTGUI component (controller) should extend this class in order to be able to receive the mouse and keyboard
     * events.
     * One should override only the 'needed' event methods. This allows to save time and decrease the amount of code.
     * One should always overridde the 'draw' method.
     * @extends ktbyte.gui.EventProcessor
     * @class
     */
    export abstract class Controller extends ktbyte.gui.EventProcessor implements PConstants {
        public title : string;

        public posx : number;

        public posy : number;

        public w : number;

        public h : number;

        public r1 : number;

        public r2 : number;

        public r3 : number;

        public r4 : number;

        public controllers : Array<Controller> = <any>([]);

        public pa : any;

        public ktgui : ktbyte.gui.KTGUI;

        public parentController : Controller = null;

        public parentStage : ktbyte.gui.Stage = null;

        public static selectedController : Controller = null;

        public pg : PGraphics;

        public userpg : PGraphics;

        public fgHoveredColor : number = ktbyte.gui.KTGUI.COLOR_FG_HOVERED;

        public fgPressedColor : number = ktbyte.gui.KTGUI.COLOR_FG_PRESSED;

        public fgPassiveColor : number = ktbyte.gui.KTGUI.COLOR_FG_PASSIVE;

        public bgHoveredColor : number = ktbyte.gui.KTGUI.COLOR_BG_HOVERED;

        public bgPressedColor : number = ktbyte.gui.KTGUI.COLOR_BG_PRESSED;

        public bgPassiveColor : number = ktbyte.gui.KTGUI.COLOR_BG_PASSIVE;

        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super();
            if(this.title===undefined) this.title = null;
            if(this.posx===undefined) this.posx = 0;
            if(this.posy===undefined) this.posy = 0;
            if(this.w===undefined) this.w = 0;
            if(this.h===undefined) this.h = 0;
            if(this.r1===undefined) this.r1 = 0;
            if(this.r2===undefined) this.r2 = 0;
            if(this.r3===undefined) this.r3 = 0;
            if(this.r4===undefined) this.r4 = 0;
            if(this.pa===undefined) this.pa = null;
            if(this.ktgui===undefined) this.ktgui = null;
            if(this.pg===undefined) this.pg = null;
            if(this.userpg===undefined) this.userpg = null;
            ktbyte.gui.KTGUI.debug("Creation of [" + title + "] started.");
            if(w < (<any>Math).fround(ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH * 0.5) || h < (<any>Math).fround(ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH * 0.5)) {
                ktbyte.gui.KTGUI.debug("!!! ERRROR.");
                ktbyte.gui.KTGUI.debug("!!! w:" + w + ", h:" + h);
                ktbyte.gui.KTGUI.debug("!!! Width and height of the " + title + " controller must be greater than KTGUI.DEFAULT_COMPONENT_SIZE/2 a.u. Which is currently equal to " + (<any>Math).fround(ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH * 0.5) + " a.u.");
                ktbyte.gui.KTGUI.debug("!!! Creation of " + title + " interrupted (prevented).");
                ktbyte.gui.KTGUI.debug("!!! Exiting from " + title + "`s constructor without creating the actual object.\n");
                return;
            }
            this.ktgui = ktgui;
            this.pa = ktbyte.gui.KTGUI.getParentPApplet();
            this.title = title;
            this.posx = posx;
            this.posy = posy;
            this.w = w;
            this.h = h;
            this.pg = this.pa.createGraphics(w + 1, h + 1);
            this.userpg = this.pa.createGraphics(w + 1, h + 1);
            ktbyte.gui.StageManager.getInstance().getDefaultStage().registerController(this);
            ktbyte.gui.KTGUI.debug("Creation of [" + title + "] completed.\n");
        }

        public updateGraphics() {
            this.ktgui.addDrawCallStackDebugMessage(this.title + ".updateGraphics()");
        }

        public updateUserDefinedGraphics(userpg : PGraphics) {
            this.userpg = userpg;
        }

        public drawUserDefinedGraphics() {
            /* add */(this.ktgui.drawCallStack.push(this.title + ".drawUserDefinedGraphics()-\'")>0);
            this.pg.beginDraw();
            this.pg.image(this.userpg, 0, 0);
            this.pg.endDraw();
        }

        public drawControllers() {
            /* add */(this.ktgui.drawCallStack.push(this.title + ".drawControllers()-\'")>0);
            for(let index142=0; index142 < this.controllers.length; index142++) {
                let child = this.controllers[index142];
                {
                    child.updateGraphics();
                    child.draw();
                    this.pg.beginDraw();
                    /* add */(this.ktgui.drawCallStack.push("pg.image(" + child.title + ").getGraphics: " + child.posx + ", " + child.posy + "-\'  ")>0);
                    /* add */(this.ktgui.drawCallStack.push("(" + child.title + ").apos:" + child.getAbsolutePosX() + ", " + child.getAbsolutePosY() + "-\'    ")>0);
                    this.pg.image(child.getGraphics(), child.posx, child.posy);
                    this.pg.endDraw();
                }
            }
        }

        /*private*/ drawGraphics() {
            if(this.parentController == null) {
                /* add */(this.ktgui.drawCallStack.push(this.title + ".drawGraphics()-\'")>0);
                this.pa.image(this.pg, this.posx, this.posy);
            }
        }

        public draw() {
            if(this.isVisible) {
                /* add */(this.ktgui.drawCallStack.push(this.title + ".draw()|")>0);
                this.drawControllers();
                this.drawUserDefinedGraphics();
                this.drawGraphics();
            }
        }

        public setParentController(controller : Controller) {
            this.parentController = controller;
        }

        public setTitle(title : string) {
            this.title = title;
        }

        public getInfo() : string {
            let info : { str: string, toString: Function } = { str: "", toString: function() { return this.str; } };
            /* append */(sb => { sb.str = sb.str.concat(<any>"[" + ((this.title != null)?this.title:"null") + "]"); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", pStage:" + ((this.parentStage != null)?this.parentStage.getName():"null")); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", pCtrlr:" + ((this.parentController != null)?this.parentController.title:"null")); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", childs.sz():" + /* size */(<number>this.controllers.length)); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", isPrsd:" + this.isPressed); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", isHvrd:" + this.isHovered); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", isDrgd:" + this.isDragged); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", rpsx:" + this.posx); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", rpsy:" + this.posy); return sb; })(info);
            return /* toString */info.str;
        }

        public getFullInfoList(level : number) : Array<string> {
            let recursyLevel : number = level;
            let list : Array<string> = <any>([]);
            let prefix : { str: string, toString: Function } = { str: "", toString: function() { return this.str; } };
            if(recursyLevel > 0) {
                /* append */(sb => { sb.str = sb.str.concat(<any>"\'"); return sb; })(prefix);
                for(let i : number = 0; i < recursyLevel; i++) {{
                    /* append */(sb => { sb.str = sb.str.concat(<any>"-"); return sb; })(prefix);
                };}
            } else {
                /* append */(sb => { sb.str = sb.str.concat(<any>"+"); return sb; })(prefix);
            }
            /* add */(list.push(/* toString */prefix.str + this.getInfo())>0);
            if(/* size */(<number>this.controllers.length) > 0) {
                recursyLevel++;
                for(let index143=0; index143 < this.controllers.length; index143++) {
                    let child = this.controllers[index143];
                    {
                        /* addAll */((l1, l2) => l1.push.apply(l1, l2))(list, child.getFullInfoList(recursyLevel));
                    }
                }
            }
            return list;
        }

        public getWidth() : number {
            return this.w;
        }

        public setWidth(w : number) {
            this.w = w;
        }

        public getHeight() : number {
            return this.h;
        }

        public getAbsolutePosX() : number {
            let px : number = 0;
            if(this.parentController != null) {
                px += this.parentController.getAbsolutePosX();
            }
            px += this.posx;
            return px;
        }

        public getAbsolutePosY() : number {
            let py : number = 0;
            if(this.parentController != null) {
                py += this.parentController.getAbsolutePosY();
            }
            py += this.posy;
            return py;
        }

        public setHeight(h : number) {
            this.h = h;
        }

        public setHoveredColor(c : number) {
            this.fgHoveredColor = c;
        }

        public setPressedColor(c : number) {
            this.fgPressedColor = c;
        }

        public setPassiveColor(c : number) {
            this.fgPassiveColor = c;
        }

        public setBorderRoundings(r1 : number, r2 : number, r3 : number, r4 : number) {
            this.r1 = r1;
            this.r2 = r2;
            this.r3 = r3;
            this.r4 = r4;
        }

        public setHandleFocus(val : boolean) {
            this.handleFocus = val;
        }

        public getGraphics() : PGraphics {
            return this.pg;
        }

        public addController$ktbyte_gui_Controller$int$int(child : Controller, hAlign : number, vAlign : number) {
            if(this.isActive) {
                child.alignAbout$ktbyte_gui_Controller$int$int(this, hAlign, vAlign);
                this.attachController(child);
            }
        }

        public addController$ktbyte_gui_Controller$int$int$int(child : Controller, hAlign : number, vAlign : number, gap : number) {
            if(this.isActive) {
                child.alignAbout$ktbyte_gui_Controller$int$int$int(this, hAlign, vAlign, gap);
                this.attachController(child);
            }
        }

        public addController(child? : any, hAlign? : any, vAlign? : any, gap? : any) : any {
            if(((child != null && child instanceof <any>ktbyte.gui.Controller) || child === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && ((typeof gap === 'number') || gap === null)) {
                return <any>this.addController$ktbyte_gui_Controller$int$int$int(child, hAlign, vAlign, gap);
            } else if(((child != null && child instanceof <any>ktbyte.gui.Controller) || child === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && gap === undefined) {
                return <any>this.addController$ktbyte_gui_Controller$int$int(child, hAlign, vAlign);
            } else throw new Error('invalid overload');
        }

        public positionAboutOtherController(controller : Controller, relativePosx : number, relativePosy : number) {
            this.posx = controller.posx + relativePosx;
            this.posy = controller.posy + relativePosy;
        }

        public attachController(controller : Controller) {
            if(this.isActive) {
                ktbyte.gui.KTGUI.debug("Attaching of [" + controller.title + "] of type <" + /* getName */(c => c["__class"]?c["__class"]:c["name"])((<any>controller.constructor)) + "> to [" + this.title + "] of type <" + /* getName */(c => c["__class"]?c["__class"]:c["name"])((<any>this.constructor)) + "> started.");
                if(controller.parentController != null) {
                    let pc : Controller = controller.parentController;
                    pc.detachController(controller);
                }
                if(!/* contains */(this.controllers.indexOf(<any>(controller)) >= 0)) {
                    ktbyte.gui.KTGUI.debug("\t[" + this.title + "].controllers.contains(" + controller.title + ") = " + /* contains */(this.controllers.indexOf(<any>(controller)) >= 0));
                    /* add */(this.controllers.push(controller)>0);
                }
                ktbyte.gui.KTGUI.debug("\tSetting parent controller...");
                controller.setParentController(this);
                ktbyte.gui.KTGUI.debug("\t[" + controller.title + "].parentController is [" + controller.parentController.title + "]");
                ktbyte.gui.StageManager.getInstance().unregisterControllerFromAllStages(controller);
                ktbyte.gui.KTGUI.debug("Attaching of [" + controller.title + "] to [" + this.title + "] completed.\n");
            }
        }

        public detachController(controller : Controller) {
            controller.parentController = null;
            /* remove */(a => { let index = a.indexOf(controller); if(index>=0) { a.splice(index, 1); return true; } else { return false; }})(this.controllers);
        }

        public detachAllControllers() {
            for(let index144=0; index144 < this.controllers.length; index144++) {
                let controller = this.controllers[index144];
                {
                    this.detachController(controller);
                }
            }
        }

        public closeParent() {
            if(this.parentController != null) {
                this.parentController.close();
            }
            this.closeAllChildsRecursively();
        }

        public closeAllChildsRecursively() {
            for(let index145=0; index145 < this.controllers.length; index145++) {
                let childController = this.controllers[index145];
                {
                    childController.closeAllChildsRecursively();
                    childController.close();
                }
            }
        }

        public close() {
            PApplet.println("Closing \'" + this.title + "\' controller.");
            this.isActive = false;
            this.ktgui.addToGarbage(this, this.pa.millis());
        }

        public getPosx() : number {
            return this.posx;
        }

        public setPosx(posx : number) {
            this.posx = posx;
        }

        public getPosy() : number {
            return this.posy;
        }

        public setPosy(posy : number) {
            this.posy = posy;
        }

        public alignAboutCanvas$int$int(hAlign : number, vAlign : number) {
            this.alignAboutCanvas$int$int$int(hAlign, vAlign, ktbyte.gui.KTGUI.DEFAULT_ALIGN_GAP);
        }

        public alignAboutCanvas$int$int$int(hAlign : number, vAlign : number, gap : number) {
            switch((hAlign)) {
            case PConstants.LEFT:
                this.posx = gap;
                break;
            case PConstants.RIGHT:
                this.posx = this.pa.width - this.w - gap;
                break;
            case PConstants.CENTER:
                this.posx = (<number>(this.pa.width * 0.5 - this.w * 0.5)|0);
                break;
            default:
                break;
            }
            switch((vAlign)) {
            case PConstants.TOP:
                this.posy = gap;
                break;
            case PConstants.BOTTOM:
                this.posy = this.pa.height - this.h - gap;
                break;
            case PConstants.CENTER:
                this.posy = (<number>(this.pa.height * 0.5 - this.h * 0.5)|0);
                break;
            default:
                break;
            }
        }

        /**
         * @param {number} hAlign
         * the horizontal alignment position
         * @param {number} vAlign
         * the vertical alignment position
         * @param {number} gap
         * the gap between the outer boundary of the PApplet canvas and
         * the side of the controller to be aligned.
         */
        public alignAboutCanvas(hAlign? : any, vAlign? : any, gap? : any) : any {
            if(((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && ((typeof gap === 'number') || gap === null)) {
                return <any>this.alignAboutCanvas$int$int$int(hAlign, vAlign, gap);
            } else if(((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && gap === undefined) {
                return <any>this.alignAboutCanvas$int$int(hAlign, vAlign);
            } else throw new Error('invalid overload');
        }

        public alignAbout$ktbyte_gui_Controller$int$int(controller : Controller, hAlign : number, vAlign : number) {
            this.alignAbout$ktbyte_gui_Controller$int$int$int(controller, hAlign, vAlign, ktbyte.gui.KTGUI.DEFAULT_ALIGN_GAP);
        }

        public alignAbout$ktbyte_gui_Controller$int$int$int(controller : Controller, hAlign : number, vAlign : number, gap : number) {
            switch((hAlign)) {
            case PConstants.LEFT:
                this.posx = gap;
                break;
            case PConstants.RIGHT:
                this.posx = controller.w - this.w - gap;
                break;
            case PConstants.CENTER:
                this.posx = (<number>(controller.w * 0.5 - this.w * 0.5)|0);
                break;
            default:
                break;
            }
            switch((vAlign)) {
            case PConstants.TOP:
                this.posy = gap;
                break;
            case PConstants.BOTTOM:
                this.posy = controller.h - this.h - gap;
                break;
            case PConstants.CENTER:
                this.posy = (<number>(controller.h * 0.5 - this.h * 0.5)|0);
                break;
            default:
                break;
            }
        }

        /**
         * This method is used to place one controller <b>inside</b> the other (reference)
         * controller.
         * By 'aligning' we understand the process of changing the X and Y coordinates
         * so that the controller is placed inside and near one of the walls of the
         * reference controller.
         * The X and Y position, and width and height of the controller being used as
         * a reference are used to calculate the new position of the controller that is to
         * be aligned. The said values identify the 'boundary rectangle' of the reference
         * controller. The named constants LEFT, RIGHT, BOTTOM, TOP and CENTER are used to
         * identify the sides and the center of the bounding rectangle. The sides and center
         * of the reference rectangle are used for calculation of the relative
         * distances that are used to 'shift' the position of the controller to be
         * aligned. The direction of shifting is <b>inward</b> - i.e. the changing of relative
         * position is made <i>from the sides</i> of the bounding rectangle <i>to the
         * center</i> of the bounding rectangle.
         * 
         * @param {ktbyte.gui.Controller} controller
         * the 'reference' controller.
         * @param {number} hAlign
         * the horizontal alignment direction. The following named constants can be used:</br>
         * <ul>
         * <li>
         * LEFT - the controller will be placed so that its <i>left</i> side will
         * 'stick' to the <i>left</i> side of the reference controller.</br>
         * </li>
         * <li>
         * RIGHT - the controller will be placed so that its <i>right</i> side will
         * 'stick' to the <i>right</i> side of the reference controller.</br>
         * </li>
         * <li>
         * CENTER - the controller will be placed so that its <i>center</i> will
         * 'stick' to the <i>center</i> of the reference controller.</br>
         * </li>
         * </ul>
         * @param {number} vAlign
         * the vertical alignment direction. The following named constants can be used:</br>
         * <ul>
         * <li>
         * TOP - the controller will be placed so that its <i>top</i> side will
         * 'stick' to the <i>top</i> side of the reference controller.</br>
         * </li>
         * <li>
         * BOTTOM - the controller will be placed so that its <i>bottom</i> side will
         * 'stick' to the <i>bottom</i> side of the reference controller.</br>
         * </li>
         * <li>
         * CENTER - the controller will be placed so that its <i>center</i> will
         * 'stick' to the <i>center</i> of the reference controller. </br>
         * </li>
         * </ul>
         * @param {number} gap
         * the gap between aligned sides. If the CENTER constant is used as hAlign
         * or vAlign argument then the gap will <b>not</b> be added to that direction.
         */
        public alignAbout(controller? : any, hAlign? : any, vAlign? : any, gap? : any) : any {
            if(((controller != null && controller instanceof <any>ktbyte.gui.Controller) || controller === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && ((typeof gap === 'number') || gap === null)) {
                return <any>this.alignAbout$ktbyte_gui_Controller$int$int$int(controller, hAlign, vAlign, gap);
            } else if(((controller != null && controller instanceof <any>ktbyte.gui.Controller) || controller === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && gap === undefined) {
                return <any>this.alignAbout$ktbyte_gui_Controller$int$int(controller, hAlign, vAlign);
            } else throw new Error('invalid overload');
        }

        public stackAbout$ktbyte_gui_Controller$int$int(controller : Controller, direction : number, align : number) {
            this.stackAbout$ktbyte_gui_Controller$int$int$int(controller, direction, align, ktbyte.gui.KTGUI.DEFAULT_ALIGN_GAP);
        }

        public stackAbout$ktbyte_gui_Controller$int$int$int(controller : Controller, direction : number, align : number, gap : number) {
            switch((direction)) {
            case PConstants.TOP:
                this.posy = controller.posy - this.h - gap;
                switch((align)) {
                case PConstants.LEFT:
                    this.posx = controller.posx + gap;
                    break;
                case PConstants.RIGHT:
                    this.posx = controller.posx + controller.w - this.w - gap;
                    break;
                case PConstants.CENTER:
                    this.posx = (<number>(controller.posx + controller.w * 0.5)|0) - (<number>(this.w * 0.5)|0);
                    break;
                default:
                    break;
                }
                break;
            case PConstants.BOTTOM:
                this.posy = controller.posy + controller.h + gap;
                switch((align)) {
                case PConstants.LEFT:
                    this.posx = controller.posx + gap;
                    break;
                case PConstants.RIGHT:
                    this.posx = controller.posx + controller.w - this.w - gap;
                    break;
                case PConstants.CENTER:
                    this.posx = (<number>(controller.posx + controller.w * 0.5)|0) - (<number>(this.w * 0.5)|0);
                    break;
                default:
                    break;
                }
                break;
            case PConstants.LEFT:
                this.posx = controller.posx - this.w - gap;
                switch((align)) {
                case PConstants.TOP:
                    this.posy = controller.posy + gap;
                    break;
                case PConstants.BOTTOM:
                    this.posy = controller.posy + controller.h - this.h - gap;
                    break;
                case PConstants.CENTER:
                    this.posy = (<number>(controller.posy + controller.h * 0.5)|0) - (<number>(this.h * 0.5)|0);
                    break;
                default:
                    break;
                }
                break;
            case PConstants.RIGHT:
                this.posx = controller.posx + controller.w + gap;
                switch((align)) {
                case PConstants.TOP:
                    this.posy = controller.posy + gap;
                    break;
                case PConstants.BOTTOM:
                    this.posy = controller.posy + controller.h - this.h - gap;
                    break;
                case PConstants.CENTER:
                    this.posy = (<number>(controller.posy + controller.h * 0.5)|0) - (<number>(this.h * 0.5)|0);
                    break;
                default:
                    break;
                }
                break;
            default:
                break;
            }
        }

        /**
         * This method is used to position one controller <b>outside</b> the other
         * (reference) controller.
         * By 'stacking' we understand the process of changing the X and Y coordinates
         * so that the controller is placed outside and near one of the walls of the
         * reference controller.
         * The X and Y position, and width and height of the controller being used as
         * a reference are used to calculate the new position of the controller to
         * be aligned. The said values identify the 'boundary rectangle' of the reference
         * controller.
         * The named constants LEFT, RIGHT, BOTTOM and TOP are used to identify
         * the sides of the bounding rectangle. They are used for calculation of the
         * relative distances that are used to 'shift' the position of the controller to be
         * aligned. The direction of shifting is <b>outward</b> - i.e. the changing of
         * relative position is made from the sides of the bounding rectangle <i>to the
         * outward direction about</i> the bounding rectangle.
         * 
         * @param <b>controller</b>
         * the 'reference' controller.
         * @param <b>direction</b>
         * the 'reference' alignment direction. The following named constants can be used:</br>
         * <ul>
         * <li>
         * LEFT - the controller will be placed so that its <i>rigth</i> side will
         * 'stick' to the <i>left</i> side of the reference controller.</br>
         * </li>
         * <li>
         * RIGHT - the controller will be placed so that its <i>left</i> side will
         * 'stick' to the <i>right</i> side of the reference controller.</br>
         * </li>
         * <li>
         * TOP - the controller will be placed so that its <i>bottom</i> side will
         * 'stick' to the <i>top</i> side of the reference controller.</br>
         * </li>
         * <li>
         * BOTTOM - the controller will be placed so that its <i>top</i> side will
         * 'stick' to the <i>bottom</i> side of the reference controller.</br>
         * </li>
         * </ul>
         * @param <b>align</b>
         * the 'orthogonal' alignment direction. </br>
         * The following named constants can be used:</br>
         * If the 'reference' alignment direction was chosen as LEFT or RIGTH, then the
         * 'orthogonal' direction can be set only fron one of the following constants:
         * <ul>
         * <li>
         * TOP - the controller will be placed so that its <i>top</i> side will be
         * aligned to the <i>top</i> side of the reference controller.</br>
         * </li>
         * <li>
         * BOTTOM - the controller will be placed so that its <i>bottom</i> side will be
         * aligned to the <i>bottom</i> side of the reference controller.</br>
         * </li>
         * <li>
         * CENTER - the controller will be placed so that its <i>center</i> will be
         * aligned to the <i>center</i> of the reference controller. </br>
         * </li>
         * </ul>
         * 
         * If the 'reference' alignment direction was chosen as BOTTOM or TOP, then the
         * 'orthogonal' direction can be set only from one of the following constants:
         * <ul>
         * <li>
         * LEFT - the controller will be placed so that its <i>left</i> side will be
         * aligned to the <i>left</i> side of the reference controller.</br>
         * </li>
         * <li>
         * RIGHT - the controller will be placed so that its <i>right</i> side will be
         * aligned to the <i>right</i> side of the reference controller.</br>
         * </li>
         * <li>
         * CENTER - the controller will be placed so that its <i>center</i> will be
         * aligned to the <i>center</i> of the reference controller. </br>
         * </li>
         * </ul>
         * 
         * @param <b>gap</b>
         * the gap of some length between the sides to be aligned. If the CENTER constant
         * is used as 'direction' or 'align' argument then the gap is <b>not</b> added
         * in that direction.
         * @param {ktbyte.gui.Controller} controller
         * @param {number} direction
         * @param {number} align
         * @param {number} gap
         */
        public stackAbout(controller? : any, direction? : any, align? : any, gap? : any) : any {
            if(((controller != null && controller instanceof <any>ktbyte.gui.Controller) || controller === null) && ((typeof direction === 'number') || direction === null) && ((typeof align === 'number') || align === null) && ((typeof gap === 'number') || gap === null)) {
                return <any>this.stackAbout$ktbyte_gui_Controller$int$int$int(controller, direction, align, gap);
            } else if(((controller != null && controller instanceof <any>ktbyte.gui.Controller) || controller === null) && ((typeof direction === 'number') || direction === null) && ((typeof align === 'number') || align === null) && gap === undefined) {
                return <any>this.stackAbout$ktbyte_gui_Controller$int$int(controller, direction, align);
            } else throw new Error('invalid overload');
        }

        public isAnyChildPressed() : boolean {
            for(let index146=0; index146 < this.controllers.length; index146++) {
                let child = this.controllers[index146];
                {
                    if(child.isPressed) {
                        return true;
                    }
                    if(child.isAnyChildPressed()) {
                        return true;
                    }
                }
            }
            return false;
        }

        /**
         * 
         */
        public processMouseMoved() {
            if(this.isActive) {
                for(let index147=0; index147 < this.controllers.length; index147++) {
                    let child = this.controllers[index147];
                    {
                        child.processMouseMoved();
                    }
                }
                this.isHovered = this.isPointInside(this.pa.mouseX, this.pa.mouseY)?true:false;
                for(let index148=0; index148 < this.adapters.length; index148++) {
                    let adapter = this.adapters[index148];
                    {
                        adapter.onMouseMoved();
                    }
                }
            }
        }

        /**
         * 
         */
        public processMousePressed() {
            if(this.isActive) {
                if(this.isHovered) {
                    for(let index149=0; index149 < this.controllers.length; index149++) {
                        let child = this.controllers[index149];
                        {
                            child.processMousePressed();
                        }
                    }
                    if(this.isAnyChildPressed()) {
                        this.isPressed = false;
                        return;
                    } else {
                        this.isPressed = true;
                        Controller.selectedController = this;
                    }
                    for(let index150=0; index150 < this.adapters.length; index150++) {
                        let adapter = this.adapters[index150];
                        {
                            adapter.onMousePressed();
                        }
                    }
                }
            }
        }

        /**
         * 
         */
        public processMouseReleased() {
            if(this.isActive) {
                this.isPressed = false;
                for(let index151=0; index151 < this.controllers.length; index151++) {
                    let child = this.controllers[index151];
                    {
                        child.processMouseReleased();
                    }
                }
                if(this.isHovered) {
                    for(let index152=0; index152 < this.adapters.length; index152++) {
                        let adapter = this.adapters[index152];
                        {
                            adapter.onMouseReleased();
                        }
                    }
                }
            }
        }

        /**
         * 
         */
        public processMouseDragged() {
            if(this.isActive) {
                for(let index153=0; index153 < this.controllers.length; index153++) {
                    let child = this.controllers[index153];
                    {
                        child.processMouseDragged();
                    }
                }
                if(this.isDragable) {
                    if(this.isPressed) {
                        this.posx += this.pa.mouseX - this.pa.pmouseX;
                        this.posy += this.pa.mouseY - this.pa.pmouseY;
                        for(let index154=0; index154 < this.adapters.length; index154++) {
                            let adapter = this.adapters[index154];
                            {
                                adapter.onMouseDragged();
                            }
                        }
                    }
                }
            }
        }

        /**
         * 
         * @param {ProcessingMouseEvent} me
         */
        public processMouseWheel(me : ProcessingMouseEvent) {
            if(this.isActive) {
                for(let index155=0; index155 < this.controllers.length; index155++) {
                    let child = this.controllers[index155];
                    {
                        child.processMouseWheel(me);
                    }
                }
            }
        }

        /**
         * 
         */
        public processKeyPressed() {
            if(this.isActive) {
                for(let index156=0; index156 < this.controllers.length; index156++) {
                    let child = this.controllers[index156];
                    {
                        child.processKeyPressed();
                    }
                }
            }
        }

        /**
         * 
         */
        public processKeyReleased() {
            if(this.isActive) {
                for(let index157=0; index157 < this.controllers.length; index157++) {
                    let child = this.controllers[index157];
                    {
                        child.processKeyReleased();
                    }
                }
            }
        }

        public isSelected(controller : Controller) : boolean {
            return Controller.selectedController === <Controller>controller;
        }

        /**
         * 
         * @param {number} x
         * @param {number} y
         * @return {boolean}
         */
        public isPointInside(x : number, y : number) : boolean {
            let isInside : boolean = false;
            if(this.isActive) {
                if(x > this.getAbsolutePosX() && x < this.getAbsolutePosX() + this.w) {
                    if(y > this.getAbsolutePosY() && y < this.getAbsolutePosY() + this.h) {
                        isInside = true;
                    }
                }
            }
            return isInside;
        }
    }
    Controller["__class"] = "ktbyte.gui.Controller";
    Controller["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class InputTextBox extends ktbyte.gui.Controller {
        static BACKSPACE_ASCII_CODE : number = 8;

        static ENTER_ASCII_CODE : number = 10;

        static BASIC_ASCII_LOWER_LIMIT : number = 32;

        static BASIC_ASCII_UPPER_LIMIT : number = 126;

        /*private*/ welcomeText : string;

        /*private*/ inputText : string;

        /*private*/ textSize : number;

        /*private*/ textHeight : number;

        /*private*/ padding : number;

        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.welcomeText===undefined) this.welcomeText = null;
            if(this.inputText===undefined) this.inputText = null;
            if(this.textSize===undefined) this.textSize = 0;
            if(this.textHeight===undefined) this.textHeight = 0;
            if(this.padding===undefined) this.padding = 0;
            this.inputText = "";
            this.welcomeText = "Type text here ...";
            this.textSize = 18;
            this.updateTextAttributes();
        }

        public updateGraphics() {
            super.updateGraphics();
            this.updateTextBox();
            this.updateBlinkingCursorGraphics();
        }

        /*private*/ updateTextBox() {
            this.pg.beginDraw();
            this.pg.pushStyle();
            if(this.isSelected(this)) {
                this.pg.fill(this.bgPressedColor);
                this.pg.stroke(50);
                this.pg.strokeWeight(3.0);
            } else {
                this.pg.fill(this.bgPassiveColor);
                this.pg.stroke(0, 50, 0);
                this.pg.strokeWeight(1.0);
            }
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            this.pg.textSize(this.textSize);
            this.pg.textAlign(PConstants.LEFT, PConstants.CENTER);
            if(this.inputText.length > 0) {
                this.pg.fill(0);
                this.pg.text(this.getTrimmedInputText(), this.padding, (<any>Math).fround(this.h * 0.5));
            } else {
                this.pg.fill(100);
                this.pg.text(this.welcomeText, this.padding, (<any>Math).fround(this.h * 0.5));
            }
            this.pg.popStyle();
            this.pg.endDraw();
        }

        /*private*/ updateBlinkingCursorGraphics() {
            if(this.isSelected(this)) {
                if(this.pa.frameCount % 60 < 30) {
                    this.pa.textSize(this.textSize);
                    let cursorX : number = PApplet.min((<any>Math).fround(this.w - this.padding), (<any>Math).fround(this.padding + this.pa.textWidth(this.inputText)));
                    this.pg.beginDraw();
                    this.pg.stroke(0);
                    this.pg.strokeWeight(2);
                    this.pg.line(cursorX, (<any>Math).fround((<any>Math).fround(this.h * 0.5) - (<any>Math).fround(this.textHeight * 0.5)), cursorX, (<any>Math).fround((<any>Math).fround(this.h * 0.5) + (<any>Math).fround(this.textHeight * 0.5)));
                    this.pg.endDraw();
                }
            }
        }

        /**
         * 
         */
        public processMousePressed() {
            super.processMousePressed();
            if(this.isSelected(this)) {
                this.welcomeText = "";
            }
        }

        /**
         * 
         */
        public processKeyPressed() {
            if(!this.isSelected(this)) {
                return;
            }
            if(((String.fromCharCode(this.pa.key))).charCodeAt(0) === InputTextBox.BACKSPACE_ASCII_CODE && this.inputText.length > 0) {
                this.inputText = this.inputText.substring(0, this.inputText.length - 1);
            }
            if(((String.fromCharCode(this.pa.key))).charCodeAt(0) === InputTextBox.ENTER_ASCII_CODE) {
                for(let index158=0; index158 < this.adapters.length; index158++) {
                    let adapter = this.adapters[index158];
                    {
                        adapter.onEnterKeyPressed();
                    }
                }
            } else if(((String.fromCharCode(this.pa.key))).charCodeAt(0) >= InputTextBox.BASIC_ASCII_LOWER_LIMIT && ((String.fromCharCode(this.pa.key))).charCodeAt(0) <= InputTextBox.BASIC_ASCII_UPPER_LIMIT) {
                let b : number = ((String.fromCharCode(this.pa.key))).charCodeAt(0);
                let ch : string = String.fromCharCode(b);
                this.inputText += ch;
            }
        }

        public setFocused(value : boolean) {
        }

        public setWelcomeText(text : string) {
            this.welcomeText = text;
        }

        /**
         * Sets the current text
         * 
         * @param {string} text
         * The text that should be displayed inside the box
         */
        public setText(text : string) {
            this.inputText = text;
        }

        public getText() : string {
            return this.inputText;
        }

        /**
         * Sets the text size
         * 
         * @param {number} textSize
         * The text size
         */
        public setTextSize(textSize : number) {
            this.textSize = textSize;
            this.pa.textSize(this.textSize);
            this.updateTextAttributes();
        }

        /*private*/ updateTextAttributes() {
            this.padding = (<any>Math).fround(0.08 * this.h);
            this.textHeight = (<any>Math).fround(this.pa.textAscent() + this.pa.textDescent());
        }

        /*private*/ getTrimmedInputText() : string {
            let sb : { str: string, toString: Function } = { str: "", toString: function() { return this.str; } };
            let wrappedWidth : number = PApplet.floor((<any>Math).fround(this.w - this.padding));
            this.pa.textSize(this.textSize);
            for(let i : number = this.inputText.length - 1; i >= 0; i--) {{
                let chunkWidth : number = PApplet.ceil(this.pa.textWidth(/* toString */sb.str + ":"));
                if(chunkWidth >= wrappedWidth) {
                    break;
                }
                /* append */(sb => { sb.str = sb.str.concat(<any>this.inputText.charAt(i)); return sb; })(sb);
            };}
            return this.reverse(/* toString */sb.str);
        }

        /*private*/ reverse(input : string) : string {
            let inChars : string[] = (s => { let a=[]; while(s-->0) a.push(null); return a; })(input.length);
            /* getChars */((a, s, e, d, l) => { d.splice.apply(d, [l, e-s].concat(<any>a.substring(s, e).split(''))); })(input, 0, input.length, inChars, 0);
            let outChars : string[] = (s => { let a=[]; while(s-->0) a.push(null); return a; })(inChars.length);
            for(let i : number = inChars.length; i > 0; i--) {{
                outChars[i - 1] = inChars[inChars.length - i];
            };}
            return outChars.join('');
        }
    }
    InputTextBox["__class"] = "ktbyte.gui.InputTextBox";
    InputTextBox["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class Bar extends ktbyte.gui.Controller {
        public constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.pg.beginDraw();
            this.pg.background(200, 200);
            this.pg.rectMode(PConstants.CORNER);
            this.pg.fill(this.bgPassiveColor);
            this.pg.stroke(0);
            this.pg.rectMode(PConstants.CORNER);
            if(this.isSelected(this)) {
                this.pg.strokeWeight(3.0);
            } else {
                this.pg.strokeWeight(1.0);
            }
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            this.pg.fill(25);
            this.pg.textAlign(PConstants.LEFT, PConstants.CENTER);
            this.pg.textSize((<any>Math).fround(this.h * 0.65));
            this.pg.text(this.title, 10, (<any>Math).fround(this.h * 0.5));
            this.pg.endDraw();
        }
    }
    Bar["__class"] = "ktbyte.gui.Bar";
    Bar["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class ScrollBar extends ktbyte.gui.Controller {
        /*private*/ backwardButton : ktbyte.gui.ArrowButton;

        /*private*/ forwardButton : ktbyte.gui.ArrowButton;

        /*private*/ slider : ktbyte.gui.Slider;

        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number, sr : number, er : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.backwardButton===undefined) this.backwardButton = null;
            if(this.forwardButton===undefined) this.forwardButton = null;
            if(this.slider===undefined) this.slider = null;
            this.createButtons();
            this.createSlider(sr, er);
            this.setBorderRoundings(5, 5, 5, 5);
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
        }

        /**
         * 
         * @param {number} r1
         * @param {number} r2
         * @param {number} r3
         * @param {number} r4
         */
        public setBorderRoundings(r1 : number, r2 : number, r3 : number, r4 : number) {
            if(this.w > this.h) {
                this.backwardButton.setBorderRoundings(r1, 0, 0, r4);
                this.forwardButton.setBorderRoundings(0, r2, r3, 0);
            } else {
                this.forwardButton.setBorderRoundings(r1, r2, 0, 0);
                this.backwardButton.setBorderRoundings(0, 0, r3, r4);
            }
        }

        /*private*/ createButtons() {
            if(this.w > this.h) {
                this.backwardButton = new ktbyte.gui.ArrowButton(this.ktgui, "bckwrdBtn:" + this.title, 0, 0, this.h, this.h, PConstants.LEFT);
                this.forwardButton = new ktbyte.gui.ArrowButton(this.ktgui, "frwrdBtn:" + this.title, this.w - this.h, 0, this.h, this.h, PConstants.RIGHT);
            } else {
                this.forwardButton = new ktbyte.gui.ArrowButton(this.ktgui, "frwrdBtn:" + this.title, 0, 0, this.w, this.w, PConstants.UP);
                this.backwardButton = new ktbyte.gui.ArrowButton(this.ktgui, "bckwrdBtn:" + this.title, 0, this.h - this.w, this.w, this.w, PConstants.DOWN);
            }
            this.backwardButton.addEventAdapter(new ScrollBar.ScrollBar$0(this));
            this.forwardButton.addEventAdapter(new ScrollBar.ScrollBar$1(this));
            this.backwardButton.isDragable = false;
            this.forwardButton.isDragable = false;
            this.attachController(this.backwardButton);
            this.attachController(this.forwardButton);
        }

        /*private*/ createSlider(sr : number, er : number) {
            if(this.w > this.h) {
                this.slider = new ktbyte.gui.Slider(this.ktgui, "hSlider:" + this.title, this.backwardButton.w, 0, this.w - this.backwardButton.w - this.forwardButton.w, this.h, sr, er);
            } else {
                this.slider = new ktbyte.gui.Slider(this.ktgui, "vSlider:" + this.title, 0, this.backwardButton.h, this.w, this.h - this.backwardButton.h - this.forwardButton.h, sr, er);
            }
            this.slider.isDragable = false;
            this.slider.setHandleType(ktbyte.gui.Slider.HANDLE_TYPE_CENTERED);
            this.slider.setValue(0);
            this.slider.setRounding(0);
            this.slider.setIsValueVisible(false);
            this.slider.addEventAdapter(new ScrollBar.ScrollBar$2(this));
            this.attachController(this.slider);
        }

        public getValue() : number {
            return this.slider.getValue();
        }

        public setValue(val : number) {
            this.slider.setValue(val);
        }

        public setNormalizedValue(val : number) {
            this.slider.setNormalizedValue(val);
        }

        public getNormalizedValue() : number {
            return this.slider.getNormalizedValue();
        }

        public getHandlePos() : number {
            return this.slider.getHandlePos();
        }

        public setHandlePos(pos : number) {
            this.slider.setHandlePos(pos);
        }

        public setHandleType(handleType : number) {
            this.slider.setHandleType(handleType);
        }

        public setHandleStep(step : number) {
            this.slider.setValueStep(step);
        }

        public getHandleStep() : number {
            return this.slider.getValueStep();
        }

        public getIsValueVisible() : boolean {
            return this.slider.getIsValueVisible();
        }

        public setIsValueVisible(visible : boolean) {
            this.slider.setIsValueVisible(visible);
        }

        public getRangeStart() : number {
            return this.slider.getRangeStart();
        }

        public setRangeStart(rangeStart : number) {
            this.slider.setRangeStart(rangeStart);
        }

        public getRangeEnd() : number {
            return this.slider.getRangeEnd();
        }

        public setRangeEnd(rangeEnd : number) {
            this.slider.setRangeEnd(rangeEnd);
        }

        public setRounding(n : number) {
            this.slider.setRounding(n);
        }

        public getSlider() : ktbyte.gui.Slider {
            return this.slider;
        }
    }
    ScrollBar["__class"] = "ktbyte.gui.ScrollBar";
    ScrollBar["__interfaces"] = ["def.processing.core.PConstants"];



    export namespace ScrollBar {

        export class ScrollBar$0 extends ktbyte.gui.EventAdapter {
            public __parent: any;
            public onMousePressed() {
                this.__parent.slider.decrementValue();
            }

            constructor(__parent: any) {
                super();
                this.__parent = __parent;
            }
        }


        export class ScrollBar$1 extends ktbyte.gui.EventAdapter {
            public __parent: any;
            public onMousePressed() {
                this.__parent.slider.incrementValue();
            }

            constructor(__parent: any) {
                super();
                this.__parent = __parent;
            }
        }


        export class ScrollBar$2 extends ktbyte.gui.EventAdapter {
            public __parent: any;
            public onMouseDragged() {
                for(let index159=0; index159 < this.__parent.adapters.length; index159++) {
                    let adapter = this.__parent.adapters[index159];
                    {
                        adapter.onMouseDragged();
                    }
                }
            }

            public onMousePressed() {
                for(let index160=0; index160 < this.__parent.adapters.length; index160++) {
                    let adapter = this.__parent.adapters[index160];
                    {
                        adapter.onMousePressed();
                    }
                }
            }

            public onValueChanged() {
                if(this.__parent.isActive) {
                    for(let index161=0; index161 < this.__parent.adapters.length; index161++) {
                        let adapter = this.__parent.adapters[index161];
                        {
                            adapter.onValueChanged();
                        }
                    }
                }
            }

            constructor(__parent: any) {
                super();
                this.__parent = __parent;
            }
        }

    }

}
namespace ktbyte.gui {
    /**
     * This is a KTGUI component (controller).
     * This class extends the 'Controller' class.
     * The object of this class can be 'Pressed', 'Hovered', 'Released' and 'Dragged'.
     * @param {ktbyte.gui.KTGUI} ktgui
     * @param {string} title
     * @param {number} posx
     * @param {number} posy
     * @param {number} w
     * @param {number} h
     * @class
     * @extends ktbyte.gui.Controller
     */
    export class Button extends ktbyte.gui.Controller {
        public constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.pg.beginDraw();
            this.pg.rectMode(PConstants.CORNER);
            if(this.isHovered && !this.isPressed) {
                this.pg.fill(this.fgHoveredColor);
            } else if(this.isHovered && this.isPressed) {
                this.pg.fill(this.fgPressedColor);
            } else {
                this.pg.fill(this.fgPassiveColor);
            }
            if(this.isSelected(this)) {
                this.pg.strokeWeight(2.0);
            } else {
                this.pg.strokeWeight(1.0);
            }
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            this.pg.fill(255);
            this.pg.textAlign(PConstants.CENTER, PConstants.CENTER);
            this.pg.textSize(14);
            this.pg.text(this.title, (<number>(this.w * 0.5)|0), (<number>(this.h * 0.5)|0));
            this.pg.endDraw();
        }
    }
    Button["__class"] = "ktbyte.gui.Button";
    Button["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class Console extends ktbyte.gui.Controller {
        static BOX_ROUNDING : number = 7;

        static INPUT_BOX_HEIGHT_PERCENTAGE : number = 0.1;

        /*private*/ inputBox : ktbyte.gui.InputTextBox;

        /*private*/ textArea : ktbyte.gui.ScrollableTextArea;

        /*private*/ scrollBar : ktbyte.gui.ScrollBar;

        /*private*/ inputTextColor : number = 16777215;

        /*private*/ outputTextColor : number = 0;

        /*private*/ dict : any;

        /*private*/ lastVariableName : string;

        inputBoxWidth : number = (<number>((<any>Math).fround(Console.INPUT_BOX_HEIGHT_PERCENTAGE * this.h))|0);

        public constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.inputBox===undefined) this.inputBox = null;
            if(this.textArea===undefined) this.textArea = null;
            if(this.scrollBar===undefined) this.scrollBar = null;
            if(this.dict===undefined) this.dict = null;
            if(this.lastVariableName===undefined) this.lastVariableName = null;
            this.dict = <any>({});
            this.createScrollableTextArea();
            this.createInputBox();
            this.createScrollBar();
        }

        /*private*/ createScrollableTextArea() {
            this.textArea = new ktbyte.gui.ScrollableTextArea(this.ktgui, "sta:" + this.title, 0, 0, this.w - this.inputBoxWidth, this.h - this.inputBoxWidth);
            this.textArea.setBorderRoundings(Console.BOX_ROUNDING, 0, 0, 0);
            this.textArea.addEventAdapter(new Console.Console$0(this));
            this.attachController(this.textArea);
        }

        /*private*/ createScrollBar() {
            this.scrollBar = new ktbyte.gui.ScrollBar(this.ktgui, "sb:" + this.title, this.w - this.inputBoxWidth, 0, this.inputBoxWidth, this.h - this.inputBoxWidth, 0, 100);
            this.scrollBar.addEventAdapter(new Console.Console$1(this));
            this.attachController(this.scrollBar);
        }

        /*private*/ createInputBox() {
            this.inputBox = new ktbyte.gui.InputTextBox(this.ktgui, "ib:" + this.title, 0, this.h - this.inputBoxWidth, this.w, this.inputBoxWidth);
            this.inputBox.setHandleFocus(true);
            this.inputBox.setTextSize(16);
            this.inputBox.setBorderRoundings(0, 0, Console.BOX_ROUNDING, Console.BOX_ROUNDING);
            this.inputBox.addEventAdapter(new Console.Console$2(this));
            this.attachController(this.inputBox);
        }

        /**
         * Returns a stored value from the console's memory
         * 
         * @param {string} name
         * the key of the stored entry
         * 
         * @return {string} a stored value from the console's memory
         */
        public getValue(name : string) : string {
            return /* get */((m,k) => m[k]===undefined?null:m[k])(this.dict, name);
        }

        /**
         * Sets the name of the next console's entry
         * 
         * @param {string} name
         * the key of the next stored entry
         */
        public readInput(name : string) {
            this.lastVariableName = name;
        }

        public setBorderRoundings(r1 : number, r2 : number, r3 : number, r4 : number) {
            this.textArea.setBorderRoundings(r1, 0, 0, 0);
            this.inputBox.setBorderRoundings(0, 0, r3, r4);
            this.scrollBar.setBorderRoundings(0, r2, 0, 0);
        }

        public enableLineStartMarks(val : boolean) {
            this.textArea.enableBlockMarks(val);
        }

        /*private*/ handleConsoleInput() {
            let textInput : string = this.inputBox.getText();
            this.textArea.appendTextBlock$java_lang_String$int(textInput, this.inputTextColor);
            this.textArea.scrollToBottom();
            this.inputBox.setText("");
            /* put */(this.dict[this.lastVariableName] = textInput);
            let scrollableRange : number = this.textArea.getLineCount() - this.textArea.getMaxLinesToDisplay() - 1;
            let scrollBarRange : number = (<any>Math).fround(this.scrollBar.getRangeEnd() - this.scrollBar.getRangeStart());
            let step : number = (<any>Math).fround(scrollBarRange / scrollableRange);
            this.scrollBar.setHandleStep(step);
            for(let index162=0; index162 < this.adapters.length; index162++) {
                let adapter = this.adapters[index162];
                {
                    adapter.onConsoleInput(textInput, this.lastVariableName);
                }
            }
        }

        public setInputTextSize(size : number) {
            this.inputBox.setTextSize(size);
        }

        public setOutputTextSize(size : number) {
            this.textArea.setTextSize(size);
        }

        public writeOutput(textBlock : string) {
            this.textArea.appendTextBlock$java_lang_String$int(textBlock, this.outputTextColor);
            this.textArea.scrollToBottom();
            let scrollableRange : number = this.textArea.getLineCount() - this.textArea.getMaxLinesToDisplay() - 1;
            let scrollBarRange : number = (<any>Math).fround(this.scrollBar.getRangeEnd() - this.scrollBar.getRangeStart());
            let step : number = (<any>Math).fround(scrollBarRange / scrollableRange);
            this.scrollBar.setHandleStep(step);
        }

        public setInputFocused(value : boolean) {
            this.inputBox.setFocused(value);
        }

        public getStartLinePosition() : number {
            return this.textArea.getStartLinePosition();
        }

        public setInputTextColor(c : number) {
            this.inputTextColor = c;
        }

        public setOutputTextColor(c : number) {
            this.outputTextColor = c;
        }

        public enableBlockMarks(val : boolean) {
            this.textArea.enableBlockMarks(val);
        }

        public enableLineNumbers(val : boolean) {
            this.textArea.enableLineNumbers(val);
        }

        public getLine(index : number) : string {
            return this.textArea.getTextLine(index);
        }

        public getBlock(index : number) : string {
            return this.textArea.getTextBlock(index);
        }

        public getLineCount() : number {
            return this.textArea.getLineCount();
        }

        public getBlockCount() : number {
            return this.textArea.getBlockCount();
        }

        public getLastLine() : string {
            let textLine : string = "_NO_LINES_EXIST_YET_";
            if(this.getLineCount() > 0) textLine = this.getLine(this.getLineCount() - 1);
            return textLine;
        }

        public getLastBlock() : string {
            let textBlock : string = "_NO_BLOCKS_EXIST_YET_";
            if(this.getBlockCount() > 0) textBlock = this.getBlock(this.getBlockCount() - 1);
            return textBlock;
        }

        public getInputBox() : ktbyte.gui.InputTextBox {
            return this.inputBox;
        }

        public getTextArea() : ktbyte.gui.ScrollableTextArea {
            return this.textArea;
        }

        public getScrollBar() : ktbyte.gui.ScrollBar {
            return this.scrollBar;
        }
    }
    Console["__class"] = "ktbyte.gui.Console";
    Console["__interfaces"] = ["def.processing.core.PConstants"];



    export namespace Console {

        export class Console$0 extends ktbyte.gui.EventAdapter {
            public __parent: any;
            public onMouseWheel(count : number) {
                let startLineNumberPosition : number = this.__parent.textArea.getStartLinePosition();
                let endOfScrollableRange : number = this.__parent.textArea.getLineCount() - this.__parent.textArea.getMaxLinesToDisplay() - 1;
                let mappedScrollBarPos : number = PApplet.map(startLineNumberPosition, 0, endOfScrollableRange, 0, 100);
                this.__parent.scrollBar.isActive = false;
                this.__parent.scrollBar.setNormalizedValue(mappedScrollBarPos);
                this.__parent.scrollBar.isActive = true;
            }

            constructor(__parent: any) {
                super();
                this.__parent = __parent;
            }
        }


        export class Console$1 extends ktbyte.gui.EventAdapter {
            public __parent: any;
            public onValueChanged() {
                this.__parent.textArea.setNormalizedLinePosition(this.__parent.scrollBar.getNormalizedValue());
            }

            constructor(__parent: any) {
                super();
                this.__parent = __parent;
            }
        }


        export class Console$2 extends ktbyte.gui.EventAdapter {
            public __parent: any;
            public onEnterKeyPressed() {
                ktbyte.gui.KTGUI.debug("Processing input...");
                this.__parent.handleConsoleInput();
            }

            constructor(__parent: any) {
                super();
                this.__parent = __parent;
            }
        }

    }

}
namespace ktbyte.gui {
    export class ScrollableTextArea extends ktbyte.gui.Controller {
        /*private*/ textSize : number = 14;

        /*private*/ padding : number = 6;

        /*private*/ textLines : Array<ScrollableTextArea.TextLine> = <any>([]);

        /*private*/ textBlocks : Array<ScrollableTextArea.TextBlock> = <any>([]);

        /*private*/ startLinePosition : number = 0;

        /*private*/ __enableBlockMarks : boolean;

        /*private*/ __enableLineNumbers : boolean;

        public constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.__enableBlockMarks===undefined) this.__enableBlockMarks = false;
            if(this.__enableLineNumbers===undefined) this.__enableLineNumbers = false;
            this.setPadding((<any>Math).fround(this.getTextSize() * 0.75));
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.updateTextAreaGraphics();
        }

        updateTextAreaGraphics() {
            this.pg.beginDraw();
            this.pg.pushStyle();
            if(this.isSelected(this)) {
                this.pg.fill(this.bgPressedColor);
                this.pg.stroke(50);
                this.pg.strokeWeight(3.0);
            } else {
                this.pg.fill(this.bgPassiveColor);
                this.pg.stroke(0, 50, 0);
                this.pg.strokeWeight(1.0);
            }
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            let correctedEndLinePosition : number = this.getEndLinePosition();
            for(let i : number = 0; i <= correctedEndLinePosition - this.startLinePosition; i++) {{
                let line : ScrollableTextArea.TextLine = /* get */this.textLines[i + this.startLinePosition];
                this.pg.fill(line.textColor);
                this.pg.textAlign(PConstants.LEFT, PConstants.BOTTOM);
                this.pg.textSize(this.textSize);
                this.pg.text(line.content, this.padding, (<any>Math).fround((<number>(this.padding * 0.5)|0) + (<any>Math).fround((i + 1) * this.getTextHeight())));
                if(line.isHead && this.__enableBlockMarks) {
                    this.pg.strokeWeight((<any>Math).fround(this.textSize * 0.33));
                    this.pg.stroke(line.textColor, 127);
                    this.pg.point((<any>Math).fround((<any>Math).fround(this.w - this.padding) + 6), (<number>(this.padding * 0.5 + (<any>Math).fround((i + 1) * this.getTextHeight()) - this.getTextHeight() * 0.5)|0));
                }
                if(this.__enableLineNumbers) {
                    this.pg.textSize((<any>Math).fround(this.textSize * 0.5));
                    this.pg.text(i + this.startLinePosition, (<any>Math).fround(this.padding - 5), (<number>(this.padding * 0.5 + (<any>Math).fround((i + 1) * this.getTextHeight()) - this.getTextHeight() * 0.5)|0));
                }
            };}
            this.pg.popStyle();
            this.pg.endDraw();
        }

        public getEndLinePosition() : number {
            return PApplet.min(/* size */(<number>this.textLines.length) - 1, this.startLinePosition + this.getMaxLinesToDisplay());
        }

        /**
         * 
         * @param {ProcessingMouseEvent} me
         */
        public processMouseWheel(me : ProcessingMouseEvent) {
            this.mouseScrolled(me.getCount());
            for(let index163=0; index163 < this.adapters.length; index163++) {
                let adapter = this.adapters[index163];
                {
                    adapter.onMouseWheel(me.getCount());
                }
            }
        }

        public mouseScrolled(mouseWheelDelta : number) {
            if(this.isSelected(this)) {
                if(mouseWheelDelta < 0) {
                    if(this.startLinePosition > 0) {
                        this.decrementStartLine();
                    }
                } else if(mouseWheelDelta > 0) {
                    if(this.startLinePosition < this.getMaxAllowedStartLinePos()) {
                        this.incrementStartLine();
                    }
                }
            }
        }

        public incrementStartLine() {
            if(this.startLinePosition < this.getMaxAllowedStartLinePos() - 1) {
                this.startLinePosition++;
            }
        }

        public decrementStartLine() {
            if(this.startLinePosition > 0) {
                this.startLinePosition--;
            }
        }

        public getMaxAllowedStartLinePos() : number {
            return /* size */(<number>this.textLines.length) - this.getMaxLinesToDisplay();
        }

        public getMaxLinesToDisplay() : number {
            return PApplet.floor((<any>Math).fround(((<any>Math).fround((<any>Math).fround(this.h - this.padding) - this.padding)) / this.getTextHeight()));
        }

        public scrollToTop() {
            while((this.startLinePosition > 0)) {{
                this.startLinePosition--;
            }};
        }

        public scrollToBottom() {
            while((this.startLinePosition < this.getMaxAllowedStartLinePos())) {{
                this.startLinePosition++;
            }};
        }

        public scrollToPosition(lineNumber : number) {
            if(lineNumber < 0 || lineNumber >= this.getMaxAllowedStartLinePos()) {
                ktbyte.gui.KTGUI.debug("lineNumber[" + lineNumber + "] is out of range during \'scrollToLine\' call.");
                return;
            }
            if(lineNumber > this.startLinePosition) {
                while((this.startLinePosition < lineNumber && this.startLinePosition < this.getMaxAllowedStartLinePos())) {{
                    this.startLinePosition++;
                }};
            } else if(lineNumber < this.startLinePosition) {
                while((this.startLinePosition > lineNumber && this.startLinePosition > 0)) {{
                    this.startLinePosition--;
                }};
            }
        }

        public getTextLines() : Array<ScrollableTextArea.TextLine> {
            return this.textLines;
        }

        public getTextBlocks() : Array<ScrollableTextArea.TextBlock> {
            return this.textBlocks;
        }

        public getPadding() : number {
            return this.padding;
        }

        public setPadding(padding : number) {
            this.padding = padding;
            this.updateWrappedLines();
        }

        public getTextSize() : number {
            return this.textSize;
        }

        public setTextSize(textSize : number) {
            this.textSize = textSize;
            this.updateWrappedLines();
        }

        public appendTextBlock$java_lang_String(text : string) {
            let textBlock : ScrollableTextArea.TextBlock = new ScrollableTextArea.TextBlock(this, text);
            /* add */(this.textBlocks.push(textBlock)>0);
            textBlock.appendAsWrappedLines(this.textSize);
        }

        public appendTextBlock$java_lang_String$int(text : string, color : number) {
            let textBlock : ScrollableTextArea.TextBlock = new ScrollableTextArea.TextBlock(this, text, color);
            /* add */(this.textBlocks.push(textBlock)>0);
            textBlock.appendAsWrappedLines(this.textSize);
        }

        public appendTextBlock(text? : any, color? : any) : any {
            if(((typeof text === 'string') || text === null) && ((typeof color === 'number') || color === null)) {
                return <any>this.appendTextBlock$java_lang_String$int(text, color);
            } else if(((typeof text === 'string') || text === null) && color === undefined) {
                return <any>this.appendTextBlock$java_lang_String(text);
            } else throw new Error('invalid overload');
        }

        updateWrappedLines() {
            this.textLines = <any>([]);
            for(let index164=0; index164 < this.textBlocks.length; index164++) {
                let block = this.textBlocks[index164];
                {
                    block.appendAsWrappedLines(this.textSize);
                }
            }
        }

        getTextHeight() : number {
            this.pa.textSize(this.textSize);
            return (<any>Math).fround(this.pa.textAscent() + this.pa.textDescent());
        }

        public getStartLinePosition() : number {
            return this.startLinePosition;
        }

        public setStartLinePosition(pos : number) {
            if(pos < 0 || pos > this.getMaxAllowedStartLinePos()) {
                return;
            }
            this.startLinePosition = PApplet.constrain(pos, 0, this.getMaxAllowedStartLinePos());
        }

        public setNormalizedLinePosition(pos : number) {
            let endOfScrollableRange : number = this.getLineCount() - this.getMaxLinesToDisplay() - 1;
            let normalizedPos : number = PApplet.floor(PApplet.map(pos, 0, 100.0, endOfScrollableRange, 0));
            this.setStartLinePosition(normalizedPos);
        }

        public enableBlockMarks(val : boolean) {
            this.__enableBlockMarks = val;
        }

        public enableLineNumbers(val : boolean) {
            this.__enableLineNumbers = val;
        }

        public getTextLine(index : number) : string {
            let textLine : string = "-= textLine: out of range =-";
            if(/* size */(<number>this.textLines.length) - index > 0) {
                textLine = /* get */this.textLines[index].content;
            }
            return textLine;
        }

        public getTextBlock(index : number) : string {
            let textBlock : string = "-= textBlock: out of range =-";
            if(/* size */(<number>this.textBlocks.length) - index > 0) {
                textBlock = /* get */this.textBlocks[index].content;
            }
            return textBlock;
        }

        public getLineCount() : number {
            return /* size */(<number>this.textLines.length);
        }

        public getBlockCount() : number {
            return /* size */(<number>this.textBlocks.length);
        }
    }
    ScrollableTextArea["__class"] = "ktbyte.gui.ScrollableTextArea";
    ScrollableTextArea["__interfaces"] = ["def.processing.core.PConstants"];



    export namespace ScrollableTextArea {

        export class TextLine {
            public __parent: any;
            public content : string;

            public textColor : number;

            public isHead : boolean;

            public constructor(__parent: any, content? : any, textColor? : any, isHead? : any) {
                if(((typeof content === 'string') || content === null) && ((typeof textColor === 'number') || textColor === null) && ((typeof isHead === 'boolean') || isHead === null)) {
                    let __args = Array.prototype.slice.call(arguments, [1]);
                    if(this.content===undefined) this.content = null;
                    if(this.isHead===undefined) this.isHead = false;
                    this.textColor = __parent.pa.color(0, 10, 30);
                    this.__parent = __parent;
                    if(this.content===undefined) this.content = null;
                    this.textColor = __parent.pa.color(0, 10, 30);
                    if(this.isHead===undefined) this.isHead = false;
                    (() => {
                        this.content = content;
                        this.isHead = isHead;
                        this.textColor = textColor;
                    })();
                } else if(((typeof content === 'string') || content === null) && ((typeof textColor === 'boolean') || textColor === null) && isHead === undefined) {
                    let __args = Array.prototype.slice.call(arguments, [1]);
                    let isHead : any = __args[1];
                    if(this.content===undefined) this.content = null;
                    if(this.isHead===undefined) this.isHead = false;
                    this.textColor = __parent.pa.color(0, 10, 30);
                    this.__parent = __parent;
                    if(this.content===undefined) this.content = null;
                    this.textColor = __parent.pa.color(0, 10, 30);
                    if(this.isHead===undefined) this.isHead = false;
                    (() => {
                        this.content = content;
                        this.isHead = isHead;
                    })();
                } else throw new Error('invalid overload');
            }
        }
        TextLine["__class"] = "ktbyte.gui.ScrollableTextArea.TextLine";


        export class TextBlock {
            public __parent: any;
            content : string;

            isHeadAlreadyMarked : boolean;

            textColor : number;

            public constructor(__parent: any, content? : any, textColor? : any) {
                if(((typeof content === 'string') || content === null) && ((typeof textColor === 'number') || textColor === null)) {
                    let __args = Array.prototype.slice.call(arguments, [1]);
                    if(this.content===undefined) this.content = null;
                    if(this.isHeadAlreadyMarked===undefined) this.isHeadAlreadyMarked = false;
                    this.textColor = __parent.pa.color(0);
                    this.__parent = __parent;
                    if(this.content===undefined) this.content = null;
                    if(this.isHeadAlreadyMarked===undefined) this.isHeadAlreadyMarked = false;
                    this.textColor = __parent.pa.color(0);
                    (() => {
                        this.content = /* replaceAll */content.trim().replace(new RegExp("\n\t\r", 'g')," ");
                        this.textColor = textColor;
                    })();
                } else if(((typeof content === 'string') || content === null) && textColor === undefined) {
                    let __args = Array.prototype.slice.call(arguments, [1]);
                    if(this.content===undefined) this.content = null;
                    if(this.isHeadAlreadyMarked===undefined) this.isHeadAlreadyMarked = false;
                    this.textColor = __parent.pa.color(0);
                    this.__parent = __parent;
                    if(this.content===undefined) this.content = null;
                    if(this.isHeadAlreadyMarked===undefined) this.isHeadAlreadyMarked = false;
                    this.textColor = __parent.pa.color(0);
                    (() => {
                        this.content = /* replaceAll */content.trim().replace(new RegExp("\n\t\r", 'g')," ");
                    })();
                } else throw new Error('invalid overload');
            }

            public appendAsWrappedLines(_textSize : number) {
                this.isHeadAlreadyMarked = false;
                let sb : { str: string, toString: Function } = { str: "", toString: function() { return this.str; } };
                let wrappedWidth : number = PApplet.floor((<any>Math).fround((<any>Math).fround(this.__parent.w - this.__parent.padding) - this.__parent.padding));
                this.__parent.pa.textSize(_textSize);
                for(let i : number = 0; i < this.content.length; i++) {{
                    let chunkWidth : number = PApplet.ceil(this.__parent.pa.textWidth(/* toString */sb.str));
                    if(chunkWidth >= wrappedWidth) {
                        this.addWrappedLine(sb);
                        sb = { str: "", toString: function() { return this.str; } };
                    }
                    /* append */(sb => { sb.str = sb.str.concat(<any>this.content.charAt(i)); return sb; })(sb);
                };}
                this.addWrappedLine(sb);
            }

            addWrappedLine(sb : { str: string, toString: Function }) {
                if(!this.isHeadAlreadyMarked) {
                    /* add */(this.__parent.textLines.push(new ScrollableTextArea.TextLine(this.__parent, /* toString */sb.str, this.textColor, true))>0);
                    this.isHeadAlreadyMarked = true;
                } else {
                    /* add */(this.__parent.textLines.push(new ScrollableTextArea.TextLine(this.__parent, /* toString */sb.str, this.textColor, false))>0);
                }
            }
        }
        TextBlock["__class"] = "ktbyte.gui.ScrollableTextArea.TextBlock";

    }

}
namespace ktbyte.gui {
    /**
     * @extends ktbyte.gui.Controller
     * @class
     */
    export class Pane extends ktbyte.gui.Controller {
        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.pg.beginDraw();
            this.pg.background(200, 100);
            if(this.isSelected(this)) {
                this.pg.strokeWeight(2.0);
            } else {
                this.pg.strokeWeight(1.0);
            }
            this.pg.rectMode(PConstants.CORNER);
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            this.pg.noFill();
            this.pg.endDraw();
        }
    }
    Pane["__class"] = "ktbyte.gui.Pane";
    Pane["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class ArrowButton extends ktbyte.gui.Controller {
        /*private*/ direction : number;

        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number, dir : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.direction===undefined) this.direction = 0;
            this.direction = dir;
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.pg.beginDraw();
            this.pg.pushStyle();
            this.pg.stroke(0);
            if(this.isHovered && !this.isPressed) {
                this.pg.fill(this.fgHoveredColor);
            } else if(this.isHovered && this.isPressed) {
                this.pg.fill(this.fgPressedColor);
            } else {
                this.pg.fill(this.fgPassiveColor);
            }
            if(this.isSelected(this)) {
                this.pg.strokeWeight(2.0);
            } else {
                this.pg.strokeWeight(1.0);
            }
            this.pg.rectMode(PConstants.CORNER);
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            this.pg.pushMatrix();
            this.pg.translate((<any>Math).fround(this.w * 0.5), (<any>Math).fround(this.h * 0.5));
            if(this.direction === PConstants.UP) {
                this.pg.rotate(PConstants.PI);
            } else if(this.direction === PConstants.DOWN) {
                this.pg.rotate(0);
            } else if(this.direction === PConstants.LEFT) {
                this.pg.rotate(PConstants.HALF_PI);
            } else if(this.direction === PConstants.RIGHT) {
                this.pg.rotate((<any>Math).fround(PConstants.HALF_PI + PConstants.PI));
            }
            this.pg.strokeWeight(1.0);
            this.pg.line((<any>Math).fround(-this.w * 0.4), (<any>Math).fround(-this.h * 0.4), 0, (<any>Math).fround(this.h * 0.4));
            this.pg.line(0, (<any>Math).fround(this.h * 0.4), (<any>Math).fround(this.w * 0.4), (<any>Math).fround(-this.h * 0.4));
            this.pg.popMatrix();
            this.pg.popStyle();
            this.pg.endDraw();
        }

        public setDirection(dir : number) {
            this.direction = dir;
        }
    }
    ArrowButton["__class"] = "ktbyte.gui.ArrowButton";
    ArrowButton["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class Panel extends ktbyte.gui.Controller {
        /*private*/ titleBar : ktbyte.gui.TitleBar;

        /*private*/ pane : ktbyte.gui.Pane;

        public constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.titleBar===undefined) this.titleBar = null;
            if(this.pane===undefined) this.pane = null;
            this.isDragable = true;
            this.createTitleBar();
            this.createPane();
            this.setTitle(title);
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.pg.beginDraw();
            this.pg.background(200, 50);
            this.pg.stroke(0);
            this.pg.noFill();
            this.pg.rectMode(PConstants.CORNER);
            if(this.isSelected(this)) {
                this.pg.strokeWeight(3.0);
            } else {
                this.pg.strokeWeight(1.0);
            }
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            this.pg.endDraw();
        }

        /**
         * 
         */
        public processMousePressed() {
            if(this.isActive) {
                for(let index165=0; index165 < this.controllers.length; index165++) {
                    let child = this.controllers[index165];
                    {
                        child.processMousePressed();
                    }
                }
                this.isPressed = this.isHovered;
                if(this.isPressed) {
                    for(let index166=0; index166 < this.adapters.length; index166++) {
                        let adapter = this.adapters[index166];
                        {
                            adapter.onMousePressed();
                        }
                    }
                }
            }
        }

        /**
         * 
         * @param {number} x
         * @param {number} y
         * @return {boolean}
         */
        public isPointInside(x : number, y : number) : boolean {
            let isInside : boolean = false;
            if(this.isActive) {
                if(x > this.getAbsolutePosX() && x < this.getAbsolutePosX() + this.w) {
                    if(y > this.getAbsolutePosY() && y < this.getAbsolutePosY() + this.titleBar.h) {
                        isInside = true;
                    }
                }
            }
            return isInside;
        }

        /*private*/ createTitleBar() {
            this.titleBar = new ktbyte.gui.TitleBar(this.ktgui, "tb:" + this.title, 0, 0, this.w, ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH);
            this.titleBar.isDragable = false;
            this.attachController(this.titleBar);
        }

        /*private*/ createPane() {
            this.pane = new ktbyte.gui.Pane(this.ktgui, "pane:" + this.title, 0, ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH, this.w, this.h - ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH);
            this.pane.isDragable = false;
            this.attachController(this.pane);
        }

        public addController$ktbyte_gui_Controller$int$int(child : ktbyte.gui.Controller, hAlign : number, vAlign : number) {
            if(this.isActive) {
                child.alignAbout$ktbyte_gui_Controller$int$int(this.pane, hAlign, vAlign);
                this.pane.attachController(child);
            }
        }

        public addController$ktbyte_gui_Controller$int$int$int(child : ktbyte.gui.Controller, hAlign : number, vAlign : number, gap : number) {
            if(this.isActive) {
                child.alignAbout$ktbyte_gui_Controller$int$int$int(this.pane, hAlign, vAlign, gap);
                this.pane.attachController(child);
            }
        }

        /**
         * Add child controller to the 'internal' pane instead of adding it to 'this' window
         * @param {ktbyte.gui.Controller} child
         * @param {number} hAlign
         * @param {number} vAlign
         * @param {number} gap
         */
        public addController(child? : any, hAlign? : any, vAlign? : any, gap? : any) : any {
            if(((child != null && child instanceof <any>ktbyte.gui.Controller) || child === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && ((typeof gap === 'number') || gap === null)) {
                return <any>this.addController$ktbyte_gui_Controller$int$int$int(child, hAlign, vAlign, gap);
            } else if(((child != null && child instanceof <any>ktbyte.gui.Controller) || child === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && gap === undefined) {
                return <any>this.addController$ktbyte_gui_Controller$int$int(child, hAlign, vAlign);
            } else throw new Error('invalid overload');
        }

        public getPane() : ktbyte.gui.Pane {
            return this.pane;
        }
    }
    Panel["__class"] = "ktbyte.gui.Panel";
    Panel["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    /**
     * @extends ktbyte.gui.Controller
     * @class
     */
    export class Slider extends ktbyte.gui.Controller {
        public static HANDLE_TYPE_CENTERED : number = 1;

        public static HANDLE_TYPE_EXPANDED : number = 0;

        /*private*/ handleType : number = Slider.HANDLE_TYPE_EXPANDED;

        /*private*/ handleSize : number = ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH;

        /*private*/ handlePos : number = 0;

        /*private*/ rangeStart : number = 0;

        /*private*/ rangeEnd : number = 100;

        /*private*/ value : number = this.rangeStart;

        /*private*/ valueStep : number = 1;

        /*private*/ roundingTemplate : number = 10;

        /*private*/ isValueVisible : boolean = true;

        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number, sr : number, er : number) {
            super(ktgui, title, posx, posy, w, h);
            this.rangeStart = sr;
            this.rangeEnd = er;
            this.setHandleType(Slider.HANDLE_TYPE_EXPANDED);
            this.updateHandlePositionFromValue();
            this.updateHandlePositionFromMouse();
            this.updateValueFromHandlePosition();
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            if(this.handleType === Slider.HANDLE_TYPE_CENTERED) {
                this.drawCenteredHandle();
            } else if(this.handleType === Slider.HANDLE_TYPE_EXPANDED) {
                this.drawExpandedHandle();
            } else {
                this.drawExpandedHandle();
            }
        }

        /*private*/ drawExpandedHandle() {
            this.pg.beginDraw();
            this.pg.fill(this.isHovered?ktbyte.gui.KTGUI.COLOR_BG_HOVERED:ktbyte.gui.KTGUI.COLOR_BG_PASSIVE);
            this.pg.rectMode(PConstants.CORNER);
            this.pg.rect(0, 0, this.w, this.h);
            this.pg.fill(this.isHovered?ktbyte.gui.KTGUI.COLOR_FG_HOVERED:ktbyte.gui.KTGUI.COLOR_FG_PASSIVE);
            if(this.w > this.h) {
                this.pg.rect(0, 0, this.handlePos, this.h);
            } else {
                this.pg.rect(0, (<any>Math).fround(this.h - this.handlePos), this.w, this.handlePos);
            }
            if(this.isValueVisible) {
                this.pg.fill(0);
                this.pg.textAlign(PConstants.LEFT, PConstants.CENTER);
                if(this.w > this.h) {
                    this.pg.text(PApplet.str(this.value), 10, (<any>Math).fround(this.h * 0.5));
                    this.pg.textAlign(PConstants.LEFT, PConstants.BOTTOM);
                    this.pg.text(this.title, 10, -2);
                } else {
                    this.pg.text(PApplet.str(this.value), 1, (<any>Math).fround(this.h * 0.5));
                }
            }
            this.pg.endDraw();
        }

        /*private*/ drawCenteredHandle() {
            this.pg.beginDraw();
            this.pg.fill(this.isHovered?ktbyte.gui.KTGUI.COLOR_BG_HOVERED:ktbyte.gui.KTGUI.COLOR_BG_PASSIVE);
            this.pg.rectMode(PConstants.CORNER);
            this.pg.rect(0, 0, this.w, this.h);
            this.pg.fill(this.isHovered?ktbyte.gui.KTGUI.COLOR_FG_HOVERED:ktbyte.gui.KTGUI.COLOR_FG_PASSIVE);
            this.pg.rectMode(PConstants.CENTER);
            let handleOffset : number = (<number>((<any>Math).fround(this.handleSize * 0.5))|0);
            if(this.w > this.h) {
                let correctedHandlePos : number = (<number>PApplet.constrain(this.handlePos, handleOffset, this.w - handleOffset)|0);
                this.pg.rect(correctedHandlePos, (<any>Math).fround(this.h * 0.5), this.handleSize, this.h);
            } else {
                let correctedHandlePos : number = (<number>PApplet.constrain(this.handlePos, handleOffset, this.h - handleOffset)|0);
                this.pg.rect((<any>Math).fround(this.w * 0.5), this.h - correctedHandlePos, this.w, this.handleSize);
            }
            if(this.isValueVisible) {
                this.pg.fill(0);
                this.pg.textAlign(PConstants.LEFT, PConstants.CENTER);
                if(this.w > this.h) {
                    this.pg.text(PApplet.str(this.value), 10, (<any>Math).fround(this.h * 0.5));
                    this.pg.textAlign(PConstants.LEFT, PConstants.BOTTOM);
                    this.pg.text(this.title, 10, -2);
                } else {
                    this.pg.text(PApplet.str(this.value), 1, (<any>Math).fround(this.h * 0.5));
                }
            }
            this.pg.endDraw();
        }

        public getValue() : number {
            return this.value;
        }

        public setValue(val : number) {
            if(val >= this.rangeStart && val <= this.rangeEnd) {
                this.value = val;
                this.updateHandlePositionFromValue();
                this.notifyAdapterOnValueChanged();
            } else {
            }
        }

        public getNormalizedValue() : number {
            return PApplet.map(this.value, this.rangeStart, this.rangeEnd, 0, 100.0);
        }

        public setNormalizedValue(val : number) {
            this.setValue(PApplet.map(val, 100.0, 0.0, this.rangeStart, this.rangeEnd));
        }

        /*private*/ notifyAdapterOnValueChanged() {
            if(this.isActive) {
                for(let index167=0; index167 < this.adapters.length; index167++) {
                    let adapter = this.adapters[index167];
                    {
                        adapter.onValueChanged();
                    }
                }
            }
        }

        public getIsValueVisible() : boolean {
            return this.isValueVisible;
        }

        public setIsValueVisible(visible : boolean) {
            this.isValueVisible = visible;
        }

        public getHandlePos() : number {
            return this.handlePos;
        }

        public setHandlePos(pos : number) {
            console.info("Trying to set handle pos to " + pos);
            if(this.w > this.h) {
                if(pos >= 0 && pos <= this.w) {
                    this.handlePos = pos;
                    this.updateValueFromHandlePosition();
                } else {
                    console.info("You\'re trying to set the position of the slider to be outside its width.");
                }
            } else {
                if(pos >= 0 && pos <= this.h) {
                    this.handlePos = pos;
                    this.updateValueFromHandlePosition();
                } else {
                    console.info("You\'re trying to set the position of the slider to be outside its height.");
                }
            }
            console.info("Handle position is: " + this.handlePos + ", value is:" + this.value);
        }

        public getValueStep() : number {
            return this.valueStep;
        }

        public setValueStep(step : number) {
            if(step > 0) {
                this.valueStep = step;
            }
        }

        public incrementValue() {
            let newVal : number = (<any>Math).fround(this.value + this.valueStep);
            this.setValue(newVal > this.rangeEnd?this.rangeEnd:newVal);
        }

        public decrementValue() {
            let newVal : number = (<any>Math).fround(this.value - this.valueStep);
            this.setValue(newVal < this.rangeStart?this.rangeStart:newVal);
        }

        public setHandleType(handleType : number) {
            this.handleType = handleType;
            if(handleType === Slider.HANDLE_TYPE_EXPANDED) {
                this.handleSize = 0;
            } else if(handleType === Slider.HANDLE_TYPE_CENTERED) {
                this.handleSize = ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH;
            }
        }

        public getHandleSize() : number {
            return this.handleSize;
        }

        public setHandleSize(hSize : number) {
            if(this.w > this.h) {
                this.handleSize = PApplet.constrain(hSize, ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH, this.w);
            } else {
                this.handleSize = PApplet.constrain(hSize, ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH, this.h);
            }
            this.updateValueFromHandlePosition();
        }

        public getRangeStart() : number {
            return this.rangeStart;
        }

        public setRangeStart(rangeStart : number) {
            if(rangeStart < this.rangeEnd) {
                this.rangeStart = rangeStart;
                this.updateValueFromHandlePosition();
                ktbyte.gui.KTGUI.debug("[" + this.title + "] range start set to " + rangeStart);
            } else {
                ktbyte.gui.KTGUI.debug("[" + this.title + "] range start cannot be set greater than its range end.");
            }
        }

        public getRangeEnd() : number {
            return this.rangeEnd;
        }

        public setRangeEnd(rangeEnd : number) {
            if(rangeEnd > this.rangeStart) {
                this.rangeEnd = rangeEnd;
                this.updateValueFromHandlePosition();
                ktbyte.gui.KTGUI.debug("[" + this.title + "] range end set to " + rangeEnd);
            } else {
                ktbyte.gui.KTGUI.debug("[" + this.title + "] range end cannot be set smaller than its range start.");
            }
        }

        public setRounding(n : number) {
            this.roundingTemplate = (<any>Math).fround(Math.pow(10, n));
        }

        /**
         * This method is called when the user change the <b>value</b> of the slider
         * without the mouse, using the setValue(int) method.
         * @private
         */
        /*private*/ updateHandlePositionFromValue() {
            if(this.w > this.h) {
                this.handlePos = PApplet.map(this.value, this.rangeStart, this.rangeEnd, (<any>Math).fround(this.handleSize * 0.5), (<any>Math).fround(this.w - (<any>Math).fround(this.handleSize * 0.5)));
            } else {
                this.handlePos = PApplet.map(this.value, this.rangeStart, this.rangeEnd, (<any>Math).fround(this.handleSize * 0.5), (<any>Math).fround(this.h - (<any>Math).fround(this.handleSize * 0.5)));
            }
        }

        /**
         * This method is called when the user change the <b>position</b> of the slider
         * with the mouse.
         * @private
         */
        /*private*/ updateHandlePositionFromMouse() {
            if(this.w > this.h) {
                this.handlePos = PApplet.constrain(this.pa.mouseX - this.getAbsolutePosX(), (<any>Math).fround(this.handleSize * 0.5), (<any>Math).fround(this.w - (<any>Math).fround(this.handleSize * 0.5)));
            } else {
                this.handlePos = PApplet.constrain(this.h - (this.pa.mouseY - this.getAbsolutePosY()), (<any>Math).fround(this.handleSize * 0.5), (<any>Math).fround(this.h - (<any>Math).fround(this.handleSize * 0.5)));
            }
        }

        /**
         * This method is called to recalculate the slider's `value` within the given range
         * when the user change the <b>position</b> of the slider with the mouse.
         * @private
         */
        /*private*/ updateValueFromHandlePosition() {
            if(this.w > this.h) {
                this.value = PApplet.map(this.handlePos, (<any>Math).fround(this.handleSize * 0.5), (<any>Math).fround(this.w - (<any>Math).fround(this.handleSize * 0.5)), this.rangeStart, this.rangeEnd);
            } else {
                this.value = PApplet.map(this.handlePos, (<any>Math).fround(this.handleSize * 0.5), (<any>Math).fround(this.h - (<any>Math).fround(this.handleSize * 0.5)), this.rangeStart, this.rangeEnd);
            }
            this.value = PApplet.constrain(this.value, this.rangeStart, this.rangeEnd);
            if(this.roundingTemplate > 0) {
                this.value = (<any>Math).fround(Math.round((<any>Math).fround(this.value * this.roundingTemplate)) / this.roundingTemplate);
            } else {
                this.value = (<any>Math).fround(Math.floor(this.value));
            }
            this.notifyAdapterOnValueChanged();
        }

        public processMouseMoved() {
            this.isHovered = this.isPointInside(this.pa.mouseX, this.pa.mouseY);
            for(let index168=0; index168 < this.adapters.length; index168++) {
                let adapter = this.adapters[index168];
                {
                    adapter.onMouseMoved();
                }
            }
        }

        public processMousePressed() {
            this.isPressed = this.isHovered;
            if(this.isPressed) {
                this.updateHandlePositionFromMouse();
                this.updateValueFromHandlePosition();
            }
            for(let index169=0; index169 < this.adapters.length; index169++) {
                let adapter = this.adapters[index169];
                {
                    adapter.onMousePressed();
                }
            }
        }

        public processMouseReleased() {
            this.isPressed = false;
            this.isDragged = false;
            for(let index170=0; index170 < this.adapters.length; index170++) {
                let adapter = this.adapters[index170];
                {
                    adapter.onMouseReleased();
                }
            }
        }

        public processMouseDragged() {
            this.isDragged = this.isPressed;
            if(this.isPressed) {
                this.updateHandlePositionFromMouse();
                this.updateValueFromHandlePosition();
            }
            for(let index171=0; index171 < this.adapters.length; index171++) {
                let adapter = this.adapters[index171];
                {
                    adapter.onMouseDragged();
                }
            }
        }
    }
    Slider["__class"] = "ktbyte.gui.Slider";
    Slider["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class TitleBar extends ktbyte.gui.Bar {
        closeButton : ktbyte.gui.CloseButton;

        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.closeButton===undefined) this.closeButton = null;
            this.isDragable = true;
            this.closeButton = new ktbyte.gui.CloseButton(ktgui, "cb:" + this.title, w - h + 2, 2, h - 4, h - 4);
            this.attachController(this.closeButton);
        }
    }
    TitleBar["__class"] = "ktbyte.gui.TitleBar";
    TitleBar["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    /**
     * 
     * @param {ktbyte.gui.KTGUI} ktgui
     * @param {string} title
     * @param {number} posx
     * @param {number} posy
     * @param {number} w
     * @param {number} h
     * @class
     * @extends ktbyte.gui.Button
     */
    export class CloseButton extends ktbyte.gui.Button {
        public constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
            this.isDragable = false;
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.pg.beginDraw();
            this.pg.rectMode(PConstants.CORNER);
            if(this.isHovered && !this.isPressed) {
                this.pg.fill(ktbyte.gui.KTGUI.COLOR_FG_HOVERED);
            } else if(this.isHovered && this.isPressed) {
                this.pg.fill(ktbyte.gui.KTGUI.COLOR_FG_PRESSED);
            } else {
                this.pg.fill(200, 200);
            }
            this.pg.stroke(0);
            this.pg.strokeWeight(1);
            this.pg.rectMode(PConstants.CORNER);
            this.pg.rect(0, 0, this.w, this.h);
            this.pg.line((<any>Math).fround(this.w * 0.2), (<any>Math).fround(this.h * 0.2), (<any>Math).fround(this.w * 0.8), (<any>Math).fround(this.h * 0.8));
            this.pg.line((<any>Math).fround(this.w * 0.2), (<any>Math).fround(this.h * 0.8), (<any>Math).fround(this.w * 0.8), (<any>Math).fround(this.h * 0.2));
            this.pg.endDraw();
        }

        /**
         * TODO : replace 'closeControllerRecursively' method with 'closeParentWindow' in
         * order to prevent closing ALL controllers up to the 'root'. That behaviour is not
         * right - the CloseButton of the Window.TitleBar should close only the parent Window
         * and all it's childs (and their childs).
         */
        public processMousePressed() {
            super.processMousePressed();
            if(this.isPressed) {
                this.closeParent();
            }
        }

        /**
         * This method closes all the controllers recursively up to the parent Window
         * and then closes all its childs recursively down.
         */
        public closeParent() {
            if(this.parentController != null) {
                if(!/* contains */(/* getName */(c => c["__class"]?c["__class"]:c["name"])((<any>this.parentController.constructor)).indexOf("Window") != -1)) {
                    this.parentController.closeParent();
                }
                this.parentController.close();
            }
            this.closeAllChildsRecursively();
        }
    }
    CloseButton["__class"] = "ktbyte.gui.CloseButton";
    CloseButton["__interfaces"] = ["def.processing.core.PConstants"];


}


ktbyte.gui.StageManager.instance_$LI$();

ktbyte.gui.StageManager.defaultStage_$LI$();

ktbyte.gui.StageManager.activeStage_$LI$();

ktbyte.gui.StageManager.stages_$LI$();

ktbyte.gui.StageManager.__static_initialize();
