/* Generated from Java with JSweet 2.2.0-SNAPSHOT - http://www.jsweet.org */
namespace ktbyte.gui {
    /**
     * This abstract class should be extended by the KTGUI components (controllers)
     * @class
     */
    export abstract class EventAdapter {
        public onMousePressed() {
        }

        public onMouseReleased() {
        }

        public onMouseMoved() {
        }

        public onMouseDragged() {
        }

        public onMouseWheel(count : number) {
        }

        public onAnyKeyReleased() {
        }

        public onAnyKeyPressed() {
        }

        public onEnterKeyPressed() {
        }

        public onConsoleInput(textInput : string, lastVariableName : string) {
        }

        public println(string : string) {
            PApplet.println(string);
        }
    }
    EventAdapter["__class"] = "ktbyte.gui.EventAdapter";

}
namespace ktbyte.gui {
    export class EventProcessor {
        public isActive : boolean = true;

        public isPressed : boolean;

        public isHovered : boolean;

        public isDragged : boolean;

        public isVisible : boolean = true;

        public isDragable : boolean;

        public handleFocus : boolean;

        public adapters : Array<ktbyte.gui.EventAdapter> = <any>([]);

        public processMouseMoved() {
        }

        public processMousePressed() {
        }

        public processMouseReleased() {
        }

        public processMouseDragged() {
        }

        public processMouseWheel(me : ProcessingMouseEvent) {
        }

        public processKeyPressed() {
        }

        public processKeyReleased() {
        }

        public isPointInside(x : number, y : number) : boolean {
            return false;
        }

        public addEventAdapter(adapter : ktbyte.gui.EventAdapter) {
            /* add */(this.adapters.push(adapter)>0);
        }

        constructor() {
            if(this.isPressed===undefined) this.isPressed = false;
            if(this.isHovered===undefined) this.isHovered = false;
            if(this.isDragged===undefined) this.isDragged = false;
            if(this.isDragable===undefined) this.isDragable = false;
            if(this.handleFocus===undefined) this.handleFocus = false;
        }
    }
    EventProcessor["__class"] = "ktbyte.gui.EventProcessor";

}
namespace ktbyte.gui {
    /**
     * This is a constructor of the KTGUI class.
     * It automatically registers the 'draw', 'mouseEvent' and 'keyEvent' methods of this class in PApplet.
     * @param {*} pa
     * @class
     */
    export class KTGUI implements PConstants {
        static pa : any = null;

        /*private*/ garbageList : any;

        public drawCallStack : Array<string> = <any>([]);

        public static COLOR_FG_HOVERED : number = 0;

        public static COLOR_FG_PRESSED : number = 0;

        public static COLOR_FG_PASSIVE : number = 0;

        public static COLOR_BG_HOVERED : number = 0;

        public static COLOR_BG_PASSIVE : number = 0;

        public static COLOR_BG_PRESSED : number = 0;

        public static DEFAULT_COMPONENT_WIDTH : number = 0;

        public static DEFAULT_ALIGN_GAP : number = 0;

        public static DEFAULT_ROUNDING : number = 0;

        static debugControllers : boolean = false;

        /*private*/ debugDrawCallStack : boolean = false;

        public constructor(pa : any) {
            if(this.garbageList===undefined) this.garbageList = null;
            KTGUI.debug("\nCreating of the KTGUI instance started.");
            this.init(pa);
            KTGUI.debug("Creating of the KTGUI instance completed.\n");
        }

        /*private*/ init(pa : any) {
            KTGUI.debug("\tInitializing of the KTGUI started.");
            KTGUI.pa = pa;
            KTGUI.pa.registerMethod("draw", this);
            KTGUI.debug("\t\t\'draw()\' method has been registered in parent PApplet.");
            KTGUI.pa.registerMethod("mouseEvent", this);
            KTGUI.debug("\t\t\'mouseEvent()\' method has been registered in parent PApplet.");
            KTGUI.pa.registerMethod("keyEvent", this);
            KTGUI.debug("\t\t\'keyEvent()\' method has been registered in parent PApplet.");
            this.garbageList = <any>({});
            KTGUI.debug("\t\tGarbage list created.");
            KTGUI.COLOR_FG_PASSIVE = pa.color(150, 180, 150);
            KTGUI.COLOR_FG_HOVERED = pa.color(150, 220, 150);
            KTGUI.COLOR_FG_PRESSED = pa.color(110, 200, 110);
            KTGUI.COLOR_BG_PASSIVE = pa.color(190);
            KTGUI.COLOR_BG_HOVERED = pa.color(220);
            KTGUI.COLOR_BG_PRESSED = pa.color(210);
            KTGUI.DEFAULT_COMPONENT_WIDTH = 16;
            KTGUI.DEFAULT_ALIGN_GAP = 20;
            KTGUI.DEFAULT_ROUNDING = 8;
            KTGUI.debug("\t\tColor and size constants initialized.");
            ktbyte.gui.StageManager.getInstance();
            KTGUI.debug("\tInitializing of the KTGUI completed.");
        }

        public static getParentPApplet() : any {
            return KTGUI.pa;
        }

        /**
         * This method is intended to be called <b>automatically</b> at the end of each draw() cycle of the parent PApplet.
         * This way, the KTGUI class automatically updates all the controllers on the <i>default</i> and <i>active</i> stages.
         */
        public draw() {
            if(ktbyte.gui.StageManager.getInstance().userStagesExist()) {
                ktbyte.gui.StageManager.getInstance().getActiveStage().draw();
            }
            ktbyte.gui.StageManager.getInstance().getDefaultStage().draw();
            this.collectGarbage();
        }

        public setDrawCallStackFlag(debug : boolean) {
            this.debugDrawCallStack = debug;
        }

        drawDebugTextSplitLine(x : number, y : number) {
            KTGUI.pa.text("----------------------------------------------------------------------------------------------------------------------------", x, y);
        }

        public addDrawCallStackDebugMessage(msg : string) {
            if(this.debugDrawCallStack) {
                /* add */(this.drawCallStack.push(msg)>0);
            }
        }

        public addToGarbage(controller : ktbyte.gui.Controller, millis : number) {
            /* put */((m,k,v) => { if(m.entries==null) m.entries=[]; for(let i=0;i<m.entries.length;i++) if(m.entries[i].key.equals!=null && m.entries[i].key.equals(k) || m.entries[i].key===k) { m.entries[i].value=v; return; } m.entries.push({key:k,value:v,getKey: function() { return this.key }, getValue: function() { return this.value }}); })(<any>this.garbageList, controller, millis);
        }

        collectGarbage() {
            {
                let array170 = /* entrySet */((m) => { if(m.entries==null) m.entries=[]; return m.entries; })(<any>this.garbageList);
                for(let index169=0; index169 < array170.length; index169++) {
                    let me = array170[index169];
                    {
                        let controller : ktbyte.gui.Controller = <ktbyte.gui.Controller>me.getKey();
                        let time : number = <number>me.getValue();
                        if(KTGUI.pa.millis() - time > 100) {
                            if(controller.parentStage != null) {
                                controller.parentStage.unregisterController(controller);
                            } else {
                                if(controller.parentController != null) {
                                    controller.parentController.detachController(controller);
                                }
                            }
                        }
                    }
                }
            }
        }

        public createButton$java_lang_String$int$int$int$int(title : string, x : number, y : number, w : number, h : number) : ktbyte.gui.Button {
            return new ktbyte.gui.Button(this, title, x, y, w, h);
        }

        public createButton(title? : any, x? : any, y? : any, w? : any, h? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                return <any>this.createButton$java_lang_String$int$int$int$int(title, x, y, w, h);
            } else if(((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                return <any>this.createButton$int$int$int$int(title, x, y, w);
            } else throw new Error('invalid overload');
        }

        public createButton$int$int$int$int(x : number, y : number, w : number, h : number) : ktbyte.gui.Button {
            return new ktbyte.gui.Button(this, "A Button", x, y, w, h);
        }

        public createDirectionButton$java_lang_String$int$int$int$int$int(title : string, x : number, y : number, w : number, h : number, dir : number) : ktbyte.gui.ArrowButton {
            return new ktbyte.gui.ArrowButton(this, title, x, y, w, h, dir);
        }

        public createDirectionButton(title? : any, x? : any, y? : any, w? : any, h? : any, dir? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof dir === 'number') || dir === null)) {
                return <any>this.createDirectionButton$java_lang_String$int$int$int$int$int(title, x, y, w, h, dir);
            } else if(((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && dir === undefined) {
                return <any>this.createDirectionButton$int$int$int$int$int(title, x, y, w, h);
            } else throw new Error('invalid overload');
        }

        public createDirectionButton$int$int$int$int$int(x : number, y : number, w : number, h : number, dir : number) : ktbyte.gui.ArrowButton {
            return new ktbyte.gui.ArrowButton(this, "A DirButton", x, y, w, h, dir);
        }

        public createSlider$java_lang_String$int$int$int$int$int$int(title : string, posx : number, posy : number, w : number, h : number, sr : number, er : number) : ktbyte.gui.Slider {
            return new ktbyte.gui.Slider(this, title, posx, posy, w, h, sr, er);
        }

        public createSlider(title? : any, posx? : any, posy? : any, w? : any, h? : any, sr? : any, er? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof posx === 'number') || posx === null) && ((typeof posy === 'number') || posy === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof sr === 'number') || sr === null) && ((typeof er === 'number') || er === null)) {
                return <any>this.createSlider$java_lang_String$int$int$int$int$int$int(title, posx, posy, w, h, sr, er);
            } else if(((typeof title === 'number') || title === null) && ((typeof posx === 'number') || posx === null) && ((typeof posy === 'number') || posy === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof sr === 'number') || sr === null) && er === undefined) {
                return <any>this.createSlider$int$int$int$int$int$int(title, posx, posy, w, h, sr);
            } else throw new Error('invalid overload');
        }

        public createSlider$int$int$int$int$int$int(posx : number, posy : number, w : number, h : number, sr : number, er : number) : ktbyte.gui.Slider {
            return new ktbyte.gui.Slider(this, "A Slider", posx, posy, w, h, sr, er);
        }

        public createWindow$java_lang_String$int$int$int$int(title : string, x : number, y : number, w : number, h : number) : ktbyte.gui.Panel {
            let window : ktbyte.gui.Panel = new ktbyte.gui.Panel(this, title, x, y, w, h);
            return window;
        }

        public createWindow(title? : any, x? : any, y? : any, w? : any, h? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                return <any>this.createWindow$java_lang_String$int$int$int$int(title, x, y, w, h);
            } else if(((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                return <any>this.createWindow$int$int$int$int(title, x, y, w);
            } else throw new Error('invalid overload');
        }

        public createWindow$int$int$int$int(x : number, y : number, w : number, h : number) : ktbyte.gui.Panel {
            let window : ktbyte.gui.Panel = new ktbyte.gui.Panel(this, "A Window", x, y, w, h);
            return window;
        }

        public createPane$java_lang_String$int$int$int$int(title : string, x : number, y : number, w : number, h : number) : ktbyte.gui.Pane {
            let pane : ktbyte.gui.Pane = new ktbyte.gui.Pane(this, title, x, y, w, h);
            return pane;
        }

        public createPane(title? : any, x? : any, y? : any, w? : any, h? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                return <any>this.createPane$java_lang_String$int$int$int$int(title, x, y, w, h);
            } else if(((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                return <any>this.createPane$int$int$int$int(title, x, y, w);
            } else throw new Error('invalid overload');
        }

        public createPane$int$int$int$int(x : number, y : number, w : number, h : number) : ktbyte.gui.Pane {
            let pane : ktbyte.gui.Pane = new ktbyte.gui.Pane(this, "A Pane", x, y, w, h);
            return pane;
        }

        public createScrollBar$int$int$int$int$int$int(x : number, y : number, w : number, h : number, sr : number, er : number) : ktbyte.gui.ScrollBar {
            let scrollBar : ktbyte.gui.ScrollBar = this.createScrollBar$java_lang_String$int$int$int$int$int$int("A ScrollBar", x, y, w, h, sr, er);
            return scrollBar;
        }

        public createScrollBar$java_lang_String$int$int$int$int$int$int(title : string, x : number, y : number, w : number, h : number, sr : number, er : number) : ktbyte.gui.ScrollBar {
            if(w > h) {
                if((w - 2 * h) < 2 * KTGUI.DEFAULT_COMPONENT_WIDTH) {
                    KTGUI.debug("ERROR: The width of the ScrollBar to be created is  too small. As a consequence, the internal slider would have  orthogonal direction. Cannot create ScrollBar. Returning null reference.");
                    return null;
                }
            } else {
                if((h - 2 * w) < 2 * KTGUI.DEFAULT_COMPONENT_WIDTH) {
                    KTGUI.debug("ERROR: The height of the ScrollBar to be created is  too small. As a consequence, the internal slider would have  orthogonal direction. Cannot create ScrollBar. Returning null reference.");
                    return null;
                }
            }
            let scrollBar : ktbyte.gui.ScrollBar = new ktbyte.gui.ScrollBar(this, title, x, y, w, h, sr, er);
            return scrollBar;
        }

        public createScrollBar(title? : any, x? : any, y? : any, w? : any, h? : any, sr? : any, er? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof sr === 'number') || sr === null) && ((typeof er === 'number') || er === null)) {
                return <any>this.createScrollBar$java_lang_String$int$int$int$int$int$int(title, x, y, w, h, sr, er);
            } else if(((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof sr === 'number') || sr === null) && er === undefined) {
                return <any>this.createScrollBar$int$int$int$int$int$int(title, x, y, w, h, sr);
            } else throw new Error('invalid overload');
        }

        public createInputTextBox$java_lang_String$int$int$int$int(title : string, x : number, y : number, w : number, h : number) : ktbyte.gui.InputTextBox {
            return new ktbyte.gui.InputTextBox(this, title, x, y, w, h);
        }

        public createInputTextBox(title? : any, x? : any, y? : any, w? : any, h? : any) : any {
            if(((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                return <any>this.createInputTextBox$java_lang_String$int$int$int$int(title, x, y, w, h);
            } else if(((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                return <any>this.createInputTextBox$int$int$int$int(title, x, y, w);
            } else throw new Error('invalid overload');
        }

        public createInputTextBox$int$int$int$int(x : number, y : number, w : number, h : number) : ktbyte.gui.InputTextBox {
            return this.createInputTextBox$java_lang_String$int$int$int$int("An InputTextBox", x, y, w, h);
        }

        /**
         * This method 'redirects' the emitted mouse event from PApplet to KTGUI 'transfer' methods.
         * This method will be called <b>automatically</b> when the PApplet.mouseEvent is happening.
         * @param {ProcessingMouseEvent} e
         */
        public mouseEvent(e : ProcessingMouseEvent) {
            switch((e.getAction())) {
            case ProcessingMouseEvent.PRESS:
                this.mousePressed();
                break;
            case ProcessingMouseEvent.RELEASE:
                this.mouseReleased();
                break;
            case ProcessingMouseEvent.DRAG:
                this.mouseDragged();
                break;
            case ProcessingMouseEvent.MOVE:
                this.mouseMoved();
                break;
            case ProcessingMouseEvent.WHEEL:
                this.mouseWheel(e);
                break;
            }
        }

        /**
         * This method 'redirects' the emitted keyboard event from PApplet to KTGUI 'transfer' methods.
         * This method will be called <b>automatically</b> when the PApplet.keyEvent is happening.
         * @param {ProcessingKeyEvent} e
         */
        public keyEvent(e : ProcessingKeyEvent) {
            switch((e.getAction())) {
            case ProcessingKeyEvent.PRESS:
                this.keyPressed();
                break;
            case ProcessingKeyEvent.RELEASE:
                this.keyReleased();
                break;
            }
        }

        public static debug(string : string) {
            if(KTGUI.debugControllers) PApplet.println(string);
        }

        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.mouseDragged event to KTGUI components (controllers)
         * @private
         */
        /*private*/ mouseDragged() {
            for(let index171=0; index171 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index171++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index171];
                {
                    controller.processMouseDragged();
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index172=0; index172 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index172++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index172];
                    {
                        controller.processMouseDragged();
                    }
                }
            }
        }

        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.mousePressed event to KTGUI components (controllers)
         * @private
         */
        /*private*/ mousePressed() {
            for(let index173=0; index173 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index173++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index173];
                {
                    controller.processMousePressed();
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index174=0; index174 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index174++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index174];
                    {
                        controller.processMousePressed();
                    }
                }
            }
        }

        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.mouseReleased event to KTGUI components (controllers)
         * @private
         */
        /*private*/ mouseReleased() {
            for(let index175=0; index175 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index175++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index175];
                {
                    controller.processMouseReleased();
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index176=0; index176 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index176++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index176];
                    {
                        controller.processMouseReleased();
                    }
                }
            }
        }

        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.mouseMoved event to KTGUI components (controllers)
         * @private
         */
        /*private*/ mouseMoved() {
            for(let index177=0; index177 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index177++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index177];
                {
                    controller.processMouseMoved();
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index178=0; index178 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index178++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index178];
                    {
                        controller.processMouseMoved();
                    }
                }
            }
        }

        /*private*/ mouseWheel(me : ProcessingMouseEvent) {
            for(let index179=0; index179 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index179++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index179];
                {
                    controller.processMouseWheel(me);
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index180=0; index180 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index180++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index180];
                    {
                        controller.processMouseWheel(me);
                    }
                }
            }
        }

        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.keyPressed event to KTGUI components (controllers)
         * @private
         */
        /*private*/ keyPressed() {
            for(let index181=0; index181 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index181++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index181];
                {
                    controller.processKeyPressed();
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index182=0; index182 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index182++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index182];
                    {
                        controller.processKeyPressed();
                    }
                }
            }
        }

        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.keyReleased event to KTGUI components (controllers)
         * @private
         */
        /*private*/ keyReleased() {
            for(let index183=0; index183 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index183++) {
                let controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index183];
                {
                    controller.processKeyReleased();
                }
            }
            if(ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                for(let index184=0; index184 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index184++) {
                    let controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index184];
                    {
                        controller.processKeyReleased();
                    }
                }
            }
        }
    }
    KTGUI["__class"] = "ktbyte.gui.KTGUI";
    KTGUI["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {}
namespace ktbyte.gui {
    /**
     * A Stage can have multple controllers.
     * The KTGUI class should handle the transition from one Stage to another.
     * Only one Stage can be active at a time.
     * Only the GUI elements from the active Stage will be displayed
     * This allows the sharing of variables between different Stages, by storing/retriving data from the 'context' object
     * @param {string} name
     * @class
     */
    export class Stage {
        controllers : Array<ktbyte.gui.Controller>;

        name : string;

        pa : any;

        public constructor(name : string) {
            if(this.controllers===undefined) this.controllers = null;
            if(this.name===undefined) this.name = null;
            if(this.pa===undefined) this.pa = null;
            ktbyte.gui.KTGUI.debug("Creation of stage {" + name + "} started.");
            this.pa = ktbyte.gui.KTGUI.getParentPApplet();
            this.name = name;
            this.controllers = <any>([]);
            /* add */(ktbyte.gui.StageManager.getInstance().getStages().push(this)>0);
            ktbyte.gui.KTGUI.debug("Creation of stage {" + name + "} completed.");
        }

        public getName() : string {
            return this.name;
        }

        public draw() {
            for(let index185=0; index185 < this.controllers.length; index185++) {
                let controller = this.controllers[index185];
                {
                    if(controller.isActive) {
                        controller.updateGraphics();
                        controller.draw();
                    }
                }
            }
        }

        public registerController(controller : ktbyte.gui.Controller) {
            ktbyte.gui.KTGUI.debug("Registering controller [" + controller.title + "] of type <" + /* getName */(c => c["__class"]?c["__class"]:c["name"])((<any>controller.constructor)) + "> in stage {" + this.name + "}:");
            if(/* contains */(this.controllers.indexOf(<any>(controller)) >= 0)) {
                ktbyte.gui.KTGUI.debug("\tController [" + controller.title + "] already exist in stage {" + this.name + "}. Interrupting.");
                return;
            }
            if(/* contains */(ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.indexOf(<any>(controller)) >= 0)) {
                ktbyte.gui.StageManager.getInstance().getDefaultStage().unregisterController(controller);
            }
            if(ktbyte.gui.StageManager.getInstance().getActiveStage() != null) {
                if(/* contains */(ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.indexOf(<any>(controller)) >= 0)) {
                    ktbyte.gui.StageManager.getInstance().getActiveStage().unregisterController(controller);
                }
            }
            /* add */(this.controllers.push(controller)>0);
            controller.parentStage = this;
            ktbyte.gui.KTGUI.debug("\tDone. Now, stage {" + this.name + "} contain " + /* size */(<number>this.controllers.length) + " controller(s).");
            for(let index186=0; index186 < this.controllers.length; index186++) {
                let c = this.controllers[index186];
                {
                    ktbyte.gui.KTGUI.debug("\t\t" + this.controllers.indexOf(c) + ": " + c.title + " (" + /* size */(<number>c.controllers.length) + " child controllers)");
                    for(let index187=0; index187 < c.controllers.length; index187++) {
                        let child = c.controllers[index187];
                        {
                            ktbyte.gui.KTGUI.debug("\t\t\t" + c.controllers.indexOf(child) + ": " + child.title);
                        }
                    }
                }
            }
        }

        public unregisterController(controller : ktbyte.gui.Controller) {
            if(/* contains */(this.controllers.indexOf(<any>(controller)) >= 0)) {
                /* remove */(a => { let index = a.indexOf(controller); if(index>=0) { a.splice(index, 1); return true; } else { return false; }})(this.controllers);
                controller.parentStage = null;
            }
        }

        public getControllers() : Array<ktbyte.gui.Controller> {
            return this.controllers;
        }
    }
    Stage["__class"] = "ktbyte.gui.Stage";

}
namespace ktbyte.gui {
    /**
     * 
     * 
     * @class
     */
    export class StageManager {
        static __static_initialized : boolean = false;
        static __static_initialize() { if(!StageManager.__static_initialized) { StageManager.__static_initialized = true; StageManager.__static_initializer_0(); } }

        public static stages : Array<ktbyte.gui.Stage>; public static stages_$LI$() : Array<ktbyte.gui.Stage> { StageManager.__static_initialize(); return StageManager.stages; };

        static activeStage : ktbyte.gui.Stage; public static activeStage_$LI$() : ktbyte.gui.Stage { StageManager.__static_initialize(); return StageManager.activeStage; };

        static defaultStage : ktbyte.gui.Stage; public static defaultStage_$LI$() : ktbyte.gui.Stage { StageManager.__static_initialize(); return StageManager.defaultStage; };

        static instance : StageManager; public static instance_$LI$() : StageManager { StageManager.__static_initialize(); return StageManager.instance; };

        static __static_initializer_0() {
            StageManager.instance = new StageManager();
            StageManager.instance_$LI$().init();
        }

        public static getInstance() : StageManager {
            return StageManager.instance_$LI$();
        }

        /*private*/ init() {
            StageManager.stages = <any>([]);
            StageManager.defaultStage = this.createStage("Default");
            StageManager.activeStage = StageManager.defaultStage;
        }

        public createStage(name : string) : ktbyte.gui.Stage {
            let stage : ktbyte.gui.Stage = new ktbyte.gui.Stage(name);
            StageManager.activeStage = stage;
            return stage;
        }

        public getDefaultStage() : ktbyte.gui.Stage {
            return StageManager.defaultStage_$LI$();
        }

        public getActiveStage() : ktbyte.gui.Stage {
            return StageManager.activeStage_$LI$();
        }

        public goToStage$ktbyte_gui_Stage(stage : ktbyte.gui.Stage) {
            if(stage !== StageManager.defaultStage_$LI$()) {
                StageManager.activeStage = stage;
            }
        }

        public goToStage(stage? : any) : any {
            if(((stage != null && stage instanceof <any>ktbyte.gui.Stage) || stage === null)) {
                return <any>this.goToStage$ktbyte_gui_Stage(stage);
            } else if(((typeof stage === 'number') || stage === null)) {
                return <any>this.goToStage$int(stage);
            } else throw new Error('invalid overload');
        }

        public goToStage$int(numStage : number) {
            if(numStage > 0 && numStage < /* size */(<number>StageManager.stages_$LI$().length)) {
                StageManager.activeStage = /* get */StageManager.stages[numStage];
            }
        }

        public goToNextStage() {
            if(this.userStagesExist()) {
                let indexOfCurrentStage : number = StageManager.stages_$LI$().indexOf(StageManager.activeStage_$LI$());
                if(indexOfCurrentStage > 0 && indexOfCurrentStage < /* size */(<number>StageManager.stages_$LI$().length) - 1) {
                    StageManager.activeStage = /* get */StageManager.stages[indexOfCurrentStage + 1];
                } else {
                    StageManager.activeStage = /* get */StageManager.stages[1];
                }
            }
        }

        public unregisterControllerFromAllStages(controller : ktbyte.gui.Controller) {
            ktbyte.gui.KTGUI.debug("Unregistering [" + controller.title + "] from all stages ...");
            for(let index188=0; index188 < StageManager.stages_$LI$().length; index188++) {
                let stage = StageManager.stages_$LI$()[index188];
                {
                    ktbyte.gui.KTGUI.debug("\tStage {" + stage.getName() + "} contains:");
                    for(let index189=0; index189 < stage.controllers.length; index189++) {
                        let c = stage.controllers[index189];
                        {
                            ktbyte.gui.KTGUI.debug("\t\t[" + c.title + "] of type <" + /* getName */(c => c["__class"]?c["__class"]:c["name"])((<any>c.constructor)) + ">");
                        }
                    }
                    if(/* contains */(stage.controllers.indexOf(<any>(controller)) >= 0)) {
                        ktbyte.gui.KTGUI.debug("\t\t\t>>> Found [" + controller.title + "] of type <" + /* getName */(c => c["__class"]?c["__class"]:c["name"])((<any>controller.constructor)) + "> in stage {" + stage.getName() + "}, removing ...");
                        /* remove */stage.controllers.splice(stage.controllers.indexOf(controller), 1)[0];
                        ktbyte.gui.KTGUI.debug("\t\t\tNow, {" + stage.getName() + "}.controllers.contains(" + controller.title + ") = " + /* contains */(stage.controllers.indexOf(<any>(controller)) >= 0));
                    }
                }
            }
            controller.parentStage = null;
            ktbyte.gui.KTGUI.debug("Done.");
        }

        public userStagesExist() : boolean {
            return StageManager.getInstance().getDefaultStage() !== StageManager.getInstance().getActiveStage();
        }

        public getStages() : Array<ktbyte.gui.Stage> {
            return StageManager.stages_$LI$();
        }
    }
    StageManager["__class"] = "ktbyte.gui.StageManager";

}
namespace ktbyte.gui {
    /**
     * This class automatically receives events from PApplet when they happen.
     * Every KTGUI component (controller) should extend this class in order to be able to receive the mouse and keyboard
     * events.
     * One should override only the 'needed' event methods. This allows to save time and decrease the amount of code.
     * One should always overridde the 'draw' method.
     * @extends ktbyte.gui.EventProcessor
     * @class
     */
    export abstract class Controller extends ktbyte.gui.EventProcessor implements PConstants {
        public title : string;

        public posx : number;

        public posy : number;

        public w : number;

        public h : number;

        public r1 : number;

        public r2 : number;

        public r3 : number;

        public r4 : number;

        public controllers : Array<Controller> = <any>([]);

        public pa : any;

        public ktgui : ktbyte.gui.KTGUI;

        public parentController : Controller = null;

        public parentStage : ktbyte.gui.Stage = null;

        public static selectedController : Controller = null;

        public pg : PGraphics;

        public userpg : PGraphics;

        public fgHoveredColor : number = ktbyte.gui.KTGUI.COLOR_FG_HOVERED;

        public fgPressedColor : number = ktbyte.gui.KTGUI.COLOR_FG_PRESSED;

        public fgPassiveColor : number = ktbyte.gui.KTGUI.COLOR_FG_PASSIVE;

        public bgHoveredColor : number = ktbyte.gui.KTGUI.COLOR_BG_HOVERED;

        public bgPressedColor : number = ktbyte.gui.KTGUI.COLOR_BG_PRESSED;

        public bgPassiveColor : number = ktbyte.gui.KTGUI.COLOR_BG_PASSIVE;

        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super();
            if(this.title===undefined) this.title = null;
            if(this.posx===undefined) this.posx = 0;
            if(this.posy===undefined) this.posy = 0;
            if(this.w===undefined) this.w = 0;
            if(this.h===undefined) this.h = 0;
            if(this.r1===undefined) this.r1 = 0;
            if(this.r2===undefined) this.r2 = 0;
            if(this.r3===undefined) this.r3 = 0;
            if(this.r4===undefined) this.r4 = 0;
            if(this.pa===undefined) this.pa = null;
            if(this.ktgui===undefined) this.ktgui = null;
            if(this.pg===undefined) this.pg = null;
            if(this.userpg===undefined) this.userpg = null;
            ktbyte.gui.KTGUI.debug("Creation of [" + title + "] started.");
            if(w < (<any>Math).fround(ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH * 0.5) || h < (<any>Math).fround(ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH * 0.5)) {
                ktbyte.gui.KTGUI.debug("!!! ERRROR.");
                ktbyte.gui.KTGUI.debug("!!! w:" + w + ", h:" + h);
                ktbyte.gui.KTGUI.debug("!!! Width and height of the " + title + " controller must be greater than KTGUI.DEFAULT_COMPONENT_SIZE/2 a.u. Which is currently equal to " + (<any>Math).fround(ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH * 0.5) + " a.u.");
                ktbyte.gui.KTGUI.debug("!!! Creation of " + title + " interrupted (prevented).");
                ktbyte.gui.KTGUI.debug("!!! Exiting from " + title + "`s constructor without creating the actual object.\n");
                return;
            }
            this.ktgui = ktgui;
            this.pa = ktbyte.gui.KTGUI.getParentPApplet();
            this.title = title;
            this.posx = posx;
            this.posy = posy;
            this.w = w;
            this.h = h;
            this.pg = this.pa.createGraphics(w + 1, h + 1);
            this.userpg = this.pa.createGraphics(w + 1, h + 1);
            ktbyte.gui.StageManager.getInstance().getDefaultStage().registerController(this);
            ktbyte.gui.KTGUI.debug("Creation of [" + title + "] completed.\n");
        }

        public updateGraphics() {
            this.ktgui.addDrawCallStackDebugMessage(this.title + ".updateGraphics()");
        }

        public updateUserDefinedGraphics(userpg : PGraphics) {
            this.userpg = userpg;
        }

        public drawUserDefinedGraphics() {
            /* add */(this.ktgui.drawCallStack.push(this.title + ".drawUserDefinedGraphics()-\'")>0);
            this.pg.beginDraw();
            this.pg.image(this.userpg, 0, 0);
            this.pg.endDraw();
        }

        public drawControllers() {
            /* add */(this.ktgui.drawCallStack.push(this.title + ".drawControllers()-\'")>0);
            for(let index190=0; index190 < this.controllers.length; index190++) {
                let child = this.controllers[index190];
                {
                    child.updateGraphics();
                    child.draw();
                    this.pg.beginDraw();
                    /* add */(this.ktgui.drawCallStack.push("pg.image(" + child.title + ").getGraphics: " + child.posx + ", " + child.posy + "-\'  ")>0);
                    /* add */(this.ktgui.drawCallStack.push("(" + child.title + ").apos:" + child.getAbsolutePosX() + ", " + child.getAbsolutePosY() + "-\'    ")>0);
                    this.pg.image(child.getGraphics(), child.posx, child.posy);
                    this.pg.endDraw();
                }
            }
        }

        /*private*/ drawGraphics() {
            if(this.parentController == null) {
                /* add */(this.ktgui.drawCallStack.push(this.title + ".drawGraphics()-\'")>0);
                this.pa.image(this.pg, this.posx, this.posy);
            }
        }

        public draw() {
            if(this.isVisible) {
                /* add */(this.ktgui.drawCallStack.push(this.title + ".draw()|")>0);
                this.drawControllers();
                this.drawUserDefinedGraphics();
                this.drawGraphics();
            }
        }

        public setParentController(controller : Controller) {
            this.parentController = controller;
        }

        public setTitle(title : string) {
            this.title = title;
        }

        public getInfo() : string {
            let info : { str: string, toString: Function } = { str: "", toString: function() { return this.str; } };
            /* append */(sb => { sb.str = sb.str.concat(<any>"[" + ((this.title != null)?this.title:"null") + "]"); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", pStage:" + ((this.parentStage != null)?this.parentStage.getName():"null")); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", pCtrlr:" + ((this.parentController != null)?this.parentController.title:"null")); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", childs.sz():" + /* size */(<number>this.controllers.length)); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", isPrsd:" + this.isPressed); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", isHvrd:" + this.isHovered); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", isDrgd:" + this.isDragged); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", rpsx:" + this.posx); return sb; })(info);
            /* append */(sb => { sb.str = sb.str.concat(<any>", rpsy:" + this.posy); return sb; })(info);
            return /* toString */info.str;
        }

        public getFullInfoList(level : number) : Array<string> {
            let recursyLevel : number = level;
            let list : Array<string> = <any>([]);
            let prefix : { str: string, toString: Function } = { str: "", toString: function() { return this.str; } };
            if(recursyLevel > 0) {
                /* append */(sb => { sb.str = sb.str.concat(<any>"\'"); return sb; })(prefix);
                for(let i : number = 0; i < recursyLevel; i++) {{
                    /* append */(sb => { sb.str = sb.str.concat(<any>"-"); return sb; })(prefix);
                };}
            } else {
                /* append */(sb => { sb.str = sb.str.concat(<any>"+"); return sb; })(prefix);
            }
            /* add */(list.push(/* toString */prefix.str + this.getInfo())>0);
            if(/* size */(<number>this.controllers.length) > 0) {
                recursyLevel++;
                for(let index191=0; index191 < this.controllers.length; index191++) {
                    let child = this.controllers[index191];
                    {
                        /* addAll */((l1, l2) => l1.push.apply(l1, l2))(list, child.getFullInfoList(recursyLevel));
                    }
                }
            }
            return list;
        }

        public getWidth() : number {
            return this.w;
        }

        public setWidth(w : number) {
            this.w = w;
        }

        public getHeight() : number {
            return this.h;
        }

        public getAbsolutePosX() : number {
            let px : number = 0;
            if(this.parentController != null) {
                px += this.parentController.getAbsolutePosX();
            }
            px += this.posx;
            return px;
        }

        public getAbsolutePosY() : number {
            let py : number = 0;
            if(this.parentController != null) {
                py += this.parentController.getAbsolutePosY();
            }
            py += this.posy;
            return py;
        }

        public setHeight(h : number) {
            this.h = h;
        }

        public setHoveredColor(c : number) {
            this.fgHoveredColor = c;
        }

        public setPressedColor(c : number) {
            this.fgPressedColor = c;
        }

        public setPassiveColor(c : number) {
            this.fgPassiveColor = c;
        }

        public setBorderRoundings(r1 : number, r2 : number, r3 : number, r4 : number) {
            this.r1 = r1;
            this.r2 = r2;
            this.r3 = r3;
            this.r4 = r4;
        }

        public setHandleFocus(val : boolean) {
            this.handleFocus = val;
        }

        public getGraphics() : PGraphics {
            return this.pg;
        }

        public addController$ktbyte_gui_Controller$int$int(child : Controller, hAlign : number, vAlign : number) {
            if(this.isActive) {
                child.alignAbout$ktbyte_gui_Controller$int$int(this, hAlign, vAlign);
                this.attachController(child);
            }
        }

        public addController$ktbyte_gui_Controller$int$int$int(child : Controller, hAlign : number, vAlign : number, gap : number) {
            if(this.isActive) {
                child.alignAbout$ktbyte_gui_Controller$int$int$int(this, hAlign, vAlign, gap);
                this.attachController(child);
            }
        }

        public addController(child? : any, hAlign? : any, vAlign? : any, gap? : any) : any {
            if(((child != null && child instanceof <any>ktbyte.gui.Controller) || child === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && ((typeof gap === 'number') || gap === null)) {
                return <any>this.addController$ktbyte_gui_Controller$int$int$int(child, hAlign, vAlign, gap);
            } else if(((child != null && child instanceof <any>ktbyte.gui.Controller) || child === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && gap === undefined) {
                return <any>this.addController$ktbyte_gui_Controller$int$int(child, hAlign, vAlign);
            } else throw new Error('invalid overload');
        }

        public positionAboutOtherController(controller : Controller, relativePosx : number, relativePosy : number) {
            this.posx = controller.posx + relativePosx;
            this.posy = controller.posy + relativePosy;
        }

        public attachController(controller : Controller) {
            if(this.isActive) {
                ktbyte.gui.KTGUI.debug("Attaching of [" + controller.title + "] of type <" + /* getName */(c => c["__class"]?c["__class"]:c["name"])((<any>controller.constructor)) + "> to [" + this.title + "] of type <" + /* getName */(c => c["__class"]?c["__class"]:c["name"])((<any>this.constructor)) + "> started.");
                if(controller.parentController != null) {
                    let pc : Controller = controller.parentController;
                    pc.detachController(controller);
                }
                if(!/* contains */(this.controllers.indexOf(<any>(controller)) >= 0)) {
                    ktbyte.gui.KTGUI.debug("\t[" + this.title + "].controllers.contains(" + controller.title + ") = " + /* contains */(this.controllers.indexOf(<any>(controller)) >= 0));
                    /* add */(this.controllers.push(controller)>0);
                }
                ktbyte.gui.KTGUI.debug("\tSetting parent controller...");
                controller.setParentController(this);
                ktbyte.gui.KTGUI.debug("\t[" + controller.title + "].parentController is [" + controller.parentController.title + "]");
                ktbyte.gui.StageManager.getInstance().unregisterControllerFromAllStages(controller);
                ktbyte.gui.KTGUI.debug("Attaching of [" + controller.title + "] to [" + this.title + "] completed.\n");
            }
        }

        public detachController(controller : Controller) {
            controller.parentController = null;
            /* remove */(a => { let index = a.indexOf(controller); if(index>=0) { a.splice(index, 1); return true; } else { return false; }})(this.controllers);
        }

        public detachAllControllers() {
            for(let index192=0; index192 < this.controllers.length; index192++) {
                let controller = this.controllers[index192];
                {
                    this.detachController(controller);
                }
            }
        }

        public closeParent() {
            if(this.parentController != null) {
                this.parentController.close();
            }
            this.closeAllChildsRecursively();
        }

        public closeAllChildsRecursively() {
            for(let index193=0; index193 < this.controllers.length; index193++) {
                let childController = this.controllers[index193];
                {
                    childController.closeAllChildsRecursively();
                    childController.close();
                }
            }
        }

        public close() {
            PApplet.println("Closing \'" + this.title + "\' controller.");
            this.isActive = false;
            this.ktgui.addToGarbage(this, this.pa.millis());
        }

        public getPosx() : number {
            return this.posx;
        }

        public setPosx(posx : number) {
            this.posx = posx;
        }

        public getPosy() : number {
            return this.posy;
        }

        public setPosy(posy : number) {
            this.posy = posy;
        }

        public alignAboutCanvas$int$int(hAlign : number, vAlign : number) {
            this.alignAboutCanvas$int$int$int(hAlign, vAlign, ktbyte.gui.KTGUI.DEFAULT_ALIGN_GAP);
        }

        public alignAboutCanvas$int$int$int(hAlign : number, vAlign : number, gap : number) {
            switch((hAlign)) {
            case PConstants.LEFT:
                this.posx = gap;
                break;
            case PConstants.RIGHT:
                this.posx = this.pa.width - this.w - gap;
                break;
            case PConstants.CENTER:
                this.posx = (<number>(this.pa.width * 0.5 - this.w * 0.5)|0);
                break;
            default:
                break;
            }
            switch((vAlign)) {
            case PConstants.TOP:
                this.posy = gap;
                break;
            case PConstants.BOTTOM:
                this.posy = this.pa.height - this.h - gap;
                break;
            case PConstants.CENTER:
                this.posy = (<number>(this.pa.height * 0.5 - this.h * 0.5)|0);
                break;
            default:
                break;
            }
        }

        /**
         * @param {number} hAlign
         * the horizontal alignment position
         * @param {number} vAlign
         * the vertical alignment position
         * @param {number} gap
         * the gap between the outer boundary of the PApplet canvas and
         * the side of the controller to be aligned.
         */
        public alignAboutCanvas(hAlign? : any, vAlign? : any, gap? : any) : any {
            if(((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && ((typeof gap === 'number') || gap === null)) {
                return <any>this.alignAboutCanvas$int$int$int(hAlign, vAlign, gap);
            } else if(((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && gap === undefined) {
                return <any>this.alignAboutCanvas$int$int(hAlign, vAlign);
            } else throw new Error('invalid overload');
        }

        public alignAbout$ktbyte_gui_Controller$int$int(controller : Controller, hAlign : number, vAlign : number) {
            this.alignAbout$ktbyte_gui_Controller$int$int$int(controller, hAlign, vAlign, ktbyte.gui.KTGUI.DEFAULT_ALIGN_GAP);
        }

        public alignAbout$ktbyte_gui_Controller$int$int$int(controller : Controller, hAlign : number, vAlign : number, gap : number) {
            switch((hAlign)) {
            case PConstants.LEFT:
                this.posx = gap;
                break;
            case PConstants.RIGHT:
                this.posx = controller.w - this.w - gap;
                break;
            case PConstants.CENTER:
                this.posx = (<number>(controller.w * 0.5 - this.w * 0.5)|0);
                break;
            default:
                break;
            }
            switch((vAlign)) {
            case PConstants.TOP:
                this.posy = gap;
                break;
            case PConstants.BOTTOM:
                this.posy = controller.h - this.h - gap;
                break;
            case PConstants.CENTER:
                this.posy = (<number>(controller.h * 0.5 - this.h * 0.5)|0);
                break;
            default:
                break;
            }
        }

        /**
         * This method is used to place one controller <b>inside</b> the other (reference)
         * controller.
         * By 'aligning' we understand the process of changing the X and Y coordinates
         * so that the controller is placed inside and near one of the walls of the
         * reference controller.
         * The X and Y position, and width and height of the controller being used as
         * a reference are used to calculate the new position of the controller that is to
         * be aligned. The said values identify the 'boundary rectangle' of the reference
         * controller. The named constants LEFT, RIGHT, BOTTOM, TOP and CENTER are used to
         * identify the sides and the center of the bounding rectangle. The sides and center
         * of the reference rectangle are used for calculation of the relative
         * distances that are used to 'shift' the position of the controller to be
         * aligned. The direction of shifting is <b>inward</b> - i.e. the changing of relative
         * position is made <i>from the sides</i> of the bounding rectangle <i>to the
         * center</i> of the bounding rectangle.
         * 
         * @param {ktbyte.gui.Controller} controller
         * the 'reference' controller.
         * @param {number} hAlign
         * the horizontal alignment direction. The following named constants can be used:</br>
         * <ul>
         * <li>
         * LEFT - the controller will be placed so that its <i>left</i> side will
         * 'stick' to the <i>left</i> side of the reference controller.</br>
         * </li>
         * <li>
         * RIGHT - the controller will be placed so that its <i>right</i> side will
         * 'stick' to the <i>right</i> side of the reference controller.</br>
         * </li>
         * <li>
         * CENTER - the controller will be placed so that its <i>center</i> will
         * 'stick' to the <i>center</i> of the reference controller.</br>
         * </li>
         * </ul>
         * @param {number} vAlign
         * the vertical alignment direction. The following named constants can be used:</br>
         * <ul>
         * <li>
         * TOP - the controller will be placed so that its <i>top</i> side will
         * 'stick' to the <i>top</i> side of the reference controller.</br>
         * </li>
         * <li>
         * BOTTOM - the controller will be placed so that its <i>bottom</i> side will
         * 'stick' to the <i>bottom</i> side of the reference controller.</br>
         * </li>
         * <li>
         * CENTER - the controller will be placed so that its <i>center</i> will
         * 'stick' to the <i>center</i> of the reference controller. </br>
         * </li>
         * </ul>
         * @param {number} gap
         * the gap between aligned sides. If the CENTER constant is used as hAlign
         * or vAlign argument then the gap will <b>not</b> be added to that direction.
         */
        public alignAbout(controller? : any, hAlign? : any, vAlign? : any, gap? : any) : any {
            if(((controller != null && controller instanceof <any>ktbyte.gui.Controller) || controller === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && ((typeof gap === 'number') || gap === null)) {
                return <any>this.alignAbout$ktbyte_gui_Controller$int$int$int(controller, hAlign, vAlign, gap);
            } else if(((controller != null && controller instanceof <any>ktbyte.gui.Controller) || controller === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && gap === undefined) {
                return <any>this.alignAbout$ktbyte_gui_Controller$int$int(controller, hAlign, vAlign);
            } else throw new Error('invalid overload');
        }

        public stackAbout$ktbyte_gui_Controller$int$int(controller : Controller, direction : number, align : number) {
            this.stackAbout$ktbyte_gui_Controller$int$int$int(controller, direction, align, ktbyte.gui.KTGUI.DEFAULT_ALIGN_GAP);
        }

        public stackAbout$ktbyte_gui_Controller$int$int$int(controller : Controller, direction : number, align : number, gap : number) {
            switch((direction)) {
            case PConstants.TOP:
                this.posy = controller.posy - this.h - gap;
                switch((align)) {
                case PConstants.LEFT:
                    this.posx = controller.posx + gap;
                    break;
                case PConstants.RIGHT:
                    this.posx = controller.posx + controller.w - this.w - gap;
                    break;
                case PConstants.CENTER:
                    this.posx = (<number>(controller.posx + controller.w * 0.5)|0) - (<number>(this.w * 0.5)|0);
                    break;
                default:
                    break;
                }
                break;
            case PConstants.BOTTOM:
                this.posy = controller.posy + controller.h + gap;
                switch((align)) {
                case PConstants.LEFT:
                    this.posx = controller.posx + gap;
                    break;
                case PConstants.RIGHT:
                    this.posx = controller.posx + controller.w - this.w - gap;
                    break;
                case PConstants.CENTER:
                    this.posx = (<number>(controller.posx + controller.w * 0.5)|0) - (<number>(this.w * 0.5)|0);
                    break;
                default:
                    break;
                }
                break;
            case PConstants.LEFT:
                this.posx = controller.posx - this.w - gap;
                switch((align)) {
                case PConstants.TOP:
                    this.posy = controller.posy + gap;
                    break;
                case PConstants.BOTTOM:
                    this.posy = controller.posy + controller.h - this.h - gap;
                    break;
                case PConstants.CENTER:
                    this.posy = (<number>(controller.posy + controller.h * 0.5)|0) - (<number>(this.h * 0.5)|0);
                    break;
                default:
                    break;
                }
                break;
            case PConstants.RIGHT:
                this.posx = controller.posx + controller.w + gap;
                switch((align)) {
                case PConstants.TOP:
                    this.posy = controller.posy + gap;
                    break;
                case PConstants.BOTTOM:
                    this.posy = controller.posy + controller.h - this.h - gap;
                    break;
                case PConstants.CENTER:
                    this.posy = (<number>(controller.posy + controller.h * 0.5)|0) - (<number>(this.h * 0.5)|0);
                    break;
                default:
                    break;
                }
                break;
            default:
                break;
            }
        }

        /**
         * This method is used to position one controller <b>outside</b> the other
         * (reference) controller.
         * By 'stacking' we understand the process of changing the X and Y coordinates
         * so that the controller is placed outside and near one of the walls of the
         * reference controller.
         * The X and Y position, and width and height of the controller being used as
         * a reference are used to calculate the new position of the controller to
         * be aligned. The said values identify the 'boundary rectangle' of the reference
         * controller.
         * The named constants LEFT, RIGHT, BOTTOM and TOP are used to identify
         * the sides of the bounding rectangle. They are used for calculation of the
         * relative distances that are used to 'shift' the position of the controller to be
         * aligned. The direction of shifting is <b>outward</b> - i.e. the changing of
         * relative position is made from the sides of the bounding rectangle <i>to the
         * outward direction about</i> the bounding rectangle.
         * 
         * @param <b>controller</b>
         * the 'reference' controller.
         * @param <b>direction</b>
         * the 'reference' alignment direction. The following named constants can be used:</br>
         * <ul>
         * <li>
         * LEFT - the controller will be placed so that its <i>rigth</i> side will
         * 'stick' to the <i>left</i> side of the reference controller.</br>
         * </li>
         * <li>
         * RIGHT - the controller will be placed so that its <i>left</i> side will
         * 'stick' to the <i>right</i> side of the reference controller.</br>
         * </li>
         * <li>
         * TOP - the controller will be placed so that its <i>bottom</i> side will
         * 'stick' to the <i>top</i> side of the reference controller.</br>
         * </li>
         * <li>
         * BOTTOM - the controller will be placed so that its <i>top</i> side will
         * 'stick' to the <i>bottom</i> side of the reference controller.</br>
         * </li>
         * </ul>
         * @param <b>align</b>
         * the 'orthogonal' alignment direction. </br>
         * The following named constants can be used:</br>
         * If the 'reference' alignment direction was chosen as LEFT or RIGTH, then the
         * 'orthogonal' direction can be set only fron one of the following constants:
         * <ul>
         * <li>
         * TOP - the controller will be placed so that its <i>top</i> side will be
         * aligned to the <i>top</i> side of the reference controller.</br>
         * </li>
         * <li>
         * BOTTOM - the controller will be placed so that its <i>bottom</i> side will be
         * aligned to the <i>bottom</i> side of the reference controller.</br>
         * </li>
         * <li>
         * CENTER - the controller will be placed so that its <i>center</i> will be
         * aligned to the <i>center</i> of the reference controller. </br>
         * </li>
         * </ul>
         * 
         * If the 'reference' alignment direction was chosen as BOTTOM or TOP, then the
         * 'orthogonal' direction can be set only from one of the following constants:
         * <ul>
         * <li>
         * LEFT - the controller will be placed so that its <i>left</i> side will be
         * aligned to the <i>left</i> side of the reference controller.</br>
         * </li>
         * <li>
         * RIGHT - the controller will be placed so that its <i>right</i> side will be
         * aligned to the <i>right</i> side of the reference controller.</br>
         * </li>
         * <li>
         * CENTER - the controller will be placed so that its <i>center</i> will be
         * aligned to the <i>center</i> of the reference controller. </br>
         * </li>
         * </ul>
         * 
         * @param <b>gap</b>
         * the gap of some length between the sides to be aligned. If the CENTER constant
         * is used as 'direction' or 'align' argument then the gap is <b>not</b> added
         * in that direction.
         * @param {ktbyte.gui.Controller} controller
         * @param {number} direction
         * @param {number} align
         * @param {number} gap
         */
        public stackAbout(controller? : any, direction? : any, align? : any, gap? : any) : any {
            if(((controller != null && controller instanceof <any>ktbyte.gui.Controller) || controller === null) && ((typeof direction === 'number') || direction === null) && ((typeof align === 'number') || align === null) && ((typeof gap === 'number') || gap === null)) {
                return <any>this.stackAbout$ktbyte_gui_Controller$int$int$int(controller, direction, align, gap);
            } else if(((controller != null && controller instanceof <any>ktbyte.gui.Controller) || controller === null) && ((typeof direction === 'number') || direction === null) && ((typeof align === 'number') || align === null) && gap === undefined) {
                return <any>this.stackAbout$ktbyte_gui_Controller$int$int(controller, direction, align);
            } else throw new Error('invalid overload');
        }

        public isAnyChildPressed() : boolean {
            for(let index194=0; index194 < this.controllers.length; index194++) {
                let child = this.controllers[index194];
                {
                    if(child.isPressed) {
                        return true;
                    }
                    if(child.isAnyChildPressed()) {
                        return true;
                    }
                }
            }
            return false;
        }

        /**
         * 
         */
        public processMouseMoved() {
            if(this.isActive) {
                for(let index195=0; index195 < this.controllers.length; index195++) {
                    let child = this.controllers[index195];
                    {
                        child.processMouseMoved();
                    }
                }
                this.isHovered = this.isPointInside(this.pa.mouseX, this.pa.mouseY)?true:false;
                for(let index196=0; index196 < this.adapters.length; index196++) {
                    let adapter = this.adapters[index196];
                    {
                        adapter.onMouseMoved();
                    }
                }
            }
        }

        /**
         * 
         */
        public processMousePressed() {
            if(this.isActive) {
                if(this.isHovered) {
                    for(let index197=0; index197 < this.controllers.length; index197++) {
                        let child = this.controllers[index197];
                        {
                            child.processMousePressed();
                        }
                    }
                    if(this.isAnyChildPressed()) {
                        this.isPressed = this.isHovered = false;
                        return;
                    } else {
                        this.isPressed = true;
                        Controller.selectedController = this;
                    }
                    for(let index198=0; index198 < this.adapters.length; index198++) {
                        let adapter = this.adapters[index198];
                        {
                            adapter.onMousePressed();
                        }
                    }
                }
            }
        }

        /**
         * 
         */
        public processMouseReleased() {
            if(this.isActive) {
                this.isPressed = false;
                for(let index199=0; index199 < this.controllers.length; index199++) {
                    let child = this.controllers[index199];
                    {
                        child.processMouseReleased();
                    }
                }
                if(this.isHovered) {
                    for(let index200=0; index200 < this.adapters.length; index200++) {
                        let adapter = this.adapters[index200];
                        {
                            adapter.onMouseReleased();
                        }
                    }
                }
            }
        }

        /**
         * 
         */
        public processMouseDragged() {
            if(this.isActive) {
                for(let index201=0; index201 < this.controllers.length; index201++) {
                    let child = this.controllers[index201];
                    {
                        child.processMouseDragged();
                    }
                }
                if(this.isDragable) {
                    if(this.isPressed) {
                        this.posx += this.pa.mouseX - this.pa.pmouseX;
                        this.posy += this.pa.mouseY - this.pa.pmouseY;
                        for(let index202=0; index202 < this.adapters.length; index202++) {
                            let adapter = this.adapters[index202];
                            {
                                adapter.onMouseDragged();
                            }
                        }
                    }
                }
            }
        }

        /**
         * 
         * @param {ProcessingMouseEvent} me
         */
        public processMouseWheel(me : ProcessingMouseEvent) {
            if(this.isActive) {
                for(let index203=0; index203 < this.controllers.length; index203++) {
                    let child = this.controllers[index203];
                    {
                        child.processMouseWheel(me);
                    }
                }
            }
        }

        /**
         * 
         */
        public processKeyPressed() {
            if(this.isActive) {
                for(let index204=0; index204 < this.controllers.length; index204++) {
                    let child = this.controllers[index204];
                    {
                        child.processKeyPressed();
                    }
                }
            }
        }

        /**
         * 
         */
        public processKeyReleased() {
            if(this.isActive) {
                for(let index205=0; index205 < this.controllers.length; index205++) {
                    let child = this.controllers[index205];
                    {
                        child.processKeyReleased();
                    }
                }
            }
        }

        public isSelected(controller : Controller) : boolean {
            return Controller.selectedController === <Controller>controller;
        }

        /**
         * 
         * @param {number} x
         * @param {number} y
         * @return {boolean}
         */
        public isPointInside(x : number, y : number) : boolean {
            let isInside : boolean = false;
            if(this.isActive) {
                if(x > this.getAbsolutePosX() && x < this.getAbsolutePosX() + this.w) {
                    if(y > this.getAbsolutePosY() && y < this.getAbsolutePosY() + this.h) {
                        isInside = true;
                    }
                }
            }
            return isInside;
        }
    }
    Controller["__class"] = "ktbyte.gui.Controller";
    Controller["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class ArrowButton extends ktbyte.gui.Controller {
        /*private*/ direction : number;

        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number, dir : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.direction===undefined) this.direction = 0;
            this.direction = dir;
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.pg.beginDraw();
            this.pg.pushStyle();
            this.pg.stroke(0);
            if(this.isHovered && !this.isPressed) {
                this.pg.fill(this.fgHoveredColor);
            } else if(this.isHovered && this.isPressed) {
                this.pg.fill(this.fgPressedColor);
            } else {
                this.pg.fill(this.fgPassiveColor);
            }
            if(this.isSelected(this)) {
                this.pg.strokeWeight(2.0);
            } else {
                this.pg.strokeWeight(1.0);
            }
            this.pg.rectMode(PConstants.CORNER);
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            this.pg.pushMatrix();
            this.pg.translate((<any>Math).fround(this.w * 0.5), (<any>Math).fround(this.h * 0.5));
            if(this.direction === PConstants.UP) {
                this.pg.rotate(PConstants.PI);
            } else if(this.direction === PConstants.DOWN) {
                this.pg.rotate(0);
            } else if(this.direction === PConstants.LEFT) {
                this.pg.rotate(PConstants.HALF_PI);
            } else if(this.direction === PConstants.RIGHT) {
                this.pg.rotate((<any>Math).fround(PConstants.HALF_PI + PConstants.PI));
            }
            this.pg.strokeWeight(1.0);
            this.pg.line((<any>Math).fround(-this.w * 0.4), (<any>Math).fround(-this.h * 0.4), 0, (<any>Math).fround(this.h * 0.4));
            this.pg.line(0, (<any>Math).fround(this.h * 0.4), (<any>Math).fround(this.w * 0.4), (<any>Math).fround(-this.h * 0.4));
            this.pg.popMatrix();
            this.pg.popStyle();
            this.pg.endDraw();
        }

        public setDirection(dir : number) {
            this.direction = dir;
        }
    }
    ArrowButton["__class"] = "ktbyte.gui.ArrowButton";
    ArrowButton["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class Bar extends ktbyte.gui.Controller {
        public constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.pg.beginDraw();
            this.pg.background(200, 200);
            this.pg.rectMode(PConstants.CORNER);
            this.pg.fill(this.bgPassiveColor);
            this.pg.stroke(0);
            this.pg.rectMode(PConstants.CORNER);
            if(this.isSelected(this)) {
                this.pg.strokeWeight(3.0);
            } else {
                this.pg.strokeWeight(1.0);
            }
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            this.pg.fill(25);
            this.pg.textAlign(PConstants.LEFT, PConstants.CENTER);
            this.pg.textSize((<any>Math).fround(this.h * 0.65));
            this.pg.text(this.title, 10, (<any>Math).fround(this.h * 0.5));
            this.pg.endDraw();
        }
    }
    Bar["__class"] = "ktbyte.gui.Bar";
    Bar["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    /**
     * This is a KTGUI component (controller).
     * This class extends the 'Controller' class.
     * The object of this class can be 'Pressed', 'Hovered', 'Released' and 'Dragged'.
     * @param {ktbyte.gui.KTGUI} ktgui
     * @param {string} title
     * @param {number} posx
     * @param {number} posy
     * @param {number} w
     * @param {number} h
     * @class
     * @extends ktbyte.gui.Controller
     */
    export class Button extends ktbyte.gui.Controller {
        public constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.pg.beginDraw();
            this.pg.rectMode(PConstants.CORNER);
            if(this.isHovered && !this.isPressed) {
                this.pg.fill(this.fgHoveredColor);
            } else if(this.isHovered && this.isPressed) {
                this.pg.fill(this.fgPressedColor);
            } else {
                this.pg.fill(this.fgPassiveColor);
            }
            if(this.isSelected(this)) {
                this.pg.strokeWeight(2.0);
            } else {
                this.pg.strokeWeight(1.0);
            }
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            this.pg.fill(255);
            this.pg.textAlign(PConstants.CENTER, PConstants.CENTER);
            this.pg.textSize(14);
            this.pg.text(this.title, (<number>(this.w * 0.5)|0), (<number>(this.h * 0.5)|0));
            this.pg.endDraw();
        }
    }
    Button["__class"] = "ktbyte.gui.Button";
    Button["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class Console extends ktbyte.gui.Controller {
        static BOX_ROUNDING : number = 7;

        static INPUT_BOX_HEIGHT_PERCENTAGE : number = 0.1;

        /*private*/ inputBox : ktbyte.gui.InputTextBox;

        /*private*/ textArea : ktbyte.gui.ScrollableTextArea;

        /*private*/ scrollBar : ktbyte.gui.ScrollBar;

        /*private*/ inputTextColor : number = 16777215;

        /*private*/ outputTextColor : number = 0;

        /*private*/ dict : any;

        /*private*/ lastVariableName : string;

        inputBoxWidth : number = (<number>((<any>Math).fround(Console.INPUT_BOX_HEIGHT_PERCENTAGE * this.h))|0);

        public constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.inputBox===undefined) this.inputBox = null;
            if(this.textArea===undefined) this.textArea = null;
            if(this.scrollBar===undefined) this.scrollBar = null;
            if(this.dict===undefined) this.dict = null;
            if(this.lastVariableName===undefined) this.lastVariableName = null;
            this.dict = <any>({});
            this.createScrollableTextArea();
            this.createInputBox();
            this.createScrollBar();
        }

        /*private*/ createScrollableTextArea() {
            this.textArea = new ktbyte.gui.ScrollableTextArea(this.ktgui, "sta:" + this.title, 0, 0, this.w - this.inputBoxWidth, this.h - this.inputBoxWidth);
            this.textArea.setBorderRoundings(Console.BOX_ROUNDING, 0, 0, 0);
            this.textArea.addEventAdapter(new Console.Console$0(this));
            this.attachController(this.textArea);
        }

        /*private*/ createScrollBar() {
            this.scrollBar = new ktbyte.gui.ScrollBar(this.ktgui, "sb:" + this.title, this.w - this.inputBoxWidth, 0, this.inputBoxWidth, this.h - this.inputBoxWidth, 0, 100);
            this.scrollBar.addEventAdapter(new Console.Console$1(this));
            this.attachController(this.scrollBar);
        }

        /*private*/ createInputBox() {
            this.inputBox = new ktbyte.gui.InputTextBox(this.ktgui, "ib:" + this.title, 0, this.h - this.inputBoxWidth, this.w, this.inputBoxWidth);
            this.inputBox.setHandleFocus(true);
            this.inputBox.setTextSize(16);
            this.inputBox.setBorderRoundings(0, 0, Console.BOX_ROUNDING, Console.BOX_ROUNDING);
            this.inputBox.addEventAdapter(new Console.Console$2(this));
            this.attachController(this.inputBox);
        }

        /**
         * Returns a stored value from the console's memory
         * 
         * @param {string} name
         * the key of the stored entry
         * 
         * @return {string} a stored value from the console's memory
         */
        public getValue(name : string) : string {
            return /* get */((m,k) => m[k]===undefined?null:m[k])(this.dict, name);
        }

        /**
         * Sets the name of the next console's entry
         * 
         * @param {string} name
         * the key of the next stored entry
         */
        public readInput(name : string) {
            this.lastVariableName = name;
        }

        public setBorderRoundings(r1 : number, r2 : number, r3 : number, r4 : number) {
            this.textArea.setBorderRoundings(r1, 0, 0, 0);
            this.inputBox.setBorderRoundings(0, 0, r3, r4);
            this.scrollBar.setBorderRoundings(0, r2, 0, 0);
        }

        public enableLineStartMarks(val : boolean) {
            this.textArea.enableTextBlockStartMarks(val);
        }

        /*private*/ handleConsoleInput() {
            let textInput : string = this.inputBox.getText();
            this.textArea.appendTextBlock$java_lang_String$int(textInput, this.inputTextColor);
            this.textArea.scrollToBottom();
            this.inputBox.setText("");
            /* put */(this.dict[this.lastVariableName] = textInput);
            for(let index206=0; index206 < this.adapters.length; index206++) {
                let adapter = this.adapters[index206];
                {
                    adapter.onConsoleInput(textInput, this.lastVariableName);
                }
            }
        }

        /*private*/ updateScrollBar() {
            this.scrollBar.setRangeEnd(this.textArea.getMaximumAllowedPositionOfStartLine());
            this.scrollBar.setValue((<number>((<any>Math).fround(this.scrollBar.getRangeEnd() - this.getStartLinePosition()))|0));
        }

        public setInputTextSize(size : number) {
            this.inputBox.setTextSize(size);
        }

        public setOutputTextSize(size : number) {
            this.textArea.setTextSize(size);
        }

        public writeOutput(textBlock : string) {
            this.textArea.appendTextBlock$java_lang_String$int(textBlock, this.outputTextColor);
            this.textArea.scrollToBottom();
        }

        public setInputFocused(value : boolean) {
            this.inputBox.setFocused(value);
        }

        public getStartLinePosition() : number {
            return this.textArea.getStartLinePosition();
        }

        public setInputTextColor(c : number) {
            this.inputTextColor = c;
        }

        public setOutputTextColor(c : number) {
            this.outputTextColor = c;
        }

        public getLine(index : number) : string {
            return this.textArea.getTextLine(index);
        }

        public getBlock(index : number) : string {
            return this.textArea.getTextBlock(index);
        }

        public getLineCount() : number {
            return this.textArea.getLineCount();
        }

        public getBlockCount() : number {
            return this.textArea.getBlockCount();
        }

        public getLastLine() : string {
            let textLine : string = "_NO_LINES_EXIST_YET_";
            if(this.getLineCount() > 0) textLine = this.getLine(this.getLineCount() - 1);
            return textLine;
        }

        public getLastBlock() : string {
            let textBlock : string = "_NO_BLOCKS_EXIST_YET_";
            if(this.getBlockCount() > 0) textBlock = this.getBlock(this.getBlockCount() - 1);
            return textBlock;
        }
    }
    Console["__class"] = "ktbyte.gui.Console";
    Console["__interfaces"] = ["def.processing.core.PConstants"];



    export namespace Console {

        export class Console$0 extends ktbyte.gui.EventAdapter {
            public __parent: any;
            public onMouseWheel(count : number) {
            }

            constructor(__parent: any) {
                super();
                this.__parent = __parent;
            }
        }


        export class Console$1 extends ktbyte.gui.EventAdapter {
            public __parent: any;
            public onMouseDragged() {
            }

            public onMousePressed() {
            }

            constructor(__parent: any) {
                super();
                this.__parent = __parent;
            }
        }


        export class Console$2 extends ktbyte.gui.EventAdapter {
            public __parent: any;
            public onEnterKeyPressed() {
                ktbyte.gui.KTGUI.debug("Processing input...");
                this.__parent.handleConsoleInput();
            }

            constructor(__parent: any) {
                super();
                this.__parent = __parent;
            }
        }

    }

}
namespace ktbyte.gui {
    export class InputTextBox extends ktbyte.gui.Controller {
        static BACKSPACE_ASCII_CODE : number = 8;

        static ENTER_ASCII_CODE : number = 10;

        static BASIC_ASCII_LOWER_LIMIT : number = 32;

        static BASIC_ASCII_UPPER_LIMIT : number = 126;

        /*private*/ textInput : string;

        /*private*/ textSize : number;

        /*private*/ textHeight : number;

        /*private*/ padding : number;

        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.textInput===undefined) this.textInput = null;
            if(this.textSize===undefined) this.textSize = 0;
            if(this.textHeight===undefined) this.textHeight = 0;
            if(this.padding===undefined) this.padding = 0;
            this.textInput = "";
            this.textSize = 18;
            this.updateTextAttributes();
        }

        public updateGraphics() {
            super.updateGraphics();
            this.updateTextBox();
            this.updateBlinkingCursorGraphics();
        }

        /*private*/ updateTextBox() {
            this.pg.beginDraw();
            this.pg.pushStyle();
            if(this.isSelected(this)) {
                this.pg.fill(this.bgPressedColor);
                this.pg.stroke(50);
                this.pg.strokeWeight(3.0);
            } else {
                this.pg.fill(this.bgPassiveColor);
                this.pg.stroke(0, 50, 0);
                this.pg.strokeWeight(1.0);
            }
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            this.pg.fill(0);
            this.pg.textSize(this.textSize);
            this.pg.textAlign(PConstants.LEFT, PConstants.CENTER);
            this.pg.text(this.getTrimmedInputText(), this.padding, (<any>Math).fround(this.h * 0.5));
            this.pg.popStyle();
            this.pg.endDraw();
        }

        /*private*/ updateBlinkingCursorGraphics() {
            if(this.isSelected(this)) {
                if(this.pa.frameCount % 60 < 30) {
                    this.pa.textSize(this.textSize);
                    let cursorX : number = PApplet.min((<any>Math).fround(this.w - this.padding), (<any>Math).fround(this.padding + this.pa.textWidth(this.textInput)));
                    this.pg.beginDraw();
                    this.pg.stroke(0);
                    this.pg.strokeWeight(2);
                    this.pg.line(cursorX, (<any>Math).fround((<any>Math).fround(this.h * 0.5) - (<any>Math).fround(this.textHeight * 0.5)), cursorX, (<any>Math).fround((<any>Math).fround(this.h * 0.5) + (<any>Math).fround(this.textHeight * 0.5)));
                    this.pg.endDraw();
                }
            }
        }

        /**
         * 
         */
        public processMousePressed() {
            super.processMousePressed();
            if(this.isSelected(this)) {
                this.setText("");
            }
        }

        /**
         * 
         */
        public processKeyPressed() {
            if(!this.isSelected(this)) {
                return;
            }
            if(((String.fromCharCode(this.pa.key))).charCodeAt(0) === InputTextBox.BACKSPACE_ASCII_CODE && this.textInput.length > 0) {
                this.textInput = this.textInput.substring(0, this.textInput.length - 1);
            }
            if(((String.fromCharCode(this.pa.key))).charCodeAt(0) === InputTextBox.ENTER_ASCII_CODE) {
                for(let index207=0; index207 < this.adapters.length; index207++) {
                    let adapter = this.adapters[index207];
                    {
                        adapter.onEnterKeyPressed();
                    }
                }
            } else if(((String.fromCharCode(this.pa.key))).charCodeAt(0) >= InputTextBox.BASIC_ASCII_LOWER_LIMIT && ((String.fromCharCode(this.pa.key))).charCodeAt(0) <= InputTextBox.BASIC_ASCII_UPPER_LIMIT) {
                let b : number = ((String.fromCharCode(this.pa.key))).charCodeAt(0);
                let ch : string = String.fromCharCode(b);
                this.textInput += ch;
            }
        }

        public setFocused(value : boolean) {
        }

        /**
         * Sets the current text
         * 
         * @param {string} text
         * The text that should be displayed inside the box
         */
        public setText(text : string) {
            this.textInput = text;
        }

        public getText() : string {
            return this.textInput;
        }

        /**
         * Sets the text size
         * 
         * @param {number} textSize
         * The text size
         */
        public setTextSize(textSize : number) {
            this.pa.textSize(this.textSize);
            this.updateTextAttributes();
        }

        /*private*/ updateTextAttributes() {
            this.padding = (<any>Math).fround(0.08 * this.h);
            this.textHeight = (<any>Math).fround(this.pa.textAscent() + this.pa.textDescent());
            while((this.textHeight > (<any>Math).fround((<any>Math).fround(this.h - this.padding) - this.padding))) {{
                this.textSize--;
                this.textHeight = (<any>Math).fround(this.pa.textAscent() + this.pa.textDescent());
            }};
        }

        /*private*/ getTrimmedInputText() : string {
            let sb : { str: string, toString: Function } = { str: "", toString: function() { return this.str; } };
            let wrappedWidth : number = PApplet.floor((<any>Math).fround(this.w - this.padding));
            this.pa.textSize(this.textSize);
            for(let i : number = this.textInput.length - 1; i >= 0; i--) {{
                let chunkWidth : number = PApplet.ceil(this.pa.textWidth(/* toString */sb.str + ":"));
                if(chunkWidth >= wrappedWidth) {
                    break;
                }
                /* append */(sb => { sb.str = sb.str.concat(<any>this.textInput.charAt(i)); return sb; })(sb);
            };}
            return this.reverse(/* toString */sb.str);
        }

        /*private*/ reverse(input : string) : string {
            let inChars : string[] = (s => { let a=[]; while(s-->0) a.push(null); return a; })(input.length);
            /* getChars */((a, s, e, d, l) => { d.splice.apply(d, [l, e-s].concat(<any>a.substring(s, e).split(''))); })(input, 0, input.length, inChars, 0);
            let outChars : string[] = (s => { let a=[]; while(s-->0) a.push(null); return a; })(inChars.length);
            for(let i : number = inChars.length; i > 0; i--) {{
                outChars[i - 1] = inChars[inChars.length - i];
            };}
            return /* valueOf */new String(outChars).toString().toString();
        }
    }
    InputTextBox["__class"] = "ktbyte.gui.InputTextBox";
    InputTextBox["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    /**
     * @extends ktbyte.gui.Controller
     * @class
     */
    export class Pane extends ktbyte.gui.Controller {
        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.pg.beginDraw();
            this.pg.background(200, 100);
            if(this.isSelected(this)) {
                this.pg.strokeWeight(2.0);
            } else {
                this.pg.strokeWeight(1.0);
            }
            this.pg.rectMode(PConstants.CORNER);
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            this.pg.noFill();
            this.pg.endDraw();
        }
    }
    Pane["__class"] = "ktbyte.gui.Pane";
    Pane["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class Panel extends ktbyte.gui.Controller {
        /*private*/ titleBar : ktbyte.gui.TitleBar;

        /*private*/ pane : ktbyte.gui.Pane;

        public constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.titleBar===undefined) this.titleBar = null;
            if(this.pane===undefined) this.pane = null;
            this.isDragable = true;
            this.createTitleBar();
            this.createPane();
            this.setTitle(title);
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.pg.beginDraw();
            this.pg.background(200, 50);
            this.pg.stroke(0);
            this.pg.noFill();
            this.pg.rectMode(PConstants.CORNER);
            if(this.isSelected(this)) {
                this.pg.strokeWeight(3.0);
            } else {
                this.pg.strokeWeight(1.0);
            }
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            this.pg.endDraw();
        }

        /**
         * 
         */
        public processMousePressed() {
            if(this.isActive) {
                for(let index208=0; index208 < this.controllers.length; index208++) {
                    let child = this.controllers[index208];
                    {
                        child.processMousePressed();
                    }
                }
                this.isPressed = this.isHovered;
                if(this.isPressed) {
                    for(let index209=0; index209 < this.adapters.length; index209++) {
                        let adapter = this.adapters[index209];
                        {
                            adapter.onMousePressed();
                        }
                    }
                }
            }
        }

        /**
         * 
         * @param {number} x
         * @param {number} y
         * @return {boolean}
         */
        public isPointInside(x : number, y : number) : boolean {
            let isInside : boolean = false;
            if(this.isActive) {
                if(x > this.getAbsolutePosX() && x < this.getAbsolutePosX() + this.w) {
                    if(y > this.getAbsolutePosY() && y < this.getAbsolutePosY() + this.titleBar.h) {
                        isInside = true;
                    }
                }
            }
            return isInside;
        }

        /*private*/ createTitleBar() {
            this.titleBar = new ktbyte.gui.TitleBar(this.ktgui, "tb:" + this.title, 0, 0, this.w, ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH);
            this.titleBar.isDragable = false;
            this.attachController(this.titleBar);
        }

        /*private*/ createPane() {
            this.pane = new ktbyte.gui.Pane(this.ktgui, "pane:" + this.title, 0, ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH, this.w, this.h - ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH);
            this.pane.isDragable = false;
            this.attachController(this.pane);
        }

        public addController$ktbyte_gui_Controller$int$int(child : ktbyte.gui.Controller, hAlign : number, vAlign : number) {
            if(this.isActive) {
                child.alignAbout$ktbyte_gui_Controller$int$int(this.pane, hAlign, vAlign);
                this.pane.attachController(child);
            }
        }

        public addController$ktbyte_gui_Controller$int$int$int(child : ktbyte.gui.Controller, hAlign : number, vAlign : number, gap : number) {
            if(this.isActive) {
                child.alignAbout$ktbyte_gui_Controller$int$int$int(this.pane, hAlign, vAlign, gap);
                this.pane.attachController(child);
            }
        }

        /**
         * Add child controller to the 'internal' pane instead of adding it to 'this' window
         * @param {ktbyte.gui.Controller} child
         * @param {number} hAlign
         * @param {number} vAlign
         * @param {number} gap
         */
        public addController(child? : any, hAlign? : any, vAlign? : any, gap? : any) : any {
            if(((child != null && child instanceof <any>ktbyte.gui.Controller) || child === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && ((typeof gap === 'number') || gap === null)) {
                return <any>this.addController$ktbyte_gui_Controller$int$int$int(child, hAlign, vAlign, gap);
            } else if(((child != null && child instanceof <any>ktbyte.gui.Controller) || child === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && gap === undefined) {
                return <any>this.addController$ktbyte_gui_Controller$int$int(child, hAlign, vAlign);
            } else throw new Error('invalid overload');
        }

        public getPane() : ktbyte.gui.Pane {
            return this.pane;
        }
    }
    Panel["__class"] = "ktbyte.gui.Panel";
    Panel["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class ScrollableTextArea extends ktbyte.gui.Controller {
        /*private*/ textSize : number = 14;

        /*private*/ padding : number = 6;

        /*private*/ textLines : Array<ScrollableTextArea.TextLine> = <any>([]);

        /*private*/ textBlocks : Array<ScrollableTextArea.TextBlock> = <any>([]);

        /*private*/ startLineNumber : number = 0;

        /*private*/ enableLineStartMarks : boolean;

        public constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.enableLineStartMarks===undefined) this.enableLineStartMarks = false;
            this.setPadding((<any>Math).fround(this.getTextSize() * 0.75));
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.updateTextAreaGraphics();
        }

        updateTextAreaGraphics() {
            this.pg.beginDraw();
            this.pg.pushStyle();
            if(this.isSelected(this)) {
                this.pg.fill(this.bgPressedColor);
                this.pg.stroke(50);
                this.pg.strokeWeight(3.0);
            } else {
                this.pg.fill(this.bgPassiveColor);
                this.pg.stroke(0, 50, 0);
                this.pg.strokeWeight(1.0);
            }
            this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
            let calculatedEndLineNumber : number = PApplet.min(/* size */(<number>this.textLines.length) - 1, this.startLineNumber + this.getMaxLinesToDisplay());
            for(let i : number = 0; i <= calculatedEndLineNumber - this.startLineNumber; i++) {{
                let line : ScrollableTextArea.TextLine = /* get */this.textLines[i + this.startLineNumber];
                this.pg.fill(line.textColor);
                this.pg.textAlign(PConstants.LEFT, PConstants.BOTTOM);
                this.pg.textSize(this.textSize);
                this.pg.text(line.content, this.padding, (<any>Math).fround((<number>(this.padding * 0.5)|0) + (<any>Math).fround((i + 1) * this.getTextHeight())));
                if(line.isHead && this.enableLineStartMarks) {
                    this.pg.strokeWeight(3);
                    this.pg.point((<any>Math).fround(this.padding - 5), (<number>(this.padding * 0.5 + (<any>Math).fround((i + 1) * this.getTextHeight()) - this.getTextHeight() * 0.5)|0));
                }
            };}
            this.pg.popStyle();
            this.pg.endDraw();
        }

        /**
         * 
         * @param {ProcessingMouseEvent} me
         */
        public processMouseWheel(me : ProcessingMouseEvent) {
            this.mouseScrolled(me.getCount());
            for(let index210=0; index210 < this.adapters.length; index210++) {
                let adapter = this.adapters[index210];
                {
                    adapter.onMouseWheel(me.getCount());
                }
            }
        }

        public mouseScrolled(mouseWheelDelta : number) {
            if(this.isSelected(this)) {
                if(mouseWheelDelta < 0) {
                    if(this.startLineNumber > 0) {
                        this.decrementStartLine();
                    }
                } else if(mouseWheelDelta > 0) {
                    if(this.startLineNumber < this.getMaximumAllowedPositionOfStartLine()) {
                        this.incrementStartLine();
                    }
                }
            }
        }

        public incrementStartLine() {
            if(this.startLineNumber < this.getMaximumAllowedPositionOfStartLine()) {
                this.startLineNumber++;
            }
        }

        public getMaximumAllowedPositionOfStartLine() : number {
            return /* size */(<number>this.textLines.length) - this.getMaxLinesToDisplay();
        }

        public decrementStartLine() {
            if(this.startLineNumber > 0) {
                this.startLineNumber--;
            }
        }

        public scrollToTop() {
            while((this.startLineNumber > 0)) {{
                this.startLineNumber--;
            }};
        }

        public scrollToBottom() {
            while((this.startLineNumber < this.getMaximumAllowedPositionOfStartLine())) {{
                this.startLineNumber++;
            }};
        }

        public scrollToPosition(lineNumber : number) {
            if(lineNumber < 0 || lineNumber >= this.getMaximumAllowedPositionOfStartLine()) {
                ktbyte.gui.KTGUI.debug("lineNumber[" + lineNumber + "] is out of range during \'scrollToLine\' call.");
                return;
            }
            if(lineNumber > this.startLineNumber) {
                while((this.startLineNumber < lineNumber && this.startLineNumber < this.getMaximumAllowedPositionOfStartLine())) {{
                    this.startLineNumber++;
                }};
            } else if(lineNumber < this.startLineNumber) {
                while((this.startLineNumber > lineNumber && this.startLineNumber > 0)) {{
                    this.startLineNumber--;
                }};
            }
        }

        public getTextLines() : Array<ScrollableTextArea.TextLine> {
            return this.textLines;
        }

        public getTextBlocks() : Array<ScrollableTextArea.TextBlock> {
            return this.textBlocks;
        }

        public getPadding() : number {
            return this.padding;
        }

        public setPadding(padding : number) {
            this.padding = padding;
            this.updateWrappedLines();
        }

        public getTextSize() : number {
            return this.textSize;
        }

        public setTextSize(textSize : number) {
            this.textSize = textSize;
            this.updateWrappedLines();
        }

        public appendTextBlock$java_lang_String(text : string) {
            let textBlock : ScrollableTextArea.TextBlock = new ScrollableTextArea.TextBlock(this, text);
            /* add */(this.textBlocks.push(textBlock)>0);
            textBlock.appendAsWrappedLines(this.textSize);
        }

        public appendTextBlock$java_lang_String$int(text : string, color : number) {
            let textBlock : ScrollableTextArea.TextBlock = new ScrollableTextArea.TextBlock(this, text, color);
            /* add */(this.textBlocks.push(textBlock)>0);
            textBlock.appendAsWrappedLines(this.textSize);
        }

        public appendTextBlock(text? : any, color? : any) : any {
            if(((typeof text === 'string') || text === null) && ((typeof color === 'number') || color === null)) {
                return <any>this.appendTextBlock$java_lang_String$int(text, color);
            } else if(((typeof text === 'string') || text === null) && color === undefined) {
                return <any>this.appendTextBlock$java_lang_String(text);
            } else throw new Error('invalid overload');
        }

        updateWrappedLines() {
            this.textLines = <any>([]);
            for(let index211=0; index211 < this.textBlocks.length; index211++) {
                let block = this.textBlocks[index211];
                {
                    block.appendAsWrappedLines(this.textSize);
                }
            }
        }

        public getMaxLinesToDisplay() : number {
            return PApplet.floor((<any>Math).fround(((<any>Math).fround((<any>Math).fround(this.h - this.padding) - this.padding)) / this.getTextHeight()));
        }

        getTextHeight() : number {
            this.pa.textSize(this.textSize);
            return (<any>Math).fround(this.pa.textAscent() + this.pa.textDescent());
        }

        public getStartLinePosition() : number {
            return this.startLineNumber;
        }

        public enableTextBlockStartMarks(val : boolean) {
            this.enableLineStartMarks = val;
        }

        public getTextLine(index : number) : string {
            let textLine : string = "-= textLine: out of range =-";
            if(/* size */(<number>this.textLines.length) - index > 0) {
                textLine = /* get */this.textLines[index].content;
            }
            return textLine;
        }

        public getTextBlock(index : number) : string {
            let textBlock : string = "-= textBlock: out of range =-";
            if(/* size */(<number>this.textBlocks.length) - index > 0) {
                textBlock = /* get */this.textBlocks[index].content;
            }
            return textBlock;
        }

        public getLineCount() : number {
            return /* size */(<number>this.textLines.length);
        }

        public getBlockCount() : number {
            return /* size */(<number>this.textBlocks.length);
        }
    }
    ScrollableTextArea["__class"] = "ktbyte.gui.ScrollableTextArea";
    ScrollableTextArea["__interfaces"] = ["def.processing.core.PConstants"];



    export namespace ScrollableTextArea {

        export class TextLine {
            public __parent: any;
            public content : string;

            public textColor : number;

            public isHead : boolean;

            public constructor(__parent: any, content? : any, textColor? : any, isHead? : any) {
                if(((typeof content === 'string') || content === null) && ((typeof textColor === 'number') || textColor === null) && ((typeof isHead === 'boolean') || isHead === null)) {
                    let __args = Array.prototype.slice.call(arguments, [1]);
                    if(this.content===undefined) this.content = null;
                    if(this.isHead===undefined) this.isHead = false;
                    this.textColor = __parent.pa.color(0, 10, 30);
                    this.__parent = __parent;
                    if(this.content===undefined) this.content = null;
                    this.textColor = __parent.pa.color(0, 10, 30);
                    if(this.isHead===undefined) this.isHead = false;
                    (() => {
                        this.content = content;
                        this.isHead = isHead;
                        this.textColor = textColor;
                    })();
                } else if(((typeof content === 'string') || content === null) && ((typeof textColor === 'boolean') || textColor === null) && isHead === undefined) {
                    let __args = Array.prototype.slice.call(arguments, [1]);
                    let isHead : any = __args[1];
                    if(this.content===undefined) this.content = null;
                    if(this.isHead===undefined) this.isHead = false;
                    this.textColor = __parent.pa.color(0, 10, 30);
                    this.__parent = __parent;
                    if(this.content===undefined) this.content = null;
                    this.textColor = __parent.pa.color(0, 10, 30);
                    if(this.isHead===undefined) this.isHead = false;
                    (() => {
                        this.content = content;
                        this.isHead = isHead;
                    })();
                } else throw new Error('invalid overload');
            }
        }
        TextLine["__class"] = "ktbyte.gui.ScrollableTextArea.TextLine";


        export class TextBlock {
            public __parent: any;
            content : string;

            isHeadAlreadyMarked : boolean;

            textColor : number;

            public constructor(__parent: any, content? : any, textColor? : any) {
                if(((typeof content === 'string') || content === null) && ((typeof textColor === 'number') || textColor === null)) {
                    let __args = Array.prototype.slice.call(arguments, [1]);
                    if(this.content===undefined) this.content = null;
                    if(this.isHeadAlreadyMarked===undefined) this.isHeadAlreadyMarked = false;
                    this.textColor = __parent.pa.color(0);
                    this.__parent = __parent;
                    if(this.content===undefined) this.content = null;
                    if(this.isHeadAlreadyMarked===undefined) this.isHeadAlreadyMarked = false;
                    this.textColor = __parent.pa.color(0);
                    (() => {
                        this.content = /* replaceAll */content.trim().replace(new RegExp("\n\t\r", 'g')," ");
                        this.textColor = textColor;
                    })();
                } else if(((typeof content === 'string') || content === null) && textColor === undefined) {
                    let __args = Array.prototype.slice.call(arguments, [1]);
                    if(this.content===undefined) this.content = null;
                    if(this.isHeadAlreadyMarked===undefined) this.isHeadAlreadyMarked = false;
                    this.textColor = __parent.pa.color(0);
                    this.__parent = __parent;
                    if(this.content===undefined) this.content = null;
                    if(this.isHeadAlreadyMarked===undefined) this.isHeadAlreadyMarked = false;
                    this.textColor = __parent.pa.color(0);
                    (() => {
                        this.content = /* replaceAll */content.trim().replace(new RegExp("\n\t\r", 'g')," ");
                    })();
                } else throw new Error('invalid overload');
            }

            public appendAsWrappedLines(_textSize : number) {
                this.isHeadAlreadyMarked = false;
                let sb : { str: string, toString: Function } = { str: "", toString: function() { return this.str; } };
                let wrappedWidth : number = PApplet.floor((<any>Math).fround((<any>Math).fround(this.__parent.w - this.__parent.padding) - this.__parent.padding));
                this.__parent.pa.textSize(_textSize);
                for(let i : number = 0; i < this.content.length; i++) {{
                    let chunkWidth : number = PApplet.ceil(this.__parent.pa.textWidth(/* toString */sb.str));
                    if(chunkWidth >= wrappedWidth) {
                        this.addWrappedLine(sb);
                        sb = { str: "", toString: function() { return this.str; } };
                    }
                    /* append */(sb => { sb.str = sb.str.concat(<any>this.content.charAt(i)); return sb; })(sb);
                };}
                this.addWrappedLine(sb);
            }

            addWrappedLine(sb : { str: string, toString: Function }) {
                if(!this.isHeadAlreadyMarked) {
                    /* add */(this.__parent.textLines.push(new ScrollableTextArea.TextLine(this.__parent, /* toString */sb.str, this.textColor, true))>0);
                    this.isHeadAlreadyMarked = true;
                } else {
                    /* add */(this.__parent.textLines.push(new ScrollableTextArea.TextLine(this.__parent, /* toString */sb.str, this.textColor, false))>0);
                }
            }
        }
        TextBlock["__class"] = "ktbyte.gui.ScrollableTextArea.TextBlock";

    }

}
namespace ktbyte.gui {
    export class ScrollBar extends ktbyte.gui.Controller {
        /*private*/ backwardButton : ktbyte.gui.ArrowButton;

        /*private*/ forwardButton : ktbyte.gui.ArrowButton;

        /*private*/ slider : ktbyte.gui.Slider;

        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number, sr : number, er : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.backwardButton===undefined) this.backwardButton = null;
            if(this.forwardButton===undefined) this.forwardButton = null;
            if(this.slider===undefined) this.slider = null;
            this.createButtons();
            this.createSlider(sr, er);
            this.setBorderRoundings(5, 5, 5, 5);
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
        }

        /**
         * 
         * @param {number} r1
         * @param {number} r2
         * @param {number} r3
         * @param {number} r4
         */
        public setBorderRoundings(r1 : number, r2 : number, r3 : number, r4 : number) {
            if(this.w > this.h) {
                this.backwardButton.setBorderRoundings(r1, 0, 0, r4);
                this.forwardButton.setBorderRoundings(0, r2, r3, 0);
            } else {
                this.forwardButton.setBorderRoundings(r1, r2, 0, 0);
                this.backwardButton.setBorderRoundings(0, 0, r3, r4);
            }
        }

        /*private*/ createButtons() {
            if(this.w > this.h) {
                this.backwardButton = new ktbyte.gui.ArrowButton(this.ktgui, "bckwrdBtn:" + this.title, 0, 0, this.h, this.h, PConstants.LEFT);
                this.forwardButton = new ktbyte.gui.ArrowButton(this.ktgui, "frwrdBtn:" + this.title, this.w - this.h, 0, this.h, this.h, PConstants.RIGHT);
            } else {
                this.forwardButton = new ktbyte.gui.ArrowButton(this.ktgui, "frwrdBtn:" + this.title, 0, 0, this.w, this.w, PConstants.UP);
                this.backwardButton = new ktbyte.gui.ArrowButton(this.ktgui, "bckwrdBtn:" + this.title, 0, this.h - this.w, this.w, this.w, PConstants.DOWN);
            }
            this.backwardButton.addEventAdapter(new ScrollBar.ScrollBar$0(this));
            this.forwardButton.addEventAdapter(new ScrollBar.ScrollBar$1(this));
            this.backwardButton.isDragable = false;
            this.forwardButton.isDragable = false;
            this.attachController(this.backwardButton);
            this.attachController(this.forwardButton);
        }

        /*private*/ createSlider(sr : number, er : number) {
            if(this.w > this.h) {
                this.slider = new ktbyte.gui.Slider(this.ktgui, "hSlider:" + this.title, this.backwardButton.w, 0, this.w - this.backwardButton.w - this.forwardButton.w, this.h, sr, er);
            } else {
                this.slider = new ktbyte.gui.Slider(this.ktgui, "vSlider:" + this.title, 0, this.backwardButton.h, this.w, this.h - this.backwardButton.h - this.forwardButton.h, sr, er);
            }
            this.slider.isDragable = false;
            this.slider.setValue(0);
            this.slider.setRounding(0);
            this.slider.setIsValueVisible(false);
            this.slider.addEventAdapter(new ScrollBar.ScrollBar$2(this));
            this.attachController(this.slider);
        }

        public getValue() : number {
            return this.slider.getValue();
        }

        public setValue(val : number) {
            this.slider.setValue(val);
        }

        public getHandlePos() : number {
            return this.slider.getHandlePos();
        }

        public setHandlePos(pos : number) {
            this.slider.setHandlePos(pos);
        }

        public setHandleType(handleType : number) {
            this.slider.setHandleType(handleType);
        }

        public setHandleStep(step : number) {
            this.slider.setHandleValue(step);
        }

        public getHandleStep() : number {
            return this.slider.getValueStep();
        }

        public getIsValueVisible() : boolean {
            return this.slider.getIsValueVisible();
        }

        public setIsValueVisible(visible : boolean) {
            this.slider.setIsValueVisible(visible);
        }

        public getRangeStart() : number {
            return this.slider.getRangeStart();
        }

        public setRangeStart(rangeStart : number) {
            this.slider.setRangeStart(rangeStart);
        }

        public getRangeEnd() : number {
            return this.slider.getRangeEnd();
        }

        public setRangeEnd(rangeEnd : number) {
            this.slider.setRangeEnd(rangeEnd);
        }

        public setRounding(n : number) {
            this.slider.setRounding(n);
        }
    }
    ScrollBar["__class"] = "ktbyte.gui.ScrollBar";
    ScrollBar["__interfaces"] = ["def.processing.core.PConstants"];



    export namespace ScrollBar {

        export class ScrollBar$0 extends ktbyte.gui.EventAdapter {
            public __parent: any;
            public onMousePressed() {
                this.__parent.slider.decrementValue();
            }

            constructor(__parent: any) {
                super();
                this.__parent = __parent;
            }
        }


        export class ScrollBar$1 extends ktbyte.gui.EventAdapter {
            public __parent: any;
            public onMousePressed() {
                this.__parent.slider.incrementValue();
            }

            constructor(__parent: any) {
                super();
                this.__parent = __parent;
            }
        }


        export class ScrollBar$2 extends ktbyte.gui.EventAdapter {
            public __parent: any;
            public onMouseDragged() {
                for(let index212=0; index212 < this.__parent.adapters.length; index212++) {
                    let adapter = this.__parent.adapters[index212];
                    {
                        adapter.onMouseDragged();
                    }
                }
            }

            constructor(__parent: any) {
                super();
                this.__parent = __parent;
            }
        }

    }

}
namespace ktbyte.gui {
    /**
     * @extends ktbyte.gui.Controller
     * @class
     */
    export class Slider extends ktbyte.gui.Controller {
        public static HANDLE_TYPE_CENTERED : number = 1;

        public static HANDLE_TYPE_EXPANDED : number = 0;

        /*private*/ handleType : number = Slider.HANDLE_TYPE_EXPANDED;

        /*private*/ handleSize : number = ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH;

        /*private*/ handlePos : number = 0;

        /*private*/ rangeStart : number = 0;

        /*private*/ rangeEnd : number = 100;

        /*private*/ value : number = this.rangeStart;

        /*private*/ valueStep : number = 1;

        /*private*/ roundingTemplate : number = 10;

        /*private*/ isValueVisible : boolean = true;

        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number, sr : number, er : number) {
            super(ktgui, title, posx, posy, w, h);
            this.rangeStart = sr;
            this.rangeEnd = er;
            this.setHandleType(Slider.HANDLE_TYPE_EXPANDED);
            this.updateHandlePositionFromValue();
            this.updateHandlePositionFromMouse();
            this.updateValueFromHandlePosition();
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            if(this.handleType === Slider.HANDLE_TYPE_CENTERED) {
                this.drawCenteredHandle();
            } else if(this.handleType === Slider.HANDLE_TYPE_EXPANDED) {
                this.drawExpandedHandle();
            } else {
                this.drawExpandedHandle();
            }
        }

        /*private*/ drawExpandedHandle() {
            this.pg.beginDraw();
            this.pg.fill(this.isHovered?ktbyte.gui.KTGUI.COLOR_BG_HOVERED:ktbyte.gui.KTGUI.COLOR_BG_PASSIVE);
            this.pg.rectMode(PConstants.CORNER);
            this.pg.rect(0, 0, this.w, this.h);
            this.pg.fill(this.isHovered?ktbyte.gui.KTGUI.COLOR_FG_HOVERED:ktbyte.gui.KTGUI.COLOR_FG_PASSIVE);
            if(this.w > this.h) {
                this.pg.rect(0, 0, this.handlePos, this.h);
            } else {
                this.pg.rect(0, (<any>Math).fround(this.h - this.handlePos), this.w, this.handlePos);
            }
            if(this.isValueVisible) {
                this.pg.fill(0);
                this.pg.textAlign(PConstants.LEFT, PConstants.CENTER);
                if(this.w > this.h) {
                    this.pg.text(PApplet.str(this.value), 10, (<any>Math).fround(this.h * 0.5));
                    this.pg.textAlign(PConstants.LEFT, PConstants.BOTTOM);
                    this.pg.text(this.title, 10, -2);
                } else {
                    this.pg.text(PApplet.str(this.value), 1, (<any>Math).fround(this.h * 0.5));
                }
            }
            this.pg.endDraw();
        }

        /*private*/ drawCenteredHandle() {
            this.pg.beginDraw();
            this.pg.fill(this.isHovered?ktbyte.gui.KTGUI.COLOR_BG_HOVERED:ktbyte.gui.KTGUI.COLOR_BG_PASSIVE);
            this.pg.rectMode(PConstants.CORNER);
            this.pg.rect(0, 0, this.w, this.h);
            this.pg.fill(this.isHovered?ktbyte.gui.KTGUI.COLOR_FG_HOVERED:ktbyte.gui.KTGUI.COLOR_FG_PASSIVE);
            this.pg.rectMode(PConstants.CENTER);
            let handleOffset : number = (<number>((<any>Math).fround(this.handleSize * 0.5))|0);
            if(this.w > this.h) {
                let correctedHandlePos : number = (<number>PApplet.constrain(this.handlePos, handleOffset, this.w - handleOffset)|0);
                this.pg.rect(correctedHandlePos, (<any>Math).fround(this.h * 0.5), this.handleSize, this.h);
            } else {
                let correctedHandlePos : number = (<number>PApplet.constrain(this.handlePos, handleOffset, this.h - handleOffset)|0);
                this.pg.rect((<any>Math).fround(this.w * 0.5), this.h - correctedHandlePos, this.w, this.handleSize);
            }
            if(this.isValueVisible) {
                this.pg.fill(0);
                this.pg.textAlign(PConstants.LEFT, PConstants.CENTER);
                if(this.w > this.h) {
                    this.pg.text(PApplet.str(this.value), 10, (<any>Math).fround(this.h * 0.5));
                    this.pg.textAlign(PConstants.LEFT, PConstants.BOTTOM);
                    this.pg.text(this.title, 10, -2);
                } else {
                    this.pg.text(PApplet.str(this.value), 1, (<any>Math).fround(this.h * 0.5));
                }
            }
            this.pg.endDraw();
        }

        public addEventAdapter(adapter : ktbyte.gui.EventAdapter) {
            /* add */(this.adapters.push(adapter)>0);
        }

        public getValue() : number {
            return this.value;
        }

        public setValue(val : number) {
            if(val >= this.rangeStart && val <= this.rangeEnd) {
                this.value = val;
                this.updateHandlePositionFromValue();
            } else {
                console.info("You\'re trying to set the value of the slider to be outside its range.");
            }
        }

        public getIsValueVisible() : boolean {
            return this.isValueVisible;
        }

        public setIsValueVisible(visible : boolean) {
            this.isValueVisible = visible;
        }

        public getHandlePos() : number {
            return this.handlePos;
        }

        public setHandlePos(pos : number) {
            console.info("Trying to set handle pos to " + pos);
            if(this.w > this.h) {
                if(pos >= 0 && pos <= this.w) {
                    this.handlePos = pos;
                    this.updateValueFromHandlePosition();
                } else {
                    console.info("You\'re trying to set the position of the slider to be outside its width.");
                }
            } else {
                if(pos >= 0 && pos <= this.h) {
                    this.handlePos = pos;
                    this.updateValueFromHandlePosition();
                } else {
                    console.info("You\'re trying to set the position of the slider to be outside its height.");
                }
            }
            console.info("Handle position is: " + this.handlePos + ", value is:" + this.value);
        }

        public getValueStep() : number {
            return this.valueStep;
        }

        public setHandleValue(valueStep : number) {
            if(valueStep > 0) {
                this.valueStep = valueStep;
            }
        }

        public incrementValue() {
            let newVal : number = (<any>Math).fround(this.value + this.valueStep);
            this.setValue(newVal > this.rangeEnd?this.rangeEnd:newVal);
        }

        public decrementValue() {
            let newVal : number = (<any>Math).fround(this.value - this.valueStep);
            this.setValue(newVal < this.rangeStart?this.rangeStart:newVal);
        }

        public setHandleType(handleType : number) {
            this.handleType = handleType;
            if(handleType === Slider.HANDLE_TYPE_EXPANDED) {
                this.handleSize = 0;
            } else if(handleType === Slider.HANDLE_TYPE_CENTERED) {
                this.handleSize = ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH;
            }
        }

        public getHandleSize() : number {
            return this.handleSize;
        }

        public setHandleSize(hSize : number) {
            if(this.w > this.h) {
                this.handleSize = PApplet.constrain(hSize, ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH, this.w);
            } else {
                this.handleSize = PApplet.constrain(hSize, ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH, this.h);
            }
            this.updateValueFromHandlePosition();
        }

        public getRangeStart() : number {
            return this.rangeStart;
        }

        public setRangeStart(rangeStart : number) {
            if(rangeStart < this.rangeEnd) {
                this.rangeStart = rangeStart;
                this.updateValueFromHandlePosition();
                ktbyte.gui.KTGUI.debug("[" + this.title + "] range start set to " + rangeStart);
            } else {
                ktbyte.gui.KTGUI.debug("[" + this.title + "] range start cannot be set greater than its range end.");
            }
        }

        public getRangeEnd() : number {
            return this.rangeEnd;
        }

        public setRangeEnd(rangeEnd : number) {
            if(rangeEnd > this.rangeStart) {
                this.rangeEnd = rangeEnd;
                this.updateValueFromHandlePosition();
                ktbyte.gui.KTGUI.debug("[" + this.title + "] range end set to " + rangeEnd);
            } else {
                ktbyte.gui.KTGUI.debug("[" + this.title + "] range end cannot be set smaller than its range start.");
            }
        }

        public setRounding(n : number) {
            this.roundingTemplate = (<any>Math).fround(Math.pow(10, n));
        }

        /**
         * This method is called when the user change the <b>value</b> of the slider
         * without the mouse, using the setValue(int) method.
         * @private
         */
        /*private*/ updateHandlePositionFromValue() {
            if(this.w > this.h) {
                this.handlePos = PApplet.map(this.value, this.rangeStart, this.rangeEnd, (<any>Math).fround(this.handleSize * 0.5), (<any>Math).fround(this.w - (<any>Math).fround(this.handleSize * 0.5)));
            } else {
                this.handlePos = PApplet.map(this.value, this.rangeStart, this.rangeEnd, (<any>Math).fround(this.handleSize * 0.5), (<any>Math).fround(this.h - (<any>Math).fround(this.handleSize * 0.5)));
            }
        }

        /**
         * This method is called when the user change the <b>position</b> of the slider
         * with the mouse.
         * @private
         */
        /*private*/ updateHandlePositionFromMouse() {
            if(this.w > this.h) {
                this.handlePos = PApplet.constrain(this.pa.mouseX - this.getAbsolutePosX(), (<any>Math).fround(this.handleSize * 0.5), (<any>Math).fround(this.w - (<any>Math).fround(this.handleSize * 0.5)));
            } else {
                this.handlePos = PApplet.constrain(this.h - (this.pa.mouseY - this.getAbsolutePosY()), (<any>Math).fround(this.handleSize * 0.5), (<any>Math).fround(this.h - (<any>Math).fround(this.handleSize * 0.5)));
            }
        }

        /**
         * This method is called to recalculate the slider's `value` within the given range
         * when the user change the <b>position</b> of the slider with the mouse.
         * @private
         */
        /*private*/ updateValueFromHandlePosition() {
            if(this.w > this.h) {
                this.value = PApplet.map(this.handlePos, (<any>Math).fround(this.handleSize * 0.5), (<any>Math).fround(this.w - (<any>Math).fround(this.handleSize * 0.5)), this.rangeStart, this.rangeEnd);
            } else {
                this.value = PApplet.map(this.handlePos, (<any>Math).fround(this.handleSize * 0.5), (<any>Math).fround(this.h - (<any>Math).fround(this.handleSize * 0.5)), this.rangeStart, this.rangeEnd);
            }
            this.value = PApplet.constrain(this.value, this.rangeStart, this.rangeEnd);
            if(this.roundingTemplate > 0) {
                this.value = (<any>Math).fround(Math.round((<any>Math).fround(this.value * this.roundingTemplate)) / this.roundingTemplate);
            } else {
                this.value = (<any>Math).fround(Math.floor(this.value));
            }
        }

        public processMouseMoved() {
            this.isHovered = this.isPointInside(this.pa.mouseX, this.pa.mouseY);
            for(let index213=0; index213 < this.adapters.length; index213++) {
                let adapter = this.adapters[index213];
                {
                    adapter.onMouseMoved();
                }
            }
        }

        public processMousePressed() {
            this.isPressed = this.isHovered;
            if(this.isPressed) {
                this.updateHandlePositionFromMouse();
                this.updateValueFromHandlePosition();
            }
            for(let index214=0; index214 < this.adapters.length; index214++) {
                let adapter = this.adapters[index214];
                {
                    adapter.onMousePressed();
                }
            }
        }

        public processMouseReleased() {
            this.isPressed = false;
            this.isDragged = false;
            for(let index215=0; index215 < this.adapters.length; index215++) {
                let adapter = this.adapters[index215];
                {
                    adapter.onMouseReleased();
                }
            }
        }

        public processMouseDragged() {
            this.isDragged = this.isPressed;
            if(this.isPressed) {
                this.updateHandlePositionFromMouse();
                this.updateValueFromHandlePosition();
            }
            for(let index216=0; index216 < this.adapters.length; index216++) {
                let adapter = this.adapters[index216];
                {
                    adapter.onMouseDragged();
                }
            }
        }
    }
    Slider["__class"] = "ktbyte.gui.Slider";
    Slider["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    export class TitleBar extends ktbyte.gui.Bar {
        closeButton : ktbyte.gui.CloseButton;

        constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
            if(this.closeButton===undefined) this.closeButton = null;
            this.isDragable = true;
            this.closeButton = new ktbyte.gui.CloseButton(ktgui, "cb:" + this.title, w - h + 2, 2, h - 4, h - 4);
            this.attachController(this.closeButton);
        }
    }
    TitleBar["__class"] = "ktbyte.gui.TitleBar";
    TitleBar["__interfaces"] = ["def.processing.core.PConstants"];


}
namespace ktbyte.gui {
    /**
     * 
     * @param {ktbyte.gui.KTGUI} ktgui
     * @param {string} title
     * @param {number} posx
     * @param {number} posy
     * @param {number} w
     * @param {number} h
     * @class
     * @extends ktbyte.gui.Button
     */
    export class CloseButton extends ktbyte.gui.Button {
        public constructor(ktgui : ktbyte.gui.KTGUI, title : string, posx : number, posy : number, w : number, h : number) {
            super(ktgui, title, posx, posy, w, h);
            this.isDragable = false;
        }

        /**
         * 
         */
        public updateGraphics() {
            super.updateGraphics();
            this.pg.beginDraw();
            this.pg.rectMode(PConstants.CORNER);
            if(this.isHovered && !this.isPressed) {
                this.pg.fill(ktbyte.gui.KTGUI.COLOR_FG_HOVERED);
            } else if(this.isHovered && this.isPressed) {
                this.pg.fill(ktbyte.gui.KTGUI.COLOR_FG_PRESSED);
            } else {
                this.pg.fill(200, 200);
            }
            this.pg.stroke(0);
            this.pg.strokeWeight(1);
            this.pg.rectMode(PConstants.CORNER);
            this.pg.rect(0, 0, this.w, this.h);
            this.pg.line((<any>Math).fround(this.w * 0.2), (<any>Math).fround(this.h * 0.2), (<any>Math).fround(this.w * 0.8), (<any>Math).fround(this.h * 0.8));
            this.pg.line((<any>Math).fround(this.w * 0.2), (<any>Math).fround(this.h * 0.8), (<any>Math).fround(this.w * 0.8), (<any>Math).fround(this.h * 0.2));
            this.pg.endDraw();
        }

        /**
         * TODO : replace 'closeControllerRecursively' method with 'closeParentWindow' in
         * order to prevent closing ALL controllers up to the 'root'. That behaviour is not
         * right - the CloseButton of the Window.TitleBar should close only the parent Window
         * and all it's childs (and their childs).
         */
        public processMousePressed() {
            super.processMousePressed();
            if(this.isPressed) {
                this.closeParent();
            }
        }

        /**
         * This method closes all the controllers recursively up to the parent Window
         * and then closes all its childs recursively down.
         */
        public closeParent() {
            if(this.parentController != null) {
                if(!/* contains */(/* getName */(c => c["__class"]?c["__class"]:c["name"])((<any>this.parentController.constructor)).indexOf("Window") != -1)) {
                    this.parentController.closeParent();
                }
                this.parentController.close();
            }
            this.closeAllChildsRecursively();
        }
    }
    CloseButton["__class"] = "ktbyte.gui.CloseButton";
    CloseButton["__interfaces"] = ["def.processing.core.PConstants"];


}


ktbyte.gui.StageManager.instance_$LI$();

ktbyte.gui.StageManager.defaultStage_$LI$();

ktbyte.gui.StageManager.activeStage_$LI$();

ktbyte.gui.StageManager.stages_$LI$();

ktbyte.gui.StageManager.__static_initialize();
