var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
/* Generated from Java with JSweet 2.2.0-SNAPSHOT - http://www.jsweet.org */
var ktbyte;
(function (ktbyte) {
    var gui;
    (function (gui) {
        /**
         * This abstract class should be extended by the KTGUI components (controllers)
         * @class
         */
        var EventAdapter = (function () {
            function EventAdapter() {
            }
            EventAdapter.prototype.onMousePressed = function () {
            };
            EventAdapter.prototype.onMouseReleased = function () {
            };
            EventAdapter.prototype.onMouseMoved = function () {
            };
            EventAdapter.prototype.onMouseDragged = function () {
            };
            EventAdapter.prototype.onMouseWheel = function (count) {
            };
            EventAdapter.prototype.onAnyKeyReleased = function () {
            };
            EventAdapter.prototype.onAnyKeyPressed = function () {
            };
            EventAdapter.prototype.onEnterKeyPressed = function () {
            };
            EventAdapter.prototype.onConsoleInput = function (textInput, lastVariableName) {
            };
            EventAdapter.prototype.println = function (string) {
                PApplet.println(string);
            };
            return EventAdapter;
        }());
        gui.EventAdapter = EventAdapter;
        EventAdapter["__class"] = "ktbyte.gui.EventAdapter";
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        var EventProcessor = (function () {
            function EventProcessor() {
                this.isActive = true;
                this.isVisible = true;
                this.adapters = ([]);
                if (this.isPressed === undefined)
                    this.isPressed = false;
                if (this.isHovered === undefined)
                    this.isHovered = false;
                if (this.isDragged === undefined)
                    this.isDragged = false;
                if (this.isDragable === undefined)
                    this.isDragable = false;
                if (this.handleFocus === undefined)
                    this.handleFocus = false;
            }
            EventProcessor.prototype.processMouseMoved = function () {
            };
            EventProcessor.prototype.processMousePressed = function () {
            };
            EventProcessor.prototype.processMouseReleased = function () {
            };
            EventProcessor.prototype.processMouseDragged = function () {
            };
            EventProcessor.prototype.processMouseWheel = function (me) {
            };
            EventProcessor.prototype.processKeyPressed = function () {
            };
            EventProcessor.prototype.processKeyReleased = function () {
            };
            EventProcessor.prototype.isPointInside = function (x, y) {
                return false;
            };
            EventProcessor.prototype.addEventAdapter = function (adapter) {
                /* add */ (this.adapters.push(adapter) > 0);
            };
            return EventProcessor;
        }());
        gui.EventProcessor = EventProcessor;
        EventProcessor["__class"] = "ktbyte.gui.EventProcessor";
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        /**
         * This is a constructor of the KTGUI class.
         * It automatically registers the 'draw', 'mouseEvent' and 'keyEvent' methods of this class in PApplet.
         * @param {*} pa
         * @class
         */
        var KTGUI = (function () {
            function KTGUI(pa) {
                this.drawCallStack = ([]);
                /*private*/ this.debugDrawCallStack = false;
                if (this.garbageList === undefined)
                    this.garbageList = null;
                KTGUI.debug("\nCreating of the KTGUI instance started.");
                this.init(pa);
                KTGUI.debug("Creating of the KTGUI instance completed.\n");
            }
            /*private*/ KTGUI.prototype.init = function (pa) {
                KTGUI.debug("\tInitializing of the KTGUI started.");
                KTGUI.pa = pa;
                KTGUI.pa.registerMethod("draw", this);
                KTGUI.debug("\t\t\'draw()\' method has been registered in parent PApplet.");
                KTGUI.pa.registerMethod("mouseEvent", this);
                KTGUI.debug("\t\t\'mouseEvent()\' method has been registered in parent PApplet.");
                KTGUI.pa.registerMethod("keyEvent", this);
                KTGUI.debug("\t\t\'keyEvent()\' method has been registered in parent PApplet.");
                this.garbageList = ({});
                KTGUI.debug("\t\tGarbage list created.");
                KTGUI.COLOR_FG_PASSIVE = pa.color(150, 180, 150);
                KTGUI.COLOR_FG_HOVERED = pa.color(150, 220, 150);
                KTGUI.COLOR_FG_PRESSED = pa.color(110, 200, 110);
                KTGUI.COLOR_BG_PASSIVE = pa.color(190);
                KTGUI.COLOR_BG_HOVERED = pa.color(220);
                KTGUI.COLOR_BG_PRESSED = pa.color(210);
                KTGUI.DEFAULT_COMPONENT_WIDTH = 16;
                KTGUI.DEFAULT_ALIGN_GAP = 20;
                KTGUI.DEFAULT_ROUNDING = 8;
                KTGUI.debug("\t\tColor and size constants initialized.");
                ktbyte.gui.StageManager.getInstance();
                KTGUI.debug("\tInitializing of the KTGUI completed.");
            };
            KTGUI.getParentPApplet = function () {
                return KTGUI.pa;
            };
            /**
             * This method is intended to be called <b>automatically</b> at the end of each draw() cycle of the parent PApplet.
             * This way, the KTGUI class automatically updates all the controllers on the <i>default</i> and <i>active</i> stages.
             */
            KTGUI.prototype.draw = function () {
                if (ktbyte.gui.StageManager.getInstance().userStagesExist()) {
                    ktbyte.gui.StageManager.getInstance().getActiveStage().draw();
                }
                ktbyte.gui.StageManager.getInstance().getDefaultStage().draw();
                this.collectGarbage();
            };
            KTGUI.prototype.setDrawCallStackFlag = function (debug) {
                this.debugDrawCallStack = debug;
            };
            KTGUI.prototype.drawDebugTextSplitLine = function (x, y) {
                KTGUI.pa.text("----------------------------------------------------------------------------------------------------------------------------", x, y);
            };
            KTGUI.prototype.addDrawCallStackDebugMessage = function (msg) {
                if (this.debugDrawCallStack) {
                    /* add */ (this.drawCallStack.push(msg) > 0);
                }
            };
            KTGUI.prototype.addToGarbage = function (controller, millis) {
                /* put */ (function (m, k, v) { if (m.entries == null)
                    m.entries = []; for (var i = 0; i < m.entries.length; i++)
                    if (m.entries[i].key.equals != null && m.entries[i].key.equals(k) || m.entries[i].key === k) {
                        m.entries[i].value = v;
                        return;
                    } m.entries.push({ key: k, value: v, getKey: function () { return this.key; }, getValue: function () { return this.value; } }); })(this.garbageList, controller, millis);
            };
            KTGUI.prototype.collectGarbage = function () {
                {
                    var array170 = (function (m) { if (m.entries == null)
                        m.entries = []; return m.entries; })(this.garbageList);
                    for (var index169 = 0; index169 < array170.length; index169++) {
                        var me = array170[index169];
                        {
                            var controller = me.getKey();
                            var time = me.getValue();
                            if (KTGUI.pa.millis() - time > 100) {
                                if (controller.parentStage != null) {
                                    controller.parentStage.unregisterController(controller);
                                }
                                else {
                                    if (controller.parentController != null) {
                                        controller.parentController.detachController(controller);
                                    }
                                }
                            }
                        }
                    }
                }
            };
            KTGUI.prototype.createButton$java_lang_String$int$int$int$int = function (title, x, y, w, h) {
                return new ktbyte.gui.Button(this, title, x, y, w, h);
            };
            KTGUI.prototype.createButton = function (title, x, y, w, h) {
                if (((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                    return this.createButton$java_lang_String$int$int$int$int(title, x, y, w, h);
                }
                else if (((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                    return this.createButton$int$int$int$int(title, x, y, w);
                }
                else
                    throw new Error('invalid overload');
            };
            KTGUI.prototype.createButton$int$int$int$int = function (x, y, w, h) {
                return new ktbyte.gui.Button(this, "A Button", x, y, w, h);
            };
            KTGUI.prototype.createDirectionButton$java_lang_String$int$int$int$int$int = function (title, x, y, w, h, dir) {
                return new ktbyte.gui.ArrowButton(this, title, x, y, w, h, dir);
            };
            KTGUI.prototype.createDirectionButton = function (title, x, y, w, h, dir) {
                if (((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof dir === 'number') || dir === null)) {
                    return this.createDirectionButton$java_lang_String$int$int$int$int$int(title, x, y, w, h, dir);
                }
                else if (((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && dir === undefined) {
                    return this.createDirectionButton$int$int$int$int$int(title, x, y, w, h);
                }
                else
                    throw new Error('invalid overload');
            };
            KTGUI.prototype.createDirectionButton$int$int$int$int$int = function (x, y, w, h, dir) {
                return new ktbyte.gui.ArrowButton(this, "A DirButton", x, y, w, h, dir);
            };
            KTGUI.prototype.createSlider$java_lang_String$int$int$int$int$int$int = function (title, posx, posy, w, h, sr, er) {
                return new ktbyte.gui.Slider(this, title, posx, posy, w, h, sr, er);
            };
            KTGUI.prototype.createSlider = function (title, posx, posy, w, h, sr, er) {
                if (((typeof title === 'string') || title === null) && ((typeof posx === 'number') || posx === null) && ((typeof posy === 'number') || posy === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof sr === 'number') || sr === null) && ((typeof er === 'number') || er === null)) {
                    return this.createSlider$java_lang_String$int$int$int$int$int$int(title, posx, posy, w, h, sr, er);
                }
                else if (((typeof title === 'number') || title === null) && ((typeof posx === 'number') || posx === null) && ((typeof posy === 'number') || posy === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof sr === 'number') || sr === null) && er === undefined) {
                    return this.createSlider$int$int$int$int$int$int(title, posx, posy, w, h, sr);
                }
                else
                    throw new Error('invalid overload');
            };
            KTGUI.prototype.createSlider$int$int$int$int$int$int = function (posx, posy, w, h, sr, er) {
                return new ktbyte.gui.Slider(this, "A Slider", posx, posy, w, h, sr, er);
            };
            KTGUI.prototype.createWindow$java_lang_String$int$int$int$int = function (title, x, y, w, h) {
                var window = new ktbyte.gui.Panel(this, title, x, y, w, h);
                return window;
            };
            KTGUI.prototype.createWindow = function (title, x, y, w, h) {
                if (((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                    return this.createWindow$java_lang_String$int$int$int$int(title, x, y, w, h);
                }
                else if (((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                    return this.createWindow$int$int$int$int(title, x, y, w);
                }
                else
                    throw new Error('invalid overload');
            };
            KTGUI.prototype.createWindow$int$int$int$int = function (x, y, w, h) {
                var window = new ktbyte.gui.Panel(this, "A Window", x, y, w, h);
                return window;
            };
            KTGUI.prototype.createPane$java_lang_String$int$int$int$int = function (title, x, y, w, h) {
                var pane = new ktbyte.gui.Pane(this, title, x, y, w, h);
                return pane;
            };
            KTGUI.prototype.createPane = function (title, x, y, w, h) {
                if (((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                    return this.createPane$java_lang_String$int$int$int$int(title, x, y, w, h);
                }
                else if (((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                    return this.createPane$int$int$int$int(title, x, y, w);
                }
                else
                    throw new Error('invalid overload');
            };
            KTGUI.prototype.createPane$int$int$int$int = function (x, y, w, h) {
                var pane = new ktbyte.gui.Pane(this, "A Pane", x, y, w, h);
                return pane;
            };
            KTGUI.prototype.createScrollBar$int$int$int$int$int$int = function (x, y, w, h, sr, er) {
                var scrollBar = this.createScrollBar$java_lang_String$int$int$int$int$int$int("A ScrollBar", x, y, w, h, sr, er);
                return scrollBar;
            };
            KTGUI.prototype.createScrollBar$java_lang_String$int$int$int$int$int$int = function (title, x, y, w, h, sr, er) {
                if (w > h) {
                    if ((w - 2 * h) < 2 * KTGUI.DEFAULT_COMPONENT_WIDTH) {
                        KTGUI.debug("ERROR: The width of the ScrollBar to be created is  too small. As a consequence, the internal slider would have  orthogonal direction. Cannot create ScrollBar. Returning null reference.");
                        return null;
                    }
                }
                else {
                    if ((h - 2 * w) < 2 * KTGUI.DEFAULT_COMPONENT_WIDTH) {
                        KTGUI.debug("ERROR: The height of the ScrollBar to be created is  too small. As a consequence, the internal slider would have  orthogonal direction. Cannot create ScrollBar. Returning null reference.");
                        return null;
                    }
                }
                var scrollBar = new ktbyte.gui.ScrollBar(this, title, x, y, w, h, sr, er);
                return scrollBar;
            };
            KTGUI.prototype.createScrollBar = function (title, x, y, w, h, sr, er) {
                if (((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof sr === 'number') || sr === null) && ((typeof er === 'number') || er === null)) {
                    return this.createScrollBar$java_lang_String$int$int$int$int$int$int(title, x, y, w, h, sr, er);
                }
                else if (((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null) && ((typeof sr === 'number') || sr === null) && er === undefined) {
                    return this.createScrollBar$int$int$int$int$int$int(title, x, y, w, h, sr);
                }
                else
                    throw new Error('invalid overload');
            };
            KTGUI.prototype.createInputTextBox$java_lang_String$int$int$int$int = function (title, x, y, w, h) {
                return new ktbyte.gui.InputTextBox(this, title, x, y, w, h);
            };
            KTGUI.prototype.createInputTextBox = function (title, x, y, w, h) {
                if (((typeof title === 'string') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && ((typeof h === 'number') || h === null)) {
                    return this.createInputTextBox$java_lang_String$int$int$int$int(title, x, y, w, h);
                }
                else if (((typeof title === 'number') || title === null) && ((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null) && ((typeof w === 'number') || w === null) && h === undefined) {
                    return this.createInputTextBox$int$int$int$int(title, x, y, w);
                }
                else
                    throw new Error('invalid overload');
            };
            KTGUI.prototype.createInputTextBox$int$int$int$int = function (x, y, w, h) {
                return this.createInputTextBox$java_lang_String$int$int$int$int("An InputTextBox", x, y, w, h);
            };
            /**
             * This method 'redirects' the emitted mouse event from PApplet to KTGUI 'transfer' methods.
             * This method will be called <b>automatically</b> when the PApplet.mouseEvent is happening.
             * @param {ProcessingMouseEvent} e
             */
            KTGUI.prototype.mouseEvent = function (e) {
                switch ((e.getAction())) {
                    case ProcessingMouseEvent.PRESS:
                        this.mousePressed();
                        break;
                    case ProcessingMouseEvent.RELEASE:
                        this.mouseReleased();
                        break;
                    case ProcessingMouseEvent.DRAG:
                        this.mouseDragged();
                        break;
                    case ProcessingMouseEvent.MOVE:
                        this.mouseMoved();
                        break;
                    case ProcessingMouseEvent.WHEEL:
                        this.mouseWheel(e);
                        break;
                }
            };
            /**
             * This method 'redirects' the emitted keyboard event from PApplet to KTGUI 'transfer' methods.
             * This method will be called <b>automatically</b> when the PApplet.keyEvent is happening.
             * @param {ProcessingKeyEvent} e
             */
            KTGUI.prototype.keyEvent = function (e) {
                switch ((e.getAction())) {
                    case ProcessingKeyEvent.PRESS:
                        this.keyPressed();
                        break;
                    case ProcessingKeyEvent.RELEASE:
                        this.keyReleased();
                        break;
                }
            };
            KTGUI.debug = function (string) {
                if (KTGUI.debugControllers)
                    PApplet.println(string);
            };
            /**
             * This is a 'transfer' method - it 'redirects' the PApplet.mouseDragged event to KTGUI components (controllers)
             * @private
             */
            /*private*/ KTGUI.prototype.mouseDragged = function () {
                for (var index171 = 0; index171 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index171++) {
                    var controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index171];
                    {
                        controller.processMouseDragged();
                    }
                }
                if (ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                    for (var index172 = 0; index172 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index172++) {
                        var controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index172];
                        {
                            controller.processMouseDragged();
                        }
                    }
                }
            };
            /**
             * This is a 'transfer' method - it 'redirects' the PApplet.mousePressed event to KTGUI components (controllers)
             * @private
             */
            /*private*/ KTGUI.prototype.mousePressed = function () {
                for (var index173 = 0; index173 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index173++) {
                    var controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index173];
                    {
                        controller.processMousePressed();
                    }
                }
                if (ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                    for (var index174 = 0; index174 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index174++) {
                        var controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index174];
                        {
                            controller.processMousePressed();
                        }
                    }
                }
            };
            /**
             * This is a 'transfer' method - it 'redirects' the PApplet.mouseReleased event to KTGUI components (controllers)
             * @private
             */
            /*private*/ KTGUI.prototype.mouseReleased = function () {
                for (var index175 = 0; index175 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index175++) {
                    var controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index175];
                    {
                        controller.processMouseReleased();
                    }
                }
                if (ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                    for (var index176 = 0; index176 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index176++) {
                        var controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index176];
                        {
                            controller.processMouseReleased();
                        }
                    }
                }
            };
            /**
             * This is a 'transfer' method - it 'redirects' the PApplet.mouseMoved event to KTGUI components (controllers)
             * @private
             */
            /*private*/ KTGUI.prototype.mouseMoved = function () {
                for (var index177 = 0; index177 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index177++) {
                    var controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index177];
                    {
                        controller.processMouseMoved();
                    }
                }
                if (ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                    for (var index178 = 0; index178 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index178++) {
                        var controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index178];
                        {
                            controller.processMouseMoved();
                        }
                    }
                }
            };
            /*private*/ KTGUI.prototype.mouseWheel = function (me) {
                for (var index179 = 0; index179 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index179++) {
                    var controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index179];
                    {
                        controller.processMouseWheel(me);
                    }
                }
                if (ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                    for (var index180 = 0; index180 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index180++) {
                        var controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index180];
                        {
                            controller.processMouseWheel(me);
                        }
                    }
                }
            };
            /**
             * This is a 'transfer' method - it 'redirects' the PApplet.keyPressed event to KTGUI components (controllers)
             * @private
             */
            /*private*/ KTGUI.prototype.keyPressed = function () {
                for (var index181 = 0; index181 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index181++) {
                    var controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index181];
                    {
                        controller.processKeyPressed();
                    }
                }
                if (ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                    for (var index182 = 0; index182 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index182++) {
                        var controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index182];
                        {
                            controller.processKeyPressed();
                        }
                    }
                }
            };
            /**
             * This is a 'transfer' method - it 'redirects' the PApplet.keyReleased event to KTGUI components (controllers)
             * @private
             */
            /*private*/ KTGUI.prototype.keyReleased = function () {
                for (var index183 = 0; index183 < ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.length; index183++) {
                    var controller = ktbyte.gui.StageManager.getInstance().getActiveStage().controllers[index183];
                    {
                        controller.processKeyReleased();
                    }
                }
                if (ktbyte.gui.StageManager.getInstance().getDefaultStage() !== ktbyte.gui.StageManager.getInstance().getActiveStage()) {
                    for (var index184 = 0; index184 < ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.length; index184++) {
                        var controller = ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers[index184];
                        {
                            controller.processKeyReleased();
                        }
                    }
                }
            };
            return KTGUI;
        }());
        KTGUI.pa = null;
        KTGUI.COLOR_FG_HOVERED = 0;
        KTGUI.COLOR_FG_PRESSED = 0;
        KTGUI.COLOR_FG_PASSIVE = 0;
        KTGUI.COLOR_BG_HOVERED = 0;
        KTGUI.COLOR_BG_PASSIVE = 0;
        KTGUI.COLOR_BG_PRESSED = 0;
        KTGUI.DEFAULT_COMPONENT_WIDTH = 0;
        KTGUI.DEFAULT_ALIGN_GAP = 0;
        KTGUI.DEFAULT_ROUNDING = 0;
        KTGUI.debugControllers = false;
        gui.KTGUI = KTGUI;
        KTGUI["__class"] = "ktbyte.gui.KTGUI";
        KTGUI["__interfaces"] = ["def.processing.core.PConstants"];
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        /**
         * A Stage can have multple controllers.
         * The KTGUI class should handle the transition from one Stage to another.
         * Only one Stage can be active at a time.
         * Only the GUI elements from the active Stage will be displayed
         * This allows the sharing of variables between different Stages, by storing/retriving data from the 'context' object
         * @param {string} name
         * @class
         */
        var Stage = (function () {
            function Stage(name) {
                if (this.controllers === undefined)
                    this.controllers = null;
                if (this.name === undefined)
                    this.name = null;
                if (this.pa === undefined)
                    this.pa = null;
                ktbyte.gui.KTGUI.debug("Creation of stage {" + name + "} started.");
                this.pa = ktbyte.gui.KTGUI.getParentPApplet();
                this.name = name;
                this.controllers = ([]);
                /* add */ (ktbyte.gui.StageManager.getInstance().getStages().push(this) > 0);
                ktbyte.gui.KTGUI.debug("Creation of stage {" + name + "} completed.");
            }
            Stage.prototype.getName = function () {
                return this.name;
            };
            Stage.prototype.draw = function () {
                for (var index185 = 0; index185 < this.controllers.length; index185++) {
                    var controller = this.controllers[index185];
                    {
                        if (controller.isActive) {
                            controller.updateGraphics();
                            controller.draw();
                        }
                    }
                }
            };
            Stage.prototype.registerController = function (controller) {
                ktbyte.gui.KTGUI.debug("Registering controller [" + controller.title + "] of type <" + (function (c) { return c["__class"] ? c["__class"] : c["name"]; })(controller.constructor) + "> in stage {" + this.name + "}:");
                if ((this.controllers.indexOf((controller)) >= 0)) {
                    ktbyte.gui.KTGUI.debug("\tController [" + controller.title + "] already exist in stage {" + this.name + "}. Interrupting.");
                    return;
                }
                if ((ktbyte.gui.StageManager.getInstance().getDefaultStage().controllers.indexOf((controller)) >= 0)) {
                    ktbyte.gui.StageManager.getInstance().getDefaultStage().unregisterController(controller);
                }
                if (ktbyte.gui.StageManager.getInstance().getActiveStage() != null) {
                    if ((ktbyte.gui.StageManager.getInstance().getActiveStage().controllers.indexOf((controller)) >= 0)) {
                        ktbyte.gui.StageManager.getInstance().getActiveStage().unregisterController(controller);
                    }
                }
                /* add */ (this.controllers.push(controller) > 0);
                controller.parentStage = this;
                ktbyte.gui.KTGUI.debug("\tDone. Now, stage {" + this.name + "} contain " + this.controllers.length + " controller(s).");
                for (var index186 = 0; index186 < this.controllers.length; index186++) {
                    var c = this.controllers[index186];
                    {
                        ktbyte.gui.KTGUI.debug("\t\t" + this.controllers.indexOf(c) + ": " + c.title + " (" + c.controllers.length + " child controllers)");
                        for (var index187 = 0; index187 < c.controllers.length; index187++) {
                            var child = c.controllers[index187];
                            {
                                ktbyte.gui.KTGUI.debug("\t\t\t" + c.controllers.indexOf(child) + ": " + child.title);
                            }
                        }
                    }
                }
            };
            Stage.prototype.unregisterController = function (controller) {
                if ((this.controllers.indexOf((controller)) >= 0)) {
                    /* remove */ (function (a) { var index = a.indexOf(controller); if (index >= 0) {
                        a.splice(index, 1);
                        return true;
                    }
                    else {
                        return false;
                    } })(this.controllers);
                    controller.parentStage = null;
                }
            };
            Stage.prototype.getControllers = function () {
                return this.controllers;
            };
            return Stage;
        }());
        gui.Stage = Stage;
        Stage["__class"] = "ktbyte.gui.Stage";
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        /**
         *
         *
         * @class
         */
        var StageManager = (function () {
            function StageManager() {
            }
            StageManager.__static_initialize = function () { if (!StageManager.__static_initialized) {
                StageManager.__static_initialized = true;
                StageManager.__static_initializer_0();
            } };
            StageManager.stages_$LI$ = function () { StageManager.__static_initialize(); return StageManager.stages; };
            ;
            StageManager.activeStage_$LI$ = function () { StageManager.__static_initialize(); return StageManager.activeStage; };
            ;
            StageManager.defaultStage_$LI$ = function () { StageManager.__static_initialize(); return StageManager.defaultStage; };
            ;
            StageManager.instance_$LI$ = function () { StageManager.__static_initialize(); return StageManager.instance; };
            ;
            StageManager.__static_initializer_0 = function () {
                StageManager.instance = new StageManager();
                StageManager.instance_$LI$().init();
            };
            StageManager.getInstance = function () {
                return StageManager.instance_$LI$();
            };
            /*private*/ StageManager.prototype.init = function () {
                StageManager.stages = ([]);
                StageManager.defaultStage = this.createStage("Default");
                StageManager.activeStage = StageManager.defaultStage;
            };
            StageManager.prototype.createStage = function (name) {
                var stage = new ktbyte.gui.Stage(name);
                StageManager.activeStage = stage;
                return stage;
            };
            StageManager.prototype.getDefaultStage = function () {
                return StageManager.defaultStage_$LI$();
            };
            StageManager.prototype.getActiveStage = function () {
                return StageManager.activeStage_$LI$();
            };
            StageManager.prototype.goToStage$ktbyte_gui_Stage = function (stage) {
                if (stage !== StageManager.defaultStage_$LI$()) {
                    StageManager.activeStage = stage;
                }
            };
            StageManager.prototype.goToStage = function (stage) {
                if (((stage != null && stage instanceof ktbyte.gui.Stage) || stage === null)) {
                    return this.goToStage$ktbyte_gui_Stage(stage);
                }
                else if (((typeof stage === 'number') || stage === null)) {
                    return this.goToStage$int(stage);
                }
                else
                    throw new Error('invalid overload');
            };
            StageManager.prototype.goToStage$int = function (numStage) {
                if (numStage > 0 && numStage < StageManager.stages_$LI$().length) {
                    StageManager.activeStage = StageManager.stages[numStage];
                }
            };
            StageManager.prototype.goToNextStage = function () {
                if (this.userStagesExist()) {
                    var indexOfCurrentStage = StageManager.stages_$LI$().indexOf(StageManager.activeStage_$LI$());
                    if (indexOfCurrentStage > 0 && indexOfCurrentStage < StageManager.stages_$LI$().length - 1) {
                        StageManager.activeStage = StageManager.stages[indexOfCurrentStage + 1];
                    }
                    else {
                        StageManager.activeStage = StageManager.stages[1];
                    }
                }
            };
            StageManager.prototype.unregisterControllerFromAllStages = function (controller) {
                ktbyte.gui.KTGUI.debug("Unregistering [" + controller.title + "] from all stages ...");
                for (var index188 = 0; index188 < StageManager.stages_$LI$().length; index188++) {
                    var stage = StageManager.stages_$LI$()[index188];
                    {
                        ktbyte.gui.KTGUI.debug("\tStage {" + stage.getName() + "} contains:");
                        for (var index189 = 0; index189 < stage.controllers.length; index189++) {
                            var c = stage.controllers[index189];
                            {
                                ktbyte.gui.KTGUI.debug("\t\t[" + c.title + "] of type <" + (function (c) { return c["__class"] ? c["__class"] : c["name"]; })(c.constructor) + ">");
                            }
                        }
                        if ((stage.controllers.indexOf((controller)) >= 0)) {
                            ktbyte.gui.KTGUI.debug("\t\t\t>>> Found [" + controller.title + "] of type <" + (function (c) { return c["__class"] ? c["__class"] : c["name"]; })(controller.constructor) + "> in stage {" + stage.getName() + "}, removing ...");
                            /* remove */ stage.controllers.splice(stage.controllers.indexOf(controller), 1)[0];
                            ktbyte.gui.KTGUI.debug("\t\t\tNow, {" + stage.getName() + "}.controllers.contains(" + controller.title + ") = " + (stage.controllers.indexOf((controller)) >= 0));
                        }
                    }
                }
                controller.parentStage = null;
                ktbyte.gui.KTGUI.debug("Done.");
            };
            StageManager.prototype.userStagesExist = function () {
                return StageManager.getInstance().getDefaultStage() !== StageManager.getInstance().getActiveStage();
            };
            StageManager.prototype.getStages = function () {
                return StageManager.stages_$LI$();
            };
            return StageManager;
        }());
        StageManager.__static_initialized = false;
        gui.StageManager = StageManager;
        StageManager["__class"] = "ktbyte.gui.StageManager";
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        /**
         * This class automatically receives events from PApplet when they happen.
         * Every KTGUI component (controller) should extend this class in order to be able to receive the mouse and keyboard
         * events.
         * One should override only the 'needed' event methods. This allows to save time and decrease the amount of code.
         * One should always overridde the 'draw' method.
         * @extends ktbyte.gui.EventProcessor
         * @class
         */
        var Controller = (function (_super) {
            __extends(Controller, _super);
            function Controller(ktgui, title, posx, posy, w, h) {
                var _this = _super.call(this) || this;
                _this.controllers = ([]);
                _this.parentController = null;
                _this.parentStage = null;
                _this.fgHoveredColor = ktbyte.gui.KTGUI.COLOR_FG_HOVERED;
                _this.fgPressedColor = ktbyte.gui.KTGUI.COLOR_FG_PRESSED;
                _this.fgPassiveColor = ktbyte.gui.KTGUI.COLOR_FG_PASSIVE;
                _this.bgHoveredColor = ktbyte.gui.KTGUI.COLOR_BG_HOVERED;
                _this.bgPressedColor = ktbyte.gui.KTGUI.COLOR_BG_PRESSED;
                _this.bgPassiveColor = ktbyte.gui.KTGUI.COLOR_BG_PASSIVE;
                if (_this.title === undefined)
                    _this.title = null;
                if (_this.posx === undefined)
                    _this.posx = 0;
                if (_this.posy === undefined)
                    _this.posy = 0;
                if (_this.w === undefined)
                    _this.w = 0;
                if (_this.h === undefined)
                    _this.h = 0;
                if (_this.r1 === undefined)
                    _this.r1 = 0;
                if (_this.r2 === undefined)
                    _this.r2 = 0;
                if (_this.r3 === undefined)
                    _this.r3 = 0;
                if (_this.r4 === undefined)
                    _this.r4 = 0;
                if (_this.pa === undefined)
                    _this.pa = null;
                if (_this.ktgui === undefined)
                    _this.ktgui = null;
                if (_this.pg === undefined)
                    _this.pg = null;
                if (_this.userpg === undefined)
                    _this.userpg = null;
                ktbyte.gui.KTGUI.debug("Creation of [" + title + "] started.");
                if (w < Math.fround(ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH * 0.5) || h < Math.fround(ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH * 0.5)) {
                    ktbyte.gui.KTGUI.debug("!!! ERRROR.");
                    ktbyte.gui.KTGUI.debug("!!! w:" + w + ", h:" + h);
                    ktbyte.gui.KTGUI.debug("!!! Width and height of the " + title + " controller must be greater than KTGUI.DEFAULT_COMPONENT_SIZE/2 a.u. Which is currently equal to " + Math.fround(ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH * 0.5) + " a.u.");
                    ktbyte.gui.KTGUI.debug("!!! Creation of " + title + " interrupted (prevented).");
                    ktbyte.gui.KTGUI.debug("!!! Exiting from " + title + "`s constructor without creating the actual object.\n");
                    return _this;
                }
                _this.ktgui = ktgui;
                _this.pa = ktbyte.gui.KTGUI.getParentPApplet();
                _this.title = title;
                _this.posx = posx;
                _this.posy = posy;
                _this.w = w;
                _this.h = h;
                _this.pg = _this.pa.createGraphics(w + 1, h + 1);
                _this.userpg = _this.pa.createGraphics(w + 1, h + 1);
                ktbyte.gui.StageManager.getInstance().getDefaultStage().registerController(_this);
                ktbyte.gui.KTGUI.debug("Creation of [" + title + "] completed.\n");
                return _this;
            }
            Controller.prototype.updateGraphics = function () {
                this.ktgui.addDrawCallStackDebugMessage(this.title + ".updateGraphics()");
            };
            Controller.prototype.updateUserDefinedGraphics = function (userpg) {
                this.userpg = userpg;
            };
            Controller.prototype.drawUserDefinedGraphics = function () {
                /* add */ (this.ktgui.drawCallStack.push(this.title + ".drawUserDefinedGraphics()-\'") > 0);
                this.pg.beginDraw();
                this.pg.image(this.userpg, 0, 0);
                this.pg.endDraw();
            };
            Controller.prototype.drawControllers = function () {
                /* add */ (this.ktgui.drawCallStack.push(this.title + ".drawControllers()-\'") > 0);
                for (var index190 = 0; index190 < this.controllers.length; index190++) {
                    var child = this.controllers[index190];
                    {
                        child.updateGraphics();
                        child.draw();
                        this.pg.beginDraw();
                        /* add */ (this.ktgui.drawCallStack.push("pg.image(" + child.title + ").getGraphics: " + child.posx + ", " + child.posy + "-\'  ") > 0);
                        /* add */ (this.ktgui.drawCallStack.push("(" + child.title + ").apos:" + child.getAbsolutePosX() + ", " + child.getAbsolutePosY() + "-\'    ") > 0);
                        this.pg.image(child.getGraphics(), child.posx, child.posy);
                        this.pg.endDraw();
                    }
                }
            };
            /*private*/ Controller.prototype.drawGraphics = function () {
                if (this.parentController == null) {
                    /* add */ (this.ktgui.drawCallStack.push(this.title + ".drawGraphics()-\'") > 0);
                    this.pa.image(this.pg, this.posx, this.posy);
                }
            };
            Controller.prototype.draw = function () {
                if (this.isVisible) {
                    /* add */ (this.ktgui.drawCallStack.push(this.title + ".draw()|") > 0);
                    this.drawControllers();
                    this.drawUserDefinedGraphics();
                    this.drawGraphics();
                }
            };
            Controller.prototype.setParentController = function (controller) {
                this.parentController = controller;
            };
            Controller.prototype.setTitle = function (title) {
                this.title = title;
            };
            Controller.prototype.getInfo = function () {
                var _this = this;
                var info = { str: "", toString: function () { return this.str; } };
                /* append */ (function (sb) { sb.str = sb.str.concat("[" + ((_this.title != null) ? _this.title : "null") + "]"); return sb; })(info);
                /* append */ (function (sb) { sb.str = sb.str.concat(", pStage:" + ((_this.parentStage != null) ? _this.parentStage.getName() : "null")); return sb; })(info);
                /* append */ (function (sb) { sb.str = sb.str.concat(", pCtrlr:" + ((_this.parentController != null) ? _this.parentController.title : "null")); return sb; })(info);
                /* append */ (function (sb) { sb.str = sb.str.concat(", childs.sz():" + _this.controllers.length); return sb; })(info);
                /* append */ (function (sb) { sb.str = sb.str.concat(", isPrsd:" + _this.isPressed); return sb; })(info);
                /* append */ (function (sb) { sb.str = sb.str.concat(", isHvrd:" + _this.isHovered); return sb; })(info);
                /* append */ (function (sb) { sb.str = sb.str.concat(", isDrgd:" + _this.isDragged); return sb; })(info);
                /* append */ (function (sb) { sb.str = sb.str.concat(", rpsx:" + _this.posx); return sb; })(info);
                /* append */ (function (sb) { sb.str = sb.str.concat(", rpsy:" + _this.posy); return sb; })(info);
                return info.str;
            };
            Controller.prototype.getFullInfoList = function (level) {
                var recursyLevel = level;
                var list = ([]);
                var prefix = { str: "", toString: function () { return this.str; } };
                if (recursyLevel > 0) {
                    /* append */ (function (sb) { sb.str = sb.str.concat("\'"); return sb; })(prefix);
                    for (var i = 0; i < recursyLevel; i++) {
                        {
                            /* append */ (function (sb) { sb.str = sb.str.concat("-"); return sb; })(prefix);
                        }
                        ;
                    }
                }
                else {
                    /* append */ (function (sb) { sb.str = sb.str.concat("+"); return sb; })(prefix);
                }
                /* add */ (list.push(/* toString */ prefix.str + this.getInfo()) > 0);
                if (this.controllers.length > 0) {
                    recursyLevel++;
                    for (var index191 = 0; index191 < this.controllers.length; index191++) {
                        var child = this.controllers[index191];
                        {
                            /* addAll */ (function (l1, l2) { return l1.push.apply(l1, l2); })(list, child.getFullInfoList(recursyLevel));
                        }
                    }
                }
                return list;
            };
            Controller.prototype.getWidth = function () {
                return this.w;
            };
            Controller.prototype.setWidth = function (w) {
                this.w = w;
            };
            Controller.prototype.getHeight = function () {
                return this.h;
            };
            Controller.prototype.getAbsolutePosX = function () {
                var px = 0;
                if (this.parentController != null) {
                    px += this.parentController.getAbsolutePosX();
                }
                px += this.posx;
                return px;
            };
            Controller.prototype.getAbsolutePosY = function () {
                var py = 0;
                if (this.parentController != null) {
                    py += this.parentController.getAbsolutePosY();
                }
                py += this.posy;
                return py;
            };
            Controller.prototype.setHeight = function (h) {
                this.h = h;
            };
            Controller.prototype.setHoveredColor = function (c) {
                this.fgHoveredColor = c;
            };
            Controller.prototype.setPressedColor = function (c) {
                this.fgPressedColor = c;
            };
            Controller.prototype.setPassiveColor = function (c) {
                this.fgPassiveColor = c;
            };
            Controller.prototype.setBorderRoundings = function (r1, r2, r3, r4) {
                this.r1 = r1;
                this.r2 = r2;
                this.r3 = r3;
                this.r4 = r4;
            };
            Controller.prototype.setHandleFocus = function (val) {
                this.handleFocus = val;
            };
            Controller.prototype.getGraphics = function () {
                return this.pg;
            };
            Controller.prototype.addController$ktbyte_gui_Controller$int$int = function (child, hAlign, vAlign) {
                if (this.isActive) {
                    child.alignAbout$ktbyte_gui_Controller$int$int(this, hAlign, vAlign);
                    this.attachController(child);
                }
            };
            Controller.prototype.addController$ktbyte_gui_Controller$int$int$int = function (child, hAlign, vAlign, gap) {
                if (this.isActive) {
                    child.alignAbout$ktbyte_gui_Controller$int$int$int(this, hAlign, vAlign, gap);
                    this.attachController(child);
                }
            };
            Controller.prototype.addController = function (child, hAlign, vAlign, gap) {
                if (((child != null && child instanceof ktbyte.gui.Controller) || child === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && ((typeof gap === 'number') || gap === null)) {
                    return this.addController$ktbyte_gui_Controller$int$int$int(child, hAlign, vAlign, gap);
                }
                else if (((child != null && child instanceof ktbyte.gui.Controller) || child === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && gap === undefined) {
                    return this.addController$ktbyte_gui_Controller$int$int(child, hAlign, vAlign);
                }
                else
                    throw new Error('invalid overload');
            };
            Controller.prototype.positionAboutOtherController = function (controller, relativePosx, relativePosy) {
                this.posx = controller.posx + relativePosx;
                this.posy = controller.posy + relativePosy;
            };
            Controller.prototype.attachController = function (controller) {
                if (this.isActive) {
                    ktbyte.gui.KTGUI.debug("Attaching of [" + controller.title + "] of type <" + (function (c) { return c["__class"] ? c["__class"] : c["name"]; })(controller.constructor) + "> to [" + this.title + "] of type <" + (function (c) { return c["__class"] ? c["__class"] : c["name"]; })(this.constructor) + "> started.");
                    if (controller.parentController != null) {
                        var pc = controller.parentController;
                        pc.detachController(controller);
                    }
                    if (!(this.controllers.indexOf((controller)) >= 0)) {
                        ktbyte.gui.KTGUI.debug("\t[" + this.title + "].controllers.contains(" + controller.title + ") = " + (this.controllers.indexOf((controller)) >= 0));
                        /* add */ (this.controllers.push(controller) > 0);
                    }
                    ktbyte.gui.KTGUI.debug("\tSetting parent controller...");
                    controller.setParentController(this);
                    ktbyte.gui.KTGUI.debug("\t[" + controller.title + "].parentController is [" + controller.parentController.title + "]");
                    ktbyte.gui.StageManager.getInstance().unregisterControllerFromAllStages(controller);
                    ktbyte.gui.KTGUI.debug("Attaching of [" + controller.title + "] to [" + this.title + "] completed.\n");
                }
            };
            Controller.prototype.detachController = function (controller) {
                controller.parentController = null;
                /* remove */ (function (a) { var index = a.indexOf(controller); if (index >= 0) {
                    a.splice(index, 1);
                    return true;
                }
                else {
                    return false;
                } })(this.controllers);
            };
            Controller.prototype.detachAllControllers = function () {
                for (var index192 = 0; index192 < this.controllers.length; index192++) {
                    var controller = this.controllers[index192];
                    {
                        this.detachController(controller);
                    }
                }
            };
            Controller.prototype.closeParent = function () {
                if (this.parentController != null) {
                    this.parentController.close();
                }
                this.closeAllChildsRecursively();
            };
            Controller.prototype.closeAllChildsRecursively = function () {
                for (var index193 = 0; index193 < this.controllers.length; index193++) {
                    var childController = this.controllers[index193];
                    {
                        childController.closeAllChildsRecursively();
                        childController.close();
                    }
                }
            };
            Controller.prototype.close = function () {
                PApplet.println("Closing \'" + this.title + "\' controller.");
                this.isActive = false;
                this.ktgui.addToGarbage(this, this.pa.millis());
            };
            Controller.prototype.getPosx = function () {
                return this.posx;
            };
            Controller.prototype.setPosx = function (posx) {
                this.posx = posx;
            };
            Controller.prototype.getPosy = function () {
                return this.posy;
            };
            Controller.prototype.setPosy = function (posy) {
                this.posy = posy;
            };
            Controller.prototype.alignAboutCanvas$int$int = function (hAlign, vAlign) {
                this.alignAboutCanvas$int$int$int(hAlign, vAlign, ktbyte.gui.KTGUI.DEFAULT_ALIGN_GAP);
            };
            Controller.prototype.alignAboutCanvas$int$int$int = function (hAlign, vAlign, gap) {
                switch ((hAlign)) {
                    case PConstants.LEFT:
                        this.posx = gap;
                        break;
                    case PConstants.RIGHT:
                        this.posx = this.pa.width - this.w - gap;
                        break;
                    case PConstants.CENTER:
                        this.posx = ((this.pa.width * 0.5 - this.w * 0.5) | 0);
                        break;
                    default:
                        break;
                }
                switch ((vAlign)) {
                    case PConstants.TOP:
                        this.posy = gap;
                        break;
                    case PConstants.BOTTOM:
                        this.posy = this.pa.height - this.h - gap;
                        break;
                    case PConstants.CENTER:
                        this.posy = ((this.pa.height * 0.5 - this.h * 0.5) | 0);
                        break;
                    default:
                        break;
                }
            };
            /**
             * @param {number} hAlign
             * the horizontal alignment position
             * @param {number} vAlign
             * the vertical alignment position
             * @param {number} gap
             * the gap between the outer boundary of the PApplet canvas and
             * the side of the controller to be aligned.
             */
            Controller.prototype.alignAboutCanvas = function (hAlign, vAlign, gap) {
                if (((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && ((typeof gap === 'number') || gap === null)) {
                    return this.alignAboutCanvas$int$int$int(hAlign, vAlign, gap);
                }
                else if (((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && gap === undefined) {
                    return this.alignAboutCanvas$int$int(hAlign, vAlign);
                }
                else
                    throw new Error('invalid overload');
            };
            Controller.prototype.alignAbout$ktbyte_gui_Controller$int$int = function (controller, hAlign, vAlign) {
                this.alignAbout$ktbyte_gui_Controller$int$int$int(controller, hAlign, vAlign, ktbyte.gui.KTGUI.DEFAULT_ALIGN_GAP);
            };
            Controller.prototype.alignAbout$ktbyte_gui_Controller$int$int$int = function (controller, hAlign, vAlign, gap) {
                switch ((hAlign)) {
                    case PConstants.LEFT:
                        this.posx = gap;
                        break;
                    case PConstants.RIGHT:
                        this.posx = controller.w - this.w - gap;
                        break;
                    case PConstants.CENTER:
                        this.posx = ((controller.w * 0.5 - this.w * 0.5) | 0);
                        break;
                    default:
                        break;
                }
                switch ((vAlign)) {
                    case PConstants.TOP:
                        this.posy = gap;
                        break;
                    case PConstants.BOTTOM:
                        this.posy = controller.h - this.h - gap;
                        break;
                    case PConstants.CENTER:
                        this.posy = ((controller.h * 0.5 - this.h * 0.5) | 0);
                        break;
                    default:
                        break;
                }
            };
            /**
             * This method is used to place one controller <b>inside</b> the other (reference)
             * controller.
             * By 'aligning' we understand the process of changing the X and Y coordinates
             * so that the controller is placed inside and near one of the walls of the
             * reference controller.
             * The X and Y position, and width and height of the controller being used as
             * a reference are used to calculate the new position of the controller that is to
             * be aligned. The said values identify the 'boundary rectangle' of the reference
             * controller. The named constants LEFT, RIGHT, BOTTOM, TOP and CENTER are used to
             * identify the sides and the center of the bounding rectangle. The sides and center
             * of the reference rectangle are used for calculation of the relative
             * distances that are used to 'shift' the position of the controller to be
             * aligned. The direction of shifting is <b>inward</b> - i.e. the changing of relative
             * position is made <i>from the sides</i> of the bounding rectangle <i>to the
             * center</i> of the bounding rectangle.
             *
             * @param {ktbyte.gui.Controller} controller
             * the 'reference' controller.
             * @param {number} hAlign
             * the horizontal alignment direction. The following named constants can be used:</br>
             * <ul>
             * <li>
             * LEFT - the controller will be placed so that its <i>left</i> side will
             * 'stick' to the <i>left</i> side of the reference controller.</br>
             * </li>
             * <li>
             * RIGHT - the controller will be placed so that its <i>right</i> side will
             * 'stick' to the <i>right</i> side of the reference controller.</br>
             * </li>
             * <li>
             * CENTER - the controller will be placed so that its <i>center</i> will
             * 'stick' to the <i>center</i> of the reference controller.</br>
             * </li>
             * </ul>
             * @param {number} vAlign
             * the vertical alignment direction. The following named constants can be used:</br>
             * <ul>
             * <li>
             * TOP - the controller will be placed so that its <i>top</i> side will
             * 'stick' to the <i>top</i> side of the reference controller.</br>
             * </li>
             * <li>
             * BOTTOM - the controller will be placed so that its <i>bottom</i> side will
             * 'stick' to the <i>bottom</i> side of the reference controller.</br>
             * </li>
             * <li>
             * CENTER - the controller will be placed so that its <i>center</i> will
             * 'stick' to the <i>center</i> of the reference controller. </br>
             * </li>
             * </ul>
             * @param {number} gap
             * the gap between aligned sides. If the CENTER constant is used as hAlign
             * or vAlign argument then the gap will <b>not</b> be added to that direction.
             */
            Controller.prototype.alignAbout = function (controller, hAlign, vAlign, gap) {
                if (((controller != null && controller instanceof ktbyte.gui.Controller) || controller === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && ((typeof gap === 'number') || gap === null)) {
                    return this.alignAbout$ktbyte_gui_Controller$int$int$int(controller, hAlign, vAlign, gap);
                }
                else if (((controller != null && controller instanceof ktbyte.gui.Controller) || controller === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && gap === undefined) {
                    return this.alignAbout$ktbyte_gui_Controller$int$int(controller, hAlign, vAlign);
                }
                else
                    throw new Error('invalid overload');
            };
            Controller.prototype.stackAbout$ktbyte_gui_Controller$int$int = function (controller, direction, align) {
                this.stackAbout$ktbyte_gui_Controller$int$int$int(controller, direction, align, ktbyte.gui.KTGUI.DEFAULT_ALIGN_GAP);
            };
            Controller.prototype.stackAbout$ktbyte_gui_Controller$int$int$int = function (controller, direction, align, gap) {
                switch ((direction)) {
                    case PConstants.TOP:
                        this.posy = controller.posy - this.h - gap;
                        switch ((align)) {
                            case PConstants.LEFT:
                                this.posx = controller.posx + gap;
                                break;
                            case PConstants.RIGHT:
                                this.posx = controller.posx + controller.w - this.w - gap;
                                break;
                            case PConstants.CENTER:
                                this.posx = ((controller.posx + controller.w * 0.5) | 0) - ((this.w * 0.5) | 0);
                                break;
                            default:
                                break;
                        }
                        break;
                    case PConstants.BOTTOM:
                        this.posy = controller.posy + controller.h + gap;
                        switch ((align)) {
                            case PConstants.LEFT:
                                this.posx = controller.posx + gap;
                                break;
                            case PConstants.RIGHT:
                                this.posx = controller.posx + controller.w - this.w - gap;
                                break;
                            case PConstants.CENTER:
                                this.posx = ((controller.posx + controller.w * 0.5) | 0) - ((this.w * 0.5) | 0);
                                break;
                            default:
                                break;
                        }
                        break;
                    case PConstants.LEFT:
                        this.posx = controller.posx - this.w - gap;
                        switch ((align)) {
                            case PConstants.TOP:
                                this.posy = controller.posy + gap;
                                break;
                            case PConstants.BOTTOM:
                                this.posy = controller.posy + controller.h - this.h - gap;
                                break;
                            case PConstants.CENTER:
                                this.posy = ((controller.posy + controller.h * 0.5) | 0) - ((this.h * 0.5) | 0);
                                break;
                            default:
                                break;
                        }
                        break;
                    case PConstants.RIGHT:
                        this.posx = controller.posx + controller.w + gap;
                        switch ((align)) {
                            case PConstants.TOP:
                                this.posy = controller.posy + gap;
                                break;
                            case PConstants.BOTTOM:
                                this.posy = controller.posy + controller.h - this.h - gap;
                                break;
                            case PConstants.CENTER:
                                this.posy = ((controller.posy + controller.h * 0.5) | 0) - ((this.h * 0.5) | 0);
                                break;
                            default:
                                break;
                        }
                        break;
                    default:
                        break;
                }
            };
            /**
             * This method is used to position one controller <b>outside</b> the other
             * (reference) controller.
             * By 'stacking' we understand the process of changing the X and Y coordinates
             * so that the controller is placed outside and near one of the walls of the
             * reference controller.
             * The X and Y position, and width and height of the controller being used as
             * a reference are used to calculate the new position of the controller to
             * be aligned. The said values identify the 'boundary rectangle' of the reference
             * controller.
             * The named constants LEFT, RIGHT, BOTTOM and TOP are used to identify
             * the sides of the bounding rectangle. They are used for calculation of the
             * relative distances that are used to 'shift' the position of the controller to be
             * aligned. The direction of shifting is <b>outward</b> - i.e. the changing of
             * relative position is made from the sides of the bounding rectangle <i>to the
             * outward direction about</i> the bounding rectangle.
             *
             * @param <b>controller</b>
             * the 'reference' controller.
             * @param <b>direction</b>
             * the 'reference' alignment direction. The following named constants can be used:</br>
             * <ul>
             * <li>
             * LEFT - the controller will be placed so that its <i>rigth</i> side will
             * 'stick' to the <i>left</i> side of the reference controller.</br>
             * </li>
             * <li>
             * RIGHT - the controller will be placed so that its <i>left</i> side will
             * 'stick' to the <i>right</i> side of the reference controller.</br>
             * </li>
             * <li>
             * TOP - the controller will be placed so that its <i>bottom</i> side will
             * 'stick' to the <i>top</i> side of the reference controller.</br>
             * </li>
             * <li>
             * BOTTOM - the controller will be placed so that its <i>top</i> side will
             * 'stick' to the <i>bottom</i> side of the reference controller.</br>
             * </li>
             * </ul>
             * @param <b>align</b>
             * the 'orthogonal' alignment direction. </br>
             * The following named constants can be used:</br>
             * If the 'reference' alignment direction was chosen as LEFT or RIGTH, then the
             * 'orthogonal' direction can be set only fron one of the following constants:
             * <ul>
             * <li>
             * TOP - the controller will be placed so that its <i>top</i> side will be
             * aligned to the <i>top</i> side of the reference controller.</br>
             * </li>
             * <li>
             * BOTTOM - the controller will be placed so that its <i>bottom</i> side will be
             * aligned to the <i>bottom</i> side of the reference controller.</br>
             * </li>
             * <li>
             * CENTER - the controller will be placed so that its <i>center</i> will be
             * aligned to the <i>center</i> of the reference controller. </br>
             * </li>
             * </ul>
             *
             * If the 'reference' alignment direction was chosen as BOTTOM or TOP, then the
             * 'orthogonal' direction can be set only from one of the following constants:
             * <ul>
             * <li>
             * LEFT - the controller will be placed so that its <i>left</i> side will be
             * aligned to the <i>left</i> side of the reference controller.</br>
             * </li>
             * <li>
             * RIGHT - the controller will be placed so that its <i>right</i> side will be
             * aligned to the <i>right</i> side of the reference controller.</br>
             * </li>
             * <li>
             * CENTER - the controller will be placed so that its <i>center</i> will be
             * aligned to the <i>center</i> of the reference controller. </br>
             * </li>
             * </ul>
             *
             * @param <b>gap</b>
             * the gap of some length between the sides to be aligned. If the CENTER constant
             * is used as 'direction' or 'align' argument then the gap is <b>not</b> added
             * in that direction.
             * @param {ktbyte.gui.Controller} controller
             * @param {number} direction
             * @param {number} align
             * @param {number} gap
             */
            Controller.prototype.stackAbout = function (controller, direction, align, gap) {
                if (((controller != null && controller instanceof ktbyte.gui.Controller) || controller === null) && ((typeof direction === 'number') || direction === null) && ((typeof align === 'number') || align === null) && ((typeof gap === 'number') || gap === null)) {
                    return this.stackAbout$ktbyte_gui_Controller$int$int$int(controller, direction, align, gap);
                }
                else if (((controller != null && controller instanceof ktbyte.gui.Controller) || controller === null) && ((typeof direction === 'number') || direction === null) && ((typeof align === 'number') || align === null) && gap === undefined) {
                    return this.stackAbout$ktbyte_gui_Controller$int$int(controller, direction, align);
                }
                else
                    throw new Error('invalid overload');
            };
            Controller.prototype.isAnyChildPressed = function () {
                for (var index194 = 0; index194 < this.controllers.length; index194++) {
                    var child = this.controllers[index194];
                    {
                        if (child.isPressed) {
                            return true;
                        }
                        if (child.isAnyChildPressed()) {
                            return true;
                        }
                    }
                }
                return false;
            };
            /**
             *
             */
            Controller.prototype.processMouseMoved = function () {
                if (this.isActive) {
                    for (var index195 = 0; index195 < this.controllers.length; index195++) {
                        var child = this.controllers[index195];
                        {
                            child.processMouseMoved();
                        }
                    }
                    this.isHovered = this.isPointInside(this.pa.mouseX, this.pa.mouseY) ? true : false;
                    for (var index196 = 0; index196 < this.adapters.length; index196++) {
                        var adapter = this.adapters[index196];
                        {
                            adapter.onMouseMoved();
                        }
                    }
                }
            };
            /**
             *
             */
            Controller.prototype.processMousePressed = function () {
                if (this.isActive) {
                    if (this.isHovered) {
                        for (var index197 = 0; index197 < this.controllers.length; index197++) {
                            var child = this.controllers[index197];
                            {
                                child.processMousePressed();
                            }
                        }
                        if (this.isAnyChildPressed()) {
                            this.isPressed = this.isHovered = false;
                            return;
                        }
                        else {
                            this.isPressed = true;
                            Controller.selectedController = this;
                        }
                        for (var index198 = 0; index198 < this.adapters.length; index198++) {
                            var adapter = this.adapters[index198];
                            {
                                adapter.onMousePressed();
                            }
                        }
                    }
                }
            };
            /**
             *
             */
            Controller.prototype.processMouseReleased = function () {
                if (this.isActive) {
                    this.isPressed = false;
                    for (var index199 = 0; index199 < this.controllers.length; index199++) {
                        var child = this.controllers[index199];
                        {
                            child.processMouseReleased();
                        }
                    }
                    if (this.isHovered) {
                        for (var index200 = 0; index200 < this.adapters.length; index200++) {
                            var adapter = this.adapters[index200];
                            {
                                adapter.onMouseReleased();
                            }
                        }
                    }
                }
            };
            /**
             *
             */
            Controller.prototype.processMouseDragged = function () {
                if (this.isActive) {
                    for (var index201 = 0; index201 < this.controllers.length; index201++) {
                        var child = this.controllers[index201];
                        {
                            child.processMouseDragged();
                        }
                    }
                    if (this.isDragable) {
                        if (this.isPressed) {
                            this.posx += this.pa.mouseX - this.pa.pmouseX;
                            this.posy += this.pa.mouseY - this.pa.pmouseY;
                            for (var index202 = 0; index202 < this.adapters.length; index202++) {
                                var adapter = this.adapters[index202];
                                {
                                    adapter.onMouseDragged();
                                }
                            }
                        }
                    }
                }
            };
            /**
             *
             * @param {ProcessingMouseEvent} me
             */
            Controller.prototype.processMouseWheel = function (me) {
                if (this.isActive) {
                    for (var index203 = 0; index203 < this.controllers.length; index203++) {
                        var child = this.controllers[index203];
                        {
                            child.processMouseWheel(me);
                        }
                    }
                }
            };
            /**
             *
             */
            Controller.prototype.processKeyPressed = function () {
                if (this.isActive) {
                    for (var index204 = 0; index204 < this.controllers.length; index204++) {
                        var child = this.controllers[index204];
                        {
                            child.processKeyPressed();
                        }
                    }
                }
            };
            /**
             *
             */
            Controller.prototype.processKeyReleased = function () {
                if (this.isActive) {
                    for (var index205 = 0; index205 < this.controllers.length; index205++) {
                        var child = this.controllers[index205];
                        {
                            child.processKeyReleased();
                        }
                    }
                }
            };
            Controller.prototype.isSelected = function (controller) {
                return Controller.selectedController === controller;
            };
            /**
             *
             * @param {number} x
             * @param {number} y
             * @return {boolean}
             */
            Controller.prototype.isPointInside = function (x, y) {
                var isInside = false;
                if (this.isActive) {
                    if (x > this.getAbsolutePosX() && x < this.getAbsolutePosX() + this.w) {
                        if (y > this.getAbsolutePosY() && y < this.getAbsolutePosY() + this.h) {
                            isInside = true;
                        }
                    }
                }
                return isInside;
            };
            return Controller;
        }(ktbyte.gui.EventProcessor));
        Controller.selectedController = null;
        gui.Controller = Controller;
        Controller["__class"] = "ktbyte.gui.Controller";
        Controller["__interfaces"] = ["def.processing.core.PConstants"];
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        var ArrowButton = (function (_super) {
            __extends(ArrowButton, _super);
            function ArrowButton(ktgui, title, posx, posy, w, h, dir) {
                var _this = _super.call(this, ktgui, title, posx, posy, w, h) || this;
                if (_this.direction === undefined)
                    _this.direction = 0;
                _this.direction = dir;
                return _this;
            }
            /**
             *
             */
            ArrowButton.prototype.updateGraphics = function () {
                _super.prototype.updateGraphics.call(this);
                this.pg.beginDraw();
                this.pg.pushStyle();
                this.pg.stroke(0);
                if (this.isHovered && !this.isPressed) {
                    this.pg.fill(this.fgHoveredColor);
                }
                else if (this.isHovered && this.isPressed) {
                    this.pg.fill(this.fgPressedColor);
                }
                else {
                    this.pg.fill(this.fgPassiveColor);
                }
                if (this.isSelected(this)) {
                    this.pg.strokeWeight(2.0);
                }
                else {
                    this.pg.strokeWeight(1.0);
                }
                this.pg.rectMode(PConstants.CORNER);
                this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
                this.pg.pushMatrix();
                this.pg.translate(Math.fround(this.w * 0.5), Math.fround(this.h * 0.5));
                if (this.direction === PConstants.UP) {
                    this.pg.rotate(PConstants.PI);
                }
                else if (this.direction === PConstants.DOWN) {
                    this.pg.rotate(0);
                }
                else if (this.direction === PConstants.LEFT) {
                    this.pg.rotate(PConstants.HALF_PI);
                }
                else if (this.direction === PConstants.RIGHT) {
                    this.pg.rotate(Math.fround(PConstants.HALF_PI + PConstants.PI));
                }
                this.pg.strokeWeight(1.0);
                this.pg.line(Math.fround(-this.w * 0.4), Math.fround(-this.h * 0.4), 0, Math.fround(this.h * 0.4));
                this.pg.line(0, Math.fround(this.h * 0.4), Math.fround(this.w * 0.4), Math.fround(-this.h * 0.4));
                this.pg.popMatrix();
                this.pg.popStyle();
                this.pg.endDraw();
            };
            ArrowButton.prototype.setDirection = function (dir) {
                this.direction = dir;
            };
            return ArrowButton;
        }(ktbyte.gui.Controller));
        gui.ArrowButton = ArrowButton;
        ArrowButton["__class"] = "ktbyte.gui.ArrowButton";
        ArrowButton["__interfaces"] = ["def.processing.core.PConstants"];
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        var Bar = (function (_super) {
            __extends(Bar, _super);
            function Bar(ktgui, title, posx, posy, w, h) {
                return _super.call(this, ktgui, title, posx, posy, w, h) || this;
            }
            /**
             *
             */
            Bar.prototype.updateGraphics = function () {
                _super.prototype.updateGraphics.call(this);
                this.pg.beginDraw();
                this.pg.background(200, 200);
                this.pg.rectMode(PConstants.CORNER);
                this.pg.fill(this.bgPassiveColor);
                this.pg.stroke(0);
                this.pg.rectMode(PConstants.CORNER);
                if (this.isSelected(this)) {
                    this.pg.strokeWeight(3.0);
                }
                else {
                    this.pg.strokeWeight(1.0);
                }
                this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
                this.pg.fill(25);
                this.pg.textAlign(PConstants.LEFT, PConstants.CENTER);
                this.pg.textSize(Math.fround(this.h * 0.65));
                this.pg.text(this.title, 10, Math.fround(this.h * 0.5));
                this.pg.endDraw();
            };
            return Bar;
        }(ktbyte.gui.Controller));
        gui.Bar = Bar;
        Bar["__class"] = "ktbyte.gui.Bar";
        Bar["__interfaces"] = ["def.processing.core.PConstants"];
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        /**
         * This is a KTGUI component (controller).
         * This class extends the 'Controller' class.
         * The object of this class can be 'Pressed', 'Hovered', 'Released' and 'Dragged'.
         * @param {ktbyte.gui.KTGUI} ktgui
         * @param {string} title
         * @param {number} posx
         * @param {number} posy
         * @param {number} w
         * @param {number} h
         * @class
         * @extends ktbyte.gui.Controller
         */
        var Button = (function (_super) {
            __extends(Button, _super);
            function Button(ktgui, title, posx, posy, w, h) {
                return _super.call(this, ktgui, title, posx, posy, w, h) || this;
            }
            /**
             *
             */
            Button.prototype.updateGraphics = function () {
                _super.prototype.updateGraphics.call(this);
                this.pg.beginDraw();
                this.pg.rectMode(PConstants.CORNER);
                if (this.isHovered && !this.isPressed) {
                    this.pg.fill(this.fgHoveredColor);
                }
                else if (this.isHovered && this.isPressed) {
                    this.pg.fill(this.fgPressedColor);
                }
                else {
                    this.pg.fill(this.fgPassiveColor);
                }
                if (this.isSelected(this)) {
                    this.pg.strokeWeight(2.0);
                }
                else {
                    this.pg.strokeWeight(1.0);
                }
                this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
                this.pg.fill(255);
                this.pg.textAlign(PConstants.CENTER, PConstants.CENTER);
                this.pg.textSize(14);
                this.pg.text(this.title, ((this.w * 0.5) | 0), ((this.h * 0.5) | 0));
                this.pg.endDraw();
            };
            return Button;
        }(ktbyte.gui.Controller));
        gui.Button = Button;
        Button["__class"] = "ktbyte.gui.Button";
        Button["__interfaces"] = ["def.processing.core.PConstants"];
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        var Console = (function (_super) {
            __extends(Console, _super);
            function Console(ktgui, title, posx, posy, w, h) {
                var _this = _super.call(this, ktgui, title, posx, posy, w, h) || this;
                /*private*/ _this.inputTextColor = 16777215;
                /*private*/ _this.outputTextColor = 0;
                _this.inputBoxWidth = ((Math.fround(Console.INPUT_BOX_HEIGHT_PERCENTAGE * _this.h)) | 0);
                if (_this.inputBox === undefined)
                    _this.inputBox = null;
                if (_this.textArea === undefined)
                    _this.textArea = null;
                if (_this.scrollBar === undefined)
                    _this.scrollBar = null;
                if (_this.dict === undefined)
                    _this.dict = null;
                if (_this.lastVariableName === undefined)
                    _this.lastVariableName = null;
                _this.dict = ({});
                _this.createScrollableTextArea();
                _this.createInputBox();
                _this.createScrollBar();
                return _this;
            }
            /*private*/ Console.prototype.createScrollableTextArea = function () {
                this.textArea = new ktbyte.gui.ScrollableTextArea(this.ktgui, "sta:" + this.title, 0, 0, this.w - this.inputBoxWidth, this.h - this.inputBoxWidth);
                this.textArea.setBorderRoundings(Console.BOX_ROUNDING, 0, 0, 0);
                this.textArea.addEventAdapter(new Console.Console$0(this));
                this.attachController(this.textArea);
            };
            /*private*/ Console.prototype.createScrollBar = function () {
                this.scrollBar = new ktbyte.gui.ScrollBar(this.ktgui, "sb:" + this.title, this.w - this.inputBoxWidth, 0, this.inputBoxWidth, this.h - this.inputBoxWidth, 0, 100);
                this.scrollBar.addEventAdapter(new Console.Console$1(this));
                this.attachController(this.scrollBar);
            };
            /*private*/ Console.prototype.createInputBox = function () {
                this.inputBox = new ktbyte.gui.InputTextBox(this.ktgui, "ib:" + this.title, 0, this.h - this.inputBoxWidth, this.w, this.inputBoxWidth);
                this.inputBox.setHandleFocus(true);
                this.inputBox.setTextSize(16);
                this.inputBox.setBorderRoundings(0, 0, Console.BOX_ROUNDING, Console.BOX_ROUNDING);
                this.inputBox.addEventAdapter(new Console.Console$2(this));
                this.attachController(this.inputBox);
            };
            /**
             * Returns a stored value from the console's memory
             *
             * @param {string} name
             * the key of the stored entry
             *
             * @return {string} a stored value from the console's memory
             */
            Console.prototype.getValue = function (name) {
                return (function (m, k) { return m[k] === undefined ? null : m[k]; })(this.dict, name);
            };
            /**
             * Sets the name of the next console's entry
             *
             * @param {string} name
             * the key of the next stored entry
             */
            Console.prototype.readInput = function (name) {
                this.lastVariableName = name;
            };
            Console.prototype.setBorderRoundings = function (r1, r2, r3, r4) {
                this.textArea.setBorderRoundings(r1, 0, 0, 0);
                this.inputBox.setBorderRoundings(0, 0, r3, r4);
                this.scrollBar.setBorderRoundings(0, r2, 0, 0);
            };
            Console.prototype.enableLineStartMarks = function (val) {
                this.textArea.enableTextBlockStartMarks(val);
            };
            /*private*/ Console.prototype.handleConsoleInput = function () {
                var textInput = this.inputBox.getText();
                this.textArea.appendTextBlock$java_lang_String$int(textInput, this.inputTextColor);
                this.textArea.scrollToBottom();
                this.inputBox.setText("");
                /* put */ (this.dict[this.lastVariableName] = textInput);
                for (var index206 = 0; index206 < this.adapters.length; index206++) {
                    var adapter = this.adapters[index206];
                    {
                        adapter.onConsoleInput(textInput, this.lastVariableName);
                    }
                }
            };
            /*private*/ Console.prototype.updateScrollBar = function () {
                this.scrollBar.setRangeEnd(this.textArea.getMaximumAllowedPositionOfStartLine());
                this.scrollBar.setValue(((Math.fround(this.scrollBar.getRangeEnd() - this.getStartLinePosition())) | 0));
            };
            Console.prototype.setInputTextSize = function (size) {
                this.inputBox.setTextSize(size);
            };
            Console.prototype.setOutputTextSize = function (size) {
                this.textArea.setTextSize(size);
            };
            Console.prototype.writeOutput = function (textBlock) {
                this.textArea.appendTextBlock$java_lang_String$int(textBlock, this.outputTextColor);
                this.textArea.scrollToBottom();
            };
            Console.prototype.setInputFocused = function (value) {
                this.inputBox.setFocused(value);
            };
            Console.prototype.getStartLinePosition = function () {
                return this.textArea.getStartLinePosition();
            };
            Console.prototype.setInputTextColor = function (c) {
                this.inputTextColor = c;
            };
            Console.prototype.setOutputTextColor = function (c) {
                this.outputTextColor = c;
            };
            Console.prototype.getLine = function (index) {
                return this.textArea.getTextLine(index);
            };
            Console.prototype.getBlock = function (index) {
                return this.textArea.getTextBlock(index);
            };
            Console.prototype.getLineCount = function () {
                return this.textArea.getLineCount();
            };
            Console.prototype.getBlockCount = function () {
                return this.textArea.getBlockCount();
            };
            Console.prototype.getLastLine = function () {
                var textLine = "_NO_LINES_EXIST_YET_";
                if (this.getLineCount() > 0)
                    textLine = this.getLine(this.getLineCount() - 1);
                return textLine;
            };
            Console.prototype.getLastBlock = function () {
                var textBlock = "_NO_BLOCKS_EXIST_YET_";
                if (this.getBlockCount() > 0)
                    textBlock = this.getBlock(this.getBlockCount() - 1);
                return textBlock;
            };
            return Console;
        }(ktbyte.gui.Controller));
        Console.BOX_ROUNDING = 7;
        Console.INPUT_BOX_HEIGHT_PERCENTAGE = 0.1;
        gui.Console = Console;
        Console["__class"] = "ktbyte.gui.Console";
        Console["__interfaces"] = ["def.processing.core.PConstants"];
        (function (Console) {
            var Console$0 = (function (_super) {
                __extends(Console$0, _super);
                function Console$0(__parent) {
                    var _this = _super.call(this) || this;
                    _this.__parent = __parent;
                    return _this;
                }
                Console$0.prototype.onMouseWheel = function (count) {
                };
                return Console$0;
            }(ktbyte.gui.EventAdapter));
            Console.Console$0 = Console$0;
            var Console$1 = (function (_super) {
                __extends(Console$1, _super);
                function Console$1(__parent) {
                    var _this = _super.call(this) || this;
                    _this.__parent = __parent;
                    return _this;
                }
                Console$1.prototype.onMouseDragged = function () {
                };
                Console$1.prototype.onMousePressed = function () {
                };
                return Console$1;
            }(ktbyte.gui.EventAdapter));
            Console.Console$1 = Console$1;
            var Console$2 = (function (_super) {
                __extends(Console$2, _super);
                function Console$2(__parent) {
                    var _this = _super.call(this) || this;
                    _this.__parent = __parent;
                    return _this;
                }
                Console$2.prototype.onEnterKeyPressed = function () {
                    ktbyte.gui.KTGUI.debug("Processing input...");
                    this.__parent.handleConsoleInput();
                };
                return Console$2;
            }(ktbyte.gui.EventAdapter));
            Console.Console$2 = Console$2;
        })(Console = gui.Console || (gui.Console = {}));
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        var InputTextBox = (function (_super) {
            __extends(InputTextBox, _super);
            function InputTextBox(ktgui, title, posx, posy, w, h) {
                var _this = _super.call(this, ktgui, title, posx, posy, w, h) || this;
                if (_this.textInput === undefined)
                    _this.textInput = null;
                if (_this.textSize === undefined)
                    _this.textSize = 0;
                if (_this.textHeight === undefined)
                    _this.textHeight = 0;
                if (_this.padding === undefined)
                    _this.padding = 0;
                _this.textInput = "";
                _this.textSize = 18;
                _this.updateTextAttributes();
                return _this;
            }
            InputTextBox.prototype.updateGraphics = function () {
                _super.prototype.updateGraphics.call(this);
                this.updateTextBox();
                this.updateBlinkingCursorGraphics();
            };
            /*private*/ InputTextBox.prototype.updateTextBox = function () {
                this.pg.beginDraw();
                this.pg.pushStyle();
                if (this.isSelected(this)) {
                    this.pg.fill(this.bgPressedColor);
                    this.pg.stroke(50);
                    this.pg.strokeWeight(3.0);
                }
                else {
                    this.pg.fill(this.bgPassiveColor);
                    this.pg.stroke(0, 50, 0);
                    this.pg.strokeWeight(1.0);
                }
                this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
                this.pg.fill(0);
                this.pg.textSize(this.textSize);
                this.pg.textAlign(PConstants.LEFT, PConstants.CENTER);
                this.pg.text(this.getTrimmedInputText(), this.padding, Math.fround(this.h * 0.5));
                this.pg.popStyle();
                this.pg.endDraw();
            };
            /*private*/ InputTextBox.prototype.updateBlinkingCursorGraphics = function () {
                if (this.isSelected(this)) {
                    if (this.pa.frameCount % 60 < 30) {
                        this.pa.textSize(this.textSize);
                        var cursorX = PApplet.min(Math.fround(this.w - this.padding), Math.fround(this.padding + this.pa.textWidth(this.textInput)));
                        this.pg.beginDraw();
                        this.pg.stroke(0);
                        this.pg.strokeWeight(2);
                        this.pg.line(cursorX, Math.fround(Math.fround(this.h * 0.5) - Math.fround(this.textHeight * 0.5)), cursorX, Math.fround(Math.fround(this.h * 0.5) + Math.fround(this.textHeight * 0.5)));
                        this.pg.endDraw();
                    }
                }
            };
            /**
             *
             */
            InputTextBox.prototype.processMousePressed = function () {
                _super.prototype.processMousePressed.call(this);
                if (this.isSelected(this)) {
                    this.setText("");
                }
            };
            /**
             *
             */
            InputTextBox.prototype.processKeyPressed = function () {
                if (!this.isSelected(this)) {
                    return;
                }
                if (((String.fromCharCode(this.pa.key))).charCodeAt(0) === InputTextBox.BACKSPACE_ASCII_CODE && this.textInput.length > 0) {
                    this.textInput = this.textInput.substring(0, this.textInput.length - 1);
                }
                if (((String.fromCharCode(this.pa.key))).charCodeAt(0) === InputTextBox.ENTER_ASCII_CODE) {
                    for (var index207 = 0; index207 < this.adapters.length; index207++) {
                        var adapter = this.adapters[index207];
                        {
                            adapter.onEnterKeyPressed();
                        }
                    }
                }
                else if (((String.fromCharCode(this.pa.key))).charCodeAt(0) >= InputTextBox.BASIC_ASCII_LOWER_LIMIT && ((String.fromCharCode(this.pa.key))).charCodeAt(0) <= InputTextBox.BASIC_ASCII_UPPER_LIMIT) {
                    var b = ((String.fromCharCode(this.pa.key))).charCodeAt(0);
                    var ch = String.fromCharCode(b);
                    this.textInput += ch;
                }
            };
            InputTextBox.prototype.setFocused = function (value) {
            };
            /**
             * Sets the current text
             *
             * @param {string} text
             * The text that should be displayed inside the box
             */
            InputTextBox.prototype.setText = function (text) {
                this.textInput = text;
            };
            InputTextBox.prototype.getText = function () {
                return this.textInput;
            };
            /**
             * Sets the text size
             *
             * @param {number} textSize
             * The text size
             */
            InputTextBox.prototype.setTextSize = function (textSize) {
                this.pa.textSize(this.textSize);
                this.updateTextAttributes();
            };
            /*private*/ InputTextBox.prototype.updateTextAttributes = function () {
                this.padding = Math.fround(0.08 * this.h);
                this.textHeight = Math.fround(this.pa.textAscent() + this.pa.textDescent());
                while ((this.textHeight > Math.fround(Math.fround(this.h - this.padding) - this.padding))) {
                    {
                        this.textSize--;
                        this.textHeight = Math.fround(this.pa.textAscent() + this.pa.textDescent());
                    }
                }
                ;
            };
            /*private*/ InputTextBox.prototype.getTrimmedInputText = function () {
                var _this = this;
                var sb = { str: "", toString: function () { return this.str; } };
                var wrappedWidth = PApplet.floor(Math.fround(this.w - this.padding));
                this.pa.textSize(this.textSize);
                var _loop_1 = function (i) {
                    {
                        var chunkWidth = PApplet.ceil(this_1.pa.textWidth(/* toString */ sb.str + ":"));
                        if (chunkWidth >= wrappedWidth) {
                            return "break";
                        }
                        /* append */ (function (sb) { sb.str = sb.str.concat(_this.textInput.charAt(i)); return sb; })(sb);
                    }
                    ;
                };
                var this_1 = this;
                for (var i = this.textInput.length - 1; i >= 0; i--) {
                    var state_1 = _loop_1(i);
                    if (state_1 === "break")
                        break;
                }
                return this.reverse(/* toString */ sb.str);
            };
            /*private*/ InputTextBox.prototype.reverse = function (input) {
                var inChars = (function (s) { var a = []; while (s-- > 0)
                    a.push(null); return a; })(input.length);
                /* getChars */ (function (a, s, e, d, l) { d.splice.apply(d, [l, e - s].concat(a.substring(s, e).split(''))); })(input, 0, input.length, inChars, 0);
                var outChars = (function (s) { var a = []; while (s-- > 0)
                    a.push(null); return a; })(inChars.length);
                for (var i = inChars.length; i > 0; i--) {
                    {
                        outChars[i - 1] = inChars[inChars.length - i];
                    }
                    ;
                }
                return new String(outChars).toString().toString();
            };
            return InputTextBox;
        }(ktbyte.gui.Controller));
        InputTextBox.BACKSPACE_ASCII_CODE = 8;
        InputTextBox.ENTER_ASCII_CODE = 10;
        InputTextBox.BASIC_ASCII_LOWER_LIMIT = 32;
        InputTextBox.BASIC_ASCII_UPPER_LIMIT = 126;
        gui.InputTextBox = InputTextBox;
        InputTextBox["__class"] = "ktbyte.gui.InputTextBox";
        InputTextBox["__interfaces"] = ["def.processing.core.PConstants"];
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        /**
         * @extends ktbyte.gui.Controller
         * @class
         */
        var Pane = (function (_super) {
            __extends(Pane, _super);
            function Pane(ktgui, title, posx, posy, w, h) {
                return _super.call(this, ktgui, title, posx, posy, w, h) || this;
            }
            /**
             *
             */
            Pane.prototype.updateGraphics = function () {
                _super.prototype.updateGraphics.call(this);
                this.pg.beginDraw();
                this.pg.background(200, 100);
                if (this.isSelected(this)) {
                    this.pg.strokeWeight(2.0);
                }
                else {
                    this.pg.strokeWeight(1.0);
                }
                this.pg.rectMode(PConstants.CORNER);
                this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
                this.pg.noFill();
                this.pg.endDraw();
            };
            return Pane;
        }(ktbyte.gui.Controller));
        gui.Pane = Pane;
        Pane["__class"] = "ktbyte.gui.Pane";
        Pane["__interfaces"] = ["def.processing.core.PConstants"];
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        var Panel = (function (_super) {
            __extends(Panel, _super);
            function Panel(ktgui, title, posx, posy, w, h) {
                var _this = _super.call(this, ktgui, title, posx, posy, w, h) || this;
                if (_this.titleBar === undefined)
                    _this.titleBar = null;
                if (_this.pane === undefined)
                    _this.pane = null;
                _this.isDragable = true;
                _this.createTitleBar();
                _this.createPane();
                _this.setTitle(title);
                return _this;
            }
            /**
             *
             */
            Panel.prototype.updateGraphics = function () {
                _super.prototype.updateGraphics.call(this);
                this.pg.beginDraw();
                this.pg.background(200, 50);
                this.pg.stroke(0);
                this.pg.noFill();
                this.pg.rectMode(PConstants.CORNER);
                if (this.isSelected(this)) {
                    this.pg.strokeWeight(3.0);
                }
                else {
                    this.pg.strokeWeight(1.0);
                }
                this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
                this.pg.endDraw();
            };
            /**
             *
             */
            Panel.prototype.processMousePressed = function () {
                if (this.isActive) {
                    for (var index208 = 0; index208 < this.controllers.length; index208++) {
                        var child = this.controllers[index208];
                        {
                            child.processMousePressed();
                        }
                    }
                    this.isPressed = this.isHovered;
                    if (this.isPressed) {
                        for (var index209 = 0; index209 < this.adapters.length; index209++) {
                            var adapter = this.adapters[index209];
                            {
                                adapter.onMousePressed();
                            }
                        }
                    }
                }
            };
            /**
             *
             * @param {number} x
             * @param {number} y
             * @return {boolean}
             */
            Panel.prototype.isPointInside = function (x, y) {
                var isInside = false;
                if (this.isActive) {
                    if (x > this.getAbsolutePosX() && x < this.getAbsolutePosX() + this.w) {
                        if (y > this.getAbsolutePosY() && y < this.getAbsolutePosY() + this.titleBar.h) {
                            isInside = true;
                        }
                    }
                }
                return isInside;
            };
            /*private*/ Panel.prototype.createTitleBar = function () {
                this.titleBar = new ktbyte.gui.TitleBar(this.ktgui, "tb:" + this.title, 0, 0, this.w, ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH);
                this.titleBar.isDragable = false;
                this.attachController(this.titleBar);
            };
            /*private*/ Panel.prototype.createPane = function () {
                this.pane = new ktbyte.gui.Pane(this.ktgui, "pane:" + this.title, 0, ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH, this.w, this.h - ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH);
                this.pane.isDragable = false;
                this.attachController(this.pane);
            };
            Panel.prototype.addController$ktbyte_gui_Controller$int$int = function (child, hAlign, vAlign) {
                if (this.isActive) {
                    child.alignAbout$ktbyte_gui_Controller$int$int(this.pane, hAlign, vAlign);
                    this.pane.attachController(child);
                }
            };
            Panel.prototype.addController$ktbyte_gui_Controller$int$int$int = function (child, hAlign, vAlign, gap) {
                if (this.isActive) {
                    child.alignAbout$ktbyte_gui_Controller$int$int$int(this.pane, hAlign, vAlign, gap);
                    this.pane.attachController(child);
                }
            };
            /**
             * Add child controller to the 'internal' pane instead of adding it to 'this' window
             * @param {ktbyte.gui.Controller} child
             * @param {number} hAlign
             * @param {number} vAlign
             * @param {number} gap
             */
            Panel.prototype.addController = function (child, hAlign, vAlign, gap) {
                if (((child != null && child instanceof ktbyte.gui.Controller) || child === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && ((typeof gap === 'number') || gap === null)) {
                    return this.addController$ktbyte_gui_Controller$int$int$int(child, hAlign, vAlign, gap);
                }
                else if (((child != null && child instanceof ktbyte.gui.Controller) || child === null) && ((typeof hAlign === 'number') || hAlign === null) && ((typeof vAlign === 'number') || vAlign === null) && gap === undefined) {
                    return this.addController$ktbyte_gui_Controller$int$int(child, hAlign, vAlign);
                }
                else
                    throw new Error('invalid overload');
            };
            Panel.prototype.getPane = function () {
                return this.pane;
            };
            return Panel;
        }(ktbyte.gui.Controller));
        gui.Panel = Panel;
        Panel["__class"] = "ktbyte.gui.Panel";
        Panel["__interfaces"] = ["def.processing.core.PConstants"];
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        var ScrollableTextArea = (function (_super) {
            __extends(ScrollableTextArea, _super);
            function ScrollableTextArea(ktgui, title, posx, posy, w, h) {
                var _this = _super.call(this, ktgui, title, posx, posy, w, h) || this;
                /*private*/ _this.textSize = 14;
                /*private*/ _this.padding = 6;
                /*private*/ _this.textLines = ([]);
                /*private*/ _this.textBlocks = ([]);
                /*private*/ _this.startLineNumber = 0;
                if (_this.enableLineStartMarks === undefined)
                    _this.enableLineStartMarks = false;
                _this.setPadding(Math.fround(_this.getTextSize() * 0.75));
                return _this;
            }
            /**
             *
             */
            ScrollableTextArea.prototype.updateGraphics = function () {
                _super.prototype.updateGraphics.call(this);
                this.updateTextAreaGraphics();
            };
            ScrollableTextArea.prototype.updateTextAreaGraphics = function () {
                this.pg.beginDraw();
                this.pg.pushStyle();
                if (this.isSelected(this)) {
                    this.pg.fill(this.bgPressedColor);
                    this.pg.stroke(50);
                    this.pg.strokeWeight(3.0);
                }
                else {
                    this.pg.fill(this.bgPassiveColor);
                    this.pg.stroke(0, 50, 0);
                    this.pg.strokeWeight(1.0);
                }
                this.pg.rect(0, 0, this.w, this.h, this.r1, this.r2, this.r3, this.r4);
                var calculatedEndLineNumber = PApplet.min(/* size */ this.textLines.length - 1, this.startLineNumber + this.getMaxLinesToDisplay());
                for (var i = 0; i <= calculatedEndLineNumber - this.startLineNumber; i++) {
                    {
                        var line = this.textLines[i + this.startLineNumber];
                        this.pg.fill(line.textColor);
                        this.pg.textAlign(PConstants.LEFT, PConstants.BOTTOM);
                        this.pg.textSize(this.textSize);
                        this.pg.text(line.content, this.padding, Math.fround(((this.padding * 0.5) | 0) + Math.fround((i + 1) * this.getTextHeight())));
                        if (line.isHead && this.enableLineStartMarks) {
                            this.pg.strokeWeight(3);
                            this.pg.point(Math.fround(this.padding - 5), ((this.padding * 0.5 + Math.fround((i + 1) * this.getTextHeight()) - this.getTextHeight() * 0.5) | 0));
                        }
                    }
                    ;
                }
                this.pg.popStyle();
                this.pg.endDraw();
            };
            /**
             *
             * @param {ProcessingMouseEvent} me
             */
            ScrollableTextArea.prototype.processMouseWheel = function (me) {
                this.mouseScrolled(me.getCount());
                for (var index210 = 0; index210 < this.adapters.length; index210++) {
                    var adapter = this.adapters[index210];
                    {
                        adapter.onMouseWheel(me.getCount());
                    }
                }
            };
            ScrollableTextArea.prototype.mouseScrolled = function (mouseWheelDelta) {
                if (this.isSelected(this)) {
                    if (mouseWheelDelta < 0) {
                        if (this.startLineNumber > 0) {
                            this.decrementStartLine();
                        }
                    }
                    else if (mouseWheelDelta > 0) {
                        if (this.startLineNumber < this.getMaximumAllowedPositionOfStartLine()) {
                            this.incrementStartLine();
                        }
                    }
                }
            };
            ScrollableTextArea.prototype.incrementStartLine = function () {
                if (this.startLineNumber < this.getMaximumAllowedPositionOfStartLine()) {
                    this.startLineNumber++;
                }
            };
            ScrollableTextArea.prototype.getMaximumAllowedPositionOfStartLine = function () {
                return this.textLines.length - this.getMaxLinesToDisplay();
            };
            ScrollableTextArea.prototype.decrementStartLine = function () {
                if (this.startLineNumber > 0) {
                    this.startLineNumber--;
                }
            };
            ScrollableTextArea.prototype.scrollToTop = function () {
                while ((this.startLineNumber > 0)) {
                    {
                        this.startLineNumber--;
                    }
                }
                ;
            };
            ScrollableTextArea.prototype.scrollToBottom = function () {
                while ((this.startLineNumber < this.getMaximumAllowedPositionOfStartLine())) {
                    {
                        this.startLineNumber++;
                    }
                }
                ;
            };
            ScrollableTextArea.prototype.scrollToPosition = function (lineNumber) {
                if (lineNumber < 0 || lineNumber >= this.getMaximumAllowedPositionOfStartLine()) {
                    ktbyte.gui.KTGUI.debug("lineNumber[" + lineNumber + "] is out of range during \'scrollToLine\' call.");
                    return;
                }
                if (lineNumber > this.startLineNumber) {
                    while ((this.startLineNumber < lineNumber && this.startLineNumber < this.getMaximumAllowedPositionOfStartLine())) {
                        {
                            this.startLineNumber++;
                        }
                    }
                    ;
                }
                else if (lineNumber < this.startLineNumber) {
                    while ((this.startLineNumber > lineNumber && this.startLineNumber > 0)) {
                        {
                            this.startLineNumber--;
                        }
                    }
                    ;
                }
            };
            ScrollableTextArea.prototype.getTextLines = function () {
                return this.textLines;
            };
            ScrollableTextArea.prototype.getTextBlocks = function () {
                return this.textBlocks;
            };
            ScrollableTextArea.prototype.getPadding = function () {
                return this.padding;
            };
            ScrollableTextArea.prototype.setPadding = function (padding) {
                this.padding = padding;
                this.updateWrappedLines();
            };
            ScrollableTextArea.prototype.getTextSize = function () {
                return this.textSize;
            };
            ScrollableTextArea.prototype.setTextSize = function (textSize) {
                this.textSize = textSize;
                this.updateWrappedLines();
            };
            ScrollableTextArea.prototype.appendTextBlock$java_lang_String = function (text) {
                var textBlock = new ScrollableTextArea.TextBlock(this, text);
                /* add */ (this.textBlocks.push(textBlock) > 0);
                textBlock.appendAsWrappedLines(this.textSize);
            };
            ScrollableTextArea.prototype.appendTextBlock$java_lang_String$int = function (text, color) {
                var textBlock = new ScrollableTextArea.TextBlock(this, text, color);
                /* add */ (this.textBlocks.push(textBlock) > 0);
                textBlock.appendAsWrappedLines(this.textSize);
            };
            ScrollableTextArea.prototype.appendTextBlock = function (text, color) {
                if (((typeof text === 'string') || text === null) && ((typeof color === 'number') || color === null)) {
                    return this.appendTextBlock$java_lang_String$int(text, color);
                }
                else if (((typeof text === 'string') || text === null) && color === undefined) {
                    return this.appendTextBlock$java_lang_String(text);
                }
                else
                    throw new Error('invalid overload');
            };
            ScrollableTextArea.prototype.updateWrappedLines = function () {
                this.textLines = ([]);
                for (var index211 = 0; index211 < this.textBlocks.length; index211++) {
                    var block = this.textBlocks[index211];
                    {
                        block.appendAsWrappedLines(this.textSize);
                    }
                }
            };
            ScrollableTextArea.prototype.getMaxLinesToDisplay = function () {
                return PApplet.floor(Math.fround((Math.fround(Math.fround(this.h - this.padding) - this.padding)) / this.getTextHeight()));
            };
            ScrollableTextArea.prototype.getTextHeight = function () {
                this.pa.textSize(this.textSize);
                return Math.fround(this.pa.textAscent() + this.pa.textDescent());
            };
            ScrollableTextArea.prototype.getStartLinePosition = function () {
                return this.startLineNumber;
            };
            ScrollableTextArea.prototype.enableTextBlockStartMarks = function (val) {
                this.enableLineStartMarks = val;
            };
            ScrollableTextArea.prototype.getTextLine = function (index) {
                var textLine = "-= textLine: out of range =-";
                if (this.textLines.length - index > 0) {
                    textLine = this.textLines[index].content;
                }
                return textLine;
            };
            ScrollableTextArea.prototype.getTextBlock = function (index) {
                var textBlock = "-= textBlock: out of range =-";
                if (this.textBlocks.length - index > 0) {
                    textBlock = this.textBlocks[index].content;
                }
                return textBlock;
            };
            ScrollableTextArea.prototype.getLineCount = function () {
                return this.textLines.length;
            };
            ScrollableTextArea.prototype.getBlockCount = function () {
                return this.textBlocks.length;
            };
            return ScrollableTextArea;
        }(ktbyte.gui.Controller));
        gui.ScrollableTextArea = ScrollableTextArea;
        ScrollableTextArea["__class"] = "ktbyte.gui.ScrollableTextArea";
        ScrollableTextArea["__interfaces"] = ["def.processing.core.PConstants"];
        (function (ScrollableTextArea) {
            var TextLine = (function () {
                function TextLine(__parent, content, textColor, isHead) {
                    var _this = this;
                    if (((typeof content === 'string') || content === null) && ((typeof textColor === 'number') || textColor === null) && ((typeof isHead === 'boolean') || isHead === null)) {
                        var __args = Array.prototype.slice.call(arguments, [1]);
                        if (this.content === undefined)
                            this.content = null;
                        if (this.isHead === undefined)
                            this.isHead = false;
                        this.textColor = __parent.pa.color(0, 10, 30);
                        this.__parent = __parent;
                        if (this.content === undefined)
                            this.content = null;
                        this.textColor = __parent.pa.color(0, 10, 30);
                        if (this.isHead === undefined)
                            this.isHead = false;
                        (function () {
                            _this.content = content;
                            _this.isHead = isHead;
                            _this.textColor = textColor;
                        })();
                    }
                    else if (((typeof content === 'string') || content === null) && ((typeof textColor === 'boolean') || textColor === null) && isHead === undefined) {
                        var __args = Array.prototype.slice.call(arguments, [1]);
                        var isHead_1 = __args[1];
                        if (this.content === undefined)
                            this.content = null;
                        if (this.isHead === undefined)
                            this.isHead = false;
                        this.textColor = __parent.pa.color(0, 10, 30);
                        this.__parent = __parent;
                        if (this.content === undefined)
                            this.content = null;
                        this.textColor = __parent.pa.color(0, 10, 30);
                        if (this.isHead === undefined)
                            this.isHead = false;
                        (function () {
                            _this.content = content;
                            _this.isHead = isHead_1;
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                return TextLine;
            }());
            ScrollableTextArea.TextLine = TextLine;
            TextLine["__class"] = "ktbyte.gui.ScrollableTextArea.TextLine";
            var TextBlock = (function () {
                function TextBlock(__parent, content, textColor) {
                    var _this = this;
                    if (((typeof content === 'string') || content === null) && ((typeof textColor === 'number') || textColor === null)) {
                        var __args = Array.prototype.slice.call(arguments, [1]);
                        if (this.content === undefined)
                            this.content = null;
                        if (this.isHeadAlreadyMarked === undefined)
                            this.isHeadAlreadyMarked = false;
                        this.textColor = __parent.pa.color(0);
                        this.__parent = __parent;
                        if (this.content === undefined)
                            this.content = null;
                        if (this.isHeadAlreadyMarked === undefined)
                            this.isHeadAlreadyMarked = false;
                        this.textColor = __parent.pa.color(0);
                        (function () {
                            _this.content = content.trim().replace(new RegExp("\n\t\r", 'g'), " ");
                            _this.textColor = textColor;
                        })();
                    }
                    else if (((typeof content === 'string') || content === null) && textColor === undefined) {
                        var __args = Array.prototype.slice.call(arguments, [1]);
                        if (this.content === undefined)
                            this.content = null;
                        if (this.isHeadAlreadyMarked === undefined)
                            this.isHeadAlreadyMarked = false;
                        this.textColor = __parent.pa.color(0);
                        this.__parent = __parent;
                        if (this.content === undefined)
                            this.content = null;
                        if (this.isHeadAlreadyMarked === undefined)
                            this.isHeadAlreadyMarked = false;
                        this.textColor = __parent.pa.color(0);
                        (function () {
                            _this.content = content.trim().replace(new RegExp("\n\t\r", 'g'), " ");
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                TextBlock.prototype.appendAsWrappedLines = function (_textSize) {
                    var _this = this;
                    this.isHeadAlreadyMarked = false;
                    var sb = { str: "", toString: function () { return this.str; } };
                    var wrappedWidth = PApplet.floor(Math.fround(Math.fround(this.__parent.w - this.__parent.padding) - this.__parent.padding));
                    this.__parent.pa.textSize(_textSize);
                    var _loop_2 = function (i) {
                        {
                            var chunkWidth = PApplet.ceil(this_2.__parent.pa.textWidth(/* toString */ sb.str));
                            if (chunkWidth >= wrappedWidth) {
                                this_2.addWrappedLine(sb);
                                sb = { str: "", toString: function () { return this.str; } };
                            }
                            /* append */ (function (sb) { sb.str = sb.str.concat(_this.content.charAt(i)); return sb; })(sb);
                        }
                        ;
                    };
                    var this_2 = this;
                    for (var i = 0; i < this.content.length; i++) {
                        _loop_2(i);
                    }
                    this.addWrappedLine(sb);
                };
                TextBlock.prototype.addWrappedLine = function (sb) {
                    if (!this.isHeadAlreadyMarked) {
                        /* add */ (this.__parent.textLines.push(new ScrollableTextArea.TextLine(this.__parent, /* toString */ sb.str, this.textColor, true)) > 0);
                        this.isHeadAlreadyMarked = true;
                    }
                    else {
                        /* add */ (this.__parent.textLines.push(new ScrollableTextArea.TextLine(this.__parent, /* toString */ sb.str, this.textColor, false)) > 0);
                    }
                };
                return TextBlock;
            }());
            ScrollableTextArea.TextBlock = TextBlock;
            TextBlock["__class"] = "ktbyte.gui.ScrollableTextArea.TextBlock";
        })(ScrollableTextArea = gui.ScrollableTextArea || (gui.ScrollableTextArea = {}));
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        var ScrollBar = (function (_super) {
            __extends(ScrollBar, _super);
            function ScrollBar(ktgui, title, posx, posy, w, h, sr, er) {
                var _this = _super.call(this, ktgui, title, posx, posy, w, h) || this;
                if (_this.backwardButton === undefined)
                    _this.backwardButton = null;
                if (_this.forwardButton === undefined)
                    _this.forwardButton = null;
                if (_this.slider === undefined)
                    _this.slider = null;
                _this.createButtons();
                _this.createSlider(sr, er);
                _this.setBorderRoundings(5, 5, 5, 5);
                return _this;
            }
            /**
             *
             */
            ScrollBar.prototype.updateGraphics = function () {
                _super.prototype.updateGraphics.call(this);
            };
            /**
             *
             * @param {number} r1
             * @param {number} r2
             * @param {number} r3
             * @param {number} r4
             */
            ScrollBar.prototype.setBorderRoundings = function (r1, r2, r3, r4) {
                if (this.w > this.h) {
                    this.backwardButton.setBorderRoundings(r1, 0, 0, r4);
                    this.forwardButton.setBorderRoundings(0, r2, r3, 0);
                }
                else {
                    this.forwardButton.setBorderRoundings(r1, r2, 0, 0);
                    this.backwardButton.setBorderRoundings(0, 0, r3, r4);
                }
            };
            /*private*/ ScrollBar.prototype.createButtons = function () {
                if (this.w > this.h) {
                    this.backwardButton = new ktbyte.gui.ArrowButton(this.ktgui, "bckwrdBtn:" + this.title, 0, 0, this.h, this.h, PConstants.LEFT);
                    this.forwardButton = new ktbyte.gui.ArrowButton(this.ktgui, "frwrdBtn:" + this.title, this.w - this.h, 0, this.h, this.h, PConstants.RIGHT);
                }
                else {
                    this.forwardButton = new ktbyte.gui.ArrowButton(this.ktgui, "frwrdBtn:" + this.title, 0, 0, this.w, this.w, PConstants.UP);
                    this.backwardButton = new ktbyte.gui.ArrowButton(this.ktgui, "bckwrdBtn:" + this.title, 0, this.h - this.w, this.w, this.w, PConstants.DOWN);
                }
                this.backwardButton.addEventAdapter(new ScrollBar.ScrollBar$0(this));
                this.forwardButton.addEventAdapter(new ScrollBar.ScrollBar$1(this));
                this.backwardButton.isDragable = false;
                this.forwardButton.isDragable = false;
                this.attachController(this.backwardButton);
                this.attachController(this.forwardButton);
            };
            /*private*/ ScrollBar.prototype.createSlider = function (sr, er) {
                if (this.w > this.h) {
                    this.slider = new ktbyte.gui.Slider(this.ktgui, "hSlider:" + this.title, this.backwardButton.w, 0, this.w - this.backwardButton.w - this.forwardButton.w, this.h, sr, er);
                }
                else {
                    this.slider = new ktbyte.gui.Slider(this.ktgui, "vSlider:" + this.title, 0, this.backwardButton.h, this.w, this.h - this.backwardButton.h - this.forwardButton.h, sr, er);
                }
                this.slider.isDragable = false;
                this.slider.setValue(0);
                this.slider.setRounding(0);
                this.slider.setIsValueVisible(false);
                this.slider.addEventAdapter(new ScrollBar.ScrollBar$2(this));
                this.attachController(this.slider);
            };
            ScrollBar.prototype.getValue = function () {
                return this.slider.getValue();
            };
            ScrollBar.prototype.setValue = function (val) {
                this.slider.setValue(val);
            };
            ScrollBar.prototype.getHandlePos = function () {
                return this.slider.getHandlePos();
            };
            ScrollBar.prototype.setHandlePos = function (pos) {
                this.slider.setHandlePos(pos);
            };
            ScrollBar.prototype.setHandleType = function (handleType) {
                this.slider.setHandleType(handleType);
            };
            ScrollBar.prototype.setHandleStep = function (step) {
                this.slider.setHandleValue(step);
            };
            ScrollBar.prototype.getHandleStep = function () {
                return this.slider.getValueStep();
            };
            ScrollBar.prototype.getIsValueVisible = function () {
                return this.slider.getIsValueVisible();
            };
            ScrollBar.prototype.setIsValueVisible = function (visible) {
                this.slider.setIsValueVisible(visible);
            };
            ScrollBar.prototype.getRangeStart = function () {
                return this.slider.getRangeStart();
            };
            ScrollBar.prototype.setRangeStart = function (rangeStart) {
                this.slider.setRangeStart(rangeStart);
            };
            ScrollBar.prototype.getRangeEnd = function () {
                return this.slider.getRangeEnd();
            };
            ScrollBar.prototype.setRangeEnd = function (rangeEnd) {
                this.slider.setRangeEnd(rangeEnd);
            };
            ScrollBar.prototype.setRounding = function (n) {
                this.slider.setRounding(n);
            };
            return ScrollBar;
        }(ktbyte.gui.Controller));
        gui.ScrollBar = ScrollBar;
        ScrollBar["__class"] = "ktbyte.gui.ScrollBar";
        ScrollBar["__interfaces"] = ["def.processing.core.PConstants"];
        (function (ScrollBar) {
            var ScrollBar$0 = (function (_super) {
                __extends(ScrollBar$0, _super);
                function ScrollBar$0(__parent) {
                    var _this = _super.call(this) || this;
                    _this.__parent = __parent;
                    return _this;
                }
                ScrollBar$0.prototype.onMousePressed = function () {
                    this.__parent.slider.decrementValue();
                };
                return ScrollBar$0;
            }(ktbyte.gui.EventAdapter));
            ScrollBar.ScrollBar$0 = ScrollBar$0;
            var ScrollBar$1 = (function (_super) {
                __extends(ScrollBar$1, _super);
                function ScrollBar$1(__parent) {
                    var _this = _super.call(this) || this;
                    _this.__parent = __parent;
                    return _this;
                }
                ScrollBar$1.prototype.onMousePressed = function () {
                    this.__parent.slider.incrementValue();
                };
                return ScrollBar$1;
            }(ktbyte.gui.EventAdapter));
            ScrollBar.ScrollBar$1 = ScrollBar$1;
            var ScrollBar$2 = (function (_super) {
                __extends(ScrollBar$2, _super);
                function ScrollBar$2(__parent) {
                    var _this = _super.call(this) || this;
                    _this.__parent = __parent;
                    return _this;
                }
                ScrollBar$2.prototype.onMouseDragged = function () {
                    for (var index212 = 0; index212 < this.__parent.adapters.length; index212++) {
                        var adapter = this.__parent.adapters[index212];
                        {
                            adapter.onMouseDragged();
                        }
                    }
                };
                return ScrollBar$2;
            }(ktbyte.gui.EventAdapter));
            ScrollBar.ScrollBar$2 = ScrollBar$2;
        })(ScrollBar = gui.ScrollBar || (gui.ScrollBar = {}));
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        /**
         * @extends ktbyte.gui.Controller
         * @class
         */
        var Slider = (function (_super) {
            __extends(Slider, _super);
            function Slider(ktgui, title, posx, posy, w, h, sr, er) {
                var _this = _super.call(this, ktgui, title, posx, posy, w, h) || this;
                /*private*/ _this.handleType = Slider.HANDLE_TYPE_EXPANDED;
                /*private*/ _this.handleSize = ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH;
                /*private*/ _this.handlePos = 0;
                /*private*/ _this.rangeStart = 0;
                /*private*/ _this.rangeEnd = 100;
                /*private*/ _this.value = _this.rangeStart;
                /*private*/ _this.valueStep = 1;
                /*private*/ _this.roundingTemplate = 10;
                /*private*/ _this.isValueVisible = true;
                _this.rangeStart = sr;
                _this.rangeEnd = er;
                _this.setHandleType(Slider.HANDLE_TYPE_EXPANDED);
                _this.updateHandlePositionFromValue();
                _this.updateHandlePositionFromMouse();
                _this.updateValueFromHandlePosition();
                return _this;
            }
            /**
             *
             */
            Slider.prototype.updateGraphics = function () {
                _super.prototype.updateGraphics.call(this);
                if (this.handleType === Slider.HANDLE_TYPE_CENTERED) {
                    this.drawCenteredHandle();
                }
                else if (this.handleType === Slider.HANDLE_TYPE_EXPANDED) {
                    this.drawExpandedHandle();
                }
                else {
                    this.drawExpandedHandle();
                }
            };
            /*private*/ Slider.prototype.drawExpandedHandle = function () {
                this.pg.beginDraw();
                this.pg.fill(this.isHovered ? ktbyte.gui.KTGUI.COLOR_BG_HOVERED : ktbyte.gui.KTGUI.COLOR_BG_PASSIVE);
                this.pg.rectMode(PConstants.CORNER);
                this.pg.rect(0, 0, this.w, this.h);
                this.pg.fill(this.isHovered ? ktbyte.gui.KTGUI.COLOR_FG_HOVERED : ktbyte.gui.KTGUI.COLOR_FG_PASSIVE);
                if (this.w > this.h) {
                    this.pg.rect(0, 0, this.handlePos, this.h);
                }
                else {
                    this.pg.rect(0, Math.fround(this.h - this.handlePos), this.w, this.handlePos);
                }
                if (this.isValueVisible) {
                    this.pg.fill(0);
                    this.pg.textAlign(PConstants.LEFT, PConstants.CENTER);
                    if (this.w > this.h) {
                        this.pg.text(PApplet.str(this.value), 10, Math.fround(this.h * 0.5));
                        this.pg.textAlign(PConstants.LEFT, PConstants.BOTTOM);
                        this.pg.text(this.title, 10, -2);
                    }
                    else {
                        this.pg.text(PApplet.str(this.value), 1, Math.fround(this.h * 0.5));
                    }
                }
                this.pg.endDraw();
            };
            /*private*/ Slider.prototype.drawCenteredHandle = function () {
                this.pg.beginDraw();
                this.pg.fill(this.isHovered ? ktbyte.gui.KTGUI.COLOR_BG_HOVERED : ktbyte.gui.KTGUI.COLOR_BG_PASSIVE);
                this.pg.rectMode(PConstants.CORNER);
                this.pg.rect(0, 0, this.w, this.h);
                this.pg.fill(this.isHovered ? ktbyte.gui.KTGUI.COLOR_FG_HOVERED : ktbyte.gui.KTGUI.COLOR_FG_PASSIVE);
                this.pg.rectMode(PConstants.CENTER);
                var handleOffset = ((Math.fround(this.handleSize * 0.5)) | 0);
                if (this.w > this.h) {
                    var correctedHandlePos = (PApplet.constrain(this.handlePos, handleOffset, this.w - handleOffset) | 0);
                    this.pg.rect(correctedHandlePos, Math.fround(this.h * 0.5), this.handleSize, this.h);
                }
                else {
                    var correctedHandlePos = (PApplet.constrain(this.handlePos, handleOffset, this.h - handleOffset) | 0);
                    this.pg.rect(Math.fround(this.w * 0.5), this.h - correctedHandlePos, this.w, this.handleSize);
                }
                if (this.isValueVisible) {
                    this.pg.fill(0);
                    this.pg.textAlign(PConstants.LEFT, PConstants.CENTER);
                    if (this.w > this.h) {
                        this.pg.text(PApplet.str(this.value), 10, Math.fround(this.h * 0.5));
                        this.pg.textAlign(PConstants.LEFT, PConstants.BOTTOM);
                        this.pg.text(this.title, 10, -2);
                    }
                    else {
                        this.pg.text(PApplet.str(this.value), 1, Math.fround(this.h * 0.5));
                    }
                }
                this.pg.endDraw();
            };
            Slider.prototype.addEventAdapter = function (adapter) {
                /* add */ (this.adapters.push(adapter) > 0);
            };
            Slider.prototype.getValue = function () {
                return this.value;
            };
            Slider.prototype.setValue = function (val) {
                if (val >= this.rangeStart && val <= this.rangeEnd) {
                    this.value = val;
                    this.updateHandlePositionFromValue();
                }
                else {
                    console.info("You\'re trying to set the value of the slider to be outside its range.");
                }
            };
            Slider.prototype.getIsValueVisible = function () {
                return this.isValueVisible;
            };
            Slider.prototype.setIsValueVisible = function (visible) {
                this.isValueVisible = visible;
            };
            Slider.prototype.getHandlePos = function () {
                return this.handlePos;
            };
            Slider.prototype.setHandlePos = function (pos) {
                console.info("Trying to set handle pos to " + pos);
                if (this.w > this.h) {
                    if (pos >= 0 && pos <= this.w) {
                        this.handlePos = pos;
                        this.updateValueFromHandlePosition();
                    }
                    else {
                        console.info("You\'re trying to set the position of the slider to be outside its width.");
                    }
                }
                else {
                    if (pos >= 0 && pos <= this.h) {
                        this.handlePos = pos;
                        this.updateValueFromHandlePosition();
                    }
                    else {
                        console.info("You\'re trying to set the position of the slider to be outside its height.");
                    }
                }
                console.info("Handle position is: " + this.handlePos + ", value is:" + this.value);
            };
            Slider.prototype.getValueStep = function () {
                return this.valueStep;
            };
            Slider.prototype.setHandleValue = function (valueStep) {
                if (valueStep > 0) {
                    this.valueStep = valueStep;
                }
            };
            Slider.prototype.incrementValue = function () {
                var newVal = Math.fround(this.value + this.valueStep);
                this.setValue(newVal > this.rangeEnd ? this.rangeEnd : newVal);
            };
            Slider.prototype.decrementValue = function () {
                var newVal = Math.fround(this.value - this.valueStep);
                this.setValue(newVal < this.rangeStart ? this.rangeStart : newVal);
            };
            Slider.prototype.setHandleType = function (handleType) {
                this.handleType = handleType;
                if (handleType === Slider.HANDLE_TYPE_EXPANDED) {
                    this.handleSize = 0;
                }
                else if (handleType === Slider.HANDLE_TYPE_CENTERED) {
                    this.handleSize = ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH;
                }
            };
            Slider.prototype.getHandleSize = function () {
                return this.handleSize;
            };
            Slider.prototype.setHandleSize = function (hSize) {
                if (this.w > this.h) {
                    this.handleSize = PApplet.constrain(hSize, ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH, this.w);
                }
                else {
                    this.handleSize = PApplet.constrain(hSize, ktbyte.gui.KTGUI.DEFAULT_COMPONENT_WIDTH, this.h);
                }
                this.updateValueFromHandlePosition();
            };
            Slider.prototype.getRangeStart = function () {
                return this.rangeStart;
            };
            Slider.prototype.setRangeStart = function (rangeStart) {
                if (rangeStart < this.rangeEnd) {
                    this.rangeStart = rangeStart;
                    this.updateValueFromHandlePosition();
                    ktbyte.gui.KTGUI.debug("[" + this.title + "] range start set to " + rangeStart);
                }
                else {
                    ktbyte.gui.KTGUI.debug("[" + this.title + "] range start cannot be set greater than its range end.");
                }
            };
            Slider.prototype.getRangeEnd = function () {
                return this.rangeEnd;
            };
            Slider.prototype.setRangeEnd = function (rangeEnd) {
                if (rangeEnd > this.rangeStart) {
                    this.rangeEnd = rangeEnd;
                    this.updateValueFromHandlePosition();
                    ktbyte.gui.KTGUI.debug("[" + this.title + "] range end set to " + rangeEnd);
                }
                else {
                    ktbyte.gui.KTGUI.debug("[" + this.title + "] range end cannot be set smaller than its range start.");
                }
            };
            Slider.prototype.setRounding = function (n) {
                this.roundingTemplate = Math.fround(Math.pow(10, n));
            };
            /**
             * This method is called when the user change the <b>value</b> of the slider
             * without the mouse, using the setValue(int) method.
             * @private
             */
            /*private*/ Slider.prototype.updateHandlePositionFromValue = function () {
                if (this.w > this.h) {
                    this.handlePos = PApplet.map(this.value, this.rangeStart, this.rangeEnd, Math.fround(this.handleSize * 0.5), Math.fround(this.w - Math.fround(this.handleSize * 0.5)));
                }
                else {
                    this.handlePos = PApplet.map(this.value, this.rangeStart, this.rangeEnd, Math.fround(this.handleSize * 0.5), Math.fround(this.h - Math.fround(this.handleSize * 0.5)));
                }
            };
            /**
             * This method is called when the user change the <b>position</b> of the slider
             * with the mouse.
             * @private
             */
            /*private*/ Slider.prototype.updateHandlePositionFromMouse = function () {
                if (this.w > this.h) {
                    this.handlePos = PApplet.constrain(this.pa.mouseX - this.getAbsolutePosX(), Math.fround(this.handleSize * 0.5), Math.fround(this.w - Math.fround(this.handleSize * 0.5)));
                }
                else {
                    this.handlePos = PApplet.constrain(this.h - (this.pa.mouseY - this.getAbsolutePosY()), Math.fround(this.handleSize * 0.5), Math.fround(this.h - Math.fround(this.handleSize * 0.5)));
                }
            };
            /**
             * This method is called to recalculate the slider's `value` within the given range
             * when the user change the <b>position</b> of the slider with the mouse.
             * @private
             */
            /*private*/ Slider.prototype.updateValueFromHandlePosition = function () {
                if (this.w > this.h) {
                    this.value = PApplet.map(this.handlePos, Math.fround(this.handleSize * 0.5), Math.fround(this.w - Math.fround(this.handleSize * 0.5)), this.rangeStart, this.rangeEnd);
                }
                else {
                    this.value = PApplet.map(this.handlePos, Math.fround(this.handleSize * 0.5), Math.fround(this.h - Math.fround(this.handleSize * 0.5)), this.rangeStart, this.rangeEnd);
                }
                this.value = PApplet.constrain(this.value, this.rangeStart, this.rangeEnd);
                if (this.roundingTemplate > 0) {
                    this.value = Math.fround(Math.round(Math.fround(this.value * this.roundingTemplate)) / this.roundingTemplate);
                }
                else {
                    this.value = Math.fround(Math.floor(this.value));
                }
            };
            Slider.prototype.processMouseMoved = function () {
                this.isHovered = this.isPointInside(this.pa.mouseX, this.pa.mouseY);
                for (var index213 = 0; index213 < this.adapters.length; index213++) {
                    var adapter = this.adapters[index213];
                    {
                        adapter.onMouseMoved();
                    }
                }
            };
            Slider.prototype.processMousePressed = function () {
                this.isPressed = this.isHovered;
                if (this.isPressed) {
                    this.updateHandlePositionFromMouse();
                    this.updateValueFromHandlePosition();
                }
                for (var index214 = 0; index214 < this.adapters.length; index214++) {
                    var adapter = this.adapters[index214];
                    {
                        adapter.onMousePressed();
                    }
                }
            };
            Slider.prototype.processMouseReleased = function () {
                this.isPressed = false;
                this.isDragged = false;
                for (var index215 = 0; index215 < this.adapters.length; index215++) {
                    var adapter = this.adapters[index215];
                    {
                        adapter.onMouseReleased();
                    }
                }
            };
            Slider.prototype.processMouseDragged = function () {
                this.isDragged = this.isPressed;
                if (this.isPressed) {
                    this.updateHandlePositionFromMouse();
                    this.updateValueFromHandlePosition();
                }
                for (var index216 = 0; index216 < this.adapters.length; index216++) {
                    var adapter = this.adapters[index216];
                    {
                        adapter.onMouseDragged();
                    }
                }
            };
            return Slider;
        }(ktbyte.gui.Controller));
        Slider.HANDLE_TYPE_CENTERED = 1;
        Slider.HANDLE_TYPE_EXPANDED = 0;
        gui.Slider = Slider;
        Slider["__class"] = "ktbyte.gui.Slider";
        Slider["__interfaces"] = ["def.processing.core.PConstants"];
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        var TitleBar = (function (_super) {
            __extends(TitleBar, _super);
            function TitleBar(ktgui, title, posx, posy, w, h) {
                var _this = _super.call(this, ktgui, title, posx, posy, w, h) || this;
                if (_this.closeButton === undefined)
                    _this.closeButton = null;
                _this.isDragable = true;
                _this.closeButton = new ktbyte.gui.CloseButton(ktgui, "cb:" + _this.title, w - h + 2, 2, h - 4, h - 4);
                _this.attachController(_this.closeButton);
                return _this;
            }
            return TitleBar;
        }(ktbyte.gui.Bar));
        gui.TitleBar = TitleBar;
        TitleBar["__class"] = "ktbyte.gui.TitleBar";
        TitleBar["__interfaces"] = ["def.processing.core.PConstants"];
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
(function (ktbyte) {
    var gui;
    (function (gui) {
        /**
         *
         * @param {ktbyte.gui.KTGUI} ktgui
         * @param {string} title
         * @param {number} posx
         * @param {number} posy
         * @param {number} w
         * @param {number} h
         * @class
         * @extends ktbyte.gui.Button
         */
        var CloseButton = (function (_super) {
            __extends(CloseButton, _super);
            function CloseButton(ktgui, title, posx, posy, w, h) {
                var _this = _super.call(this, ktgui, title, posx, posy, w, h) || this;
                _this.isDragable = false;
                return _this;
            }
            /**
             *
             */
            CloseButton.prototype.updateGraphics = function () {
                _super.prototype.updateGraphics.call(this);
                this.pg.beginDraw();
                this.pg.rectMode(PConstants.CORNER);
                if (this.isHovered && !this.isPressed) {
                    this.pg.fill(ktbyte.gui.KTGUI.COLOR_FG_HOVERED);
                }
                else if (this.isHovered && this.isPressed) {
                    this.pg.fill(ktbyte.gui.KTGUI.COLOR_FG_PRESSED);
                }
                else {
                    this.pg.fill(200, 200);
                }
                this.pg.stroke(0);
                this.pg.strokeWeight(1);
                this.pg.rectMode(PConstants.CORNER);
                this.pg.rect(0, 0, this.w, this.h);
                this.pg.line(Math.fround(this.w * 0.2), Math.fround(this.h * 0.2), Math.fround(this.w * 0.8), Math.fround(this.h * 0.8));
                this.pg.line(Math.fround(this.w * 0.2), Math.fround(this.h * 0.8), Math.fround(this.w * 0.8), Math.fround(this.h * 0.2));
                this.pg.endDraw();
            };
            /**
             * TODO : replace 'closeControllerRecursively' method with 'closeParentWindow' in
             * order to prevent closing ALL controllers up to the 'root'. That behaviour is not
             * right - the CloseButton of the Window.TitleBar should close only the parent Window
             * and all it's childs (and their childs).
             */
            CloseButton.prototype.processMousePressed = function () {
                _super.prototype.processMousePressed.call(this);
                if (this.isPressed) {
                    this.closeParent();
                }
            };
            /**
             * This method closes all the controllers recursively up to the parent Window
             * and then closes all its childs recursively down.
             */
            CloseButton.prototype.closeParent = function () {
                if (this.parentController != null) {
                    if (!((function (c) { return c["__class"] ? c["__class"] : c["name"]; })(this.parentController.constructor).indexOf("Window") != -1)) {
                        this.parentController.closeParent();
                    }
                    this.parentController.close();
                }
                this.closeAllChildsRecursively();
            };
            return CloseButton;
        }(ktbyte.gui.Button));
        gui.CloseButton = CloseButton;
        CloseButton["__class"] = "ktbyte.gui.CloseButton";
        CloseButton["__interfaces"] = ["def.processing.core.PConstants"];
    })(gui = ktbyte.gui || (ktbyte.gui = {}));
})(ktbyte || (ktbyte = {}));
ktbyte.gui.StageManager.instance_$LI$();
ktbyte.gui.StageManager.defaultStage_$LI$();
ktbyte.gui.StageManager.activeStage_$LI$();
ktbyte.gui.StageManager.stages_$LI$();
ktbyte.gui.StageManager.__static_initialize();
