/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.gui;

import java.util.ArrayList;
import java.util.List;
import ktbyte.gui.Controller;
import ktbyte.gui.KTGUI;
import ktbyte.gui.Stage;

public class StageManager {
    public static List<Stage> stages;
    private static Stage activeStage;
    private static Stage defaultStage;
    private static StageManager instance;

    public static StageManager getInstance() {
        return instance;
    }

    private void init() {
        stages = new ArrayList<Stage>();
        activeStage = defaultStage = this.createStage("Default");
    }

    public Stage createStage(String name) {
        Stage stage;
        activeStage = stage = new Stage(name);
        return stage;
    }

    public Stage getDefaultStage() {
        return defaultStage;
    }

    public Stage getActiveStage() {
        return activeStage;
    }

    public void goToStage(Stage stage) {
        if (stage != defaultStage) {
            activeStage = stage;
        }
    }

    public void goToStage(int numStage) {
        if (numStage > 0 && numStage < stages.size()) {
            activeStage = stages.get(numStage);
        }
    }

    public void goToNextStage() {
        if (this.userStagesExist()) {
            int indexOfCurrentStage = stages.indexOf(activeStage);
            activeStage = indexOfCurrentStage > 0 && indexOfCurrentStage < stages.size() - 1 ? stages.get(indexOfCurrentStage + 1) : stages.get(1);
        }
    }

    public void unregisterControllerFromAllStages(Controller controller) {
        KTGUI.debug("Unregistering [" + controller.title + "] from all stages ...");
        for (Stage stage : stages) {
            KTGUI.debug("\tStage {" + stage.getName() + "} contains:");
            for (Controller c : stage.controllers) {
                KTGUI.debug("\t\t[" + c.title + "] of type <" + c.getClass().getName() + ">");
            }
            if (!stage.controllers.contains(controller)) continue;
            KTGUI.debug("\t\t\t>>> Found [" + controller.title + "] of type <" + controller.getClass().getName() + "> in stage {" + stage.getName() + "}, removing ...");
            stage.controllers.remove(stage.controllers.indexOf(controller));
            KTGUI.debug("\t\t\tNow, {" + stage.getName() + "}.controllers.contains(" + controller.title + ") = " + stage.controllers.contains(controller));
        }
        controller.parentStage = null;
        KTGUI.debug("Done.");
    }

    public boolean userStagesExist() {
        return StageManager.getInstance().getDefaultStage() != StageManager.getInstance().getActiveStage();
    }

    public List<Stage> getStages() {
        return stages;
    }

    static {
        instance = new StageManager();
        instance.init();
    }
}

