/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.gui;

import def.processing.core.PApplet;
import java.util.ArrayList;
import ktbyte.gui.Controller;
import ktbyte.gui.KTGUI;
import ktbyte.gui.StageManager;

public class Stage {
    ArrayList<Controller> controllers;
    String name;
    PApplet pa;

    public Stage(String name) {
        KTGUI.debug("Creation of stage {" + name + "} started.");
        this.pa = KTGUI.getParentPApplet();
        this.name = name;
        this.controllers = new ArrayList();
        StageManager.getInstance().getStages().add(this);
        KTGUI.debug("Creation of stage {" + name + "} completed.");
    }

    public String getName() {
        return this.name;
    }

    public void draw() {
        for (Controller controller : this.controllers) {
            if (!controller.isActive) continue;
            controller.updateGraphics();
            controller.draw();
        }
    }

    public void registerController(Controller controller) {
        KTGUI.debug("Registering controller [" + controller.title + "] of type <" + controller.getClass().getName() + "> in stage {" + this.name + "}:");
        if (this.controllers.contains(controller)) {
            KTGUI.debug("\tController [" + controller.title + "] already exist in stage {" + this.name + "}. Interrupting.");
            return;
        }
        if (StageManager.getInstance().getDefaultStage().controllers.contains(controller)) {
            StageManager.getInstance().getDefaultStage().unregisterController(controller);
        }
        if (StageManager.getInstance().getActiveStage() != null && StageManager.getInstance().getActiveStage().controllers.contains(controller)) {
            StageManager.getInstance().getActiveStage().unregisterController(controller);
        }
        this.controllers.add(controller);
        controller.parentStage = this;
        KTGUI.debug("\tDone. Now, stage {" + this.name + "} contain " + this.controllers.size() + " controller(s).");
        for (Controller c : this.controllers) {
            KTGUI.debug("\t\t" + this.controllers.indexOf(c) + ": " + c.title + " (" + c.controllers.size() + " child controllers)");
            for (Controller child : c.controllers) {
                KTGUI.debug("\t\t\t" + c.controllers.indexOf(child) + ": " + child.title);
            }
        }
    }

    public void unregisterController(Controller controller) {
        if (this.controllers.contains(controller)) {
            this.controllers.remove(controller);
            controller.parentStage = null;
        }
    }

    public ArrayList<Controller> getControllers() {
        return this.controllers;
    }
}

