/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.gui;

import def.processing.core.PApplet;
import ktbyte.gui.Controller;
import ktbyte.gui.EventAdapter;
import ktbyte.gui.KTGUI;

public class Slider
extends Controller {
    public static final int HANDLE_TYPE_CENTERED = 1;
    public static final int HANDLE_TYPE_EXPANDED = 0;
    private int handleType = 0;
    private float handleSize = KTGUI.DEFAULT_COMPONENT_WIDTH;
    private float handlePos = 0.0f;
    private float rangeStart = 0.0f;
    private float rangeEnd = 100.0f;
    private float value = this.rangeStart;
    private float valueStep = 1.0f;
    private float roundingTemplate = 10.0f;
    private boolean isValueVisible = true;

    Slider(KTGUI ktgui, String title, int posx, int posy, int w, int h, int sr, int er) {
        super(ktgui, title, posx, posy, w, h);
        this.rangeStart = sr;
        this.rangeEnd = er;
        this.setHandleType(0);
        this.updateHandlePositionFromValue();
        this.updateHandlePositionFromMouse();
        this.updateValueFromHandlePosition();
    }

    @Override
    public void updateGraphics() {
        super.updateGraphics();
        if (this.handleType == 1) {
            this.drawCenteredHandle();
        } else if (this.handleType == 0) {
            this.drawExpandedHandle();
        } else {
            this.drawExpandedHandle();
        }
    }

    private void drawExpandedHandle() {
        this.pg.beginDraw();
        this.pg.fill(this.isHovered ? KTGUI.COLOR_BG_HOVERED : KTGUI.COLOR_BG_PASSIVE);
        this.pg.rectMode(0);
        this.pg.rect(0.0f, 0.0f, (float)this.w, (float)this.h);
        this.pg.fill(this.isHovered ? KTGUI.COLOR_FG_HOVERED : KTGUI.COLOR_FG_PASSIVE);
        if (this.w > this.h) {
            this.pg.rect(0.0f, 0.0f, this.handlePos, (float)this.h);
        } else {
            this.pg.rect(0.0f, (float)this.h - this.handlePos, (float)this.w, this.handlePos);
        }
        if (this.isValueVisible) {
            this.pg.fill(0);
            this.pg.textAlign(37, 3);
            if (this.w > this.h) {
                this.pg.text(PApplet.str((float)this.value), 10.0f, (float)this.h * 0.5f);
                this.pg.textAlign(37, 102);
                this.pg.text(this.title, 10.0f, -2.0f);
            } else {
                this.pg.text(PApplet.str((float)this.value), 1.0f, (float)this.h * 0.5f);
            }
        }
        this.pg.endDraw();
    }

    private void drawCenteredHandle() {
        this.pg.beginDraw();
        this.pg.fill(this.isHovered ? KTGUI.COLOR_BG_HOVERED : KTGUI.COLOR_BG_PASSIVE);
        this.pg.rectMode(0);
        this.pg.rect(0.0f, 0.0f, (float)this.w, (float)this.h);
        this.pg.fill(this.isHovered ? KTGUI.COLOR_FG_HOVERED : KTGUI.COLOR_FG_PASSIVE);
        this.pg.rectMode(3);
        int handleOffset = (int)(this.handleSize * 0.5f);
        if (this.w > this.h) {
            int correctedHandlePos = (int)PApplet.constrain((float)this.handlePos, (float)handleOffset, (float)(this.w - handleOffset));
            this.pg.rect((float)correctedHandlePos, (float)this.h * 0.5f, this.handleSize, (float)this.h);
        } else {
            int correctedHandlePos = (int)PApplet.constrain((float)this.handlePos, (float)handleOffset, (float)(this.h - handleOffset));
            this.pg.rect((float)this.w * 0.5f, (float)(this.h - correctedHandlePos), (float)this.w, this.handleSize);
        }
        if (this.isValueVisible) {
            this.pg.fill(0);
            this.pg.textAlign(37, 3);
            if (this.w > this.h) {
                this.pg.text(PApplet.str((float)this.value), 10.0f, (float)this.h * 0.5f);
                this.pg.textAlign(37, 102);
                this.pg.text(this.title, 10.0f, -2.0f);
            } else {
                this.pg.text(PApplet.str((float)this.value), 1.0f, (float)this.h * 0.5f);
            }
        }
        this.pg.endDraw();
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float val) {
        if (val >= this.rangeStart && val <= this.rangeEnd) {
            this.value = val;
            this.updateHandlePositionFromValue();
            this.notifyAdapterOnValueChanged();
        }
    }

    public float getNormalizedValue() {
        return PApplet.map((float)this.value, (float)this.rangeStart, (float)this.rangeEnd, (float)0.0f, (float)100.0f);
    }

    public void setNormalizedValue(float val) {
        this.setValue(PApplet.map((float)val, (float)100.0f, (float)0.0f, (float)this.rangeStart, (float)this.rangeEnd));
    }

    private void notifyAdapterOnValueChanged() {
        if (this.isActive) {
            for (EventAdapter adapter : this.adapters) {
                adapter.onValueChanged();
            }
        }
    }

    public boolean getIsValueVisible() {
        return this.isValueVisible;
    }

    public void setIsValueVisible(boolean visible) {
        this.isValueVisible = visible;
    }

    public float getHandlePos() {
        return this.handlePos;
    }

    public void setHandlePos(float pos) {
        System.out.println("Trying to set handle pos to " + pos);
        if (this.w > this.h) {
            if (pos >= 0.0f && pos <= (float)this.w) {
                this.handlePos = pos;
                this.updateValueFromHandlePosition();
            } else {
                System.out.println("You're trying to set the position of the slider to be outside its width.");
            }
        } else if (pos >= 0.0f && pos <= (float)this.h) {
            this.handlePos = pos;
            this.updateValueFromHandlePosition();
        } else {
            System.out.println("You're trying to set the position of the slider to be outside its height.");
        }
        System.out.println("Handle position is: " + this.handlePos + ", value is:" + this.value);
    }

    public float getValueStep() {
        return this.valueStep;
    }

    public void setValueStep(float step) {
        if (step > 0.0f) {
            this.valueStep = step;
        }
    }

    public void incrementValue() {
        float newVal = this.value + this.valueStep;
        this.setValue(newVal > this.rangeEnd ? this.rangeEnd : newVal);
    }

    public void decrementValue() {
        float newVal = this.value - this.valueStep;
        this.setValue(newVal < this.rangeStart ? this.rangeStart : newVal);
    }

    public void setHandleType(int handleType) {
        this.handleType = handleType;
        if (handleType == 0) {
            this.handleSize = 0.0f;
        } else if (handleType == 1) {
            this.handleSize = KTGUI.DEFAULT_COMPONENT_WIDTH;
        }
    }

    public float getHandleSize() {
        return this.handleSize;
    }

    public void setHandleSize(float hSize) {
        this.handleSize = this.w > this.h ? PApplet.constrain((float)hSize, (float)KTGUI.DEFAULT_COMPONENT_WIDTH, (float)this.w) : PApplet.constrain((float)hSize, (float)KTGUI.DEFAULT_COMPONENT_WIDTH, (float)this.h);
        this.updateValueFromHandlePosition();
    }

    public float getRangeStart() {
        return this.rangeStart;
    }

    public void setRangeStart(float rangeStart) {
        if (rangeStart < this.rangeEnd) {
            this.rangeStart = rangeStart;
            this.updateValueFromHandlePosition();
            KTGUI.debug("[" + this.title + "] range start set to " + rangeStart);
        } else {
            KTGUI.debug("[" + this.title + "] range start cannot be set greater than its range end.");
        }
    }

    public float getRangeEnd() {
        return this.rangeEnd;
    }

    public void setRangeEnd(float rangeEnd) {
        if (rangeEnd > this.rangeStart) {
            this.rangeEnd = rangeEnd;
            this.updateValueFromHandlePosition();
            KTGUI.debug("[" + this.title + "] range end set to " + rangeEnd);
        } else {
            KTGUI.debug("[" + this.title + "] range end cannot be set smaller than its range start.");
        }
    }

    public void setRounding(int n) {
        this.roundingTemplate = (float)Math.pow(10.0, n);
    }

    private void updateHandlePositionFromValue() {
        this.handlePos = this.w > this.h ? PApplet.map((float)this.value, (float)this.rangeStart, (float)this.rangeEnd, (float)(this.handleSize * 0.5f), (float)((float)this.w - this.handleSize * 0.5f)) : PApplet.map((float)this.value, (float)this.rangeStart, (float)this.rangeEnd, (float)(this.handleSize * 0.5f), (float)((float)this.h - this.handleSize * 0.5f));
    }

    private void updateHandlePositionFromMouse() {
        this.handlePos = this.w > this.h ? PApplet.constrain((float)(this.pa.mouseX - this.getAbsolutePosX()), (float)(this.handleSize * 0.5f), (float)((float)this.w - this.handleSize * 0.5f)) : PApplet.constrain((float)(this.h - (this.pa.mouseY - this.getAbsolutePosY())), (float)(this.handleSize * 0.5f), (float)((float)this.h - this.handleSize * 0.5f));
    }

    private void updateValueFromHandlePosition() {
        this.value = this.w > this.h ? PApplet.map((float)this.handlePos, (float)(this.handleSize * 0.5f), (float)((float)this.w - this.handleSize * 0.5f), (float)this.rangeStart, (float)this.rangeEnd) : PApplet.map((float)this.handlePos, (float)(this.handleSize * 0.5f), (float)((float)this.h - this.handleSize * 0.5f), (float)this.rangeStart, (float)this.rangeEnd);
        this.value = PApplet.constrain((float)this.value, (float)this.rangeStart, (float)this.rangeEnd);
        this.value = this.roundingTemplate > 0.0f ? (float)Math.round(this.value * this.roundingTemplate) / this.roundingTemplate : (float)Math.floor(this.value);
        this.notifyAdapterOnValueChanged();
    }

    @Override
    public void processMouseMoved() {
        this.isHovered = this.isPointInside(this.pa.mouseX, this.pa.mouseY);
        for (EventAdapter adapter : this.adapters) {
            adapter.onMouseMoved();
        }
    }

    @Override
    public void processMousePressed() {
        this.isPressed = this.isHovered;
        if (this.isPressed) {
            this.updateHandlePositionFromMouse();
            this.updateValueFromHandlePosition();
        }
        for (EventAdapter adapter : this.adapters) {
            adapter.onMousePressed();
        }
    }

    @Override
    public void processMouseReleased() {
        this.isPressed = false;
        this.isDragged = false;
        for (EventAdapter adapter : this.adapters) {
            adapter.onMouseReleased();
        }
    }

    @Override
    public void processMouseDragged() {
        this.isDragged = this.isPressed;
        if (this.isPressed) {
            this.updateHandlePositionFromMouse();
            this.updateValueFromHandlePosition();
        }
        for (EventAdapter adapter : this.adapters) {
            adapter.onMouseDragged();
        }
    }
}

