/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.gui;

import def.processing.core.PApplet;
import def.processing.event.MouseEvent;
import java.util.ArrayList;
import ktbyte.gui.Controller;
import ktbyte.gui.EventAdapter;
import ktbyte.gui.KTGUI;

public class ScrollableTextArea
extends Controller {
    private float textSize = 14.0f;
    private float padding = 6.0f;
    private ArrayList<TextLine> textLines = new ArrayList();
    private ArrayList<TextBlock> textBlocks = new ArrayList();
    private int startLinePosition = 0;
    private boolean enableBlockMarks;
    private boolean enableLineNumbers;

    public ScrollableTextArea(KTGUI ktgui, String title, int posx, int posy, int w, int h) {
        super(ktgui, title, posx, posy, w, h);
        this.setPadding(this.getTextSize() * 0.75f);
    }

    @Override
    public void updateGraphics() {
        super.updateGraphics();
        this.updateTextAreaGraphics();
    }

    private void updateTextAreaGraphics() {
        this.pg.beginDraw();
        this.pg.pushStyle();
        if (this.isSelected(this)) {
            this.pg.fill(this.bgPressedColor);
            this.pg.stroke(50);
            this.pg.strokeWeight(3.0f);
        } else {
            this.pg.fill(this.bgPassiveColor);
            this.pg.stroke(0.0f, 50.0f, 0.0f);
            this.pg.strokeWeight(1.0f);
        }
        this.pg.rect(0.0f, 0.0f, (float)this.w, (float)this.h, (float)this.r1, (float)this.r2, (float)this.r3, (float)this.r4);
        int correctedEndLinePosition = this.getEndLinePosition();
        for (int i = 0; i <= correctedEndLinePosition - this.startLinePosition; ++i) {
            TextLine line = this.textLines.get(i + this.startLinePosition);
            this.pg.fill(line.textColor);
            this.pg.textAlign(37, 102);
            this.pg.textSize(this.textSize);
            this.pg.text(line.content, this.padding, (float)((int)((double)this.padding * 0.5)) + (float)(i + 1) * this.getTextHeight());
            if (line.isHead && this.enableBlockMarks) {
                this.pg.strokeWeight(this.textSize * 0.33f);
                this.pg.stroke(line.textColor, 127.0f);
                this.pg.point((float)this.w - this.padding + 6.0f, (float)((int)((double)this.padding * 0.5 + (double)((float)(i + 1) * this.getTextHeight()) - (double)this.getTextHeight() * 0.5)));
            }
            if (!this.enableLineNumbers) continue;
            this.pg.textSize(this.textSize * 0.5f);
            this.pg.text(i + this.startLinePosition, this.padding - 5.0f, (float)((int)((double)this.padding * 0.5 + (double)((float)(i + 1) * this.getTextHeight()) - (double)this.getTextHeight() * 0.5)));
        }
        this.pg.popStyle();
        this.pg.endDraw();
    }

    public int getEndLinePosition() {
        return PApplet.min((int)(this.textLines.size() - 1), (int)(this.startLinePosition + this.getMaxLinesToDisplay()));
    }

    @Override
    public void processMouseWheel(MouseEvent me) {
        this.mouseScrolled(me.getCount());
        for (EventAdapter adapter : this.adapters) {
            adapter.onMouseWheel(me.getCount());
        }
    }

    public void mouseScrolled(int mouseWheelDelta) {
        if (this.isSelected(this)) {
            if (mouseWheelDelta < 0) {
                if (this.startLinePosition > 0) {
                    this.decrementStartLine();
                }
            } else if (mouseWheelDelta > 0 && this.startLinePosition < this.getMaxAllowedStartLinePos()) {
                this.incrementStartLine();
            }
        }
    }

    public void incrementStartLine() {
        if (this.startLinePosition < this.getMaxAllowedStartLinePos() - 1) {
            ++this.startLinePosition;
        }
    }

    public void decrementStartLine() {
        if (this.startLinePosition > 0) {
            --this.startLinePosition;
        }
    }

    public int getMaxAllowedStartLinePos() {
        return this.textLines.size() - this.getMaxLinesToDisplay();
    }

    public int getMaxLinesToDisplay() {
        return PApplet.floor((float)(((float)this.h - this.padding - this.padding) / this.getTextHeight()));
    }

    public void scrollToTop() {
        while (this.startLinePosition > 0) {
            --this.startLinePosition;
        }
    }

    public void scrollToBottom() {
        while (this.startLinePosition < this.getMaxAllowedStartLinePos()) {
            ++this.startLinePosition;
        }
    }

    public void scrollToPosition(int lineNumber) {
        block4: {
            block3: {
                if (lineNumber < 0 || lineNumber >= this.getMaxAllowedStartLinePos()) {
                    KTGUI.debug("lineNumber[" + lineNumber + "] is out of range during 'scrollToLine' call.");
                    return;
                }
                if (lineNumber <= this.startLinePosition) break block3;
                while (this.startLinePosition < lineNumber && this.startLinePosition < this.getMaxAllowedStartLinePos()) {
                    ++this.startLinePosition;
                }
                break block4;
            }
            if (lineNumber >= this.startLinePosition) break block4;
            while (this.startLinePosition > lineNumber && this.startLinePosition > 0) {
                --this.startLinePosition;
            }
        }
    }

    public ArrayList<TextLine> getTextLines() {
        return this.textLines;
    }

    public ArrayList<TextBlock> getTextBlocks() {
        return this.textBlocks;
    }

    public float getPadding() {
        return this.padding;
    }

    public void setPadding(float padding) {
        this.padding = padding;
        this.updateWrappedLines();
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.updateWrappedLines();
    }

    public void appendTextBlock(String text) {
        TextBlock textBlock = new TextBlock(text);
        this.textBlocks.add(textBlock);
        textBlock.appendAsWrappedLines(this.textSize);
    }

    public void appendTextBlock(String text, int color) {
        TextBlock textBlock = new TextBlock(text, color);
        this.textBlocks.add(textBlock);
        textBlock.appendAsWrappedLines(this.textSize);
    }

    private void updateWrappedLines() {
        this.textLines = new ArrayList();
        for (TextBlock block : this.textBlocks) {
            block.appendAsWrappedLines(this.textSize);
        }
    }

    private float getTextHeight() {
        this.pa.textSize(this.textSize);
        return this.pa.textAscent() + this.pa.textDescent();
    }

    public int getStartLinePosition() {
        return this.startLinePosition;
    }

    public void setStartLinePosition(int pos) {
        if (pos < 0 || pos > this.getMaxAllowedStartLinePos()) {
            return;
        }
        this.startLinePosition = PApplet.constrain((int)pos, (int)0, (int)this.getMaxAllowedStartLinePos());
    }

    public void setNormalizedLinePosition(float pos) {
        int endOfScrollableRange = this.getLineCount() - this.getMaxLinesToDisplay() - 1;
        int normalizedPos = PApplet.floor((float)PApplet.map((float)pos, (float)0.0f, (float)100.0f, (float)endOfScrollableRange, (float)0.0f));
        this.setStartLinePosition(normalizedPos);
    }

    public void enableBlockMarks(boolean val) {
        this.enableBlockMarks = val;
    }

    public void enableLineNumbers(boolean val) {
        this.enableLineNumbers = val;
    }

    public String getTextLine(int index) {
        String textLine = "-= textLine: out of range =-";
        if (this.textLines.size() - index > 0) {
            textLine = this.textLines.get((int)index).content;
        }
        return textLine;
    }

    public String getTextBlock(int index) {
        String textBlock = "-= textBlock: out of range =-";
        if (this.textBlocks.size() - index > 0) {
            textBlock = this.textBlocks.get(index).content;
        }
        return textBlock;
    }

    public int getLineCount() {
        return this.textLines.size();
    }

    public int getBlockCount() {
        return this.textBlocks.size();
    }

    private class TextBlock {
        private String content;
        private boolean isHeadAlreadyMarked;
        private int textColor;

        public TextBlock(String content) {
            this.textColor = ScrollableTextArea.this.pa.color(0);
            this.content = content.trim().replaceAll("\n\t\r", " ");
        }

        public TextBlock(String content, int textColor) {
            this.textColor = ScrollableTextArea.this.pa.color(0);
            this.content = content.trim().replaceAll("\n\t\r", " ");
            this.textColor = textColor;
        }

        public void appendAsWrappedLines(float _textSize) {
            this.isHeadAlreadyMarked = false;
            StringBuilder sb = new StringBuilder();
            int wrappedWidth = PApplet.floor((float)((float)ScrollableTextArea.this.w - ScrollableTextArea.this.padding - ScrollableTextArea.this.padding));
            ScrollableTextArea.this.pa.textSize(_textSize);
            for (int i = 0; i < this.content.length(); ++i) {
                int chunkWidth = PApplet.ceil((float)ScrollableTextArea.this.pa.textWidth(sb.toString()));
                if (chunkWidth >= wrappedWidth) {
                    this.addWrappedLine(sb);
                    sb = new StringBuilder();
                }
                sb.append(this.content.charAt(i));
            }
            this.addWrappedLine(sb);
        }

        private void addWrappedLine(StringBuilder sb) {
            if (!this.isHeadAlreadyMarked) {
                ScrollableTextArea.this.textLines.add(new TextLine(sb.toString(), this.textColor, true));
                this.isHeadAlreadyMarked = true;
            } else {
                ScrollableTextArea.this.textLines.add(new TextLine(sb.toString(), this.textColor, false));
            }
        }
    }

    private class TextLine {
        public String content;
        public int textColor;
        public boolean isHead;

        public TextLine(String content, boolean isHead) {
            this.textColor = ScrollableTextArea.this.pa.color(0, 10, 30);
            this.content = content;
            this.isHead = isHead;
        }

        public TextLine(String content, int textColor, boolean isHead) {
            this.textColor = ScrollableTextArea.this.pa.color(0, 10, 30);
            this.content = content;
            this.isHead = isHead;
            this.textColor = textColor;
        }
    }
}

