/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.gui;

import ktbyte.gui.ArrowButton;
import ktbyte.gui.Controller;
import ktbyte.gui.EventAdapter;
import ktbyte.gui.KTGUI;
import ktbyte.gui.Slider;

public class ScrollBar
extends Controller {
    private ArrowButton backwardButton;
    private ArrowButton forwardButton;
    private Slider slider;

    ScrollBar(KTGUI ktgui, String title, int posx, int posy, int w, int h, int sr, int er) {
        super(ktgui, title, posx, posy, w, h);
        this.createButtons();
        this.createSlider(sr, er);
        this.setBorderRoundings(5, 5, 5, 5);
    }

    @Override
    public void updateGraphics() {
        super.updateGraphics();
    }

    @Override
    public void setBorderRoundings(int r1, int r2, int r3, int r4) {
        if (this.w > this.h) {
            this.backwardButton.setBorderRoundings(r1, 0, 0, r4);
            this.forwardButton.setBorderRoundings(0, r2, r3, 0);
        } else {
            this.forwardButton.setBorderRoundings(r1, r2, 0, 0);
            this.backwardButton.setBorderRoundings(0, 0, r3, r4);
        }
    }

    private void createButtons() {
        if (this.w > this.h) {
            this.backwardButton = new ArrowButton(this.ktgui, "bckwrdBtn:" + this.title, 0, 0, this.h, this.h, 37);
            this.forwardButton = new ArrowButton(this.ktgui, "frwrdBtn:" + this.title, this.w - this.h, 0, this.h, this.h, 39);
        } else {
            this.forwardButton = new ArrowButton(this.ktgui, "frwrdBtn:" + this.title, 0, 0, this.w, this.w, 38);
            this.backwardButton = new ArrowButton(this.ktgui, "bckwrdBtn:" + this.title, 0, this.h - this.w, this.w, this.w, 40);
        }
        this.backwardButton.addEventAdapter(new EventAdapter(){

            @Override
            public void onMousePressed() {
                ScrollBar.this.slider.decrementValue();
            }
        });
        this.forwardButton.addEventAdapter(new EventAdapter(){

            @Override
            public void onMousePressed() {
                ScrollBar.this.slider.incrementValue();
            }
        });
        this.backwardButton.isDragable = false;
        this.forwardButton.isDragable = false;
        this.attachController(this.backwardButton);
        this.attachController(this.forwardButton);
    }

    private void createSlider(int sr, int er) {
        this.slider = this.w > this.h ? new Slider(this.ktgui, "hSlider:" + this.title, this.backwardButton.w, 0, this.w - this.backwardButton.w - this.forwardButton.w, this.h, sr, er) : new Slider(this.ktgui, "vSlider:" + this.title, 0, this.backwardButton.h, this.w, this.h - this.backwardButton.h - this.forwardButton.h, sr, er);
        this.slider.isDragable = false;
        this.slider.setHandleType(1);
        this.slider.setValue(0.0f);
        this.slider.setRounding(0);
        this.slider.setIsValueVisible(false);
        this.slider.addEventAdapter(new EventAdapter(){

            @Override
            public void onMouseDragged() {
                for (EventAdapter adapter : ScrollBar.this.adapters) {
                    adapter.onMouseDragged();
                }
            }

            @Override
            public void onMousePressed() {
                for (EventAdapter adapter : ScrollBar.this.adapters) {
                    adapter.onMousePressed();
                }
            }

            @Override
            public void onValueChanged() {
                if (ScrollBar.this.isActive) {
                    for (EventAdapter adapter : ScrollBar.this.adapters) {
                        adapter.onValueChanged();
                    }
                }
            }
        });
        this.attachController(this.slider);
    }

    public float getValue() {
        return this.slider.getValue();
    }

    public void setValue(int val) {
        this.slider.setValue(val);
    }

    public void setNormalizedValue(float val) {
        this.slider.setNormalizedValue(val);
    }

    public float getNormalizedValue() {
        return this.slider.getNormalizedValue();
    }

    public float getHandlePos() {
        return this.slider.getHandlePos();
    }

    public void setHandlePos(int pos) {
        this.slider.setHandlePos(pos);
    }

    public void setHandleType(int handleType) {
        this.slider.setHandleType(handleType);
    }

    public void setHandleStep(float step) {
        this.slider.setValueStep(step);
    }

    public float getHandleStep() {
        return this.slider.getValueStep();
    }

    public boolean getIsValueVisible() {
        return this.slider.getIsValueVisible();
    }

    public void setIsValueVisible(boolean visible) {
        this.slider.setIsValueVisible(visible);
    }

    public float getRangeStart() {
        return this.slider.getRangeStart();
    }

    public void setRangeStart(int rangeStart) {
        this.slider.setRangeStart(rangeStart);
    }

    public float getRangeEnd() {
        return this.slider.getRangeEnd();
    }

    public void setRangeEnd(int rangeEnd) {
        this.slider.setRangeEnd(rangeEnd);
    }

    public void setRounding(int n) {
        this.slider.setRounding(n);
    }

    public Slider getSlider() {
        return this.slider;
    }
}

