/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.gui;

import ktbyte.gui.Controller;
import ktbyte.gui.EventAdapter;
import ktbyte.gui.KTGUI;
import ktbyte.gui.Pane;
import ktbyte.gui.TitleBar;

public class Panel
extends Controller {
    private TitleBar titleBar;
    private Pane pane;

    public Panel(KTGUI ktgui, String title, int posx, int posy, int w, int h) {
        super(ktgui, title, posx, posy, w, h);
        this.isDragable = true;
        this.createTitleBar();
        this.createPane();
        this.setTitle(title);
    }

    @Override
    public void updateGraphics() {
        super.updateGraphics();
        this.pg.beginDraw();
        this.pg.background(200, 50.0f);
        this.pg.stroke(0);
        this.pg.noFill();
        this.pg.rectMode(0);
        if (this.isSelected(this)) {
            this.pg.strokeWeight(3.0f);
        } else {
            this.pg.strokeWeight(1.0f);
        }
        this.pg.rect(0.0f, 0.0f, (float)this.w, (float)this.h, (float)this.r1, (float)this.r2, (float)this.r3, (float)this.r4);
        this.pg.endDraw();
    }

    @Override
    public void processMousePressed() {
        if (this.isActive) {
            for (Controller child : this.controllers) {
                child.processMousePressed();
            }
            this.isPressed = this.isHovered;
            if (this.isPressed) {
                for (EventAdapter adapter : this.adapters) {
                    adapter.onMousePressed();
                }
            }
        }
    }

    @Override
    public boolean isPointInside(int x, int y) {
        boolean isInside = false;
        if (this.isActive && x > this.getAbsolutePosX() && x < this.getAbsolutePosX() + this.w && y > this.getAbsolutePosY() && y < this.getAbsolutePosY() + this.titleBar.h) {
            isInside = true;
        }
        return isInside;
    }

    private void createTitleBar() {
        this.titleBar = new TitleBar(this.ktgui, "tb:" + this.title, 0, 0, this.w, KTGUI.DEFAULT_COMPONENT_WIDTH);
        this.titleBar.isDragable = false;
        this.attachController(this.titleBar);
    }

    private void createPane() {
        this.pane = new Pane(this.ktgui, "pane:" + this.title, 0, KTGUI.DEFAULT_COMPONENT_WIDTH, this.w, this.h - KTGUI.DEFAULT_COMPONENT_WIDTH);
        this.pane.isDragable = false;
        this.attachController(this.pane);
    }

    @Override
    public void addController(Controller child, int hAlign, int vAlign) {
        if (this.isActive) {
            child.alignAbout(this.pane, hAlign, vAlign);
            this.pane.attachController(child);
        }
    }

    @Override
    public void addController(Controller child, int hAlign, int vAlign, int gap) {
        if (this.isActive) {
            child.alignAbout(this.pane, hAlign, vAlign, gap);
            this.pane.attachController(child);
        }
    }

    public Pane getPane() {
        return this.pane;
    }
}

